/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ManipParameters;
import de.independit.scheduler.server.parser.NamedResourceLister;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.parser.SsRFormatter;
import de.independit.scheduler.server.repository.SDMSDependencyDefinition;
import de.independit.scheduler.server.repository.SDMSDependencyDefinitionTable;
import de.independit.scheduler.server.repository.SDMSDependencyState;
import de.independit.scheduler.server.repository.SDMSDependencyStateTable;
import de.independit.scheduler.server.repository.SDMSEnvironment;
import de.independit.scheduler.server.repository.SDMSEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfileTable;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSFootprint;
import de.independit.scheduler.server.repository.SDMSFootprintProxyGeneric;
import de.independit.scheduler.server.repository.SDMSFootprintTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSIgnoredDependency;
import de.independit.scheduler.server.repository.SDMSIgnoredDependencyTable;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSNamedEnvironment;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceReqStates;
import de.independit.scheduler.server.repository.SDMSResourceReqStatesTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceTemplate;
import de.independit.scheduler.server.repository.SDMSResourceTemplateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceTemplateTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.util.Lockmode;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;

public class ShowFolder
extends ShowCommented {
    ObjectURL url;

    public ShowFolder(ObjectURL objectURL) {
        this.txMode = 1;
        this.auditFlag = false;
        this.url = objectURL;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        SDMSProxy sDMSProxy = this.url.resolve(systemEnvironment);
        sDMSOutputContainer = this.url.objType == 6 ? this.showFolder(systemEnvironment, (SDMSFolder)sDMSProxy) : this.showSchedulingEntity(systemEnvironment, (SDMSSchedulingEntity)sDMSProxy);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201292028", "Folder shown"));
    }

    private SDMSOutputContainer showFolder(SystemEnvironment systemEnvironment, SDMSFolder sDMSFolder) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        if (!sDMSFolder.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411709", "Insufficient privileges"));
        }
        vector.add("ID");
        vector.add("NAME");
        vector.add("OWNER");
        vector.add("TYPE");
        vector.add("ENVIRONMENT");
        vector.add("INHERIT_PRIVS");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("PARAMETERS");
        vector.add("DEFINED_RESOURCES");
        Long l = sDMSFolder.getId(systemEnvironment);
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(l);
        vector2.add(sDMSFolder.pathVector(systemEnvironment));
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSFolder.getOwnerId(systemEnvironment));
        vector2.add(sDMSGroup.getName(systemEnvironment));
        vector2.add("FOLDER");
        Long l2 = sDMSFolder.getEnvId(systemEnvironment);
        if (l2 != null) {
            vector2.add(SDMSNamedEnvironmentTable.getObject(systemEnvironment, l2).getName(systemEnvironment));
        } else {
            vector2.add(null);
        }
        vector2.add(new SDMSPrivilege(systemEnvironment, sDMSFolder.getInheritPrivs(systemEnvironment)).toString());
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        Date date = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSFolder.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSFolder.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSFolder.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSFolder.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(sDMSFolder.getPrivileges(systemEnvironment).toString());
        vector2.add(ManipParameters.get(systemEnvironment, sDMSFolder.getId(systemEnvironment)));
        this.add_resources(systemEnvironment, sDMSFolder, vector2);
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03112201803", "Folder"), vector, vector2);
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer showSchedulingEntity(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        Vector<Object> vector2 = new Vector<Object>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("OWNER");
        vector.add("TYPE");
        vector.add("INHERIT_PRIVS");
        vector.add("RUN_PROGRAM");
        vector.add("RERUN_PROGRAM");
        vector.add("KILL_PROGRAM");
        vector.add("WORKDIR");
        vector.add("LOGFILE");
        vector.add("TRUNC_LOG");
        vector.add("ERRLOGFILE");
        vector.add("TRUNC_ERRLOG");
        vector.add("EXPECTED_RUNTIME");
        vector.add("EXPECTED_FINALTIME");
        vector.add("PRIORITY");
        vector.add("MIN_PRIORITY");
        vector.add("AGING_AMOUNT");
        vector.add("AGING_BASE");
        vector.add("SUBMIT_SUSPENDED");
        vector.add("RESUME_AT");
        vector.add("RESUME_IN");
        vector.add("RESUME_BASE");
        vector.add("MASTER_SUBMITTABLE");
        vector.add("TIMEOUT_AMOUNT");
        vector.add("TIMEOUT_BASE");
        vector.add("TIMEOUT_STATE");
        vector.add("DEPENDENCY_MODE");
        vector.add("ESP_NAME");
        vector.add("ESM_NAME");
        vector.add("ENV_NAME");
        vector.add("FP_NAME");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("PRIVS");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("CHILDREN");
        vector.add("PARENTS");
        vector.add("PARAMETER");
        vector.add("REFERENCES");
        vector.add("REQUIRED_JOBS");
        vector.add("DEPENDENT_JOBS");
        vector.add("REQUIRED_RESOURCES");
        vector.add("DEFINED_RESOURCES");
        if (!sDMSSchedulingEntity.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411708", "Insufficient privileges"));
        }
        Long l = sDMSSchedulingEntity.getId(systemEnvironment);
        vector2.add(l);
        vector2.add(sDMSSchedulingEntity.pathVector(systemEnvironment));
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSSchedulingEntity.getOwnerId(systemEnvironment));
        vector2.add(sDMSGroup.getName(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
        vector2.add(new SDMSPrivilege(systemEnvironment, sDMSSchedulingEntity.getInheritPrivs(systemEnvironment)).toString());
        vector2.add(sDMSSchedulingEntity.getRunProgram(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getRerunProgram(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getKillProgram(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getWorkdir(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getLogfile(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getTruncLog(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getErrlogfile(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getTruncErrlog(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getExpectedRuntime(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getExpectedFinaltime(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getPriority(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getMinPriority(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getAgingAmount(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getAgingBaseAsString(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getSubmitSuspended(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getResumeAt(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getResumeIn(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getResumeBaseAsString(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getMasterSubmittable(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getTimeoutAmount(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getTimeoutBaseAsString(systemEnvironment));
        Long l2 = sDMSSchedulingEntity.getTimeoutStateId(systemEnvironment);
        if (l2 != null) {
            vector2.add(SDMSExitStateDefinitionTable.getObject(systemEnvironment, l2).getName(systemEnvironment));
        } else {
            vector2.add(null);
        }
        vector2.add(sDMSSchedulingEntity.getDependencyOperationAsString(systemEnvironment));
        Long l3 = sDMSSchedulingEntity.getEspId(systemEnvironment);
        SDMSExitStateProfile sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, l3);
        vector2.add(sDMSExitStateProfile.getName(systemEnvironment));
        Long l4 = sDMSSchedulingEntity.getEsmpId(systemEnvironment);
        if (l4 != null) {
            SDMSExitStateMappingProfile sDMSExitStateMappingProfile = SDMSExitStateMappingProfileTable.getObject(systemEnvironment, l4);
            vector2.add(sDMSExitStateMappingProfile.getName(systemEnvironment));
        } else {
            vector2.add("<default>");
        }
        Long l5 = sDMSSchedulingEntity.getNeId(systemEnvironment);
        if (l5 != null) {
            SDMSNamedEnvironment sDMSNamedEnvironment = SDMSNamedEnvironmentTable.getObject(systemEnvironment, l5);
            vector2.add(sDMSNamedEnvironment.getName(systemEnvironment));
        } else {
            vector2.add("<null>");
        }
        Long l6 = sDMSSchedulingEntity.getFpId(systemEnvironment);
        if (l6 != null) {
            SDMSFootprint sDMSFootprint = SDMSFootprintTable.getObject(systemEnvironment, l6);
            vector2.add(sDMSFootprint.getName(systemEnvironment));
        } else {
            vector2.add("<null>");
        }
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        vector2.add(sDMSSchedulingEntity.getPrivileges(systemEnvironment).toString());
        Date date = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSSchedulingEntity.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSSchedulingEntity.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSSchedulingEntity.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSSchedulingEntity.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(this.childContainer(systemEnvironment, sDMSSchedulingEntity));
        vector2.add(this.parentContainer(systemEnvironment, sDMSSchedulingEntity));
        vector2.add(ManipParameters.get(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment)));
        vector2.add(ManipParameters.getReferences(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment)));
        vector2.add(this.dependentJobContainer(systemEnvironment, sDMSSchedulingEntity));
        vector2.add(this.requiredJobContainer(systemEnvironment, sDMSSchedulingEntity));
        vector2.add(this.requirementsContainer(systemEnvironment, sDMSSchedulingEntity));
        this.add_resources(systemEnvironment, sDMSSchedulingEntity, vector2);
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "02112141349", "Job Definition"), vector, vector2);
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer childContainer(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        Vector vector = SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment));
        return this.familyContainer(systemEnvironment, vector);
    }

    private SDMSOutputContainer parentContainer(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        Vector vector = SDMSSchedulingHierarchyTable.idx_seChildId.getVector(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment));
        return this.familyContainer(systemEnvironment, vector);
    }

    private SDMSOutputContainer familyContainer(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        Vector<String> vector2 = new Vector<String>();
        vector2.add("ID");
        vector2.add("CHILDNAME");
        vector2.add("CHILDTYPE");
        vector2.add("CHILDPRIVS");
        vector2.add("PARENTNAME");
        vector2.add("PARENTTYPE");
        vector2.add("PARENTPRIVS");
        vector2.add("ALIAS_NAME");
        vector2.add("IS_STATIC");
        vector2.add("IS_DISABLED");
        vector2.add("INT_NAME");
        vector2.add("PRIORITY");
        vector2.add("SUSPEND");
        vector2.add("RESUME_AT");
        vector2.add("RESUME_IN");
        vector2.add("RESUME_BASE");
        vector2.add("MERGE_MODE");
        vector2.add("EST_NAME");
        vector2.add("IGNORED_DEPENDENCIES");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector2);
        for (SDMSSchedulingHierarchy sDMSSchedulingHierarchy : vector) {
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSSchedulingHierarchy.getId(systemEnvironment));
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSchedulingHierarchy.getSeChildId(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.pathVector(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.getPrivileges(systemEnvironment).toString());
            sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSchedulingHierarchy.getSeParentId(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.pathVector(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.getPrivileges(systemEnvironment).toString());
            vector3.add(sDMSSchedulingHierarchy.getAliasName(systemEnvironment));
            vector3.add(sDMSSchedulingHierarchy.getIsStatic(systemEnvironment));
            vector3.add(sDMSSchedulingHierarchy.getIsDisabled(systemEnvironment));
            Long l = sDMSSchedulingHierarchy.getIntId(systemEnvironment);
            if (l != null) {
                SDMSInterval sDMSInterval = SDMSIntervalTable.getObject(systemEnvironment, l);
                vector3.add(sDMSInterval.getName(systemEnvironment));
            } else {
                vector3.add(null);
            }
            vector3.add(sDMSSchedulingHierarchy.getPriority(systemEnvironment));
            vector3.add(sDMSSchedulingHierarchy.getSuspendAsString(systemEnvironment));
            vector3.add(sDMSSchedulingHierarchy.getResumeAt(systemEnvironment));
            vector3.add(sDMSSchedulingHierarchy.getResumeIn(systemEnvironment));
            vector3.add(sDMSSchedulingHierarchy.getResumeBaseAsString(systemEnvironment));
            vector3.add(sDMSSchedulingHierarchy.getMergeModeAsString(systemEnvironment));
            Long l2 = sDMSSchedulingHierarchy.getEstpId(systemEnvironment);
            if (l2 != null) {
                SDMSExitStateTranslationProfile sDMSExitStateTranslationProfile = SDMSExitStateTranslationProfileTable.getObject(systemEnvironment, l2);
                vector3.add(sDMSExitStateTranslationProfile.getName(systemEnvironment));
            } else {
                vector3.add(null);
            }
            Vector vector4 = SDMSIgnoredDependencyTable.idx_shId.getVector(systemEnvironment, sDMSSchedulingHierarchy.getId(systemEnvironment));
            String string = "";
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < vector4.size(); ++i) {
                SDMSIgnoredDependency sDMSIgnoredDependency = (SDMSIgnoredDependency)vector4.get(i);
                stringBuffer.append(string);
                stringBuffer.append(sDMSIgnoredDependency.getDdName(systemEnvironment));
                string = ",";
            }
            vector3.add(new String(stringBuffer));
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer dependentJobContainer(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        Vector vector = SDMSDependencyDefinitionTable.idx_seDependentId.getVector(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment));
        return this.dependentContainer(systemEnvironment, vector);
    }

    private SDMSOutputContainer requiredJobContainer(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        Vector vector = SDMSDependencyDefinitionTable.idx_seRequiredId.getVector(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment));
        return this.dependentContainer(systemEnvironment, vector);
    }

    private SDMSOutputContainer dependentContainer(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        Vector<String> vector2 = new Vector<String>();
        vector2.add("ID");
        vector2.add("NAME");
        vector2.add("DEPENDENTNAME");
        vector2.add("DEPENDENTTYPE");
        vector2.add("DEPENDENTPRIVS");
        vector2.add("REQUIREDNAME");
        vector2.add("REQUIREDTYPE");
        vector2.add("REQUIREDPRIVS");
        vector2.add("UNRESOLVED_HANDLING");
        vector2.add("MODE");
        vector2.add("STATE_SELECTION");
        vector2.add("CONDITION");
        vector2.add("STATES");
        vector2.add("RESOLVE_MODE");
        vector2.add("EXPIRED_AMOUNT");
        vector2.add("EXPIRED_BASE");
        vector2.add("SELECT_CONDITION");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector2);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSDependencyDefinition sDMSDependencyDefinition = (SDMSDependencyDefinition)vector.get(i);
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSDependencyDefinition.getId(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getName(systemEnvironment));
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSDependencyDefinition.getSeDependentId(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.pathVector(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.getPrivileges(systemEnvironment).toString());
            sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSDependencyDefinition.getSeRequiredId(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.pathVector(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.getPrivileges(systemEnvironment).toString());
            vector3.add(sDMSDependencyDefinition.getUnresolvedHandlingAsString(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getModeAsString(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getStateSelectionAsString(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getCondition(systemEnvironment));
            Vector vector4 = SDMSDependencyStateTable.idx_ddId.getVector(systemEnvironment, sDMSDependencyDefinition.getId(systemEnvironment));
            String string = "";
            StringBuffer stringBuffer = new StringBuffer();
            for (int j = 0; j < vector4.size(); ++j) {
                SDMSDependencyState sDMSDependencyState = (SDMSDependencyState)vector4.get(j);
                String string2 = SDMSExitStateDefinitionTable.getObject(systemEnvironment, sDMSDependencyState.getEsdId(systemEnvironment)).getName(systemEnvironment);
                stringBuffer.append(string);
                stringBuffer.append(string2);
                String string3 = sDMSDependencyState.getCondition(systemEnvironment);
                if (string3 != null) {
                    stringBuffer.append(":");
                    stringBuffer.append(string3);
                }
                string = ",";
            }
            vector3.add(new String(stringBuffer));
            vector3.add(sDMSDependencyDefinition.getResolveModeAsString(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getExpiredAmount(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getExpiredBaseAsString(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getSelectCondition(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer requirementsContainer(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        SDMSEnvironment sDMSEnvironment;
        Vector vector;
        SDMSResourceRequirement sDMSResourceRequirement;
        int n;
        Object object;
        SDMSNamedEnvironment sDMSNamedEnvironment;
        HashSet<Long> hashSet = new HashSet<Long>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("ID");
        vector2.add("RESOURCE_NAME");
        vector2.add("RESOURCE_USAGE");
        vector2.add("RESOURCE_PRIVS");
        vector2.add("AMOUNT");
        vector2.add("KEEP_MODE");
        vector2.add("IS_STICKY");
        vector2.add("STICKY_NAME");
        vector2.add("STICKY_PARENT");
        vector2.add("RESOURCE_STATE_MAPPING");
        vector2.add("EXPIRED_AMOUNT");
        vector2.add("EXPIRED_BASE");
        vector2.add("IGNORE_ON_RERUN");
        vector2.add("LOCKMODE");
        vector2.add("STATES");
        vector2.add("DEFINITION");
        vector2.add("ORIGIN");
        vector2.add("CONDITION");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector2);
        Long l = sDMSSchedulingEntity.getNeId(systemEnvironment);
        Vector vector3 = SDMSEnvironmentTable.idx_neId.getVector(systemEnvironment, l);
        String string = null;
        if (l != null) {
            sDMSNamedEnvironment = SDMSNamedEnvironmentTable.getObject(systemEnvironment, l);
            string = sDMSNamedEnvironment.getName(systemEnvironment);
        }
        Long l2 = sDMSSchedulingEntity.getFpId(systemEnvironment);
        Vector vector4 = null;
        String string2 = null;
        if (l2 != null) {
            vector4 = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, l2);
            object = SDMSFootprintTable.getObject(systemEnvironment, l2);
            string2 = ((SDMSFootprintProxyGeneric)object).getName(systemEnvironment);
        } else {
            vector4 = new Vector();
        }
        object = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment));
        for (n = 0; n < ((Vector)object).size(); ++n) {
            sDMSResourceRequirement = (SDMSResourceRequirement)((Vector)object).get(n);
            vector = new Vector();
            this.render_rr(systemEnvironment, vector, sDMSResourceRequirement, "REQUIREMENT", null);
            hashSet.add(sDMSResourceRequirement.getNrId(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector);
        }
        for (n = 0; n < vector4.size(); ++n) {
            sDMSResourceRequirement = (SDMSResourceRequirement)vector4.get(n);
            if (hashSet.contains(sDMSResourceRequirement.getNrId(systemEnvironment))) continue;
            vector = new Vector();
            this.render_rr(systemEnvironment, vector, sDMSResourceRequirement, "FOOTPRINT", string2);
            hashSet.add(sDMSResourceRequirement.getNrId(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector);
        }
        for (n = 0; n < vector3.size(); ++n) {
            sDMSEnvironment = (SDMSEnvironment)vector3.get(n);
            if (hashSet.contains(sDMSEnvironment.getNrId(systemEnvironment))) continue;
            vector = new Vector();
            this.render_env(systemEnvironment, vector, sDMSEnvironment, string);
            hashSet.add(sDMSEnvironment.getNrId(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector);
        }
        Long l3 = sDMSSchedulingEntity.getFolderId(systemEnvironment);
        while (l3 != null) {
            SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l3);
            l = sDMSFolder.getEnvId(systemEnvironment);
            if (l != null) {
                String string3 = sDMSFolder.pathString(systemEnvironment);
                vector3 = SDMSEnvironmentTable.idx_neId.getVector(systemEnvironment, l);
                for (int i = 0; i < vector3.size(); ++i) {
                    sDMSNamedEnvironment = SDMSNamedEnvironmentTable.getObject(systemEnvironment, l);
                    string = sDMSNamedEnvironment.getName(systemEnvironment);
                    sDMSEnvironment = (SDMSEnvironment)vector3.get(i);
                    if (hashSet.contains(sDMSEnvironment.getNrId(systemEnvironment))) continue;
                    vector = new Vector();
                    this.render_fenv(systemEnvironment, vector, sDMSEnvironment, string + "/" + string3);
                    hashSet.add(sDMSEnvironment.getNrId(systemEnvironment));
                    sDMSOutputContainer.addData(systemEnvironment, vector);
                }
            }
            l3 = sDMSFolder.getParentId(systemEnvironment);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 2));
        return sDMSOutputContainer;
    }

    private void render_rr(SystemEnvironment systemEnvironment, Vector vector, SDMSResourceRequirement sDMSResourceRequirement, String string, String string2) throws SDMSException {
        Comparable comparable;
        vector.add(sDMSResourceRequirement.getId(systemEnvironment));
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSResourceRequirement.getNrId(systemEnvironment));
        vector.add(sDMSNamedResource.pathVector(systemEnvironment));
        vector.add(sDMSNamedResource.getUsageAsString(systemEnvironment));
        vector.add(sDMSNamedResource.getPrivileges(systemEnvironment).toString());
        vector.add(sDMSResourceRequirement.getAmount(systemEnvironment));
        vector.add(sDMSResourceRequirement.getKeepModeAsString(systemEnvironment));
        vector.add(sDMSResourceRequirement.getIsSticky(systemEnvironment));
        vector.add(sDMSResourceRequirement.getStickyName(systemEnvironment));
        Long l = sDMSResourceRequirement.getStickyParent(systemEnvironment);
        if (l == null) {
            vector.add(null);
        } else {
            comparable = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
            vector.add(comparable.pathString(systemEnvironment));
        }
        comparable = sDMSResourceRequirement.getRsmpId(systemEnvironment);
        if (comparable != null) {
            SDMSResourceStateMappingProfile sDMSResourceStateMappingProfile = SDMSResourceStateMappingProfileTable.getObject(systemEnvironment, (Long)comparable);
            vector.add(sDMSResourceStateMappingProfile.getName(systemEnvironment));
        } else {
            vector.add(null);
        }
        vector.add(sDMSResourceRequirement.getExpiredAmount(systemEnvironment));
        vector.add(sDMSResourceRequirement.getExpiredBaseAsString(systemEnvironment));
        vector.add(sDMSResourceRequirement.getIgnoreOnRerun(systemEnvironment));
        Integer n = sDMSResourceRequirement.getLockmode(systemEnvironment);
        if (n != null) {
            vector.add(new Lockmode(systemEnvironment, n).str(systemEnvironment));
        } else {
            vector.add(null);
        }
        Vector vector2 = SDMSResourceReqStatesTable.idx_rrId.getVector(systemEnvironment, sDMSResourceRequirement.getId(systemEnvironment));
        String string3 = "";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSResourceReqStates sDMSResourceReqStates = (SDMSResourceReqStates)vector2.get(i);
            String string4 = SDMSResourceStateDefinitionTable.getObject(systemEnvironment, sDMSResourceReqStates.getRsdId(systemEnvironment)).getName(systemEnvironment);
            stringBuffer.append(string3);
            stringBuffer.append(string4);
            string3 = ",";
        }
        vector.add(new String(stringBuffer));
        vector.add(string);
        vector.add(string2);
        vector.add(sDMSResourceRequirement.getCondition(systemEnvironment));
    }

    private void render_env(SystemEnvironment systemEnvironment, Vector vector, SDMSEnvironment sDMSEnvironment, String string) throws SDMSException {
        this.render_env_common(systemEnvironment, vector, sDMSEnvironment, "ENVIRONMENT", string);
    }

    private void render_fenv(SystemEnvironment systemEnvironment, Vector vector, SDMSEnvironment sDMSEnvironment, String string) throws SDMSException {
        this.render_env_common(systemEnvironment, vector, sDMSEnvironment, "FOLDER", string);
    }

    private void render_env_common(SystemEnvironment systemEnvironment, Vector vector, SDMSEnvironment sDMSEnvironment, String string, String string2) throws SDMSException {
        vector.add(sDMSEnvironment.getId(systemEnvironment));
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSEnvironment.getNrId(systemEnvironment));
        vector.add(sDMSNamedResource.pathVector(systemEnvironment));
        vector.add(sDMSNamedResource.getUsageAsString(systemEnvironment));
        vector.add(sDMSNamedResource.getPrivileges(systemEnvironment).toString());
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(null);
        vector.add(string);
        vector.add(string2);
        vector.add(sDMSEnvironment.getCondition(systemEnvironment));
    }

    private void add_resources(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, Vector vector) throws SDMSException {
        SDMSProxy sDMSProxy2;
        int n;
        Vector vector2;
        Long l = sDMSProxy.getId(systemEnvironment);
        NamedResourceLister namedResourceLister = new NamedResourceLister();
        namedResourceLister.setTitle(null);
        namedResourceLister.setFormatter(new SsRFormatter(l));
        int[] nArray = new int[]{1};
        namedResourceLister.setSortColumns(nArray);
        Vector<Long> vector3 = new Vector<Long>();
        if (sDMSProxy instanceof SDMSFolder) {
            vector2 = SDMSResourceTable.idx_scopeId.getVector(systemEnvironment, l);
            for (n = 0; n < vector2.size(); ++n) {
                sDMSProxy2 = (SDMSResource)vector2.get(n);
                vector3.add(((SDMSResourceProxyGeneric)sDMSProxy2).getNrId(systemEnvironment));
            }
        }
        if (!(sDMSProxy instanceof SDMSFolder)) {
            vector2 = SDMSResourceTemplateTable.idx_seId.getVector(systemEnvironment, l);
            for (n = 0; n < vector2.size(); ++n) {
                sDMSProxy2 = (SDMSResourceTemplate)vector2.get(n);
                vector3.add(((SDMSResourceTemplateProxyGeneric)sDMSProxy2).getNrId(systemEnvironment));
            }
        }
        namedResourceLister.setObjectsToList(vector3);
        namedResourceLister.setExpandIds(null);
        SDMSOutputContainer sDMSOutputContainer = namedResourceLister.list(systemEnvironment);
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 2));
        vector.add(sDMSOutputContainer);
    }
}

