/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.FolderLister;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.SfSeFormatter;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSFootprint;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;

public class ShowFootprint
extends ShowCommented {
    private final ObjectURL url;
    private final HashSet expandIds;

    public ShowFootprint(ObjectURL objectURL, HashSet hashSet) {
        this.txMode = 1;
        this.auditFlag = false;
        this.expandIds = hashSet;
        this.url = objectURL;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        SDMSFootprint sDMSFootprint = (SDMSFootprint)this.url.resolve(systemEnvironment);
        if (!sDMSFootprint.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411716", "Insufficient privileges"));
        }
        Long l = sDMSFootprint.getId(systemEnvironment);
        vector.add("ID");
        vector.add("NAME");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("RESOURCES");
        vector.add("JOB_DEFINITIONS");
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(l);
        vector2.add(sDMSFootprint.getName(systemEnvironment));
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        Date date = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSFootprint.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSFootprint.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSFootprint.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSFootprint.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(sDMSFootprint.getPrivileges(systemEnvironment).toString());
        vector2.add(this.requirementsContainer(systemEnvironment, l));
        vector2.add(this.jobDefContainer(systemEnvironment, l));
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03112201804", "Footprint"), vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204092347", "Footprint shown"));
    }

    private SDMSOutputContainer requirementsContainer(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("RESOURCE_NAME");
        vector.add("AMOUNT");
        vector.add("KEEP_MODE");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector);
        Vector vector2 = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSResourceRequirement sDMSResourceRequirement = (SDMSResourceRequirement)vector2.get(i);
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSResourceRequirement.getId(systemEnvironment));
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSResourceRequirement.getNrId(systemEnvironment));
            vector3.add(sDMSNamedResource.pathVector(systemEnvironment));
            vector3.add(sDMSResourceRequirement.getAmount(systemEnvironment));
            vector3.add(sDMSResourceRequirement.getKeepModeAsString(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer jobDefContainer(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        FolderLister folderLister = new FolderLister(null, this.expandIds);
        folderLister.setTitle(null);
        folderLister.setFormatter(new SfSeFormatter());
        int[] nArray = new int[]{1};
        folderLister.setSortColumns(nArray);
        Vector vector = SDMSSchedulingEntityTable.idx_fpId.getVector(systemEnvironment, l);
        folderLister.setObjectsToList(vector);
        SDMSOutputContainer sDMSOutputContainer = folderLister.list(systemEnvironment);
        return sDMSOutputContainer;
    }
}

