/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.dumpClasses;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.dumpClasses.DumpEV;
import de.independit.scheduler.server.parser.dumpClasses.DumpF;
import de.independit.scheduler.server.parser.dumpClasses.DumpGroup;
import de.independit.scheduler.server.parser.dumpClasses.DumpIV;
import de.independit.scheduler.server.parser.dumpClasses.DumpLine;
import de.independit.scheduler.server.parser.dumpClasses.DumpNE;
import de.independit.scheduler.server.parser.dumpClasses.DumpNR;
import de.independit.scheduler.server.parser.dumpClasses.DumpR;
import de.independit.scheduler.server.parser.dumpClasses.DumpRT;
import de.independit.scheduler.server.parser.dumpClasses.DumpSC;
import de.independit.scheduler.server.parser.dumpClasses.DumpSE;
import de.independit.scheduler.server.parser.dumpClasses.DumpSEV;
import de.independit.scheduler.server.parser.dumpClasses.DumpScope;
import de.independit.scheduler.server.parser.dumpClasses.Dumper;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSNamedEnvironment;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceTemplate;
import de.independit.scheduler.server.repository.SDMSResourceTemplateTable;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.HashMap;
import java.util.Vector;

public class DumpGR
extends Dumper {
    public static final String __version = "@(#) $Id: DumpGR.java,v 1.5.4.1 2013/03/14 10:24:56 ronald Exp $";

    public static String getDumpedName(SystemEnvironment systemEnvironment, SDMSGrant sDMSGrant, HashMap hashMap) throws SDMSException {
        int n = sDMSGrant.getObjectType(systemEnvironment);
        String string = "not ready yet";
        Long l = sDMSGrant.getObjectId(systemEnvironment);
        if (l.equals(SDMSPrivilege.SYSPRIVOBJID)) {
            return null;
        }
        switch (n) {
            case 1: {
                SDMSNamedEnvironment sDMSNamedEnvironment = SDMSNamedEnvironmentTable.getObject(systemEnvironment, l);
                string = "environment " + DumpNE.getDumpedName(systemEnvironment, sDMSNamedEnvironment, hashMap);
                break;
            }
            case 18: {
                SDMSEvent sDMSEvent = SDMSEventTable.getObject(systemEnvironment, l);
                string = "event " + DumpEV.getDumpedName(systemEnvironment, sDMSEvent, hashMap);
                break;
            }
            case 6: {
                SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l);
                string = "folder " + DumpF.getDumpedName(systemEnvironment, sDMSFolder, hashMap);
                break;
            }
            case 21: {
                SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l);
                string = "group " + DumpGroup.getDumpedName(systemEnvironment, sDMSGroup, hashMap);
                break;
            }
            case 19: {
                SDMSInterval sDMSInterval = SDMSIntervalTable.getObject(systemEnvironment, l);
                string = "interval " + DumpIV.getDumpedName(systemEnvironment, sDMSInterval, hashMap);
                break;
            }
            case 9: {
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
                string = "job definition " + DumpSE.getDumpedName(systemEnvironment, sDMSSchedulingEntity, hashMap);
                break;
            }
            case 10: {
                SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l);
                string = "named resource " + DumpNR.getDumpedName(systemEnvironment, sDMSNamedResource, hashMap);
                break;
            }
            case 11: {
                try {
                    SDMSResource sDMSResource = SDMSResourceTable.getObject(systemEnvironment, l);
                    string = "resource " + DumpR.getDumpedName(systemEnvironment, sDMSResource, hashMap);
                }
                catch (NotFoundException notFoundException) {
                    SDMSResourceTemplate sDMSResourceTemplate = SDMSResourceTemplateTable.getObject(systemEnvironment, l);
                    string = "resource " + DumpRT.getDumpedName(systemEnvironment, sDMSResourceTemplate, hashMap);
                }
                break;
            }
            case 20: {
                SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, l);
                string = "schedule " + DumpSC.getDumpedName(systemEnvironment, sDMSSchedule, hashMap);
                break;
            }
            case 22: {
                SDMSScheduledEvent sDMSScheduledEvent = SDMSScheduledEventTable.getObject(systemEnvironment, l);
                string = "scheduled event " + DumpSEV.getDumpedName(systemEnvironment, sDMSScheduledEvent, hashMap);
                break;
            }
            case 15: {
                SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l);
                string = "scope " + DumpScope.getDumpedName(systemEnvironment, sDMSScope, hashMap);
            }
        }
        return string;
    }

    public static long getPrivilegeMask(SystemEnvironment systemEnvironment, SDMSGrant sDMSGrant) throws SDMSException {
        int n = sDMSGrant.getObjectType(systemEnvironment);
        switch (n) {
            case 1: {
                return 0x211000111L;
            }
            case 18: {
                return 0x210000111L;
            }
            case 6: {
                return 8859488543L;
            }
            case 21: {
                return 0x210011111L;
            }
            case 19: {
                return 0x210000111L;
            }
            case 9: {
                return 8859488541L;
            }
            case 10: {
                return 8858370335L;
            }
            case 11: {
                return 8858370329L;
            }
            case 20: {
                return 8858370327L;
            }
            case 22: {
                return 0x210000111L;
            }
            case 15: {
                return 13153337631L;
            }
            case 0: {
                return 0xFFFC00000000L;
            }
        }
        return 0L;
    }

    public static Vector dump(SystemEnvironment systemEnvironment, SDMSGrant sDMSGrant, Vector vector, HashMap hashMap) throws SDMSException {
        Vector<DumpLine> vector2 = new Vector<DumpLine>();
        SDMSPrivilege sDMSPrivilege = new SDMSPrivilege(systemEnvironment, sDMSGrant.getPrivs(systemEnvironment));
        Long l = sDMSGrant.getDeleteVersion(systemEnvironment);
        if (l != null && l.compareTo(systemEnvironment.tx.versionId) > 0) {
            return vector2;
        }
        long l2 = DumpGR.getPrivilegeMask(systemEnvironment, sDMSGrant);
        sDMSPrivilege.merge(l2);
        String[] stringArray = sDMSPrivilege.asString();
        String string = DumpGR.getDumpedName(systemEnvironment, sDMSGrant, hashMap);
        if (string == null) {
            try {
                String string2 = DumpGroup.getDumpedName(systemEnvironment, SDMSGroupTable.getObject(systemEnvironment, sDMSGrant.getGId(systemEnvironment)), hashMap);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = "grant " + stringArray[i] + "\nto " + string2 + ";\n\n";
                    vector2.add(new DumpLine(64, string3));
                }
            }
            catch (NotFoundException notFoundException) {
                return vector2;
            }
        }
        String string4 = "grant ";
        String string5 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string4 = string4 + string5 + stringArray[i];
            string5 = ", ";
        }
        try {
            string4 = string4 + "\non " + string + "\nto " + DumpGroup.getDumpedName(systemEnvironment, SDMSGroupTable.getObject(systemEnvironment, sDMSGrant.getGId(systemEnvironment)), hashMap) + ";\n\n";
        }
        catch (NotFoundException notFoundException) {
            SDMSThread.doTrace(systemEnvironment.cEnv, "Trying to dump a grant for a not existing " + sDMSGrant.getObjectTypeAsString(systemEnvironment) + " " + sDMSGrant.getObjectId(systemEnvironment), -1);
            return vector2;
        }
        if (sDMSGrant.getObjectType(systemEnvironment) == 1) {
            vector2.add(new DumpLine(31, string4));
        } else {
            vector2.add(new DumpLine(64, string4));
        }
        return vector2;
    }
}

