/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.dumpClasses;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.dumpClasses.DumpGroup;
import de.independit.scheduler.server.parser.dumpClasses.DumpLine;
import de.independit.scheduler.server.parser.dumpClasses.DumpSE;
import de.independit.scheduler.server.parser.dumpClasses.Dumper;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcher;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcherTable;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchy;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyTable;
import de.independit.scheduler.server.repository.SDMSIntervalSelection;
import de.independit.scheduler.server.repository.SDMSIntervalSelectionTable;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.util.DateTime;
import java.util.HashMap;
import java.util.Vector;

public class DumpIV
extends Dumper {
    public static final String __version = "@(#) $Id: DumpIV.java,v 1.7.2.1 2013/03/14 10:24:56 ronald Exp $";

    private static String loadDispatch(SystemEnvironment systemEnvironment, Long l, Vector vector, HashMap hashMap, String string) throws SDMSException {
        String string2 = string + "dispatch = (\n";
        Vector vector2 = SDMSIntervalDispatcherTable.idx_intId.getSortedVector(systemEnvironment, l);
        if (vector2.size() == 0) {
            return string + "dispatch = none";
        }
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            SDMSIntervalDispatcher sDMSIntervalDispatcher = (SDMSIntervalDispatcher)vector2.get(i);
            String string3 = DumpIV.quotedName(sDMSIntervalDispatcher.getName(systemEnvironment));
            Boolean bl = sDMSIntervalDispatcher.getIsActive(systemEnvironment);
            Boolean bl2 = sDMSIntervalDispatcher.getIsEnabled(systemEnvironment);
            Long l2 = sDMSIntervalDispatcher.getSelectIntId(systemEnvironment);
            Long l3 = sDMSIntervalDispatcher.getFilterIntId(systemEnvironment);
            SDMSInterval sDMSInterval = l2 != null ? SDMSIntervalTable.getObject(systemEnvironment, l2) : null;
            SDMSInterval sDMSInterval2 = l3 != null ? SDMSIntervalTable.getObject(systemEnvironment, l3) : null;
            string2 = string2 + (i > 0 ? ",\n" : "") + string + "\t" + string3 + "\n" + string + "\t\t" + (bl != false ? "active" : "inactive") + "\n" + (sDMSInterval == null ? string + "\t\tnone" : DumpIV.renderInterval(systemEnvironment, sDMSInterval, vector, hashMap, string + "\t\t")) + "\n" + (sDMSInterval2 == null ? "" : DumpIV.renderInterval(systemEnvironment, sDMSInterval2, vector, hashMap, string + "\t\t") + "\n") + string + "\t\t" + (bl2 != false ? "enable" : "disable");
        }
        return string2 + "\n" + string + "\t)";
    }

    private static String loadSelection(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        Vector vector = SDMSIntervalSelectionTable.idx_intId.getSortedVector(systemEnvironment, l);
        if (vector.size() == 0) {
            return string + "selection = none";
        }
        String string2 = string + "selection = (";
        int n = vector.size();
        Vector<String> vector2 = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            SDMSIntervalSelection sDMSIntervalSelection = (SDMSIntervalSelection)vector.get(i);
            Integer n2 = sDMSIntervalSelection.getValue(systemEnvironment);
            if (n2 != null) {
                vector2.add(n2.toString());
                continue;
            }
            Long l2 = sDMSIntervalSelection.getPeriodFrom(systemEnvironment);
            DateTime dateTime = new DateTime(l2, false);
            Long l3 = sDMSIntervalSelection.getPeriodTo(systemEnvironment);
            if (l3 == null) {
                vector2.add(DumpIV.quotedString(dateTime.toString()));
                continue;
            }
            DateTime dateTime2 = new DateTime(l3, false);
            vector2.add(DumpIV.quotedString(dateTime.toString()) + " - " + DumpIV.quotedString(dateTime2.toString()));
        }
        String string3 = "";
        for (int i = 0; i < vector2.size(); ++i) {
            string2 = string2 + string3 + "\n" + string + "\t\t" + vector2.get(i).toString();
            string3 = ",";
        }
        string2 = string2 + "\n" + string + "\t)";
        return string2;
    }

    private static String loadFilter(SystemEnvironment systemEnvironment, Long l, Vector vector, HashMap hashMap, String string) throws SDMSException {
        String string2 = string + "filter = ";
        Vector vector2 = SDMSIntervalHierarchyTable.idx_parentId.getSortedVector(systemEnvironment, l);
        int n = vector2.size();
        if (n == 0) {
            return string2 + "none";
        }
        string2 = string2 + "(";
        String string3 = "";
        for (int i = 0; i < n; ++i) {
            SDMSIntervalHierarchy sDMSIntervalHierarchy = (SDMSIntervalHierarchy)vector2.get(i);
            Long l2 = sDMSIntervalHierarchy.getChildId(systemEnvironment);
            SDMSInterval sDMSInterval = SDMSIntervalTable.getObject(systemEnvironment, l2);
            string2 = string2 + string3 + "\n" + DumpIV.renderInterval(systemEnvironment, sDMSInterval, vector, hashMap, string + "\t\t");
            string3 = ",";
        }
        string2 = string2 + "\n" + string + "\t)";
        return string2;
    }

    public static String getDumpedURL(SystemEnvironment systemEnvironment, SDMSInterval sDMSInterval, HashMap hashMap) throws SDMSException {
        Long l = sDMSInterval.getSeId(systemEnvironment);
        String string = "";
        if (l != null) {
            if (l == 0L) {
                string = " (0)";
            } else {
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
                string = " (" + DumpSE.getDumpedName(systemEnvironment, sDMSSchedulingEntity, hashMap) + ")";
            }
        }
        return "interval " + DumpIV.getDumpedName(systemEnvironment, sDMSInterval, hashMap) + string;
    }

    public static String getDumpedName(SystemEnvironment systemEnvironment, SDMSInterval sDMSInterval, HashMap hashMap) throws SDMSException {
        String string = sDMSInterval.getName(systemEnvironment);
        return DumpIV.quotedName(string);
    }

    private static String renderInterval(SystemEnvironment systemEnvironment, SDMSInterval sDMSInterval, Vector vector, HashMap hashMap, String string) throws SDMSException {
        Long l = sDMSInterval.getId(systemEnvironment);
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSInterval.getOwnerId(systemEnvironment));
        Long l2 = sDMSInterval.getStartTime(systemEnvironment);
        Long l3 = sDMSInterval.getEndTime(systemEnvironment);
        Integer n = sDMSInterval.getBaseInterval(systemEnvironment);
        Integer n2 = sDMSInterval.getBaseIntervalMultiplier(systemEnvironment);
        Integer n3 = sDMSInterval.getDuration(systemEnvironment);
        Integer n4 = sDMSInterval.getDurationMultiplier(systemEnvironment);
        Long l4 = sDMSInterval.getSyncTime(systemEnvironment);
        boolean bl = sDMSInterval.getIsInverse(systemEnvironment);
        Long l5 = sDMSInterval.getEmbeddedIntervalId(systemEnvironment);
        Long l6 = sDMSInterval.getSeId(systemEnvironment);
        SDMSInterval sDMSInterval2 = null;
        if (l5 != null) {
            sDMSInterval2 = SDMSIntervalTable.getObject(systemEnvironment, l5);
        }
        String string2 = DumpIV.loadFilter(systemEnvironment, l, vector, hashMap, string + "\t");
        String string3 = DumpIV.loadSelection(systemEnvironment, l, string + "\t");
        String string4 = DumpIV.loadDispatch(systemEnvironment, l, vector, hashMap, string + "\t");
        String string5 = DumpIV.getDumpedName(systemEnvironment, sDMSInterval, hashMap);
        if (sDMSInterval.getObjId(systemEnvironment) == null) {
            return string5;
        }
        String string6 = string + "(" + string5 + "\n" + string + "\twith\n" + string + "\t\t" + (n == null ? "base = none" : "base = " + n2 + " " + sDMSInterval.getBaseIntervalAsString(systemEnvironment)) + ",\n" + string + "\t\t" + (n3 == null ? "duration = none" : "duration = " + n4 + " " + sDMSInterval.getDurationAsString(systemEnvironment)) + ",\n" + string + "\t\tgroup = " + DumpGroup.getDumpedName(systemEnvironment, sDMSGroup, hashMap) + ",\n" + string + "\t\t" + (bl ? "inverse" : "noinverse") + ",\n" + string + "\t\tsynctime = " + DumpIV.quotedString(new DateTime(l4, false).toString(null)) + ",\n" + (l2 != null ? string + "\t\tstarttime = " + DumpIV.quotedString(new DateTime(l2, false).toString(null)) + ",\n" : "") + (l3 != null ? string + "\t\tendtime = " + DumpIV.quotedString(new DateTime(l3, false).toString(null)) + ",\n" : "") + string + "\t\tembedded = " + (sDMSInterval2 == null ? "none" : DumpIV.renderInterval(systemEnvironment, sDMSInterval2, vector, hashMap, string + "\t")) + ",\n" + "\t" + string3 + ",\n" + "\t" + string2 + ",\n" + "\t" + string4 + "\n" + string + ")";
        return string6;
    }

    public static Vector dump(SystemEnvironment systemEnvironment, SDMSInterval sDMSInterval, Vector vector, HashMap hashMap) throws SDMSException {
        Vector<DumpLine> vector2 = new Vector<DumpLine>();
        Long l = sDMSInterval.getId(systemEnvironment);
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSInterval.getOwnerId(systemEnvironment));
        Long l2 = sDMSInterval.getStartTime(systemEnvironment);
        Long l3 = sDMSInterval.getEndTime(systemEnvironment);
        Integer n = sDMSInterval.getBaseInterval(systemEnvironment);
        Integer n2 = sDMSInterval.getBaseIntervalMultiplier(systemEnvironment);
        Integer n3 = sDMSInterval.getDuration(systemEnvironment);
        Integer n4 = sDMSInterval.getDurationMultiplier(systemEnvironment);
        Long l4 = sDMSInterval.getSyncTime(systemEnvironment);
        boolean bl = sDMSInterval.getIsInverse(systemEnvironment);
        Long l5 = sDMSInterval.getEmbeddedIntervalId(systemEnvironment);
        Long l6 = sDMSInterval.getSeId(systemEnvironment);
        String string = DumpIV.loadFilter(systemEnvironment, l, vector, hashMap, "");
        String string2 = DumpIV.loadSelection(systemEnvironment, l, "");
        String string3 = DumpIV.loadDispatch(systemEnvironment, l, vector, hashMap, "");
        String string4 = DumpIV.getDumpedURL(systemEnvironment, sDMSInterval, hashMap);
        String string5 = "create or alter " + string4 + "\nwith\n" + "\t" + (n == null ? "base = none" : "base = " + n2 + " " + sDMSInterval.getBaseIntervalAsString(systemEnvironment)) + ",\n" + "\t" + (n3 == null ? "duration = none" : "duration = " + n4 + " " + sDMSInterval.getDurationAsString(systemEnvironment)) + ",\n" + "\tgroup = " + DumpGroup.getDumpedName(systemEnvironment, sDMSGroup, hashMap) + ",\n" + "\t" + (bl ? "inverse" : "noinverse") + ",\n" + "\tsynctime = " + DumpIV.quotedString(new DateTime(l4, false).toString(null)) + ",\n" + (l2 != null ? "\tstarttime = " + DumpIV.quotedString(new DateTime(l2, false).toString(null)) + ",\n" : "") + (l3 != null ? "\tendtime = " + DumpIV.quotedString(new DateTime(l3, false).toString(null)) + ",\n" : "") + "\tembedded = " + "none" + ",\n" + "\t" + string2 + ";\n\n";
        vector2.add(new DumpLine(52, string5));
        string5 = "alter " + string4 + "\nwith\n" + "\t" + (l5 == null ? "embedded = none" : "embedded = " + DumpIV.getDumpedName(systemEnvironment, SDMSIntervalTable.getObject(systemEnvironment, l5), hashMap)) + ",\n" + "\t" + string + ",\n" + "\t" + string3 + ";\n\n";
        vector2.add(new DumpLine(54, string5));
        vector.add(string4);
        return vector2;
    }
}

