/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.dumpClasses;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.dumpClasses.DumpESD;
import de.independit.scheduler.server.parser.dumpClasses.DumpESM;
import de.independit.scheduler.server.parser.dumpClasses.DumpESP;
import de.independit.scheduler.server.parser.dumpClasses.DumpEST;
import de.independit.scheduler.server.parser.dumpClasses.DumpFP;
import de.independit.scheduler.server.parser.dumpClasses.DumpGroup;
import de.independit.scheduler.server.parser.dumpClasses.DumpIV;
import de.independit.scheduler.server.parser.dumpClasses.DumpLine;
import de.independit.scheduler.server.parser.dumpClasses.DumpNE;
import de.independit.scheduler.server.parser.dumpClasses.DumpNR;
import de.independit.scheduler.server.parser.dumpClasses.DumpRSD;
import de.independit.scheduler.server.parser.dumpClasses.DumpRSM;
import de.independit.scheduler.server.parser.dumpClasses.Dumper;
import de.independit.scheduler.server.repository.SDMSDependencyDefinition;
import de.independit.scheduler.server.repository.SDMSDependencyDefinitionTable;
import de.independit.scheduler.server.repository.SDMSDependencyState;
import de.independit.scheduler.server.repository.SDMSDependencyStateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSDependencyStateTable;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfileTable;
import de.independit.scheduler.server.repository.SDMSFootprintTable;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSIgnoredDependency;
import de.independit.scheduler.server.repository.SDMSIgnoredDependencyTable;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSResourceReqStates;
import de.independit.scheduler.server.repository.SDMSResourceReqStatesTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import java.util.HashMap;
import java.util.Vector;

public class DumpSE
extends Dumper {
    private static final String sep = "\n\t";
    private static final String komma = ",";

    public static String getDumpedURL(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, HashMap hashMap) throws SDMSException {
        return "job definition " + DumpSE.getDumpedName(systemEnvironment, sDMSSchedulingEntity, hashMap);
    }

    public static String getDumpedName(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, HashMap hashMap) throws SDMSException {
        return sDMSSchedulingEntity.pathVector(systemEnvironment).toQuotedString((HashMap)hashMap.get("FOLDER"));
    }

    public static Vector dump(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, Vector vector, HashMap hashMap) throws SDMSException {
        Vector<DumpLine> vector2 = new Vector<DumpLine>();
        String string = DumpSE.getDumpedURL(systemEnvironment, sDMSSchedulingEntity, hashMap);
        vector2.add(new DumpLine(36, DumpSE.singleItems(systemEnvironment, sDMSSchedulingEntity, string, hashMap)));
        String string2 = DumpSE.children(systemEnvironment, sDMSSchedulingEntity, string, hashMap);
        if (string2 != null) {
            vector2.add(new DumpLine(40, string2));
        }
        if ((string2 = DumpSE.dependencies(systemEnvironment, sDMSSchedulingEntity, string, hashMap)) != null) {
            vector2.add(new DumpLine(38, string2));
        }
        if ((string2 = DumpSE.parameters(systemEnvironment, sDMSSchedulingEntity, string, hashMap)) != null) {
            vector2.add(new DumpLine(41, string2));
        }
        vector.add(string);
        return vector2;
    }

    private static String singleItems(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, String string, HashMap hashMap) throws SDMSException {
        Long l = sDMSSchedulingEntity.getId(systemEnvironment);
        String string2 = "create or alter " + string + "\nwith" + (systemEnvironment.checkFeature("JOB_LEVEL_AGING_CONTROL") ? DumpSE.agingKlausel(systemEnvironment, sDMSSchedulingEntity) + DumpSE.minPrioKlausel(systemEnvironment, sDMSSchedulingEntity) : "") + sep + "children = none" + komma + DumpSE.depmodeKlausel(systemEnvironment, sDMSSchedulingEntity) + DumpSE.envKlausel(systemEnvironment, sDMSSchedulingEntity, hashMap) + DumpSE.errlogKlausel(systemEnvironment, sDMSSchedulingEntity) + DumpSE.footprintKlausel(systemEnvironment, sDMSSchedulingEntity, hashMap) + DumpSE.groupKlausel(systemEnvironment, sDMSSchedulingEntity, hashMap) + DumpSE.inheritPrivsKlausel(systemEnvironment, sDMSSchedulingEntity) + DumpSE.killKlausel(systemEnvironment, sDMSSchedulingEntity) + DumpSE.logfileKlausel(systemEnvironment, sDMSSchedulingEntity) + DumpSE.mappingKlausel(systemEnvironment, sDMSSchedulingEntity, hashMap) + DumpSE.masterKlausel(systemEnvironment, sDMSSchedulingEntity) + DumpSE.niceKlausel(systemEnvironment, sDMSSchedulingEntity) + DumpSE.parameterStub(systemEnvironment, sDMSSchedulingEntity) + DumpSE.profileKlausel(systemEnvironment, sDMSSchedulingEntity, hashMap) + sep + "required = none" + komma + DumpSE.rerunKlausel(systemEnvironment, sDMSSchedulingEntity) + DumpSE.resourceKlausel(systemEnvironment, sDMSSchedulingEntity, hashMap) + DumpSE.runtimeKlausel(systemEnvironment, sDMSSchedulingEntity) + DumpSE.runProgKlausel(systemEnvironment, sDMSSchedulingEntity) + DumpSE.suspendKlausel(systemEnvironment, sDMSSchedulingEntity) + DumpSE.timeoutKlausel(systemEnvironment, sDMSSchedulingEntity) + DumpSE.typeKlausel(systemEnvironment, sDMSSchedulingEntity) + DumpSE.workdirKlausel(systemEnvironment, sDMSSchedulingEntity) + ";\n\n";
        return string2;
    }

    private static String children(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, String string, HashMap hashMap) throws SDMSException {
        String string2;
        Long l = sDMSSchedulingEntity.getId(systemEnvironment);
        Vector vector = SDMSSchedulingHierarchyTable.idx_seParentId.getSortedVector(systemEnvironment, l);
        int n = vector.size();
        if (n == 0) {
            string2 = null;
        } else {
            string2 = "alter " + string + "\nadd or alter children = (";
            for (int i = 0; i < n; ++i) {
                Number number;
                Object object;
                SDMSSchedulingHierarchy sDMSSchedulingHierarchy = (SDMSSchedulingHierarchy)vector.get(i);
                SDMSSchedulingEntity sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSchedulingHierarchy.getSeChildId(systemEnvironment));
                String string3 = sDMSSchedulingHierarchy.getAliasName(systemEnvironment);
                String string4 = sDMSSchedulingHierarchy.getIsStatic(systemEnvironment) != false ? "static" : "dynamic";
                String string5 = null;
                if (sDMSSchedulingHierarchy.getIsDisabled(systemEnvironment).booleanValue()) {
                    string5 = "disable";
                } else if (SystemEnvironment.dumpLangLevel >= 1) {
                    string5 = "enable";
                }
                Integer n2 = sDMSSchedulingHierarchy.getPriority(systemEnvironment);
                String string6 = sDMSSchedulingHierarchy.getMergeModeAsString(systemEnvironment);
                String string7 = sDMSSchedulingHierarchy.getSuspendAsString(systemEnvironment);
                String string8 = null;
                if (sDMSSchedulingHierarchy.getSuspend(systemEnvironment) == 3) {
                    object = sDMSSchedulingHierarchy.getResumeAt(systemEnvironment);
                    if (object != null) {
                        string8 = "resume at '" + (String)object + "'";
                    } else {
                        number = sDMSSchedulingHierarchy.getResumeIn(systemEnvironment);
                        if (number != null) {
                            string8 = "resume in " + number + " " + sDMSSchedulingHierarchy.getResumeBaseAsString(systemEnvironment);
                        }
                    }
                }
                object = sDMSSchedulingHierarchy.getEstpId(systemEnvironment);
                number = sDMSSchedulingHierarchy.getIntId(systemEnvironment);
                Vector vector2 = SDMSIgnoredDependencyTable.idx_shId.getSortedVector(systemEnvironment, sDMSSchedulingHierarchy.getId(systemEnvironment));
                string2 = string2 + sep + DumpSE.getDumpedName(systemEnvironment, sDMSSchedulingEntity2, hashMap) + "\n\t\t" + "alias = " + (string3 == null ? "none" : string3) + "\n\t\t" + string7 + (string8 == null ? "" : "\n\t\t" + string8) + "\n\t\t" + "nicevalue = " + n2 + "\n\t\t" + string4 + (string5 == null ? "" : "\n\t\t" + string5) + (SystemEnvironment.dumpLangLevel >= 3 ? "\n\t\tinterval = " + (number == null ? "none" : DumpIV.getDumpedName(systemEnvironment, SDMSIntervalTable.getObject(systemEnvironment, number), hashMap)) : "") + (systemEnvironment.checkFeature("EXIT_STATE_TRANSLATION") ? "\n\t\ttranslation = " + (object == null ? "none" : DumpEST.getDumpedName(systemEnvironment, SDMSExitStateTranslationProfileTable.getObject(systemEnvironment, (Long)object), hashMap)) : "") + "\n\t\t" + "ignore dependency = ";
                if (vector2.size() == 0) {
                    string2 = string2 + "none";
                } else {
                    string2 = string2 + "(";
                    for (int j = 0; j < vector2.size(); ++j) {
                        SDMSIgnoredDependency sDMSIgnoredDependency = (SDMSIgnoredDependency)vector2.get(j);
                        string2 = string2 + "\n\t\t" + "\t" + DumpSE.quotedName(sDMSIgnoredDependency.getDdName(systemEnvironment));
                        if (j == vector2.size() - 1) continue;
                        string2 = string2 + komma;
                    }
                    string2 = string2 + "\n\t\t" + ")";
                }
                if (i == n - 1) continue;
                string2 = string2 + komma;
            }
            string2 = string2 + "\n);\n\n";
        }
        return string2;
    }

    private static String dependencies(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, String string, HashMap hashMap) throws SDMSException {
        String string2;
        Long l = sDMSSchedulingEntity.getId(systemEnvironment);
        Vector vector = SDMSDependencyDefinitionTable.idx_seDependentId.getSortedVector(systemEnvironment, l);
        int n = vector.size();
        if (n == 0) {
            string2 = null;
        } else {
            string2 = "alter " + string + "\nadd or alter required = (";
            for (int i = 0; i < n; ++i) {
                Object object;
                Comparable comparable;
                int n2;
                SDMSDependencyDefinition sDMSDependencyDefinition = (SDMSDependencyDefinition)vector.get(i);
                SDMSSchedulingEntity sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSDependencyDefinition.getSeRequiredId(systemEnvironment));
                String string3 = sDMSDependencyDefinition.getCondition(systemEnvironment);
                String string4 = sDMSDependencyDefinition.getName(systemEnvironment);
                String string5 = sDMSDependencyDefinition.getModeAsString(systemEnvironment);
                String string6 = sDMSDependencyDefinition.getUnresolvedHandlingAsString(systemEnvironment);
                Vector vector2 = SDMSDependencyStateTable.idx_ddId.getSortedVector(systemEnvironment, sDMSDependencyDefinition.getId(systemEnvironment));
                string2 = string2 + sep + DumpSE.getDumpedName(systemEnvironment, sDMSSchedulingEntity2, hashMap) + (string4 == null ? "" : "\n\t\tdependency " + DumpSE.quotedName(string4)) + "\n\t\t" + "mode = " + string5 + "\n\t\t" + "unresolved = " + string6 + (systemEnvironment.checkFeature("CONDITIONAL_DEPENDENCIES") ? "\n\t\tcondition = " + (string3 == null ? "none" : DumpSE.quotedString(string3)) : "") + "\n\t\t" + "state = ";
                if (vector2.size() == 0) {
                    n2 = sDMSDependencyDefinition.getStateSelection(systemEnvironment);
                    switch (n2) {
                        case 0: {
                            string2 = string2 + "none";
                            break;
                        }
                        case 1: {
                            string2 = string2 + "ALL REACHABLE";
                            break;
                        }
                        case 2: {
                            string2 = string2 + "UNREACHABLE";
                            break;
                        }
                        case 3: {
                            string2 = string2 + "DEFAULT";
                        }
                    }
                } else {
                    string2 = string2 + "(";
                    for (n2 = 0; n2 < vector2.size(); ++n2) {
                        comparable = (SDMSDependencyState)vector2.get(n2);
                        object = SDMSExitStateDefinitionTable.getObject(systemEnvironment, ((SDMSDependencyStateProxyGeneric)comparable).getEsdId(systemEnvironment));
                        string3 = ((SDMSDependencyStateProxyGeneric)comparable).getCondition(systemEnvironment);
                        string2 = string2 + "\n\t\t" + "\t" + DumpESD.getDumpedName(systemEnvironment, (SDMSExitStateDefinition)object, hashMap) + (systemEnvironment.checkFeature("CONDITIONAL_DEPENDENCIES") ? (string3 == null ? "" : "\n\t\t\t\tcondition = " + DumpSE.quotedString(string3)) : "");
                        if (n2 == vector2.size() - 1) continue;
                        string2 = string2 + komma;
                    }
                    string2 = string2 + "\n\t\t" + ")";
                }
                String string7 = sDMSDependencyDefinition.getResolveModeAsString(systemEnvironment);
                if (SystemEnvironment.dumpLangLevel >= 3) {
                    string2 = string2 + "\n\t\t" + "resolve = " + string7;
                    if (!string7.equals("INTERNAL")) {
                        comparable = sDMSDependencyDefinition.getExpiredAmount(systemEnvironment);
                        string2 = comparable != null ? string2 + "\n\t\t" + "expired = " + ((Integer)comparable).toString() + " " + sDMSDependencyDefinition.getExpiredBaseAsString(systemEnvironment) : string2 + "\n\t\t" + "expired = NONE";
                        object = sDMSDependencyDefinition.getSelectCondition(systemEnvironment);
                        string2 = string2 + "\n\t\t" + "select condition = " + (object == null ? "none" : DumpSE.quotedString((String)object));
                    }
                } else if (!string7.equals("INTERNAL")) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03801111300", "Cannot dump external dependencies with dumpLangLevel < 2.9"));
                }
                if (i == n - 1) continue;
                string2 = string2 + komma;
            }
            string2 = string2 + "\n);\n\n";
        }
        return string2;
    }

    private static String parameters(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, String string, HashMap hashMap) throws SDMSException {
        String string2;
        Long l = sDMSSchedulingEntity.getId(systemEnvironment);
        Vector vector = SDMSParameterDefinitionTable.idx_seId.getSortedVector(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment));
        int n = vector.size();
        if (n == 0) {
            string2 = null;
        } else {
            string2 = "alter " + string + "\nalter parameter = (";
            for (int i = 0; i < n; ++i) {
                SDMSParameterDefinition sDMSParameterDefinition = (SDMSParameterDefinition)vector.get(i);
                int n2 = sDMSParameterDefinition.getType(systemEnvironment);
                String string3 = sDMSParameterDefinition.getDefaultValue(systemEnvironment);
                Long l2 = sDMSParameterDefinition.getLinkPdId(systemEnvironment);
                String string4 = sDMSParameterDefinition.getExportName(systemEnvironment);
                boolean bl = sDMSParameterDefinition.getIsLocal(systemEnvironment);
                string2 = string2 + "\n\t\t" + DumpSE.quotedName(sDMSParameterDefinition.getName(systemEnvironment));
                switch (n2) {
                    case 40: 
                    case 50: 
                    case 70: {
                        string2 = string2 + "\n\t\t" + "\t" + sDMSParameterDefinition.getTypeAsString(systemEnvironment) + (string3 == null ? "" : " default = " + DumpSE.quotedString(string3.substring(1)));
                        break;
                    }
                    case 30: {
                        string2 = string2 + "\n\t\t" + "\t" + sDMSParameterDefinition.getTypeAsString(systemEnvironment) + " = " + DumpSE.quotedString(string3.substring(1));
                        break;
                    }
                    case 60: {
                        string2 = string2 + "\n\t\t" + "\t" + sDMSParameterDefinition.getAggFunctionAsString(systemEnvironment) + "(" + DumpSE.quotedString(string3.substring(1)) + ")";
                        break;
                    }
                    case 10: {
                        SDMSParameterDefinition sDMSParameterDefinition2 = SDMSParameterDefinitionTable.getObject(systemEnvironment, l2);
                        SDMSSchedulingEntity sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSParameterDefinition2.getSeId(systemEnvironment));
                        string2 = string2 + "\n\t\t" + "\treference " + DumpSE.getDumpedName(systemEnvironment, sDMSSchedulingEntity2, hashMap) + " (" + DumpSE.quotedName(sDMSParameterDefinition2.getName(systemEnvironment)) + ")";
                        break;
                    }
                    case 20: {
                        SDMSParameterDefinition sDMSParameterDefinition2 = SDMSParameterDefinitionTable.getObject(systemEnvironment, l2);
                        SDMSSchedulingEntity sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSParameterDefinition2.getSeId(systemEnvironment));
                        string2 = string2 + "\n\t\t" + "\treference child " + DumpSE.getDumpedName(systemEnvironment, sDMSSchedulingEntity2, hashMap) + " (" + DumpSE.quotedName(sDMSParameterDefinition2.getName(systemEnvironment)) + ")";
                        break;
                    }
                    case 91: {
                        SDMSParameterDefinition sDMSParameterDefinition2 = SDMSParameterDefinitionTable.getObject(systemEnvironment, l2);
                        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSParameterDefinition2.getSeId(systemEnvironment));
                        string2 = string2 + "\n\t\t" + "\treference resource " + DumpNR.getDumpedName(systemEnvironment, sDMSNamedResource, hashMap) + " (" + DumpSE.quotedName(sDMSParameterDefinition2.getName(systemEnvironment)) + ")";
                    }
                }
                if (bl) {
                    string2 = string2 + "\n\t\t" + "local";
                }
                if (SystemEnvironment.dumpLangLevel >= 1 || string4 != null) {
                    string2 = string2 + "\n\t\t" + "EXPORT = " + (string4 == null ? "NONE" : DumpSE.quotedName(string4));
                }
                if (i == n - 1) continue;
                string2 = string2 + komma;
            }
            string2 = string2 + "\n\t);\n\n";
        }
        return string2;
    }

    private static String agingKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        if (!systemEnvironment.checkFeature("JOB_LEVEL_AGING_CONTROL")) {
            return "";
        }
        Integer n = sDMSSchedulingEntity.getAgingAmount(systemEnvironment);
        String string = n != null ? "\n\taging = " + n + " " + sDMSSchedulingEntity.getAgingBaseAsString(systemEnvironment) + komma : "\n\taging = none,";
        return string;
    }

    private static String depmodeKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        int n = sDMSSchedulingEntity.getDependencyOperation(systemEnvironment);
        String string = "\n\tdependency mode = " + (n == 1 ? "all" : "any") + komma;
        return string;
    }

    private static String envKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, HashMap hashMap) throws SDMSException {
        String string;
        Long l = sDMSSchedulingEntity.getNeId(systemEnvironment);
        if (l != null) {
            String string2 = DumpNE.getDumpedName(systemEnvironment, SDMSNamedEnvironmentTable.getObject(systemEnvironment, l), hashMap);
            string = "\n\tenvironment = " + string2 + komma;
        } else {
            string = "";
        }
        return string;
    }

    private static String errlogKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        String string = sDMSSchedulingEntity.getErrlogfile(systemEnvironment);
        String string2 = sDMSSchedulingEntity.getTruncErrlogAsString(systemEnvironment);
        if (string2 == null) {
            string2 = "NOTRUNC";
        }
        String string3 = "\n\terrlog = " + (string == null ? "none" : DumpSE.quotedString(string) + " " + string2) + komma;
        return string3;
    }

    private static String footprintKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, HashMap hashMap) throws SDMSException {
        Long l = sDMSSchedulingEntity.getFpId(systemEnvironment);
        String string = l != null ? "\n\tfootprint = " + DumpFP.getDumpedName(systemEnvironment, SDMSFootprintTable.getObject(systemEnvironment, l), hashMap) + komma : "";
        return string;
    }

    private static String groupKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, HashMap hashMap) throws SDMSException {
        String string = DumpGroup.getDumpedName(systemEnvironment, SDMSGroupTable.getObject(systemEnvironment, sDMSSchedulingEntity.getOwnerId(systemEnvironment)), hashMap);
        String string2 = "\n\tgroup = " + string + komma;
        return string2;
    }

    private static String inheritPrivsKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        String[] stringArray = new SDMSPrivilege(systemEnvironment, (long)(sDMSSchedulingEntity.getInheritPrivs(systemEnvironment) & 0xFFFFFFFFFFFFFFFAL)).asString();
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(string);
            stringBuffer.append(stringArray[i]);
            string = ", ";
        }
        String string2 = "\n\tinherit grants = " + (stringBuffer.length() == 0 ? "none" : "(" + stringBuffer + ")") + komma;
        return string2;
    }

    private static String killKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        String string = sDMSSchedulingEntity.getKillProgram(systemEnvironment);
        String string2 = "\n\tkill program = " + (string == null ? "none" : DumpSE.quotedString(string)) + komma;
        return string2;
    }

    private static String logfileKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        String string = sDMSSchedulingEntity.getLogfile(systemEnvironment);
        String string2 = sDMSSchedulingEntity.getTruncLogAsString(systemEnvironment);
        if (string2 == null) {
            string2 = "NOTRUNC";
        }
        String string3 = "\n\tlogfile = " + (string == null ? "none" : DumpSE.quotedString(string) + " " + string2) + komma;
        return string3;
    }

    private static String mappingKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, HashMap hashMap) throws SDMSException {
        Long l = sDMSSchedulingEntity.getEsmpId(systemEnvironment);
        String string = l != null ? "\n\tmapping = " + DumpESM.getDumpedName(systemEnvironment, SDMSExitStateMappingProfileTable.getObject(systemEnvironment, l), hashMap) + komma : "";
        return string;
    }

    private static String masterKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        String string = sep + sDMSSchedulingEntity.getMasterSubmittableAsString(systemEnvironment) + komma;
        return string;
    }

    private static String minPrioKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        if (!systemEnvironment.checkFeature("JOB_LEVEL_AGING_CONTROL")) {
            return "";
        }
        Integer n = sDMSSchedulingEntity.getMinPriority(systemEnvironment);
        String string = n != null ? "\n\tmin priority = " + n + komma : "\n\tmin priority = none,";
        return string;
    }

    private static String niceKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        String string = "";
        Integer n = sDMSSchedulingEntity.getType(systemEnvironment);
        Integer n2 = sDMSSchedulingEntity.getPriority(systemEnvironment);
        string = n == 1 ? "\n\tpriority = " + (n2 == null ? "none" : n2.toString()) + komma : (n == 2 ? "\n\tnicevalue = " + (n2 == null ? "none" : n2.toString()) + komma : "");
        return string;
    }

    private static String profileKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, HashMap hashMap) throws SDMSException {
        Long l = sDMSSchedulingEntity.getEspId(systemEnvironment);
        String string = "\n\tprofile = " + DumpESP.getDumpedName(systemEnvironment, SDMSExitStateProfileTable.getObject(systemEnvironment, l), hashMap) + komma;
        return string;
    }

    private static String rerunKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        String string = sDMSSchedulingEntity.getRerunProgram(systemEnvironment);
        String string2 = "\n\trerun program = " + (string == null ? "none" : DumpSE.quotedString(string)) + komma;
        return string2;
    }

    private static String resourceKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, HashMap hashMap) throws SDMSException {
        String string;
        Vector vector = SDMSResourceRequirementTable.idx_seId.getSortedVector(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment));
        int n = vector.size();
        if (n == 0) {
            string = "\n\tresource = none,";
        } else {
            string = "\n\tresource = (";
            for (int i = 0; i < n; ++i) {
                Object object;
                SDMSResourceRequirement sDMSResourceRequirement = (SDMSResourceRequirement)vector.get(i);
                Long l = sDMSResourceRequirement.getNrId(systemEnvironment);
                SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l);
                Integer n2 = sDMSNamedResource.getUsage(systemEnvironment);
                String string2 = DumpNR.getDumpedName(systemEnvironment, sDMSNamedResource, hashMap);
                string = string + sep + "\t" + string2;
                if (n2 == 4 || n2 == 2) {
                    string = string + "\n\t\t\t" + "amount = " + sDMSResourceRequirement.getAmount(systemEnvironment) + "\n\t\t\t" + sDMSResourceRequirement.getKeepModeAsString(systemEnvironment);
                }
                if (n2 == 4) {
                    Object object2;
                    Object object3;
                    object = sDMSResourceRequirement.getRsmpId(systemEnvironment);
                    Integer n3 = sDMSResourceRequirement.getExpiredAmount(systemEnvironment);
                    if (sDMSResourceRequirement.getIsSticky(systemEnvironment).booleanValue()) {
                        string = string + "\n\t\t\t" + "STICKY";
                        object3 = sDMSResourceRequirement.getStickyName(systemEnvironment);
                        object2 = sDMSResourceRequirement.getStickyParent(systemEnvironment);
                        if (object3 != null || object2 != null) {
                            string = string + " (";
                            if (object3 != null) {
                                string = string + DumpSE.quotedName((String)object3);
                            }
                            if (object2 != null) {
                                SDMSSchedulingEntity sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, (Long)object2);
                                string = string + (object3 == null ? "" : ", ") + DumpSE.getDumpedName(systemEnvironment, sDMSSchedulingEntity2, hashMap);
                            }
                            string = string + ")";
                        }
                    } else {
                        string = string + "\n\t\t\t" + "NOSTICKY";
                    }
                    string = string + "\n\t\t\t" + "lockmode = " + sDMSResourceRequirement.getLockmodeAsString(systemEnvironment) + "\n\t\t\t" + "state mapping = " + (object == null ? "none" : DumpRSM.getDumpedName(systemEnvironment, SDMSResourceStateMappingProfileTable.getObject(systemEnvironment, (Long)object), hashMap)) + "\n\t\t\t" + "expired = " + (n3 == null ? "none" : n3.toString() + " " + sDMSResourceRequirement.getExpiredBaseAsString(systemEnvironment));
                    if (SystemEnvironment.dumpLangLevel >= 2 && n3 != null && sDMSResourceRequirement.getIgnoreOnRerun(systemEnvironment).booleanValue()) {
                        string = string + " ignore on rerun";
                    }
                    string = string + "\n\t\t\t" + "state = ";
                    object3 = SDMSResourceReqStatesTable.idx_rrId.getSortedVector(systemEnvironment, sDMSResourceRequirement.getId(systemEnvironment));
                    if (((Vector)object3).size() == 0) {
                        string = string + "none";
                    } else {
                        object2 = "";
                        string = string + "(";
                        for (int j = 0; j < ((Vector)object3).size(); ++j) {
                            SDMSResourceReqStates sDMSResourceReqStates = (SDMSResourceReqStates)((Vector)object3).get(j);
                            Long l2 = sDMSResourceReqStates.getRsdId(systemEnvironment);
                            string = string + (String)object2 + "\n\t\t\t" + "\t" + DumpRSD.getDumpedName(systemEnvironment, SDMSResourceStateDefinitionTable.getObject(systemEnvironment, l2), hashMap);
                            object2 = komma;
                        }
                        string = string + "\n\t\t\t" + ")";
                    }
                }
                if (n2 == 1 && (object = sDMSResourceRequirement.getCondition(systemEnvironment)) != null) {
                    string = string + " condition = " + DumpSE.quotedString((String)object);
                }
                if (i == n - 1) continue;
                string = string + komma;
            }
            string = string + sep + ")" + komma;
        }
        return string;
    }

    private static String runtimeKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        Integer n = sDMSSchedulingEntity.getExpectedRuntime(systemEnvironment);
        String string = n != null ? "\n\truntime = " + n + komma : "";
        Integer n2 = sDMSSchedulingEntity.getExpectedFinaltime(systemEnvironment);
        if (n2 != null) {
            string = string + sep + "runtime final = " + n2 + komma;
        }
        return string;
    }

    private static String runProgKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        String string = sDMSSchedulingEntity.getRunProgram(systemEnvironment);
        String string2 = "\n\trun program = " + (string == null ? "none" : DumpSE.quotedString(string)) + komma;
        return string2;
    }

    private static String suspendKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        String string = sep + sDMSSchedulingEntity.getSubmitSuspendedAsString(systemEnvironment) + komma;
        String string2 = sDMSSchedulingEntity.getResumeAt(systemEnvironment);
        if (string2 != null) {
            string = string + sep + "resume at'" + string2 + "'" + komma;
        } else {
            Integer n = sDMSSchedulingEntity.getResumeIn(systemEnvironment);
            if (n != null) {
                string = string + sep + "resume in " + n + " " + sDMSSchedulingEntity.getResumeBaseAsString(systemEnvironment) + komma;
            }
        }
        return string;
    }

    private static String timeoutKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        String string;
        Integer n = sDMSSchedulingEntity.getTimeoutAmount(systemEnvironment);
        Long l = sDMSSchedulingEntity.getTimeoutStateId(systemEnvironment);
        if (n != null) {
            String string2 = sDMSSchedulingEntity.getTimeoutBaseAsString(systemEnvironment);
            string = "\n\ttimeout = " + n + " " + string2 + " state " + DumpSE.quotedName(SDMSExitStateDefinitionTable.getObject(systemEnvironment, l).getName(systemEnvironment)) + komma;
        } else {
            string = "";
        }
        return string;
    }

    private static String typeKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        String string = "\n\ttype = " + sDMSSchedulingEntity.getTypeAsString(systemEnvironment) + komma;
        return string;
    }

    private static String workdirKlausel(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        String string = sDMSSchedulingEntity.getWorkdir(systemEnvironment);
        String string2 = string != null ? "\n\tworkdir = " + DumpSE.quotedString(string) : "\n\tworkdir = none";
        return string2;
    }

    private static String parameterStub(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        String string = "\n\tparameters = ";
        Vector vector = SDMSParameterDefinitionTable.idx_seId.getSortedVector(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment));
        int n = vector.size();
        if (n == 0) {
            string = string + "none";
        } else {
            string = string + "(";
            for (int i = 0; i < n; ++i) {
                string = string + sep + "\t" + DumpSE.quotedName(((SDMSParameterDefinition)vector.get(i)).getName(systemEnvironment)) + (i == n - 1 ? "" : komma);
            }
            string = string + sep + ")";
        }
        string = string + komma;
        return string;
    }
}

