/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.filter;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.filter.Filter;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import java.util.HashSet;
import java.util.Iterator;

public class JobStateFilter
extends Filter {
    HashSet jobStates;

    public JobStateFilter(SystemEnvironment systemEnvironment, HashSet hashSet) {
        this.jobStates = hashSet;
    }

    @Override
    public boolean valid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
        try {
            SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)sDMSProxy;
            if (this.jobStates.contains(sDMSSubmittedEntity.getState(systemEnvironment))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JobStateFilter)) {
            return false;
        }
        JobStateFilter jobStateFilter = (JobStateFilter)object;
        if (this.jobStates.size() != jobStateFilter.jobStates.size()) {
            return false;
        }
        Iterator iterator = this.jobStates.iterator();
        while (iterator.hasNext()) {
            if (jobStateFilter.jobStates.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }
}

