/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.filter;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.filter.Filter;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;

public class RestartableFilter
extends Filter {
    Integer stateType;
    public boolean mastersFirst;

    public RestartableFilter(SystemEnvironment systemEnvironment, Integer n, boolean bl) {
        this.stateType = n;
        this.mastersFirst = bl;
    }

    @Override
    public boolean valid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
        try {
            SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)sDMSProxy;
            if (this.mastersFirst && sDMSSubmittedEntity.getCntRestartable(systemEnvironment) > 0) {
                return true;
            }
            int n = sDMSSubmittedEntity.getState(systemEnvironment);
            if (this.stateType == 1) {
                if (sDMSSubmittedEntity.getJobIsRestartable(systemEnvironment).booleanValue()) {
                    return true;
                }
                if (n == 13 || n == 14 || n == 15) {
                    return true;
                }
            }
            if (n != 12 && n != 11) {
                return false;
            }
            if (this.stateType == 3) {
                return sDMSSubmittedEntity.getJobIsFinal(systemEnvironment) != false;
            }
            if (this.stateType == 2) {
                if (sDMSSubmittedEntity.getJobIsFinal(systemEnvironment).booleanValue()) {
                    return false;
                }
                return sDMSSubmittedEntity.getJobIsRestartable(systemEnvironment) == false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RestartableFilter)) {
            return false;
        }
        RestartableFilter restartableFilter = (RestartableFilter)object;
        if (this.mastersFirst != restartableFilter.mastersFirst) {
            return false;
        }
        return this.stateType.equals(restartableFilter.stateType);
    }
}

