/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcher;
import de.independit.scheduler.server.repository.SDMSIntervalTable;

class DispatchRule {
    public SDMSInterval selInterval;
    public SDMSInterval fltInterval;
    public String drName;
    public String selName;
    public String fltName;
    public boolean isActive;
    public boolean isEnabled;
    public int seqNo;

    public DispatchRule() {
        this.selInterval = null;
        this.fltInterval = null;
        this.drName = null;
        this.selName = null;
        this.fltName = null;
        this.isActive = false;
        this.isEnabled = false;
    }

    public DispatchRule(SystemEnvironment systemEnvironment, SDMSIntervalDispatcher sDMSIntervalDispatcher) throws SDMSException {
        Long l = sDMSIntervalDispatcher.getSelectIntId(systemEnvironment);
        if (l == null) {
            this.selInterval = null;
            this.selName = null;
        } else {
            this.selInterval = SDMSIntervalTable.getObject(systemEnvironment, l);
            this.selName = this.selInterval.getName(systemEnvironment);
        }
        Long l2 = sDMSIntervalDispatcher.getFilterIntId(systemEnvironment);
        if (l2 == null) {
            this.fltInterval = null;
            this.fltName = null;
        } else {
            this.fltInterval = SDMSIntervalTable.getObject(systemEnvironment, l2);
            this.fltName = this.fltInterval.getName(systemEnvironment);
        }
        this.isActive = sDMSIntervalDispatcher.getIsActive(systemEnvironment);
        this.isEnabled = sDMSIntervalDispatcher.getIsEnabled(systemEnvironment);
        this.seqNo = sDMSIntervalDispatcher.getSeqNo(systemEnvironment);
        this.drName = sDMSIntervalDispatcher.getName(systemEnvironment);
    }

    public String toString() {
        return "DispatchRule " + this.drName + ": seqNo = " + this.seqNo + ", sel = " + this.selName + ", flt = " + this.fltName + ", isActive = " + this.isActive + ", isEnabled = " + this.isEnabled;
    }
}

