/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSDependencyInstance;
import de.independit.scheduler.server.repository.SDMSDependencyInstanceTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSDependencyInstanceGeneric
extends SDMSObject
implements Cloneable {
    public static final int OPEN = 0;
    public static final int FULFILLED = 1;
    public static final int FAILED = 2;
    public static final int BROKEN = 3;
    public static final int DEFERRED = 4;
    public static final int CANCELLED = 8;
    public static final int NO = 0;
    public static final int YES = 1;
    public static final int RECURSIVE = 2;
    public static final int AND = 1;
    public static final int OR = 2;
    public static final int nr_id = 1;
    public static final int nr_ddId = 2;
    public static final int nr_dependentId = 3;
    public static final int nr_dependentIdOrig = 4;
    public static final int nr_dependencyOperation = 5;
    public static final int nr_requiredId = 6;
    public static final int nr_requiredSeId = 7;
    public static final int nr_state = 8;
    public static final int nr_ignore = 9;
    public static final int nr_diIdOrig = 10;
    public static final int nr_seVersion = 11;
    public static final int nr_creatorUId = 12;
    public static final int nr_createTs = 13;
    public static final int nr_changerUId = 14;
    public static final int nr_changeTs = 15;
    public static String tableName = "DEPENDENCY_INSTANCE";
    protected Long ddId;
    protected Long dependentId;
    protected Long dependentIdOrig;
    protected Integer dependencyOperation;
    protected Long requiredId;
    protected Long requiredSeId;
    protected Integer state;
    protected Integer ignore;
    protected Long diIdOrig;
    protected Long seVersion;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSDependencyInstanceGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Integer n, Long l4, Long l5, Integer n2, Integer n3, Long l6, Long l7, Long l8, Long l9, Long l10, Long l11) throws SDMSException {
        super(systemEnvironment, SDMSDependencyInstanceTableGeneric.table);
        this.ddId = l;
        this.dependentId = l2;
        this.dependentIdOrig = l3;
        this.dependencyOperation = n;
        this.requiredId = l4;
        this.requiredSeId = l5;
        this.state = n2;
        this.ignore = n3;
        this.diIdOrig = l6;
        this.seVersion = l7;
        this.creatorUId = l8;
        this.createTs = l9;
        this.changerUId = l10;
        this.changeTs = l11;
    }

    public Long getDdId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ddId;
    }

    public void setDdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.ddId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyInstance) Change of system object not allowed"));
            }
            SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric = (SDMSDependencyInstanceGeneric)this.change(systemEnvironment);
            sDMSDependencyInstanceGeneric.ddId = l;
            sDMSDependencyInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSDependencyInstanceGeneric.changeTs = systemEnvironment.txTime();
            sDMSDependencyInstanceGeneric.versions.table.index(systemEnvironment, sDMSDependencyInstanceGeneric, 33L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getDependentId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.dependentId;
    }

    public void setDependentId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.dependentId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyInstance) Change of system object not allowed"));
            }
            SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric = (SDMSDependencyInstanceGeneric)this.change(systemEnvironment);
            sDMSDependencyInstanceGeneric.dependentId = l;
            sDMSDependencyInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSDependencyInstanceGeneric.changeTs = systemEnvironment.txTime();
            sDMSDependencyInstanceGeneric.versions.table.index(systemEnvironment, sDMSDependencyInstanceGeneric, 98L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getDependentIdOrig(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.dependentIdOrig;
    }

    public void setDependentIdOrig(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.dependentIdOrig.equals(l)) {
            return;
        }
        SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyInstance) Change of system object not allowed"));
        }
        if (sDMSDependencyInstanceGeneric.versions.o_v == null || sDMSDependencyInstanceGeneric.versions.o_v.size() == 0 || sDMSDependencyInstanceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyInstanceGeneric = (SDMSDependencyInstanceGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyInstanceGeneric.dependentIdOrig = l;
        sDMSDependencyInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSDependencyInstanceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyInstanceGeneric != this) {
            sDMSDependencyInstanceGeneric.versions.table.index(systemEnvironment, sDMSDependencyInstanceGeneric, 0L);
        }
    }

    public Integer getDependencyOperation(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.dependencyOperation;
    }

    public String getDependencyOperationAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getDependencyOperation(systemEnvironment);
        switch (n) {
            case 1: {
                return "AND";
            }
            case 2: {
                return "OR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown DependencyInstance.dependencyOperation: $1", (Object)this.getDependencyOperation(systemEnvironment)));
    }

    public void setDependencyOperation(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.dependencyOperation.equals(n)) {
            return;
        }
        SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyInstance) Change of system object not allowed"));
        }
        if (sDMSDependencyInstanceGeneric.versions.o_v == null || sDMSDependencyInstanceGeneric.versions.o_v.size() == 0 || sDMSDependencyInstanceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyInstanceGeneric = (SDMSDependencyInstanceGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyInstanceGeneric.dependencyOperation = n;
        sDMSDependencyInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSDependencyInstanceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyInstanceGeneric != this) {
            sDMSDependencyInstanceGeneric.versions.table.index(systemEnvironment, sDMSDependencyInstanceGeneric, 0L);
        }
    }

    public Long getRequiredId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.requiredId;
    }

    public void setRequiredId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.requiredId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyInstance) Change of system object not allowed"));
            }
            SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric = (SDMSDependencyInstanceGeneric)this.change(systemEnvironment);
            sDMSDependencyInstanceGeneric.requiredId = l;
            sDMSDependencyInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSDependencyInstanceGeneric.changeTs = systemEnvironment.txTime();
            sDMSDependencyInstanceGeneric.versions.table.index(systemEnvironment, sDMSDependencyInstanceGeneric, 100L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getRequiredSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.requiredSeId;
    }

    public void setRequiredSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.requiredSeId)) {
            return;
        }
        if (l == null && this.requiredSeId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyInstance) Change of system object not allowed"));
            }
            SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric = (SDMSDependencyInstanceGeneric)this.change(systemEnvironment);
            sDMSDependencyInstanceGeneric.requiredSeId = l;
            sDMSDependencyInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSDependencyInstanceGeneric.changeTs = systemEnvironment.txTime();
            sDMSDependencyInstanceGeneric.versions.table.index(systemEnvironment, sDMSDependencyInstanceGeneric, 8L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getState(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.state;
    }

    public String getStateAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getState(systemEnvironment);
        switch (n) {
            case 0: {
                return "OPEN";
            }
            case 1: {
                return "FULFILLED";
            }
            case 2: {
                return "FAILED";
            }
            case 3: {
                return "BROKEN";
            }
            case 4: {
                return "DEFERRED";
            }
            case 8: {
                return "CANCELLED";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown DependencyInstance.state: $1", (Object)this.getState(systemEnvironment)));
    }

    public void setState(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.state.equals(n)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyInstance) Change of system object not allowed"));
            }
            SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric = (SDMSDependencyInstanceGeneric)this.change(systemEnvironment);
            sDMSDependencyInstanceGeneric.state = n;
            sDMSDependencyInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSDependencyInstanceGeneric.changeTs = systemEnvironment.txTime();
            sDMSDependencyInstanceGeneric.versions.table.index(systemEnvironment, sDMSDependencyInstanceGeneric, 64L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getIgnore(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ignore;
    }

    public String getIgnoreAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getIgnore(systemEnvironment);
        switch (n) {
            case 0: {
                return "NO";
            }
            case 1: {
                return "YES";
            }
            case 2: {
                return "RECURSIVE";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown DependencyInstance.ignore: $1", (Object)this.getIgnore(systemEnvironment)));
    }

    public void setIgnore(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.ignore.equals(n)) {
            return;
        }
        SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyInstance) Change of system object not allowed"));
        }
        if (sDMSDependencyInstanceGeneric.versions.o_v == null || sDMSDependencyInstanceGeneric.versions.o_v.size() == 0 || sDMSDependencyInstanceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyInstanceGeneric = (SDMSDependencyInstanceGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyInstanceGeneric.ignore = n;
        sDMSDependencyInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSDependencyInstanceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyInstanceGeneric != this) {
            sDMSDependencyInstanceGeneric.versions.table.index(systemEnvironment, sDMSDependencyInstanceGeneric, 0L);
        }
    }

    public Long getDiIdOrig(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.diIdOrig;
    }

    public void setDiIdOrig(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.diIdOrig.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyInstance) Change of system object not allowed"));
            }
            SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric = (SDMSDependencyInstanceGeneric)this.change(systemEnvironment);
            sDMSDependencyInstanceGeneric.diIdOrig = l;
            sDMSDependencyInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSDependencyInstanceGeneric.changeTs = systemEnvironment.txTime();
            sDMSDependencyInstanceGeneric.versions.table.index(systemEnvironment, sDMSDependencyInstanceGeneric, 16L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getSeVersion(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seVersion;
    }

    public void setSeVersion(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.seVersion.equals(l)) {
            return;
        }
        SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyInstance) Change of system object not allowed"));
        }
        if (sDMSDependencyInstanceGeneric.versions.o_v == null || sDMSDependencyInstanceGeneric.versions.o_v.size() == 0 || sDMSDependencyInstanceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyInstanceGeneric = (SDMSDependencyInstanceGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyInstanceGeneric.seVersion = l;
        sDMSDependencyInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSDependencyInstanceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyInstanceGeneric != this) {
            sDMSDependencyInstanceGeneric.versions.table.index(systemEnvironment, sDMSDependencyInstanceGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyInstance) Change of system object not allowed"));
        }
        if (sDMSDependencyInstanceGeneric.versions.o_v == null || sDMSDependencyInstanceGeneric.versions.o_v.size() == 0 || sDMSDependencyInstanceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyInstanceGeneric = (SDMSDependencyInstanceGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyInstanceGeneric.creatorUId = l;
        sDMSDependencyInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSDependencyInstanceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyInstanceGeneric != this) {
            sDMSDependencyInstanceGeneric.versions.table.index(systemEnvironment, sDMSDependencyInstanceGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(DependencyInstance) Change of system object not allowed"));
        }
        if (sDMSDependencyInstanceGeneric.versions.o_v == null || sDMSDependencyInstanceGeneric.versions.o_v.size() == 0 || sDMSDependencyInstanceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyInstanceGeneric = (SDMSDependencyInstanceGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyInstanceGeneric.createTs = l;
        sDMSDependencyInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSDependencyInstanceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyInstanceGeneric != this) {
            sDMSDependencyInstanceGeneric.versions.table.index(systemEnvironment, sDMSDependencyInstanceGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric = this;
        if (sDMSDependencyInstanceGeneric.versions.o_v == null || sDMSDependencyInstanceGeneric.versions.o_v.size() == 0 || sDMSDependencyInstanceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyInstanceGeneric = (SDMSDependencyInstanceGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyInstanceGeneric.changerUId = l;
        sDMSDependencyInstanceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSDependencyInstanceGeneric != this) {
            sDMSDependencyInstanceGeneric.versions.table.index(systemEnvironment, sDMSDependencyInstanceGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric = this;
        if (sDMSDependencyInstanceGeneric.versions.o_v == null || sDMSDependencyInstanceGeneric.versions.o_v.size() == 0 || sDMSDependencyInstanceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSDependencyInstanceGeneric = (SDMSDependencyInstanceGeneric)this.change(systemEnvironment);
        }
        sDMSDependencyInstanceGeneric.changeTs = l;
        sDMSDependencyInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSDependencyInstanceGeneric != this) {
            sDMSDependencyInstanceGeneric.versions.table.index(systemEnvironment, sDMSDependencyInstanceGeneric, 0L);
        }
    }

    public SDMSDependencyInstanceGeneric set_DdIdDependentIdRequiredId(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3) throws SDMSException {
        SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(DependencyInstance) Change of system object not allowed"));
            }
            sDMSDependencyInstanceGeneric = (SDMSDependencyInstanceGeneric)this.change(systemEnvironment);
            sDMSDependencyInstanceGeneric.ddId = l;
            sDMSDependencyInstanceGeneric.dependentId = l2;
            sDMSDependencyInstanceGeneric.requiredId = l3;
            sDMSDependencyInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSDependencyInstanceGeneric.changeTs = systemEnvironment.txTime();
            sDMSDependencyInstanceGeneric.versions.table.index(systemEnvironment, sDMSDependencyInstanceGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSDependencyInstanceGeneric;
    }

    public SDMSDependencyInstanceGeneric set_DependentIdRequiredIdState(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n) throws SDMSException {
        SDMSDependencyInstanceGeneric sDMSDependencyInstanceGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(DependencyInstance) Change of system object not allowed"));
            }
            sDMSDependencyInstanceGeneric = (SDMSDependencyInstanceGeneric)this.change(systemEnvironment);
            sDMSDependencyInstanceGeneric.dependentId = l;
            sDMSDependencyInstanceGeneric.requiredId = l2;
            sDMSDependencyInstanceGeneric.state = n;
            sDMSDependencyInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSDependencyInstanceGeneric.changeTs = systemEnvironment.txTime();
            sDMSDependencyInstanceGeneric.versions.table.index(systemEnvironment, sDMSDependencyInstanceGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSDependencyInstanceGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return SDMSDependencyInstance.getProxy(systemEnvironment, this);
    }

    protected SDMSDependencyInstanceGeneric(Long l, Long l2, Long l3, Long l4, Integer n, Long l5, Long l6, Integer n2, Integer n3, Long l7, Long l8, Long l9, Long l10, Long l11, Long l12, long l13, long l14) {
        this.id = l;
        this.ddId = l2;
        this.dependentId = l3;
        this.dependentIdOrig = l4;
        this.dependencyOperation = n;
        this.requiredId = l5;
        this.requiredSeId = l6;
        this.state = n2;
        this.ignore = n3;
        this.diIdOrig = l7;
        this.seVersion = l8;
        this.creatorUId = l9;
        this.createTs = l10;
        this.changerUId = l11;
        this.changeTs = l12;
        this.validFrom = l13;
        this.validTo = l14;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "DEPENDENCY_INSTANCE" + string3 + " (" + "ID" + ", " + string2 + "DD_ID" + string3 + ", " + string2 + "DEPENDENT_ID" + string3 + ", " + string2 + "DEPENDENT_ID_ORIG" + string3 + ", " + string2 + "DEPENDENCY_OPERATION" + string3 + ", " + string2 + "REQUIRED_ID" + string3 + ", " + string2 + "REQUIRED_SE_ID" + string3 + ", " + string2 + "STATE" + string3 + ", " + string2 + "IGNORE" + string3 + ", " + string2 + "DI_ID_ORIG" + string3 + ", " + string2 + "SE_VERSION" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ")";
                SDMSDependencyInstanceGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "DependencyInstance: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.ddId);
            preparedStatement.setLong(3, this.dependentId);
            preparedStatement.setLong(4, this.dependentIdOrig);
            preparedStatement.setInt(5, this.dependencyOperation);
            preparedStatement.setLong(6, this.requiredId);
            if (this.requiredSeId == null) {
                preparedStatement.setNull(7, 4);
            } else {
                preparedStatement.setLong(7, this.requiredSeId);
            }
            preparedStatement.setInt(8, this.state);
            preparedStatement.setInt(9, this.ignore);
            preparedStatement.setLong(10, this.diIdOrig);
            preparedStatement.setLong(11, this.seVersion);
            preparedStatement.setLong(12, this.creatorUId);
            preparedStatement.setLong(13, this.createTs);
            preparedStatement.setLong(14, this.changerUId);
            preparedStatement.setLong(15, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "DependencyInstance: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "DEPENDENCY_INSTANCE" + string3 + " WHERE ID = ?";
                SDMSDependencyInstanceGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "DependencyInstance: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "DependencyInstance: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "DEPENDENCY_INSTANCE" + string3 + " SET " + "" + string2 + "DD_ID" + string3 + " = ? " + ", " + string2 + "DEPENDENT_ID" + string3 + " = ? " + ", " + string2 + "DEPENDENT_ID_ORIG" + string3 + " = ? " + ", " + string2 + "DEPENDENCY_OPERATION" + string3 + " = ? " + ", " + string2 + "REQUIRED_ID" + string3 + " = ? " + ", " + string2 + "REQUIRED_SE_ID" + string3 + " = ? " + ", " + string2 + "STATE" + string3 + " = ? " + ", " + string2 + "IGNORE" + string3 + " = ? " + ", " + string2 + "DI_ID_ORIG" + string3 + " = ? " + ", " + string2 + "SE_VERSION" + string3 + " = ? " + ", " + string2 + "CREATOR_U_ID" + string3 + " = ? " + ", " + string2 + "CREATE_TS" + string3 + " = ? " + ", " + string2 + "CHANGER_U_ID" + string3 + " = ? " + ", " + string2 + "CHANGE_TS" + string3 + " = ? " + "WHERE ID = ?";
                SDMSDependencyInstanceGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "DependencyInstance: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.ddId);
            preparedStatement.setLong(2, this.dependentId);
            preparedStatement.setLong(3, this.dependentIdOrig);
            preparedStatement.setInt(4, this.dependencyOperation);
            preparedStatement.setLong(5, this.requiredId);
            if (this.requiredSeId == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setLong(6, this.requiredSeId);
            }
            preparedStatement.setInt(7, this.state);
            preparedStatement.setInt(8, this.ignore);
            preparedStatement.setLong(9, this.diIdOrig);
            preparedStatement.setLong(10, this.seVersion);
            preparedStatement.setLong(11, this.creatorUId);
            preparedStatement.setLong(12, this.createTs);
            preparedStatement.setLong(13, this.changerUId);
            preparedStatement.setLong(14, this.changeTs);
            preparedStatement.setLong(15, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "DependencyInstance: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    public static boolean checkDependencyOperation(Integer n) {
        switch (n) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkState(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkIgnore(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : DependencyInstance", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "ddId : " + this.ddId, 2);
        SDMSThread.doTrace(null, "dependentId : " + this.dependentId, 2);
        SDMSThread.doTrace(null, "dependentIdOrig : " + this.dependentIdOrig, 2);
        SDMSThread.doTrace(null, "dependencyOperation : " + this.dependencyOperation, 2);
        SDMSThread.doTrace(null, "requiredId : " + this.requiredId, 2);
        SDMSThread.doTrace(null, "requiredSeId : " + this.requiredSeId, 2);
        SDMSThread.doTrace(null, "state : " + this.state, 2);
        SDMSThread.doTrace(null, "ignore : " + this.ignore, 2);
        SDMSThread.doTrace(null, "diIdOrig : " + this.diIdOrig, 2);
        SDMSThread.doTrace(null, "seVersion : " + this.seVersion, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "ddId                : " + this.ddId + "\n" + string + "dependentId         : " + this.dependentId + "\n" + string + "dependentIdOrig     : " + this.dependentIdOrig + "\n" + string + "dependencyOperation : " + this.dependencyOperation + "\n" + string + "requiredId          : " + this.requiredId + "\n" + string + "requiredSeId        : " + this.requiredSeId + "\n" + string + "state               : " + this.state + "\n" + string + "ignore              : " + this.ignore + "\n" + string + "diIdOrig            : " + this.diIdOrig + "\n" + string + "seVersion           : " + this.seVersion + "\n" + string + "creatorUId          : " + this.creatorUId + "\n" + string + "createTs            : " + this.createTs + "\n" + string + "changerUId          : " + this.changerUId + "\n" + string + "changeTs            : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

