/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSEventGeneric
extends SDMSObject
implements Cloneable {
    public static final int nr_id = 1;
    public static final int nr_name = 2;
    public static final int nr_ownerId = 3;
    public static final int nr_seId = 4;
    public static final int nr_creatorUId = 5;
    public static final int nr_createTs = 6;
    public static final int nr_changerUId = 7;
    public static final int nr_changeTs = 8;
    public static String tableName = "EVENT";
    protected String name;
    protected Long ownerId;
    protected Long seId;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSEventGeneric(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        super(systemEnvironment, SDMSEventTableGeneric.table);
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(Event) Length of $1 exceeds maximum length $2", (Object)"name", (Object)"64"));
        }
        this.name = string;
        this.ownerId = l;
        this.seId = l2;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.name;
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.name.equals(string)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Event) Change of system object not allowed"));
            }
            SDMSEventGeneric sDMSEventGeneric = (SDMSEventGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(Event) Length of $1 exceeds maximum length $2", (Object)"name", (Object)"64"));
            }
            sDMSEventGeneric.name = string;
            sDMSEventGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSEventGeneric.changeTs = systemEnvironment.txTime();
            sDMSEventGeneric.versions.table.index(systemEnvironment, sDMSEventGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ownerId;
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.ownerId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Event) Change of system object not allowed"));
            }
            SDMSEventGeneric sDMSEventGeneric = (SDMSEventGeneric)this.change(systemEnvironment);
            sDMSEventGeneric.ownerId = l;
            sDMSEventGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSEventGeneric.changeTs = systemEnvironment.txTime();
            sDMSEventGeneric.versions.table.index(systemEnvironment, sDMSEventGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seId;
    }

    public void setSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.seId)) {
            return;
        }
        if (l == null && this.seId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Event) Change of system object not allowed"));
            }
            SDMSEventGeneric sDMSEventGeneric = (SDMSEventGeneric)this.change(systemEnvironment);
            sDMSEventGeneric.seId = l;
            sDMSEventGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSEventGeneric.changeTs = systemEnvironment.txTime();
            sDMSEventGeneric.versions.table.index(systemEnvironment, sDMSEventGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSEventGeneric sDMSEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Event) Change of system object not allowed"));
        }
        if (sDMSEventGeneric.versions.o_v == null || sDMSEventGeneric.versions.o_v.size() == 0 || sDMSEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSEventGeneric = (SDMSEventGeneric)this.change(systemEnvironment);
        }
        sDMSEventGeneric.creatorUId = l;
        sDMSEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSEventGeneric != this) {
            sDMSEventGeneric.versions.table.index(systemEnvironment, sDMSEventGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSEventGeneric sDMSEventGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Event) Change of system object not allowed"));
        }
        if (sDMSEventGeneric.versions.o_v == null || sDMSEventGeneric.versions.o_v.size() == 0 || sDMSEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSEventGeneric = (SDMSEventGeneric)this.change(systemEnvironment);
        }
        sDMSEventGeneric.createTs = l;
        sDMSEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSEventGeneric != this) {
            sDMSEventGeneric.versions.table.index(systemEnvironment, sDMSEventGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSEventGeneric sDMSEventGeneric = this;
        if (sDMSEventGeneric.versions.o_v == null || sDMSEventGeneric.versions.o_v.size() == 0 || sDMSEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSEventGeneric = (SDMSEventGeneric)this.change(systemEnvironment);
        }
        sDMSEventGeneric.changerUId = l;
        sDMSEventGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSEventGeneric != this) {
            sDMSEventGeneric.versions.table.index(systemEnvironment, sDMSEventGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSEventGeneric sDMSEventGeneric = this;
        if (sDMSEventGeneric.versions.o_v == null || sDMSEventGeneric.versions.o_v.size() == 0 || sDMSEventGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSEventGeneric = (SDMSEventGeneric)this.change(systemEnvironment);
        }
        sDMSEventGeneric.changeTs = l;
        sDMSEventGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSEventGeneric != this) {
            sDMSEventGeneric.versions.table.index(systemEnvironment, sDMSEventGeneric, 0L);
        }
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return SDMSEvent.getProxy(systemEnvironment, this);
    }

    protected SDMSEventGeneric(Long l, String string, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7, long l8, long l9) {
        this.id = l;
        this.name = string;
        this.ownerId = l2;
        this.seId = l3;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.validFrom = l8;
        this.validTo = l9;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "EVENT" + string3 + " (" + "ID" + ", " + string2 + "NAME" + string3 + ", " + string2 + "OWNER_ID" + string3 + ", " + string2 + "SE_ID" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ")";
                SDMSEventGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "Event: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setString(2, this.name);
            preparedStatement.setLong(3, this.ownerId);
            if (this.seId == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.seId);
            }
            preparedStatement.setLong(5, this.creatorUId);
            preparedStatement.setLong(6, this.createTs);
            preparedStatement.setLong(7, this.changerUId);
            preparedStatement.setLong(8, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "Event: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "EVENT" + string3 + " WHERE ID = ?";
                SDMSEventGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "Event: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "Event: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "EVENT" + string3 + " SET " + "" + string2 + "NAME" + string3 + " = ? " + ", " + string2 + "OWNER_ID" + string3 + " = ? " + ", " + string2 + "SE_ID" + string3 + " = ? " + ", " + string2 + "CREATOR_U_ID" + string3 + " = ? " + ", " + string2 + "CREATE_TS" + string3 + " = ? " + ", " + string2 + "CHANGER_U_ID" + string3 + " = ? " + ", " + string2 + "CHANGE_TS" + string3 + " = ? " + "WHERE ID = ?";
                SDMSEventGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "Event: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setString(1, this.name);
            preparedStatement.setLong(2, this.ownerId);
            if (this.seId == null) {
                preparedStatement.setNull(3, 4);
            } else {
                preparedStatement.setLong(3, this.seId);
            }
            preparedStatement.setLong(4, this.creatorUId);
            preparedStatement.setLong(5, this.createTs);
            preparedStatement.setLong(6, this.changerUId);
            preparedStatement.setLong(7, this.changeTs);
            preparedStatement.setLong(8, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "Event: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : Event", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "name : " + this.name, 2);
        SDMSThread.doTrace(null, "ownerId : " + this.ownerId, 2);
        SDMSThread.doTrace(null, "seId : " + this.seId, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "name       : " + this.name + "\n" + string + "ownerId    : " + this.ownerId + "\n" + string + "seId       : " + this.seId + "\n" + string + "creatorUId : " + this.creatorUId + "\n" + string + "createTs   : " + this.createTs + "\n" + string + "changerUId : " + this.changerUId + "\n" + string + "changeTs   : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

