/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSExitStateMapping;
import de.independit.scheduler.server.repository.SDMSExitStateMappingTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSExitStateMappingGeneric
extends SDMSObject
implements Cloneable {
    public static final int nr_id = 1;
    public static final int nr_esmpId = 2;
    public static final int nr_esdId = 3;
    public static final int nr_ecrStart = 4;
    public static final int nr_ecrEnd = 5;
    public static final int nr_creatorUId = 6;
    public static final int nr_createTs = 7;
    public static final int nr_changerUId = 8;
    public static final int nr_changeTs = 9;
    public static String tableName = "EXIT_STATE_MAPPING";
    protected Long esmpId;
    protected Long esdId;
    protected Integer ecrStart;
    protected Integer ecrEnd;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSExitStateMappingGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, Integer n2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        super(systemEnvironment, SDMSExitStateMappingTableGeneric.table);
        this.esmpId = l;
        this.esdId = l2;
        this.ecrStart = n;
        this.ecrEnd = n2;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
    }

    public Long getEsmpId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.esmpId;
    }

    public void setEsmpId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.esmpId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitStateMapping) Change of system object not allowed"));
            }
            SDMSExitStateMappingGeneric sDMSExitStateMappingGeneric = (SDMSExitStateMappingGeneric)this.change(systemEnvironment);
            sDMSExitStateMappingGeneric.esmpId = l;
            sDMSExitStateMappingGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSExitStateMappingGeneric.changeTs = systemEnvironment.txTime();
            sDMSExitStateMappingGeneric.versions.table.index(systemEnvironment, sDMSExitStateMappingGeneric, 5L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getEsdId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.esdId;
    }

    public void setEsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.esdId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitStateMapping) Change of system object not allowed"));
            }
            SDMSExitStateMappingGeneric sDMSExitStateMappingGeneric = (SDMSExitStateMappingGeneric)this.change(systemEnvironment);
            sDMSExitStateMappingGeneric.esdId = l;
            sDMSExitStateMappingGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSExitStateMappingGeneric.changeTs = systemEnvironment.txTime();
            sDMSExitStateMappingGeneric.versions.table.index(systemEnvironment, sDMSExitStateMappingGeneric, 6L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getEcrStart(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ecrStart;
    }

    public void setEcrStart(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.ecrStart)) {
            return;
        }
        if (n == null && this.ecrStart == null) {
            return;
        }
        SDMSExitStateMappingGeneric sDMSExitStateMappingGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitStateMapping) Change of system object not allowed"));
        }
        if (sDMSExitStateMappingGeneric.versions.o_v == null || sDMSExitStateMappingGeneric.versions.o_v.size() == 0 || sDMSExitStateMappingGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateMappingGeneric = (SDMSExitStateMappingGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateMappingGeneric.ecrStart = n;
        sDMSExitStateMappingGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExitStateMappingGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExitStateMappingGeneric != this) {
            sDMSExitStateMappingGeneric.versions.table.index(systemEnvironment, sDMSExitStateMappingGeneric, 0L);
        }
    }

    public Integer getEcrEnd(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ecrEnd;
    }

    public void setEcrEnd(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.ecrEnd)) {
            return;
        }
        if (n == null && this.ecrEnd == null) {
            return;
        }
        SDMSExitStateMappingGeneric sDMSExitStateMappingGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitStateMapping) Change of system object not allowed"));
        }
        if (sDMSExitStateMappingGeneric.versions.o_v == null || sDMSExitStateMappingGeneric.versions.o_v.size() == 0 || sDMSExitStateMappingGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateMappingGeneric = (SDMSExitStateMappingGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateMappingGeneric.ecrEnd = n;
        sDMSExitStateMappingGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExitStateMappingGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExitStateMappingGeneric != this) {
            sDMSExitStateMappingGeneric.versions.table.index(systemEnvironment, sDMSExitStateMappingGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSExitStateMappingGeneric sDMSExitStateMappingGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitStateMapping) Change of system object not allowed"));
        }
        if (sDMSExitStateMappingGeneric.versions.o_v == null || sDMSExitStateMappingGeneric.versions.o_v.size() == 0 || sDMSExitStateMappingGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateMappingGeneric = (SDMSExitStateMappingGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateMappingGeneric.creatorUId = l;
        sDMSExitStateMappingGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExitStateMappingGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExitStateMappingGeneric != this) {
            sDMSExitStateMappingGeneric.versions.table.index(systemEnvironment, sDMSExitStateMappingGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSExitStateMappingGeneric sDMSExitStateMappingGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ExitStateMapping) Change of system object not allowed"));
        }
        if (sDMSExitStateMappingGeneric.versions.o_v == null || sDMSExitStateMappingGeneric.versions.o_v.size() == 0 || sDMSExitStateMappingGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateMappingGeneric = (SDMSExitStateMappingGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateMappingGeneric.createTs = l;
        sDMSExitStateMappingGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSExitStateMappingGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExitStateMappingGeneric != this) {
            sDMSExitStateMappingGeneric.versions.table.index(systemEnvironment, sDMSExitStateMappingGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSExitStateMappingGeneric sDMSExitStateMappingGeneric = this;
        if (sDMSExitStateMappingGeneric.versions.o_v == null || sDMSExitStateMappingGeneric.versions.o_v.size() == 0 || sDMSExitStateMappingGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateMappingGeneric = (SDMSExitStateMappingGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateMappingGeneric.changerUId = l;
        sDMSExitStateMappingGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSExitStateMappingGeneric != this) {
            sDMSExitStateMappingGeneric.versions.table.index(systemEnvironment, sDMSExitStateMappingGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSExitStateMappingGeneric sDMSExitStateMappingGeneric = this;
        if (sDMSExitStateMappingGeneric.versions.o_v == null || sDMSExitStateMappingGeneric.versions.o_v.size() == 0 || sDMSExitStateMappingGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSExitStateMappingGeneric = (SDMSExitStateMappingGeneric)this.change(systemEnvironment);
        }
        sDMSExitStateMappingGeneric.changeTs = l;
        sDMSExitStateMappingGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSExitStateMappingGeneric != this) {
            sDMSExitStateMappingGeneric.versions.table.index(systemEnvironment, sDMSExitStateMappingGeneric, 0L);
        }
    }

    public SDMSExitStateMappingGeneric set_EsmpIdEsdId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSExitStateMappingGeneric sDMSExitStateMappingGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(ExitStateMapping) Change of system object not allowed"));
            }
            sDMSExitStateMappingGeneric = (SDMSExitStateMappingGeneric)this.change(systemEnvironment);
            sDMSExitStateMappingGeneric.esmpId = l;
            sDMSExitStateMappingGeneric.esdId = l2;
            sDMSExitStateMappingGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSExitStateMappingGeneric.changeTs = systemEnvironment.txTime();
            sDMSExitStateMappingGeneric.versions.table.index(systemEnvironment, sDMSExitStateMappingGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSExitStateMappingGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return SDMSExitStateMapping.getProxy(systemEnvironment, this);
    }

    protected SDMSExitStateMappingGeneric(Long l, Long l2, Long l3, Integer n, Integer n2, Long l4, Long l5, Long l6, Long l7, long l8, long l9) {
        this.id = l;
        this.esmpId = l2;
        this.esdId = l3;
        this.ecrStart = n;
        this.ecrEnd = n2;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.validFrom = l8;
        this.validTo = l9;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "EXIT_STATE_MAPPING" + string3 + " (" + "ID" + ", " + string2 + "ESMP_ID" + string3 + ", " + string2 + "ESD_ID" + string3 + ", " + string2 + "ECR_START" + string3 + ", " + string2 + "ECR_END" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ", VALID_FROM, VALID_TO" + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?, ?" + ")";
                SDMSExitStateMappingGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "ExitStateMapping: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.esmpId);
            preparedStatement.setLong(3, this.esdId);
            if (this.ecrStart == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setInt(4, this.ecrStart);
            }
            if (this.ecrEnd == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setInt(5, this.ecrEnd);
            }
            preparedStatement.setLong(6, this.creatorUId);
            preparedStatement.setLong(7, this.createTs);
            preparedStatement.setLong(8, this.changerUId);
            preparedStatement.setLong(9, this.changeTs);
            preparedStatement.setLong(10, systemEnvironment.tx.versionId);
            preparedStatement.setLong(11, Long.MAX_VALUE);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "ExitStateMapping: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.closeDBObject(systemEnvironment);
        this.insertDBObject(systemEnvironment);
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        this.closeDBObject(systemEnvironment);
    }

    private void closeDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = systemEnvironment.dbConnection.getMetaData().getDriverName();
                boolean bl = string2.startsWith("PostgreSQL");
                String string3 = SystemEnvironment.SQUOTE;
                String string4 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string3 + "EXIT_STATE_MAPPING" + string4 + " SET VALID_TO = ?, " + "    CHANGE_TS = ?, " + "    CHANGER_U_ID = ? " + "WHERE ID = ?" + "  AND VALID_TO = " + (bl ? "CAST ('9223372036854775807' AS DECIMAL)" : "9223372036854775807");
                SDMSExitStateMappingGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181955", "ExitStateMapping : $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, systemEnvironment.tx.versionId);
            preparedStatement.setLong(2, this.changeTs);
            preparedStatement.setLong(3, this.changerUId);
            preparedStatement.setLong(4, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181956", "ExitStateMapping: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : ExitStateMapping", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "esmpId : " + this.esmpId, 2);
        SDMSThread.doTrace(null, "esdId : " + this.esdId, 2);
        SDMSThread.doTrace(null, "ecrStart : " + this.ecrStart, 2);
        SDMSThread.doTrace(null, "ecrEnd : " + this.ecrEnd, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "esmpId     : " + this.esmpId + "\n" + string + "esdId      : " + this.esdId + "\n" + string + "ecrStart   : " + this.ecrStart + "\n" + string + "ecrEnd     : " + this.ecrEnd + "\n" + string + "creatorUId : " + this.creatorUId + "\n" + string + "createTs   : " + this.createTs + "\n" + string + "changerUId : " + this.changerUId + "\n" + string + "changeTs   : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

