/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderGeneric;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class SDMSFolderTableGeneric
extends SDMSTable {
    public static final String tableName = "FOLDER";
    public static SDMSFolderTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "OWNER_ID", "ENV_ID", "PARENT_ID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS", "INHERIT_PRIVS"};
    public static SDMSIndex idx_ownerId;
    public static SDMSIndex idx_envId;
    public static SDMSIndex idx_parentId;
    public static SDMSIndex idx_parentId_name;

    public SDMSFolderTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "Folder"));
        }
        table = (SDMSFolderTable)this;
        table = (SDMSFolderTable)this;
        this.isVersioned = true;
        idx_ownerId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "ownerId");
        idx_envId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "envId");
        idx_parentId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "parentId");
        idx_parentId_name = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "parentId_name");
    }

    public SDMSFolder create(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4) throws SDMSException {
        SDMSFolder sDMSFolder;
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        Long l7 = systemEnvironment.cEnv.uid();
        Long l8 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "Folder"));
        }
        this.validate(systemEnvironment, string, l, l2, l3, l5, l6, l7, l8, l4);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSFolderGeneric sDMSFolderGeneric = new SDMSFolderGeneric(systemEnvironment, string, l, l2, l3, l5, l6, l7, l8, l4);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSFolderGeneric.versions, true);
            table.put(systemEnvironment, sDMSFolderGeneric.id, sDMSFolderGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSFolder = (SDMSFolder)sDMSFolderGeneric.toProxy(systemEnvironment);
            sDMSFolder.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSFolder sDMSFolder2 = (SDMSFolder)sDMSFolderGeneric.toProxy(systemEnvironment);
            sDMSFolder2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSFolder)) {
            throw new AccessViolationException(sDMSFolder.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSFolder;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSFolder sDMSFolder) throws SDMSException {
        Long l = sDMSFolder.getParentId(systemEnvironment);
        SDMSFolder sDMSFolder2 = SDMSFolderTable.getObject(systemEnvironment, l);
        return sDMSFolder2.checkPrivileges(systemEnvironment, 2L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7, Long l8) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Long l9;
        Long l10;
        String string;
        Long l11;
        try {
            l11 = new Long(resultSet.getLong(1));
            string = resultSet.getString(2);
            l10 = new Long(resultSet.getLong(3));
            l9 = new Long(resultSet.getLong(4));
            if (resultSet.wasNull()) {
                l9 = null;
            }
            l8 = new Long(resultSet.getLong(5));
            if (resultSet.wasNull()) {
                l8 = null;
            }
            l7 = new Long(resultSet.getLong(6));
            l6 = new Long(resultSet.getLong(7));
            l5 = new Long(resultSet.getLong(8));
            l4 = new Long(resultSet.getLong(9));
            l3 = new Long(resultSet.getLong(10));
            l2 = resultSet.getLong(11);
            l = resultSet.getLong(12);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "Folder: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSFolderGeneric(l11, string, l10, l9, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "NAME" + string2 + ", " + string + "OWNER_ID" + string2 + ", " + string + "ENV_ID" + string2 + ", " + string + "PARENT_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", " + string + "INHERIT_PRIVS" + string2 + ", VALID_FROM, VALID_TO " + " FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion) + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_ownerId.check(((SDMSFolderGeneric)sDMSObject).ownerId, sDMSObject);
        string = string + "idx_ownerId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_envId.check(((SDMSFolderGeneric)sDMSObject).envId, sDMSObject);
        string = string + "idx_envId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_parentId.check(((SDMSFolderGeneric)sDMSObject).parentId, sDMSObject);
        string = string + "idx_parentId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSFolderGeneric)sDMSObject).parentId);
        sDMSKey.add((Comparable)((Object)((SDMSFolderGeneric)sDMSObject).name));
        bl = idx_parentId_name.check(sDMSKey, sDMSObject);
        string = string + "idx_parentId_name: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_ownerId.put(systemEnvironment, ((SDMSFolderGeneric)sDMSObject).ownerId, sDMSObject, (1L & l) != 0L);
        idx_envId.put(systemEnvironment, ((SDMSFolderGeneric)sDMSObject).envId, sDMSObject, (2L & l) != 0L);
        idx_parentId.put(systemEnvironment, ((SDMSFolderGeneric)sDMSObject).parentId, sDMSObject, (4L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSFolderGeneric)sDMSObject).parentId);
        sDMSKey.add((Comparable)((Object)((SDMSFolderGeneric)sDMSObject).name));
        idx_parentId_name.put(systemEnvironment, sDMSKey, sDMSObject, (8L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_ownerId.remove(systemEnvironment, ((SDMSFolderGeneric)sDMSObject).ownerId, sDMSObject);
        idx_envId.remove(systemEnvironment, ((SDMSFolderGeneric)sDMSObject).envId, sDMSObject);
        idx_parentId.remove(systemEnvironment, ((SDMSFolderGeneric)sDMSObject).parentId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSFolderGeneric)sDMSObject).parentId);
        sDMSKey.add((Comparable)((Object)((SDMSFolderGeneric)sDMSObject).name));
        idx_parentId_name.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSFolder getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSFolder)table.get(systemEnvironment, l);
    }

    public static SDMSFolder getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSFolder)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSFolder getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSFolder)table.get(systemEnvironment, l, l2);
    }

    public static SDMSFolder idx_parentId_name_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSFolder)idx_parentId_name.getUnique(systemEnvironment, object);
    }

    public static SDMSFolder idx_parentId_name_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSFolder)idx_parentId_name.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSFolder idx_parentId_name_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSFolder)idx_parentId_name.getUnique(systemEnvironment, object, l);
    }

    public static Long pathToId(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return SDMSFolderTableGeneric.getFolder(systemEnvironment, vector).getId(systemEnvironment);
    }

    public static Long pathToIdForUpdate(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return SDMSFolderTableGeneric.getFolderForUpdate(systemEnvironment, vector).getId(systemEnvironment);
    }

    public static SDMSFolder getFolder(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        Long l = null;
        SDMSFolder sDMSFolder = null;
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            sDMSFolder = (SDMSFolder)SDMSFolderTable.idx_parentId_name.getUnique(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)));
            l = sDMSFolder.getId(systemEnvironment);
        }
        return sDMSFolder;
    }

    public static SDMSFolder getFolderForUpdate(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        Long l = null;
        SDMSFolder sDMSFolder = null;
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            sDMSFolder = (SDMSFolder)SDMSFolderTable.idx_parentId_name.getUniqueForUpdate(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)));
            l = sDMSFolder.getId(systemEnvironment);
        }
        return sDMSFolder;
    }

    public static Long pathToId(SystemEnvironment systemEnvironment, Vector vector, long l) throws SDMSException {
        return SDMSFolderTableGeneric.getFolder(systemEnvironment, vector, l).getId(systemEnvironment);
    }

    public static SDMSFolder getFolder(SystemEnvironment systemEnvironment, Vector vector, long l) throws SDMSException {
        Long l2 = null;
        SDMSFolder sDMSFolder = null;
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            sDMSFolder = (SDMSFolder)SDMSFolderTable.idx_parentId_name.getUnique(systemEnvironment, new SDMSKey(l2, (Comparable)((Object)string)), l);
            l2 = sDMSFolder.getId(systemEnvironment);
        }
        return sDMSFolder;
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

