/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSGrantGeneric
extends SDMSObject
implements Cloneable {
    public static final int SYSTEM = 0;
    public static final int SELECT = 99;
    public static final int ENVIRONMENT = 1;
    public static final int EVENT = 18;
    public static final int FOLDER = 6;
    public static final int INTERVAL = 19;
    public static final int JOB = 17;
    public static final int JOB_DEFINITION = 9;
    public static final int NAMED_RESOURCE = 10;
    public static final int SCHEDULE = 20;
    public static final int SCHEDULED_EVENT = 22;
    public static final int SCOPE = 15;
    public static final int GROUP = 21;
    public static final int RESOURCE = 11;
    public static final int EXIT_STATE_DEFINITION = 2;
    public static final int EXIT_STATE_PROFILE = 3;
    public static final int EXIT_STATE_MAPPING = 4;
    public static final int EXIT_STATE_TRANSLATION = 5;
    public static final int RESOURCE_STATE_DEFINITION = 13;
    public static final int RESOURCE_STATE_PROFILE = 14;
    public static final int RESOURCE_STATE_MAPPING = 12;
    public static final int FOOTPRINT = 7;
    public static final int USER = 8;
    public static final int OBJECT_MONITOR = 30;
    public static final int NICE_PROFILE = 31;
    public static final Boolean GRANT = Boolean.TRUE;
    public static final Boolean REVOKE = Boolean.FALSE;
    public static final int nr_id = 1;
    public static final int nr_objectId = 2;
    public static final int nr_gId = 3;
    public static final int nr_objectType = 4;
    public static final int nr_privs = 5;
    public static final int nr_deleteVersion = 6;
    public static final int nr_creatorUId = 7;
    public static final int nr_createTs = 8;
    public static final int nr_changerUId = 9;
    public static final int nr_changeTs = 10;
    public static String tableName = "GRANTS";
    protected Long objectId;
    protected Long gId;
    protected Integer objectType;
    protected Long privs;
    protected Long deleteVersion;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSGrantGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, Long l3, Long l4, Long l5, Long l6, Long l7, Long l8) throws SDMSException {
        super(systemEnvironment, SDMSGrantTableGeneric.table);
        this.objectId = l;
        this.gId = l2;
        this.objectType = n;
        this.privs = l3;
        this.deleteVersion = l4;
        this.creatorUId = l5;
        this.createTs = l6;
        this.changerUId = l7;
        this.changeTs = l8;
    }

    public Long getObjectId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.objectId;
    }

    public void setObjectId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.objectId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Grant) Change of system object not allowed"));
            }
            SDMSGrantGeneric sDMSGrantGeneric = (SDMSGrantGeneric)this.change(systemEnvironment);
            sDMSGrantGeneric.objectId = l;
            sDMSGrantGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSGrantGeneric.changeTs = systemEnvironment.txTime();
            sDMSGrantGeneric.versions.table.index(systemEnvironment, sDMSGrantGeneric, 5L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getGId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.gId;
    }

    public void setGId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.gId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Grant) Change of system object not allowed"));
            }
            SDMSGrantGeneric sDMSGrantGeneric = (SDMSGrantGeneric)this.change(systemEnvironment);
            sDMSGrantGeneric.gId = l;
            sDMSGrantGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSGrantGeneric.changeTs = systemEnvironment.txTime();
            sDMSGrantGeneric.versions.table.index(systemEnvironment, sDMSGrantGeneric, 6L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getObjectType(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.objectType;
    }

    public String getObjectTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getObjectType(systemEnvironment);
        switch (n) {
            case 1: {
                return "ENVIRONMENT";
            }
            case 18: {
                return "EVENT";
            }
            case 6: {
                return "FOLDER";
            }
            case 19: {
                return "INTERVAL";
            }
            case 17: {
                return "JOB";
            }
            case 9: {
                return "JOB_DEFINITION";
            }
            case 10: {
                return "NAMED_RESOURCE";
            }
            case 20: {
                return "SCHEDULE";
            }
            case 22: {
                return "SCHEDULED_EVENT";
            }
            case 15: {
                return "SCOPE";
            }
            case 21: {
                return "GROUP";
            }
            case 11: {
                return "RESOURCE";
            }
            case 2: {
                return "EXIT_STATE_DEFINITION";
            }
            case 3: {
                return "EXIT_STATE_PROFILE";
            }
            case 4: {
                return "EXIT_STATE_MAPPING";
            }
            case 5: {
                return "EXIT_STATE_TRANSLATION";
            }
            case 13: {
                return "RESOURCE_STATE_DEFINITION";
            }
            case 14: {
                return "RESOURCE_STATE_PROFILE";
            }
            case 12: {
                return "RESOURCE_STATE_MAPPING";
            }
            case 7: {
                return "FOOTPRINT";
            }
            case 8: {
                return "USER";
            }
            case 30: {
                return "OBJECT_MONITOR";
            }
            case 0: {
                return "SYSTEM";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown Grant.objectType: $1", (Object)this.getObjectType(systemEnvironment)));
    }

    public void setObjectType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.objectType.equals(n)) {
            return;
        }
        SDMSGrantGeneric sDMSGrantGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Grant) Change of system object not allowed"));
        }
        if (sDMSGrantGeneric.versions.o_v == null || sDMSGrantGeneric.versions.o_v.size() == 0 || sDMSGrantGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSGrantGeneric = (SDMSGrantGeneric)this.change(systemEnvironment);
        }
        sDMSGrantGeneric.objectType = n;
        sDMSGrantGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSGrantGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSGrantGeneric != this) {
            sDMSGrantGeneric.versions.table.index(systemEnvironment, sDMSGrantGeneric, 0L);
        }
    }

    public Long getPrivs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.privs;
    }

    public void setPrivs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.privs.equals(l)) {
            return;
        }
        SDMSGrantGeneric sDMSGrantGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Grant) Change of system object not allowed"));
        }
        if (sDMSGrantGeneric.versions.o_v == null || sDMSGrantGeneric.versions.o_v.size() == 0 || sDMSGrantGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSGrantGeneric = (SDMSGrantGeneric)this.change(systemEnvironment);
        }
        sDMSGrantGeneric.privs = l;
        sDMSGrantGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSGrantGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSGrantGeneric != this) {
            sDMSGrantGeneric.versions.table.index(systemEnvironment, sDMSGrantGeneric, 0L);
        }
    }

    public Long getDeleteVersion(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.deleteVersion;
    }

    public void setDeleteVersion(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.deleteVersion)) {
            return;
        }
        if (l == null && this.deleteVersion == null) {
            return;
        }
        SDMSGrantGeneric sDMSGrantGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Grant) Change of system object not allowed"));
        }
        if (sDMSGrantGeneric.versions.o_v == null || sDMSGrantGeneric.versions.o_v.size() == 0 || sDMSGrantGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSGrantGeneric = (SDMSGrantGeneric)this.change(systemEnvironment);
        }
        sDMSGrantGeneric.deleteVersion = l;
        sDMSGrantGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSGrantGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSGrantGeneric != this) {
            sDMSGrantGeneric.versions.table.index(systemEnvironment, sDMSGrantGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSGrantGeneric sDMSGrantGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Grant) Change of system object not allowed"));
        }
        if (sDMSGrantGeneric.versions.o_v == null || sDMSGrantGeneric.versions.o_v.size() == 0 || sDMSGrantGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSGrantGeneric = (SDMSGrantGeneric)this.change(systemEnvironment);
        }
        sDMSGrantGeneric.creatorUId = l;
        sDMSGrantGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSGrantGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSGrantGeneric != this) {
            sDMSGrantGeneric.versions.table.index(systemEnvironment, sDMSGrantGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSGrantGeneric sDMSGrantGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Grant) Change of system object not allowed"));
        }
        if (sDMSGrantGeneric.versions.o_v == null || sDMSGrantGeneric.versions.o_v.size() == 0 || sDMSGrantGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSGrantGeneric = (SDMSGrantGeneric)this.change(systemEnvironment);
        }
        sDMSGrantGeneric.createTs = l;
        sDMSGrantGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSGrantGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSGrantGeneric != this) {
            sDMSGrantGeneric.versions.table.index(systemEnvironment, sDMSGrantGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSGrantGeneric sDMSGrantGeneric = this;
        if (sDMSGrantGeneric.versions.o_v == null || sDMSGrantGeneric.versions.o_v.size() == 0 || sDMSGrantGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSGrantGeneric = (SDMSGrantGeneric)this.change(systemEnvironment);
        }
        sDMSGrantGeneric.changerUId = l;
        sDMSGrantGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSGrantGeneric != this) {
            sDMSGrantGeneric.versions.table.index(systemEnvironment, sDMSGrantGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSGrantGeneric sDMSGrantGeneric = this;
        if (sDMSGrantGeneric.versions.o_v == null || sDMSGrantGeneric.versions.o_v.size() == 0 || sDMSGrantGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSGrantGeneric = (SDMSGrantGeneric)this.change(systemEnvironment);
        }
        sDMSGrantGeneric.changeTs = l;
        sDMSGrantGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSGrantGeneric != this) {
            sDMSGrantGeneric.versions.table.index(systemEnvironment, sDMSGrantGeneric, 0L);
        }
    }

    public SDMSGrantGeneric set_ObjectIdGId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSGrantGeneric sDMSGrantGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(Grant) Change of system object not allowed"));
            }
            sDMSGrantGeneric = (SDMSGrantGeneric)this.change(systemEnvironment);
            sDMSGrantGeneric.objectId = l;
            sDMSGrantGeneric.gId = l2;
            sDMSGrantGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSGrantGeneric.changeTs = systemEnvironment.txTime();
            sDMSGrantGeneric.versions.table.index(systemEnvironment, sDMSGrantGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSGrantGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return SDMSGrant.getProxy(systemEnvironment, this);
    }

    protected SDMSGrantGeneric(Long l, Long l2, Long l3, Integer n, Long l4, Long l5, Long l6, Long l7, Long l8, Long l9, long l10, long l11) {
        this.id = l;
        this.objectId = l2;
        this.gId = l3;
        this.objectType = n;
        this.privs = l4;
        this.deleteVersion = l5;
        this.creatorUId = l6;
        this.createTs = l7;
        this.changerUId = l8;
        this.changeTs = l9;
        this.validFrom = l10;
        this.validTo = l11;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "GRANTS" + string3 + " (" + "ID" + ", " + string2 + "OBJECT_ID" + string3 + ", " + string2 + "G_ID" + string3 + ", " + string2 + "OBJECT_TYPE" + string3 + ", " + string2 + "PRIVS" + string3 + ", " + string2 + "DELETE_VERSION" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ")";
                SDMSGrantGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "Grant: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.objectId);
            preparedStatement.setLong(3, this.gId);
            preparedStatement.setInt(4, this.objectType);
            preparedStatement.setLong(5, this.privs);
            if (this.deleteVersion == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setLong(6, this.deleteVersion);
            }
            preparedStatement.setLong(7, this.creatorUId);
            preparedStatement.setLong(8, this.createTs);
            preparedStatement.setLong(9, this.changerUId);
            preparedStatement.setLong(10, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "Grant: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "GRANTS" + string3 + " WHERE ID = ?";
                SDMSGrantGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "Grant: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "Grant: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "GRANTS" + string3 + " SET " + "" + string2 + "OBJECT_ID" + string3 + " = ? " + ", " + string2 + "G_ID" + string3 + " = ? " + ", " + string2 + "OBJECT_TYPE" + string3 + " = ? " + ", " + string2 + "PRIVS" + string3 + " = ? " + ", " + string2 + "DELETE_VERSION" + string3 + " = ? " + ", " + string2 + "CREATOR_U_ID" + string3 + " = ? " + ", " + string2 + "CREATE_TS" + string3 + " = ? " + ", " + string2 + "CHANGER_U_ID" + string3 + " = ? " + ", " + string2 + "CHANGE_TS" + string3 + " = ? " + "WHERE ID = ?";
                SDMSGrantGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "Grant: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.objectId);
            preparedStatement.setLong(2, this.gId);
            preparedStatement.setInt(3, this.objectType);
            preparedStatement.setLong(4, this.privs);
            if (this.deleteVersion == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setLong(5, this.deleteVersion);
            }
            preparedStatement.setLong(6, this.creatorUId);
            preparedStatement.setLong(7, this.createTs);
            preparedStatement.setLong(8, this.changerUId);
            preparedStatement.setLong(9, this.changeTs);
            preparedStatement.setLong(10, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "Grant: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    public static boolean checkObjectType(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : Grant", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "objectId : " + this.objectId, 2);
        SDMSThread.doTrace(null, "gId : " + this.gId, 2);
        SDMSThread.doTrace(null, "objectType : " + this.objectType, 2);
        SDMSThread.doTrace(null, "privs : " + this.privs, 2);
        SDMSThread.doTrace(null, "deleteVersion : " + this.deleteVersion, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "objectId      : " + this.objectId + "\n" + string + "gId           : " + this.gId + "\n" + string + "objectType    : " + this.objectType + "\n" + string + "privs         : " + this.privs + "\n" + string + "deleteVersion : " + this.deleteVersion + "\n" + string + "creatorUId    : " + this.creatorUId + "\n" + string + "createTs      : " + this.createTs + "\n" + string + "changerUId    : " + this.changerUId + "\n" + string + "changeTs      : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

