/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSInstanceValue;
import de.independit.scheduler.server.repository.SDMSInstanceValueGeneric;
import de.independit.scheduler.server.repository.SDMSInstanceValueTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSInstanceValueTableGeneric
extends SDMSTable {
    public static final String tableName = "INSTANCE_VALUE";
    public static SDMSInstanceValueTable table = null;
    public static final String[] columnNames = new String[]{"ID", "VALUE", "OI_ID", "WTP_ID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_oiId;
    public static SDMSIndex idx_wtpId;
    public static SDMSIndex idx_oiId_wtpId;

    public SDMSInstanceValueTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "InstanceValue"));
        }
        table = (SDMSInstanceValueTable)this;
        table = (SDMSInstanceValueTable)this;
        this.isVersioned = false;
        idx_oiId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "oiId");
        idx_wtpId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "wtpId");
        idx_oiId_wtpId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "oiId_wtpId");
    }

    public SDMSInstanceValue create(SystemEnvironment systemEnvironment, String string, Long l, Long l2) throws SDMSException {
        SDMSInstanceValue sDMSInstanceValue;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "InstanceValue"));
        }
        this.validate(systemEnvironment, string, l, l2, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSInstanceValueGeneric sDMSInstanceValueGeneric = new SDMSInstanceValueGeneric(systemEnvironment, string, l, l2, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSInstanceValueGeneric.versions, true);
            table.put(systemEnvironment, sDMSInstanceValueGeneric.id, sDMSInstanceValueGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSInstanceValue = (SDMSInstanceValue)sDMSInstanceValueGeneric.toProxy(systemEnvironment);
            sDMSInstanceValue.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSInstanceValue sDMSInstanceValue2 = (SDMSInstanceValue)sDMSInstanceValueGeneric.toProxy(systemEnvironment);
            sDMSInstanceValue2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSInstanceValue)) {
            throw new AccessViolationException(sDMSInstanceValue.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSInstanceValue.touchMaster(systemEnvironment);
        return sDMSInstanceValue;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSInstanceValue sDMSInstanceValue) throws SDMSException {
        return sDMSInstanceValue.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        String string;
        Long l9;
        try {
            l9 = new Long(resultSet.getLong(1));
            string = resultSet.getString(2);
            if (resultSet.wasNull()) {
                string = null;
            }
            l8 = new Long(resultSet.getLong(3));
            l7 = new Long(resultSet.getLong(4));
            l6 = new Long(resultSet.getLong(5));
            l5 = new Long(resultSet.getLong(6));
            l4 = new Long(resultSet.getLong(7));
            l3 = new Long(resultSet.getLong(8));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "InstanceValue: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSInstanceValueGeneric(l9, string, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "VALUE" + string2 + ", " + string + "OI_ID" + string2 + ", " + string + "WTP_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_oiId.check(((SDMSInstanceValueGeneric)sDMSObject).oiId, sDMSObject);
        string = string + "idx_oiId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_wtpId.check(((SDMSInstanceValueGeneric)sDMSObject).wtpId, sDMSObject);
        string = string + "idx_wtpId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSInstanceValueGeneric)sDMSObject).oiId);
        sDMSKey.add(((SDMSInstanceValueGeneric)sDMSObject).wtpId);
        bl = idx_oiId_wtpId.check(sDMSKey, sDMSObject);
        string = string + "idx_oiId_wtpId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_oiId.put(systemEnvironment, ((SDMSInstanceValueGeneric)sDMSObject).oiId, sDMSObject, (1L & l) != 0L);
        idx_wtpId.put(systemEnvironment, ((SDMSInstanceValueGeneric)sDMSObject).wtpId, sDMSObject, (2L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSInstanceValueGeneric)sDMSObject).oiId);
        sDMSKey.add(((SDMSInstanceValueGeneric)sDMSObject).wtpId);
        idx_oiId_wtpId.put(systemEnvironment, sDMSKey, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_oiId.remove(systemEnvironment, ((SDMSInstanceValueGeneric)sDMSObject).oiId, sDMSObject);
        idx_wtpId.remove(systemEnvironment, ((SDMSInstanceValueGeneric)sDMSObject).wtpId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSInstanceValueGeneric)sDMSObject).oiId);
        sDMSKey.add(((SDMSInstanceValueGeneric)sDMSObject).wtpId);
        idx_oiId_wtpId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSInstanceValue getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSInstanceValue)table.get(systemEnvironment, l);
    }

    public static SDMSInstanceValue getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSInstanceValue)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSInstanceValue getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSInstanceValue)table.get(systemEnvironment, l, l2);
    }

    public static SDMSInstanceValue idx_oiId_wtpId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSInstanceValue)idx_oiId_wtpId.getUnique(systemEnvironment, object);
    }

    public static SDMSInstanceValue idx_oiId_wtpId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSInstanceValue)idx_oiId_wtpId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSInstanceValue idx_oiId_wtpId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSInstanceValue)idx_oiId_wtpId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

