/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchy;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSIntervalHierarchyGeneric
extends SDMSObject
implements Cloneable {
    public static final int nr_id = 1;
    public static final int nr_childId = 2;
    public static final int nr_parentId = 3;
    public static final int nr_creatorUId = 4;
    public static final int nr_createTs = 5;
    public static final int nr_changerUId = 6;
    public static final int nr_changeTs = 7;
    public static String tableName = "INTERVAL_HIERARCHY";
    protected Long childId;
    protected Long parentId;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSIntervalHierarchyGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        super(systemEnvironment, SDMSIntervalHierarchyTableGeneric.table);
        this.childId = l;
        this.parentId = l2;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
    }

    public Long getChildId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.childId;
    }

    public void setChildId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.childId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(IntervalHierarchy) Change of system object not allowed"));
            }
            SDMSIntervalHierarchyGeneric sDMSIntervalHierarchyGeneric = (SDMSIntervalHierarchyGeneric)this.change(systemEnvironment);
            sDMSIntervalHierarchyGeneric.childId = l;
            sDMSIntervalHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSIntervalHierarchyGeneric.changeTs = systemEnvironment.txTime();
            sDMSIntervalHierarchyGeneric.versions.table.index(systemEnvironment, sDMSIntervalHierarchyGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getParentId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.parentId;
    }

    public void setParentId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.parentId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(IntervalHierarchy) Change of system object not allowed"));
            }
            SDMSIntervalHierarchyGeneric sDMSIntervalHierarchyGeneric = (SDMSIntervalHierarchyGeneric)this.change(systemEnvironment);
            sDMSIntervalHierarchyGeneric.parentId = l;
            sDMSIntervalHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSIntervalHierarchyGeneric.changeTs = systemEnvironment.txTime();
            sDMSIntervalHierarchyGeneric.versions.table.index(systemEnvironment, sDMSIntervalHierarchyGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSIntervalHierarchyGeneric sDMSIntervalHierarchyGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(IntervalHierarchy) Change of system object not allowed"));
        }
        if (sDMSIntervalHierarchyGeneric.versions.o_v == null || sDMSIntervalHierarchyGeneric.versions.o_v.size() == 0 || sDMSIntervalHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalHierarchyGeneric = (SDMSIntervalHierarchyGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalHierarchyGeneric.creatorUId = l;
        sDMSIntervalHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalHierarchyGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalHierarchyGeneric != this) {
            sDMSIntervalHierarchyGeneric.versions.table.index(systemEnvironment, sDMSIntervalHierarchyGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSIntervalHierarchyGeneric sDMSIntervalHierarchyGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(IntervalHierarchy) Change of system object not allowed"));
        }
        if (sDMSIntervalHierarchyGeneric.versions.o_v == null || sDMSIntervalHierarchyGeneric.versions.o_v.size() == 0 || sDMSIntervalHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalHierarchyGeneric = (SDMSIntervalHierarchyGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalHierarchyGeneric.createTs = l;
        sDMSIntervalHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalHierarchyGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalHierarchyGeneric != this) {
            sDMSIntervalHierarchyGeneric.versions.table.index(systemEnvironment, sDMSIntervalHierarchyGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSIntervalHierarchyGeneric sDMSIntervalHierarchyGeneric = this;
        if (sDMSIntervalHierarchyGeneric.versions.o_v == null || sDMSIntervalHierarchyGeneric.versions.o_v.size() == 0 || sDMSIntervalHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalHierarchyGeneric = (SDMSIntervalHierarchyGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalHierarchyGeneric.changerUId = l;
        sDMSIntervalHierarchyGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalHierarchyGeneric != this) {
            sDMSIntervalHierarchyGeneric.versions.table.index(systemEnvironment, sDMSIntervalHierarchyGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSIntervalHierarchyGeneric sDMSIntervalHierarchyGeneric = this;
        if (sDMSIntervalHierarchyGeneric.versions.o_v == null || sDMSIntervalHierarchyGeneric.versions.o_v.size() == 0 || sDMSIntervalHierarchyGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalHierarchyGeneric = (SDMSIntervalHierarchyGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalHierarchyGeneric.changeTs = l;
        sDMSIntervalHierarchyGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSIntervalHierarchyGeneric != this) {
            sDMSIntervalHierarchyGeneric.versions.table.index(systemEnvironment, sDMSIntervalHierarchyGeneric, 0L);
        }
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return SDMSIntervalHierarchy.getProxy(systemEnvironment, this);
    }

    protected SDMSIntervalHierarchyGeneric(Long l, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7, long l8, long l9) {
        this.id = l;
        this.childId = l2;
        this.parentId = l3;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.validFrom = l8;
        this.validTo = l9;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "INTERVAL_HIERARCHY" + string3 + " (" + "ID" + ", " + string2 + "CHILD_ID" + string3 + ", " + string2 + "PARENT_ID" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ")";
                SDMSIntervalHierarchyGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "IntervalHierarchy: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.childId);
            preparedStatement.setLong(3, this.parentId);
            preparedStatement.setLong(4, this.creatorUId);
            preparedStatement.setLong(5, this.createTs);
            preparedStatement.setLong(6, this.changerUId);
            preparedStatement.setLong(7, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "IntervalHierarchy: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "INTERVAL_HIERARCHY" + string3 + " WHERE ID = ?";
                SDMSIntervalHierarchyGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "IntervalHierarchy: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "IntervalHierarchy: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "INTERVAL_HIERARCHY" + string3 + " SET " + "" + string2 + "CHILD_ID" + string3 + " = ? " + ", " + string2 + "PARENT_ID" + string3 + " = ? " + ", " + string2 + "CREATOR_U_ID" + string3 + " = ? " + ", " + string2 + "CREATE_TS" + string3 + " = ? " + ", " + string2 + "CHANGER_U_ID" + string3 + " = ? " + ", " + string2 + "CHANGE_TS" + string3 + " = ? " + "WHERE ID = ?";
                SDMSIntervalHierarchyGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "IntervalHierarchy: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.childId);
            preparedStatement.setLong(2, this.parentId);
            preparedStatement.setLong(3, this.creatorUId);
            preparedStatement.setLong(4, this.createTs);
            preparedStatement.setLong(5, this.changerUId);
            preparedStatement.setLong(6, this.changeTs);
            preparedStatement.setLong(7, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "IntervalHierarchy: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : IntervalHierarchy", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "childId : " + this.childId, 2);
        SDMSThread.doTrace(null, "parentId : " + this.parentId, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "childId    : " + this.childId + "\n" + string + "parentId   : " + this.parentId + "\n" + string + "creatorUId : " + this.creatorUId + "\n" + string + "createTs   : " + this.createTs + "\n" + string + "changerUId : " + this.changerUId + "\n" + string + "changeTs   : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

