/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSIntervalTableGeneric
extends SDMSTable {
    public static final String tableName = "INTERVALL";
    public static SDMSIntervalTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "OWNER_ID", "START_TIME", "END_TIME", "DELAY", "BASE_INTERVAL", "BASE_INTERVAL_MULTIPLIER", "DURATION", "DURATION_MULTIPLIER", "SYNC_TIME", "IS_INVERSE", "IS_MERGE", "EMBEDDED_INT_ID", "SE_ID", "OBJ_ID", "OBJ_TYPE", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_name;
    public static SDMSIndex idx_ownerId;
    public static SDMSIndex idx_embeddedIntervalId;
    public static SDMSIndex idx_seId;
    public static SDMSIndex idx_objId;
    public static SDMSIndex idx_name_objId;

    public SDMSIntervalTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "Interval"));
        }
        table = (SDMSIntervalTable)this;
        table = (SDMSIntervalTable)this;
        this.isVersioned = false;
        idx_name = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "name");
        idx_ownerId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "ownerId");
        idx_embeddedIntervalId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "embeddedIntervalId");
        idx_seId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "seId");
        idx_objId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "objId");
        idx_name_objId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "name_objId");
    }

    public SDMSInterval create(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4, Integer n, Integer n2, Integer n3, Integer n4, Long l5, Boolean bl, Boolean bl2, Long l6, Long l7, Long l8, Integer n5) throws SDMSException {
        SDMSInterval sDMSInterval;
        Long l9 = systemEnvironment.cEnv.uid();
        Long l10 = systemEnvironment.txTime();
        Long l11 = systemEnvironment.cEnv.uid();
        Long l12 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "Interval"));
        }
        this.validate(systemEnvironment, string, l, l2, l3, l4, n, n2, n3, n4, l5, bl, bl2, l6, l7, l8, n5, l9, l10, l11, l12);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSIntervalGeneric sDMSIntervalGeneric = new SDMSIntervalGeneric(systemEnvironment, string, l, l2, l3, l4, n, n2, n3, n4, l5, bl, bl2, l6, l7, l8, n5, l9, l10, l11, l12);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSIntervalGeneric.versions, true);
            table.put(systemEnvironment, sDMSIntervalGeneric.id, sDMSIntervalGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSInterval = (SDMSInterval)sDMSIntervalGeneric.toProxy(systemEnvironment);
            sDMSInterval.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSInterval sDMSInterval2 = (SDMSInterval)sDMSIntervalGeneric.toProxy(systemEnvironment);
            sDMSInterval2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSInterval)) {
            throw new AccessViolationException(sDMSInterval.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSInterval;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSInterval sDMSInterval) throws SDMSException {
        return true;
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4, Integer n, Integer n2, Integer n3, Integer n4, Long l5, Boolean bl, Boolean bl2, Long l6, Long l7, Long l8, Integer n5, Long l9, Long l10, Long l11, Long l12) throws SDMSException {
        if (!SDMSIntervalGeneric.checkBaseInterval(n)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "Interval: $1 $2", (Object)"baseInterval", (Object)n));
        }
        if (!SDMSIntervalGeneric.checkDuration(n3)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "Interval: $1 $2", (Object)"duration", (Object)n3));
        }
        if (!SDMSIntervalGeneric.checkObjType(n5)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "Interval: $1 $2", (Object)"objType", (Object)n5));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Integer n;
        Long l7;
        Long l8;
        Long l9;
        Boolean bl;
        Boolean bl2;
        Long l10;
        Integer n2;
        Integer n3;
        Integer n4;
        Integer n5;
        Long l11;
        Long l12;
        Long l13;
        Long l14;
        String string;
        Long l15;
        try {
            l15 = new Long(resultSet.getLong(1));
            string = resultSet.getString(2);
            l14 = new Long(resultSet.getLong(3));
            l13 = new Long(resultSet.getLong(4));
            if (resultSet.wasNull()) {
                l13 = null;
            }
            l12 = new Long(resultSet.getLong(5));
            if (resultSet.wasNull()) {
                l12 = null;
            }
            l11 = new Long(resultSet.getLong(6));
            if (resultSet.wasNull()) {
                l11 = null;
            }
            n5 = new Integer(resultSet.getInt(7));
            if (resultSet.wasNull()) {
                n5 = null;
            }
            n4 = new Integer(resultSet.getInt(8));
            if (resultSet.wasNull()) {
                n4 = null;
            }
            n3 = new Integer(resultSet.getInt(9));
            if (resultSet.wasNull()) {
                n3 = null;
            }
            n2 = new Integer(resultSet.getInt(10));
            if (resultSet.wasNull()) {
                n2 = null;
            }
            l10 = new Long(resultSet.getLong(11));
            bl2 = new Boolean(resultSet.getInt(12) != 0);
            bl = new Boolean(resultSet.getInt(13) != 0);
            l9 = new Long(resultSet.getLong(14));
            if (resultSet.wasNull()) {
                l9 = null;
            }
            l8 = new Long(resultSet.getLong(15));
            if (resultSet.wasNull()) {
                l8 = null;
            }
            l7 = new Long(resultSet.getLong(16));
            if (resultSet.wasNull()) {
                l7 = null;
            }
            n = new Integer(resultSet.getInt(17));
            if (resultSet.wasNull()) {
                n = null;
            }
            l6 = new Long(resultSet.getLong(18));
            l5 = new Long(resultSet.getLong(19));
            l4 = new Long(resultSet.getLong(20));
            l3 = new Long(resultSet.getLong(21));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "Interval: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSIntervalGeneric(l15, string, l14, l13, l12, l11, n5, n4, n3, n2, l10, bl2, bl, l9, l8, l7, n, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "NAME" + string2 + ", " + string + "OWNER_ID" + string2 + ", " + string + "START_TIME" + string2 + ", " + string + "END_TIME" + string2 + ", " + string + "DELAY" + string2 + ", " + string + "BASE_INTERVAL" + string2 + ", " + string + "BASE_INTERVAL_MULTIPLIER" + string2 + ", " + string + "DURATION" + string2 + ", " + string + "DURATION_MULTIPLIER" + string2 + ", " + string + "SYNC_TIME" + string2 + ", " + string + "IS_INVERSE" + string2 + ", " + string + "IS_MERGE" + string2 + ", " + string + "EMBEDDED_INT_ID" + string2 + ", " + string + "SE_ID" + string2 + ", " + string + "OBJ_ID" + string2 + ", " + string + "OBJ_TYPE" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_name.check(((SDMSIntervalGeneric)sDMSObject).name, sDMSObject);
        string = string + "idx_name: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_ownerId.check(((SDMSIntervalGeneric)sDMSObject).ownerId, sDMSObject);
        string = string + "idx_ownerId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_embeddedIntervalId.check(((SDMSIntervalGeneric)sDMSObject).embeddedIntervalId, sDMSObject);
        string = string + "idx_embeddedIntervalId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_seId.check(((SDMSIntervalGeneric)sDMSObject).seId, sDMSObject);
        string = string + "idx_seId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_objId.check(((SDMSIntervalGeneric)sDMSObject).objId, sDMSObject);
        string = string + "idx_objId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)((SDMSIntervalGeneric)sDMSObject).name));
        sDMSKey.add(((SDMSIntervalGeneric)sDMSObject).objId);
        bl = idx_name_objId.check(sDMSKey, sDMSObject);
        string = string + "idx_name_objId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_name.put(systemEnvironment, ((SDMSIntervalGeneric)sDMSObject).name, sDMSObject, (1L & l) != 0L);
        idx_ownerId.put(systemEnvironment, ((SDMSIntervalGeneric)sDMSObject).ownerId, sDMSObject, (2L & l) != 0L);
        idx_embeddedIntervalId.put(systemEnvironment, ((SDMSIntervalGeneric)sDMSObject).embeddedIntervalId, sDMSObject, (4L & l) != 0L);
        idx_seId.put(systemEnvironment, ((SDMSIntervalGeneric)sDMSObject).seId, sDMSObject, (8L & l) != 0L);
        idx_objId.put(systemEnvironment, ((SDMSIntervalGeneric)sDMSObject).objId, sDMSObject, (0x10L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)((SDMSIntervalGeneric)sDMSObject).name));
        sDMSKey.add(((SDMSIntervalGeneric)sDMSObject).objId);
        idx_name_objId.put(systemEnvironment, sDMSKey, sDMSObject, (0x20L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_name.remove(systemEnvironment, ((SDMSIntervalGeneric)sDMSObject).name, sDMSObject);
        idx_ownerId.remove(systemEnvironment, ((SDMSIntervalGeneric)sDMSObject).ownerId, sDMSObject);
        idx_embeddedIntervalId.remove(systemEnvironment, ((SDMSIntervalGeneric)sDMSObject).embeddedIntervalId, sDMSObject);
        idx_seId.remove(systemEnvironment, ((SDMSIntervalGeneric)sDMSObject).seId, sDMSObject);
        idx_objId.remove(systemEnvironment, ((SDMSIntervalGeneric)sDMSObject).objId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)((SDMSIntervalGeneric)sDMSObject).name));
        sDMSKey.add(((SDMSIntervalGeneric)sDMSObject).objId);
        idx_name_objId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSInterval getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSInterval)table.get(systemEnvironment, l);
    }

    public static SDMSInterval getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSInterval)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSInterval getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSInterval)table.get(systemEnvironment, l, l2);
    }

    public static SDMSInterval idx_name_objId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSInterval)idx_name_objId.getUnique(systemEnvironment, object);
    }

    public static SDMSInterval idx_name_objId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSInterval)idx_name_objId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSInterval idx_name_objId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSInterval)idx_name_objId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

