/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSKillJobProxyGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;

public class SDMSKillJob
extends SDMSKillJobProxyGeneric {
    public static final String __version = "@(#) $Id: SDMSKillJob.java,v 2.2.16.1 2013/03/14 10:25:20 ronald Exp $";
    public static final String S_JOBID = "JOBID";
    public static final String S_KILLJOBID = "KILLJOBID";
    public static final String S_SDMSHOST = "SDMSHOST";
    public static final String S_SDMSPORT = "SDMSPORT";
    public static final HashSet specialNames = new HashSet<String>(Arrays.asList("JOBID", "KILLJOBID", "SDMSHOST", "SDMSPORT"));

    protected SDMSKillJob(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (specialNames.contains(string)) {
            return this.getSpecialValue(systemEnvironment, string);
        }
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, this.getSmeId(systemEnvironment));
        return sDMSSubmittedEntity.getVariableValue(systemEnvironment, string, false, "DEFAULT");
    }

    private String getSpecialValue(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string.equals(S_JOBID)) {
            return this.getId(systemEnvironment).toString();
        }
        if (string.equals(S_KILLJOBID)) {
            return this.getSmeId(systemEnvironment).toString();
        }
        if (string.equals(S_SDMSHOST)) {
            return SystemEnvironment.hostname;
        }
        if (string.equals(S_SDMSPORT)) {
            return "" + SystemEnvironment.port;
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "03208090952", "Unknown special Parameter : $1", (Object)string));
    }

    public void setToError(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.setState(systemEnvironment, new Integer(15));
        this.setErrorMsg(systemEnvironment, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        int n2 = this.getState(systemEnvironment);
        int n3 = n;
        Date date = new Date();
        Long l = new Long(date.getTime());
        if (n3 == 5) {
            HashMap<Long, Long> hashMap = SystemEnvironment.jidsStarting;
            synchronized (hashMap) {
                SystemEnvironment.jidsStarting.put(this.getId(systemEnvironment), l);
            }
        }
        if (n2 == 5) {
            HashMap<Long, Long> hashMap = SystemEnvironment.jidsStarting;
            synchronized (hashMap) {
                SystemEnvironment.jidsStarting.remove(this.getId(systemEnvironment));
            }
        }
        super.setState(systemEnvironment, n);
    }
}

