/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSNamedEnvironment;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSNamedEnvironmentGeneric
extends SDMSObject
implements Cloneable {
    public static final int nr_id = 1;
    public static final int nr_name = 2;
    public static final int nr_creatorUId = 3;
    public static final int nr_createTs = 4;
    public static final int nr_changerUId = 5;
    public static final int nr_changeTs = 6;
    public static String tableName = "NAMED_ENVIRONMENT";
    protected String name;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSNamedEnvironmentGeneric(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4) throws SDMSException {
        super(systemEnvironment, SDMSNamedEnvironmentTableGeneric.table);
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(NamedEnvironment) Length of $1 exceeds maximum length $2", (Object)"name", (Object)"64"));
        }
        this.name = string;
        this.creatorUId = l;
        this.createTs = l2;
        this.changerUId = l3;
        this.changeTs = l4;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.name;
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.name.equals(string)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NamedEnvironment) Change of system object not allowed"));
            }
            SDMSNamedEnvironmentGeneric sDMSNamedEnvironmentGeneric = (SDMSNamedEnvironmentGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(NamedEnvironment) Length of $1 exceeds maximum length $2", (Object)"name", (Object)"64"));
            }
            sDMSNamedEnvironmentGeneric.name = string;
            sDMSNamedEnvironmentGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSNamedEnvironmentGeneric.changeTs = systemEnvironment.txTime();
            sDMSNamedEnvironmentGeneric.versions.table.index(systemEnvironment, sDMSNamedEnvironmentGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSNamedEnvironmentGeneric sDMSNamedEnvironmentGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NamedEnvironment) Change of system object not allowed"));
        }
        if (sDMSNamedEnvironmentGeneric.versions.o_v == null || sDMSNamedEnvironmentGeneric.versions.o_v.size() == 0 || sDMSNamedEnvironmentGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNamedEnvironmentGeneric = (SDMSNamedEnvironmentGeneric)this.change(systemEnvironment);
        }
        sDMSNamedEnvironmentGeneric.creatorUId = l;
        sDMSNamedEnvironmentGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSNamedEnvironmentGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSNamedEnvironmentGeneric != this) {
            sDMSNamedEnvironmentGeneric.versions.table.index(systemEnvironment, sDMSNamedEnvironmentGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSNamedEnvironmentGeneric sDMSNamedEnvironmentGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NamedEnvironment) Change of system object not allowed"));
        }
        if (sDMSNamedEnvironmentGeneric.versions.o_v == null || sDMSNamedEnvironmentGeneric.versions.o_v.size() == 0 || sDMSNamedEnvironmentGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNamedEnvironmentGeneric = (SDMSNamedEnvironmentGeneric)this.change(systemEnvironment);
        }
        sDMSNamedEnvironmentGeneric.createTs = l;
        sDMSNamedEnvironmentGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSNamedEnvironmentGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSNamedEnvironmentGeneric != this) {
            sDMSNamedEnvironmentGeneric.versions.table.index(systemEnvironment, sDMSNamedEnvironmentGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSNamedEnvironmentGeneric sDMSNamedEnvironmentGeneric = this;
        if (sDMSNamedEnvironmentGeneric.versions.o_v == null || sDMSNamedEnvironmentGeneric.versions.o_v.size() == 0 || sDMSNamedEnvironmentGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNamedEnvironmentGeneric = (SDMSNamedEnvironmentGeneric)this.change(systemEnvironment);
        }
        sDMSNamedEnvironmentGeneric.changerUId = l;
        sDMSNamedEnvironmentGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSNamedEnvironmentGeneric != this) {
            sDMSNamedEnvironmentGeneric.versions.table.index(systemEnvironment, sDMSNamedEnvironmentGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSNamedEnvironmentGeneric sDMSNamedEnvironmentGeneric = this;
        if (sDMSNamedEnvironmentGeneric.versions.o_v == null || sDMSNamedEnvironmentGeneric.versions.o_v.size() == 0 || sDMSNamedEnvironmentGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNamedEnvironmentGeneric = (SDMSNamedEnvironmentGeneric)this.change(systemEnvironment);
        }
        sDMSNamedEnvironmentGeneric.changeTs = l;
        sDMSNamedEnvironmentGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSNamedEnvironmentGeneric != this) {
            sDMSNamedEnvironmentGeneric.versions.table.index(systemEnvironment, sDMSNamedEnvironmentGeneric, 0L);
        }
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return SDMSNamedEnvironment.getProxy(systemEnvironment, this);
    }

    protected SDMSNamedEnvironmentGeneric(Long l, String string, Long l2, Long l3, Long l4, Long l5, long l6, long l7) {
        this.id = l;
        this.name = string;
        this.creatorUId = l2;
        this.createTs = l3;
        this.changerUId = l4;
        this.changeTs = l5;
        this.validFrom = l6;
        this.validTo = l7;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "NAMED_ENVIRONMENT" + string3 + " (" + "ID" + ", " + string2 + "NAME" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ", VALID_FROM, VALID_TO" + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?, ?" + ")";
                SDMSNamedEnvironmentGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "NamedEnvironment: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setString(2, this.name);
            preparedStatement.setLong(3, this.creatorUId);
            preparedStatement.setLong(4, this.createTs);
            preparedStatement.setLong(5, this.changerUId);
            preparedStatement.setLong(6, this.changeTs);
            preparedStatement.setLong(7, systemEnvironment.tx.versionId);
            preparedStatement.setLong(8, Long.MAX_VALUE);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "NamedEnvironment: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.closeDBObject(systemEnvironment);
        this.insertDBObject(systemEnvironment);
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        this.closeDBObject(systemEnvironment);
    }

    private void closeDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = systemEnvironment.dbConnection.getMetaData().getDriverName();
                boolean bl = string2.startsWith("PostgreSQL");
                String string3 = SystemEnvironment.SQUOTE;
                String string4 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string3 + "NAMED_ENVIRONMENT" + string4 + " SET VALID_TO = ?, " + "    CHANGE_TS = ?, " + "    CHANGER_U_ID = ? " + "WHERE ID = ?" + "  AND VALID_TO = " + (bl ? "CAST ('9223372036854775807' AS DECIMAL)" : "9223372036854775807");
                SDMSNamedEnvironmentGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181955", "NamedEnvironment : $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, systemEnvironment.tx.versionId);
            preparedStatement.setLong(2, this.changeTs);
            preparedStatement.setLong(3, this.changerUId);
            preparedStatement.setLong(4, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181956", "NamedEnvironment: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : NamedEnvironment", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "name : " + this.name, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "name       : " + this.name + "\n" + string + "creatorUId : " + this.creatorUId + "\n" + string + "createTs   : " + this.createTs + "\n" + string + "changerUId : " + this.changerUId + "\n" + string + "changeTs   : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

