/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectEvent;
import de.independit.scheduler.server.repository.SDMSObjectEventGeneric;
import de.independit.scheduler.server.repository.SDMSObjectEventTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSObjectEventTableGeneric
extends SDMSTable {
    public static final String tableName = "OBJECT_EVENT";
    public static SDMSObjectEventTable table = null;
    public static final String[] columnNames = new String[]{"ID", "TR_ID", "OI_ID", "EVENT_TYPE", "SME_ID", "SE_ID", "SUBMIT_TS", "FINAL_TS", "FINAL_ESD_ID", "MAIN_SME_ID", "MAIN_SE_ID", "MAIN_FINAL_TS", "MAIN_FINAL_ESD_ID", "SE_VERSION", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_oiId;
    public static SDMSIndex idx_smeId;
    public static SDMSIndex idx_mainSmeId;

    public SDMSObjectEventTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ObjectEvent"));
        }
        table = (SDMSObjectEventTable)this;
        table = (SDMSObjectEventTable)this;
        this.isVersioned = false;
        idx_oiId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "oiId");
        idx_smeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "smeId");
        idx_mainSmeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "mainSmeId");
    }

    public SDMSObjectEvent create(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, Long l3, Long l4, Long l5, Long l6, Long l7, Long l8, Long l9, Long l10, Long l11, Long l12) throws SDMSException {
        SDMSObjectEvent sDMSObjectEvent;
        Long l13 = systemEnvironment.cEnv.uid();
        Long l14 = systemEnvironment.txTime();
        Long l15 = systemEnvironment.cEnv.uid();
        Long l16 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ObjectEvent"));
        }
        this.validate(systemEnvironment, l, l2, n, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSObjectEventGeneric sDMSObjectEventGeneric = new SDMSObjectEventGeneric(systemEnvironment, l, l2, n, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSObjectEventGeneric.versions, true);
            table.put(systemEnvironment, sDMSObjectEventGeneric.id, sDMSObjectEventGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSObjectEvent = (SDMSObjectEvent)sDMSObjectEventGeneric.toProxy(systemEnvironment);
            sDMSObjectEvent.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSObjectEvent sDMSObjectEvent2 = (SDMSObjectEvent)sDMSObjectEventGeneric.toProxy(systemEnvironment);
            sDMSObjectEvent2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSObjectEvent)) {
            throw new AccessViolationException(sDMSObjectEvent.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSObjectEvent;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSObjectEvent sDMSObjectEvent) throws SDMSException {
        return true;
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, Long l3, Long l4, Long l5, Long l6, Long l7, Long l8, Long l9, Long l10, Long l11, Long l12, Long l13, Long l14, Long l15, Long l16) throws SDMSException {
        if (!SDMSObjectEventGeneric.checkEventType(n)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ObjectEvent: $1 $2", (Object)"eventType", (Object)n));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Long l9;
        Long l10;
        Long l11;
        Long l12;
        Long l13;
        Long l14;
        Long l15;
        Long l16;
        Integer n;
        Long l17;
        Long l18;
        Long l19;
        try {
            l19 = new Long(resultSet.getLong(1));
            l18 = new Long(resultSet.getLong(2));
            if (resultSet.wasNull()) {
                l18 = null;
            }
            l17 = new Long(resultSet.getLong(3));
            n = new Integer(resultSet.getInt(4));
            l16 = new Long(resultSet.getLong(5));
            l15 = new Long(resultSet.getLong(6));
            l14 = new Long(resultSet.getLong(7));
            if (resultSet.wasNull()) {
                l14 = null;
            }
            l13 = new Long(resultSet.getLong(8));
            if (resultSet.wasNull()) {
                l13 = null;
            }
            l12 = new Long(resultSet.getLong(9));
            if (resultSet.wasNull()) {
                l12 = null;
            }
            l11 = new Long(resultSet.getLong(10));
            if (resultSet.wasNull()) {
                l11 = null;
            }
            l10 = new Long(resultSet.getLong(11));
            if (resultSet.wasNull()) {
                l10 = null;
            }
            l9 = new Long(resultSet.getLong(12));
            if (resultSet.wasNull()) {
                l9 = null;
            }
            l8 = new Long(resultSet.getLong(13));
            if (resultSet.wasNull()) {
                l8 = null;
            }
            l7 = new Long(resultSet.getLong(14));
            l6 = new Long(resultSet.getLong(15));
            l5 = new Long(resultSet.getLong(16));
            l4 = new Long(resultSet.getLong(17));
            l3 = new Long(resultSet.getLong(18));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ObjectEvent: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSObjectEventGeneric(l19, l18, l17, n, l16, l15, l14, l13, l12, l11, l10, l9, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "TR_ID" + string2 + ", " + string + "OI_ID" + string2 + ", " + string + "EVENT_TYPE" + string2 + ", " + string + "SME_ID" + string2 + ", " + string + "SE_ID" + string2 + ", " + string + "SUBMIT_TS" + string2 + ", " + string + "FINAL_TS" + string2 + ", " + string + "FINAL_ESD_ID" + string2 + ", " + string + "MAIN_SME_ID" + string2 + ", " + string + "MAIN_SE_ID" + string2 + ", " + string + "MAIN_FINAL_TS" + string2 + ", " + string + "MAIN_FINAL_ESD_ID" + string2 + ", " + string + "SE_VERSION" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + "  FROM " + string + this.tableName() + string2 + " WHERE SE_VERSION >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' as DECIMAL)" : "" + systemEnvironment.lowestActiveVersion) + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_oiId.check(((SDMSObjectEventGeneric)sDMSObject).oiId, sDMSObject);
        string = string + "idx_oiId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_smeId.check(((SDMSObjectEventGeneric)sDMSObject).smeId, sDMSObject);
        string = string + "idx_smeId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_mainSmeId.check(((SDMSObjectEventGeneric)sDMSObject).mainSmeId, sDMSObject);
        string = string + "idx_mainSmeId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_oiId.put(systemEnvironment, ((SDMSObjectEventGeneric)sDMSObject).oiId, sDMSObject, (1L & l) != 0L);
        idx_smeId.put(systemEnvironment, ((SDMSObjectEventGeneric)sDMSObject).smeId, sDMSObject, (2L & l) != 0L);
        idx_mainSmeId.put(systemEnvironment, ((SDMSObjectEventGeneric)sDMSObject).mainSmeId, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_oiId.remove(systemEnvironment, ((SDMSObjectEventGeneric)sDMSObject).oiId, sDMSObject);
        idx_smeId.remove(systemEnvironment, ((SDMSObjectEventGeneric)sDMSObject).smeId, sDMSObject);
        idx_mainSmeId.remove(systemEnvironment, ((SDMSObjectEventGeneric)sDMSObject).mainSmeId, sDMSObject);
    }

    public static SDMSObjectEvent getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSObjectEvent)table.get(systemEnvironment, l);
    }

    public static SDMSObjectEvent getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSObjectEvent)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSObjectEvent getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSObjectEvent)table.get(systemEnvironment, l, l2);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

