/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceAllocationProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceAllocationTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSRunnableQueue;
import de.independit.scheduler.server.repository.SDMSRunnableQueueTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSnpSrvrSRFootprint;
import de.independit.scheduler.server.repository.SDMSnpSrvrSRFootprintTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.HashMap;
import java.util.Vector;

public class SDMSResourceAllocation
extends SDMSResourceAllocationProxyGeneric {
    public static final String __version = "@(#) $Id: SDMSResourceAllocation.java,v 2.3.14.1 2013/03/14 10:25:23 ronald Exp $";
    static final Integer ONE = new Integer(1);

    protected SDMSResourceAllocation(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSThread.doTrace(systemEnvironment.cEnv, "Deleting RA without stickyCleanup ------------------------------------", -1);
        this.delete(systemEnvironment, false, false);
    }

    public void delete(SystemEnvironment systemEnvironment, boolean bl, boolean bl2) throws SDMSException {
        Integer n;
        int n2;
        int n3 = this.getRefcount(systemEnvironment);
        if (n3 > 1 && !bl2) {
            this.setRefcount(systemEnvironment, new Integer(n3 - 1));
            return;
        }
        Long l = this.getRId(systemEnvironment);
        Long l2 = this.getSmeId(systemEnvironment);
        int n4 = this.getAllocationType(systemEnvironment);
        SDMSResourceAllocation sDMSResourceAllocation = null;
        if (this.getIsSticky(systemEnvironment).booleanValue() && l2 > 0L) {
            try {
                sDMSResourceAllocation = SDMSResourceAllocationTable.idx_smeId_rId_stickyName_getUnique(systemEnvironment, new SDMSKey(new Long(-this.getStickyParent(systemEnvironment).longValue()), this.getRId(systemEnvironment), (Comparable)((Object)this.getStickyName(systemEnvironment))));
            }
            catch (NotFoundException notFoundException) {
                SDMSThread.doTrace(systemEnvironment.cEnv, ": No master reservation found for sticky allocation", -1);
            }
        }
        if ((n4 == 4 || n4 == 2 || n4 == 3) && (n2 = (n = this.getAmount(systemEnvironment)).intValue()) != 0) {
            Comparable comparable;
            if (l2 > 0L && this.getIsSticky(systemEnvironment).booleanValue()) {
                comparable = new Long(-this.getStickyParent(systemEnvironment).longValue());
                try {
                    SDMSResourceAllocation sDMSResourceAllocation2 = SDMSResourceAllocationTable.idx_smeId_rId_stickyName_getUnique(systemEnvironment, new SDMSKey(comparable, l, (Comparable)((Object)this.getStickyName(systemEnvironment))));
                    int n5 = sDMSResourceAllocation2.getAmount(systemEnvironment);
                    int n6 = sDMSResourceAllocation2.getOrigAmount(systemEnvironment) - n5;
                    if (n6 > 0) {
                        if (n6 >= n2) {
                            sDMSResourceAllocation2.setMyAmount(systemEnvironment, new Integer(n5 + n2));
                            n2 = 0;
                        } else {
                            n2 -= n6;
                            sDMSResourceAllocation2.setMyAmount(systemEnvironment, new Integer(n5 + n6));
                        }
                    }
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            try {
                comparable = SDMSResourceTable.getObjectForUpdate(systemEnvironment, l);
                comparable.releaseAmount(systemEnvironment, n2);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        super.delete(systemEnvironment);
        if (sDMSResourceAllocation != null) {
            if (bl) {
                sDMSResourceAllocation.cleanupStickyGroup(systemEnvironment);
            }
            sDMSResourceAllocation.delete(systemEnvironment, bl, false);
        }
    }

    public void cleanupStickyGroup(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getRId(systemEnvironment);
        SDMSResource sDMSResource = SDMSResourceTable.getObject(systemEnvironment, l);
        Long l2 = sDMSResource.getNrId(systemEnvironment);
        String string = this.getStickyName(systemEnvironment);
        Vector vector = SDMSResourceAllocationTable.idx_stickyParent_rId_stickyName.getVector(systemEnvironment, new SDMSKey(this.getStickyParent(systemEnvironment), this.getRId(systemEnvironment), (Comparable)((Object)string)));
        for (int i = 0; i < vector.size(); ++i) {
            Long l3;
            SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)vector.get(i);
            try {
                l3 = sDMSResourceAllocation.getId(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {
                continue;
            }
            if (this.getId(systemEnvironment).equals(l3)) continue;
            Long l4 = sDMSResourceAllocation.getSmeId(systemEnvironment);
            Vector vector2 = SDMSRunnableQueueTable.idx_smeId.getVector(systemEnvironment, l4);
            for (int j = 0; j < vector2.size(); ++j) {
                SDMSRunnableQueue sDMSRunnableQueue = (SDMSRunnableQueue)vector2.get(j);
                Long l5 = sDMSRunnableQueue.getScopeId(systemEnvironment);
                SDMSnpSrvrSRFootprint sDMSnpSrvrSRFootprint = SDMSnpSrvrSRFootprintTable.idx_sId_getUnique(systemEnvironment, l5);
                HashMap hashMap = sDMSnpSrvrSRFootprint.getFp(systemEnvironment);
                if (!l.equals(hashMap.get(l2))) continue;
                sDMSRunnableQueue.delete(systemEnvironment);
                for (Long l6 : hashMap.keySet()) {
                    Long l7 = (Long)hashMap.get(l6);
                    Vector vector3 = SDMSResourceAllocationTable.idx_smeId_nrId.getVector(systemEnvironment, new SDMSKey(l4, l6));
                    for (int k = 0; k < vector3.size(); ++k) {
                        SDMSResourceAllocation sDMSResourceAllocation2 = (SDMSResourceAllocation)vector3.get(k);
                        if (!l7.equals(sDMSResourceAllocation2.getRId(systemEnvironment))) continue;
                        sDMSResourceAllocation2.delete(systemEnvironment, true, false);
                    }
                }
            }
            vector2 = SDMSRunnableQueueTable.idx_smeId.getVector(systemEnvironment, l4);
            if (vector2.size() != 0) continue;
            SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l4);
            sDMSSubmittedEntity.setToError(systemEnvironment, "Job cannot run in any scope because all scopes were eliminated due to sticky requests");
        }
    }

    public SDMSResourceAllocation ignore(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setAllocationType(systemEnvironment, new Integer(5));
        return this;
    }

    @Override
    public void setAllocationType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        int n2;
        Comparable<Integer> comparable;
        SDMSResource sDMSResource;
        int n3 = this.getAllocationType(systemEnvironment);
        int n4 = n;
        try {
            sDMSResource = SDMSResourceTable.getObject(systemEnvironment, this.getRId(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            SDMSThread.doTrace(systemEnvironment.cEnv, "Cannot set allocation type of a Named Resource IGNORE Resource Allocation", -1);
            return;
        }
        if (!(n3 != 1 && n3 != 6 || n4 != 4 && n4 != 2 && n4 != 3 || (comparable = sDMSResource.getFreeAmount(systemEnvironment)) == null)) {
            comparable = new Integer((Integer)comparable - Math.max(this.getAmount(systemEnvironment), 0));
            sDMSResource.setFreeAmount(systemEnvironment, (Integer)comparable);
        }
        super.setAllocationType(systemEnvironment, n);
        if (n4 == 5) {
            Integer n5;
            if ((n3 == 4 || n3 == 2) && (Integer)(comparable = this.getAmount(systemEnvironment)) > 0 && (n5 = sDMSResource.getFreeAmount(systemEnvironment)) != null) {
                n5 = new Integer(n5 + (Integer)comparable);
                sDMSResource.setFreeAmount(systemEnvironment, n5);
            }
            if (this.getIsSticky(systemEnvironment).booleanValue()) {
                try {
                    comparable = SDMSSubmittedEntityTable.getObject(systemEnvironment, this.getSmeId(systemEnvironment));
                    SDMSThread.doTrace(null, "Trying to release Masterreservation", 3);
                    ((SDMSSubmittedEntity)comparable).releaseStickyResource(systemEnvironment, this, sDMSResource, ((SDMSSubmittedEntityProxyGeneric)comparable).getState(systemEnvironment));
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        }
        if ((n3 == 4 || n3 == 2) && n4 == 1 && (n2 = ((Integer)(comparable = this.getAmount(systemEnvironment))).intValue()) != 0) {
            Long l = this.getRId(systemEnvironment);
            if (this.getIsSticky(systemEnvironment).booleanValue()) {
                Long l2 = new Long(-this.getStickyParent(systemEnvironment).longValue());
                try {
                    SDMSResourceAllocation sDMSResourceAllocation = SDMSResourceAllocationTable.idx_smeId_rId_stickyName_getUnique(systemEnvironment, new SDMSKey(l2, l, (Comparable)((Object)this.getStickyName(systemEnvironment))));
                    int n6 = sDMSResourceAllocation.getAmount(systemEnvironment);
                    int n7 = sDMSResourceAllocation.getOrigAmount(systemEnvironment) - n6;
                    if (n7 > 0) {
                        if (n7 >= n2) {
                            sDMSResourceAllocation.setMyAmount(systemEnvironment, new Integer(n6 + n2));
                            n2 = 0;
                        } else {
                            n2 -= n7;
                            sDMSResourceAllocation.setMyAmount(systemEnvironment, new Integer(n6 + n7));
                        }
                    }
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            sDMSResource.releaseAmount(systemEnvironment, n2);
        }
        if (n4 == 4) {
            this.setRefcount(systemEnvironment, ONE);
        }
    }

    @Override
    public void setAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        SDMSResource sDMSResource;
        Integer n2;
        int n3;
        int n4 = this.getAllocationType(systemEnvironment);
        if (n4 == 1 || n4 == 6) {
            super.setAmount(systemEnvironment, new Integer(Math.max(n, 0)));
            return;
        }
        int n5 = this.getAmount(systemEnvironment);
        if (n5 == (n3 = n.intValue())) {
            return;
        }
        if ((n5 >= 0 || n3 >= 0) && (n2 = (sDMSResource = SDMSResourceTable.getObject(systemEnvironment, this.getRId(systemEnvironment))).getFreeAmount(systemEnvironment)) != null) {
            int n6 = n2;
            int n7 = n3 - n5;
            if (n7 < 0 && n3 < 0) {
                n7 -= n3;
            }
            if (n7 > 0 && n5 < 0) {
                n7 += n5;
            }
            sDMSResource.setFreeAmount(systemEnvironment, new Integer(n6 - n7));
        }
        super.setAmount(systemEnvironment, new Integer(Math.max(n3, 0)));
    }

    protected void setMyAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        super.setAmount(systemEnvironment, n);
    }

    @Override
    public void setRefcount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        super.setRefcount(systemEnvironment, n);
    }
}

