/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSResourceGeneric
extends SDMSObject
implements Cloneable {
    public static final int REASON_AVAILABLE = 0;
    public static final int REASON_LOCKMODE = 1;
    public static final int REASON_AMOUNT = 2;
    public static final int REASON_STATE = 4;
    public static final int REASON_EXPIRE = 8;
    public static final int REASON_OFFLINE = 16;
    public static final int nr_id = 1;
    public static final int nr_nrId = 2;
    public static final int nr_scopeId = 3;
    public static final int nr_masterId = 4;
    public static final int nr_ownerId = 5;
    public static final int nr_linkId = 6;
    public static final int nr_managerId = 7;
    public static final int nr_tag = 8;
    public static final int nr_rsdId = 9;
    public static final int nr_rsdTime = 10;
    public static final int nr_definedAmount = 11;
    public static final int nr_requestableAmount = 12;
    public static final int nr_amount = 13;
    public static final int nr_freeAmount = 14;
    public static final int nr_isOnline = 15;
    public static final int nr_factor = 16;
    public static final int nr_traceInterval = 17;
    public static final int nr_traceBase = 18;
    public static final int nr_traceBaseMultiplier = 19;
    public static final int nr_td0Avg = 20;
    public static final int nr_td1Avg = 21;
    public static final int nr_td2Avg = 22;
    public static final int nr_lwAvg = 23;
    public static final int nr_lastEval = 24;
    public static final int nr_lastWrite = 25;
    public static final int nr_creatorUId = 26;
    public static final int nr_createTs = 27;
    public static final int nr_changerUId = 28;
    public static final int nr_changeTs = 29;
    public static String tableName = "RESSOURCE";
    protected Long nrId;
    protected Long scopeId;
    protected Long masterId;
    protected Long ownerId;
    protected Long linkId;
    protected Long managerId;
    protected String tag;
    protected Long rsdId;
    protected Long rsdTime;
    protected Integer definedAmount;
    protected Integer requestableAmount;
    protected Integer amount;
    protected Integer freeAmount;
    protected Boolean isOnline;
    protected Float factor;
    protected Integer traceInterval;
    protected Integer traceBase;
    protected Integer traceBaseMultiplier;
    protected Float td0Avg;
    protected Float td1Avg;
    protected Float td2Avg;
    protected Float lwAvg;
    protected Long lastEval;
    protected Long lastWrite;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSResourceGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Long l6, String string, Long l7, Long l8, Integer n, Integer n2, Integer n3, Integer n4, Boolean bl, Float f, Integer n5, Integer n6, Integer n7, Float f2, Float f3, Float f4, Float f5, Long l9, Long l10, Long l11, Long l12, Long l13, Long l14) throws SDMSException {
        super(systemEnvironment, SDMSResourceTableGeneric.table);
        this.nrId = l;
        this.scopeId = l2;
        this.masterId = l3;
        this.ownerId = l4;
        this.linkId = l5;
        this.managerId = l6;
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(Resource) Length of $1 exceeds maximum length $2", (Object)"tag", (Object)"64"));
        }
        this.tag = string;
        this.rsdId = l7;
        this.rsdTime = l8;
        this.definedAmount = n;
        this.requestableAmount = n2;
        this.amount = n3;
        this.freeAmount = n4;
        this.isOnline = bl;
        this.factor = f;
        this.traceInterval = n5;
        this.traceBase = n6;
        this.traceBaseMultiplier = n7;
        this.td0Avg = f2;
        this.td1Avg = f3;
        this.td2Avg = f4;
        this.lwAvg = f5;
        this.lastEval = l9;
        this.lastWrite = l10;
        this.creatorUId = l11;
        this.createTs = l12;
        this.changerUId = l13;
        this.changeTs = l14;
    }

    public Long getNrId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.nrId;
    }

    public void setNrId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.nrId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
            }
            SDMSResourceGeneric sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
            sDMSResourceGeneric.nrId = l;
            sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 257L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getScopeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.scopeId;
    }

    public void setScopeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.scopeId)) {
            return;
        }
        if (l == null && this.scopeId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
            }
            SDMSResourceGeneric sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
            sDMSResourceGeneric.scopeId = l;
            sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 258L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getMasterId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.masterId;
    }

    public void setMasterId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.masterId)) {
            return;
        }
        if (l == null && this.masterId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
            }
            SDMSResourceGeneric sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
            sDMSResourceGeneric.masterId = l;
            sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ownerId;
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.ownerId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
            }
            SDMSResourceGeneric sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
            sDMSResourceGeneric.ownerId = l;
            sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 8L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getLinkId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.linkId;
    }

    public void setLinkId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.linkId)) {
            return;
        }
        if (l == null && this.linkId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
            }
            SDMSResourceGeneric sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
            sDMSResourceGeneric.linkId = l;
            sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 16L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getManagerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.managerId;
    }

    public void setManagerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.managerId)) {
            return;
        }
        if (l == null && this.managerId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
            }
            SDMSResourceGeneric sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
            sDMSResourceGeneric.managerId = l;
            sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 32L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public String getTag(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.tag;
    }

    public void setTag(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.tag)) {
            return;
        }
        if (string == null && this.tag == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
            }
            SDMSResourceGeneric sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(Resource) Length of $1 exceeds maximum length $2", (Object)"tag", (Object)"64"));
            }
            sDMSResourceGeneric.tag = string;
            sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 64L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getRsdId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.rsdId;
    }

    public void setRsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.rsdId)) {
            return;
        }
        if (l == null && this.rsdId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
            }
            SDMSResourceGeneric sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
            sDMSResourceGeneric.rsdId = l;
            sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 128L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getRsdTime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.rsdTime;
    }

    public void setRsdTime(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.rsdTime)) {
            return;
        }
        if (l == null && this.rsdTime == null) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.rsdTime = l;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Integer getDefinedAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.definedAmount;
    }

    public void setDefinedAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.definedAmount)) {
            return;
        }
        if (n == null && this.definedAmount == null) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.definedAmount = n;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Integer getRequestableAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.requestableAmount;
    }

    public void setRequestableAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.requestableAmount)) {
            return;
        }
        if (n == null && this.requestableAmount == null) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.requestableAmount = n;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Integer getAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.amount;
    }

    public void setAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.amount)) {
            return;
        }
        if (n == null && this.amount == null) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.amount = n;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Integer getFreeAmount(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.freeAmount;
    }

    public void setFreeAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.freeAmount)) {
            return;
        }
        if (n == null && this.freeAmount == null) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.freeAmount = n;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Boolean getIsOnline(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isOnline;
    }

    public void setIsOnline(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.isOnline)) {
            return;
        }
        if (bl == null && this.isOnline == null) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.isOnline = bl;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Float getFactor(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.factor;
    }

    public void setFactor(SystemEnvironment systemEnvironment, Float f) throws SDMSException {
        if (f != null && f.equals(this.factor)) {
            return;
        }
        if (f == null && this.factor == null) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.factor = f;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Integer getTraceInterval(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.traceInterval;
    }

    public void setTraceInterval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.traceInterval)) {
            return;
        }
        if (n == null && this.traceInterval == null) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.traceInterval = n;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Integer getTraceBase(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.traceBase;
    }

    public void setTraceBase(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.traceBase)) {
            return;
        }
        if (n == null && this.traceBase == null) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.traceBase = n;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Integer getTraceBaseMultiplier(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.traceBaseMultiplier;
    }

    public void setTraceBaseMultiplier(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.traceBaseMultiplier.equals(n)) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.traceBaseMultiplier = n;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Float getTd0Avg(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.td0Avg;
    }

    public void setTd0Avg(SystemEnvironment systemEnvironment, Float f) throws SDMSException {
        if (this.td0Avg.equals(f)) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.td0Avg = f;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Float getTd1Avg(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.td1Avg;
    }

    public void setTd1Avg(SystemEnvironment systemEnvironment, Float f) throws SDMSException {
        if (this.td1Avg.equals(f)) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.td1Avg = f;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Float getTd2Avg(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.td2Avg;
    }

    public void setTd2Avg(SystemEnvironment systemEnvironment, Float f) throws SDMSException {
        if (this.td2Avg.equals(f)) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.td2Avg = f;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Float getLwAvg(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.lwAvg;
    }

    public void setLwAvg(SystemEnvironment systemEnvironment, Float f) throws SDMSException {
        if (this.lwAvg.equals(f)) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.lwAvg = f;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Long getLastEval(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.lastEval;
    }

    public void setLastEval(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.lastEval.equals(l)) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.lastEval = l;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Long getLastWrite(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.lastWrite;
    }

    public void setLastWrite(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.lastWrite.equals(l)) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.lastWrite = l;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.creatorUId = l;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Resource) Change of system object not allowed"));
        }
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.createTs = l;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.changerUId = l;
        sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSResourceGeneric sDMSResourceGeneric = this;
        if (sDMSResourceGeneric.versions.o_v == null || sDMSResourceGeneric.versions.o_v.size() == 0 || sDMSResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
        }
        sDMSResourceGeneric.changeTs = l;
        sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSResourceGeneric != this) {
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric, 0L);
        }
    }

    public SDMSResourceGeneric set_NrIdScopeId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSResourceGeneric sDMSResourceGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(Resource) Change of system object not allowed"));
            }
            sDMSResourceGeneric = (SDMSResourceGeneric)this.change(systemEnvironment);
            sDMSResourceGeneric.nrId = l;
            sDMSResourceGeneric.scopeId = l2;
            sDMSResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceGeneric.versions.table.index(systemEnvironment, sDMSResourceGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSResourceGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return SDMSResource.getProxy(systemEnvironment, this);
    }

    protected SDMSResourceGeneric(Long l, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7, String string, Long l8, Long l9, Integer n, Integer n2, Integer n3, Integer n4, Boolean bl, Float f, Integer n5, Integer n6, Integer n7, Float f2, Float f3, Float f4, Float f5, Long l10, Long l11, Long l12, Long l13, Long l14, Long l15, long l16, long l17) {
        this.id = l;
        this.nrId = l2;
        this.scopeId = l3;
        this.masterId = l4;
        this.ownerId = l5;
        this.linkId = l6;
        this.managerId = l7;
        this.tag = string;
        this.rsdId = l8;
        this.rsdTime = l9;
        this.definedAmount = n;
        this.requestableAmount = n2;
        this.amount = n3;
        this.freeAmount = n4;
        this.isOnline = bl;
        this.factor = f;
        this.traceInterval = n5;
        this.traceBase = n6;
        this.traceBaseMultiplier = n7;
        this.td0Avg = f2;
        this.td1Avg = f3;
        this.td2Avg = f4;
        this.lwAvg = f5;
        this.lastEval = l10;
        this.lastWrite = l11;
        this.creatorUId = l12;
        this.createTs = l13;
        this.changerUId = l14;
        this.changeTs = l15;
        this.validFrom = l16;
        this.validTo = l17;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "RESSOURCE" + string3 + " (" + "ID" + ", " + string2 + "NR_ID" + string3 + ", " + string2 + "SCOPE_ID" + string3 + ", " + string2 + "MASTER_ID" + string3 + ", " + string2 + "OWNER_ID" + string3 + ", " + string2 + "LINK_ID" + string3 + ", " + string2 + "MANAGER_ID" + string3 + ", " + string2 + "TAG" + string3 + ", " + string2 + "RSD_ID" + string3 + ", " + string2 + "RSD_TIME" + string3 + ", " + string2 + "DEFINED_AMOUNT" + string3 + ", " + string2 + "REQUESTABLE_AMOUNT" + string3 + ", " + string2 + "AMOUNT" + string3 + ", " + string2 + "FREE_AMOUNT" + string3 + ", " + string2 + "IS_ONLINE" + string3 + ", " + string2 + "FACTOR" + string3 + ", " + string2 + "TRACE_INTERVAL" + string3 + ", " + string2 + "TRACE_BASE" + string3 + ", " + string2 + "TRACE_BASE_MULTIPLIER" + string3 + ", " + string2 + "TD0_AVG" + string3 + ", " + string2 + "TD1_AVG" + string3 + ", " + string2 + "TD2_AVG" + string3 + ", " + string2 + "LW_AVG" + string3 + ", " + string2 + "LAST_EVAL" + string3 + ", " + string2 + "LAST_WRITE" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ")";
                SDMSResourceGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "Resource: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.nrId);
            if (this.scopeId == null) {
                preparedStatement.setNull(3, 4);
            } else {
                preparedStatement.setLong(3, this.scopeId);
            }
            if (this.masterId == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.masterId);
            }
            preparedStatement.setLong(5, this.ownerId);
            if (this.linkId == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setLong(6, this.linkId);
            }
            if (this.managerId == null) {
                preparedStatement.setNull(7, 4);
            } else {
                preparedStatement.setLong(7, this.managerId);
            }
            if (this.tag == null) {
                preparedStatement.setNull(8, 12);
            } else {
                preparedStatement.setString(8, this.tag);
            }
            if (this.rsdId == null) {
                preparedStatement.setNull(9, 4);
            } else {
                preparedStatement.setLong(9, this.rsdId);
            }
            if (this.rsdTime == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setLong(10, this.rsdTime);
            }
            if (this.definedAmount == null) {
                preparedStatement.setNull(11, 4);
            } else {
                preparedStatement.setInt(11, this.definedAmount);
            }
            if (this.requestableAmount == null) {
                preparedStatement.setNull(12, 4);
            } else {
                preparedStatement.setInt(12, this.requestableAmount);
            }
            if (this.amount == null) {
                preparedStatement.setNull(13, 4);
            } else {
                preparedStatement.setInt(13, this.amount);
            }
            if (this.freeAmount == null) {
                preparedStatement.setNull(14, 4);
            } else {
                preparedStatement.setInt(14, this.freeAmount);
            }
            if (this.isOnline == null) {
                preparedStatement.setNull(15, 4);
            } else {
                preparedStatement.setInt(15, this.isOnline != false ? 1 : 0);
            }
            if (this.factor == null) {
                preparedStatement.setNull(16, 6);
            } else {
                preparedStatement.setFloat(16, this.factor.floatValue());
            }
            if (this.traceInterval == null) {
                preparedStatement.setNull(17, 4);
            } else {
                preparedStatement.setInt(17, this.traceInterval);
            }
            if (this.traceBase == null) {
                preparedStatement.setNull(18, 4);
            } else {
                preparedStatement.setInt(18, this.traceBase);
            }
            preparedStatement.setInt(19, this.traceBaseMultiplier);
            preparedStatement.setFloat(20, this.td0Avg.floatValue());
            preparedStatement.setFloat(21, this.td1Avg.floatValue());
            preparedStatement.setFloat(22, this.td2Avg.floatValue());
            preparedStatement.setFloat(23, this.lwAvg.floatValue());
            preparedStatement.setLong(24, this.lastEval);
            preparedStatement.setLong(25, this.lastWrite);
            preparedStatement.setLong(26, this.creatorUId);
            preparedStatement.setLong(27, this.createTs);
            preparedStatement.setLong(28, this.changerUId);
            preparedStatement.setLong(29, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "Resource: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "RESSOURCE" + string3 + " WHERE ID = ?";
                SDMSResourceGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "Resource: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "Resource: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "RESSOURCE" + string3 + " SET " + "" + string2 + "NR_ID" + string3 + " = ? " + ", " + string2 + "SCOPE_ID" + string3 + " = ? " + ", " + string2 + "MASTER_ID" + string3 + " = ? " + ", " + string2 + "OWNER_ID" + string3 + " = ? " + ", " + string2 + "LINK_ID" + string3 + " = ? " + ", " + string2 + "MANAGER_ID" + string3 + " = ? " + ", " + string2 + "TAG" + string3 + " = ? " + ", " + string2 + "RSD_ID" + string3 + " = ? " + ", " + string2 + "RSD_TIME" + string3 + " = ? " + ", " + string2 + "DEFINED_AMOUNT" + string3 + " = ? " + ", " + string2 + "REQUESTABLE_AMOUNT" + string3 + " = ? " + ", " + string2 + "AMOUNT" + string3 + " = ? " + ", " + string2 + "FREE_AMOUNT" + string3 + " = ? " + ", " + string2 + "IS_ONLINE" + string3 + " = ? " + ", " + string2 + "FACTOR" + string3 + " = ? " + ", " + string2 + "TRACE_INTERVAL" + string3 + " = ? " + ", " + string2 + "TRACE_BASE" + string3 + " = ? " + ", " + string2 + "TRACE_BASE_MULTIPLIER" + string3 + " = ? " + ", " + string2 + "TD0_AVG" + string3 + " = ? " + ", " + string2 + "TD1_AVG" + string3 + " = ? " + ", " + string2 + "TD2_AVG" + string3 + " = ? " + ", " + string2 + "LW_AVG" + string3 + " = ? " + ", " + string2 + "LAST_EVAL" + string3 + " = ? " + ", " + string2 + "LAST_WRITE" + string3 + " = ? " + ", " + string2 + "CREATOR_U_ID" + string3 + " = ? " + ", " + string2 + "CREATE_TS" + string3 + " = ? " + ", " + string2 + "CHANGER_U_ID" + string3 + " = ? " + ", " + string2 + "CHANGE_TS" + string3 + " = ? " + "WHERE ID = ?";
                SDMSResourceGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "Resource: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.nrId);
            if (this.scopeId == null) {
                preparedStatement.setNull(2, 4);
            } else {
                preparedStatement.setLong(2, this.scopeId);
            }
            if (this.masterId == null) {
                preparedStatement.setNull(3, 4);
            } else {
                preparedStatement.setLong(3, this.masterId);
            }
            preparedStatement.setLong(4, this.ownerId);
            if (this.linkId == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setLong(5, this.linkId);
            }
            if (this.managerId == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setLong(6, this.managerId);
            }
            if (this.tag == null) {
                preparedStatement.setNull(7, 12);
            } else {
                preparedStatement.setString(7, this.tag);
            }
            if (this.rsdId == null) {
                preparedStatement.setNull(8, 4);
            } else {
                preparedStatement.setLong(8, this.rsdId);
            }
            if (this.rsdTime == null) {
                preparedStatement.setNull(9, 4);
            } else {
                preparedStatement.setLong(9, this.rsdTime);
            }
            if (this.definedAmount == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setInt(10, this.definedAmount);
            }
            if (this.requestableAmount == null) {
                preparedStatement.setNull(11, 4);
            } else {
                preparedStatement.setInt(11, this.requestableAmount);
            }
            if (this.amount == null) {
                preparedStatement.setNull(12, 4);
            } else {
                preparedStatement.setInt(12, this.amount);
            }
            if (this.freeAmount == null) {
                preparedStatement.setNull(13, 4);
            } else {
                preparedStatement.setInt(13, this.freeAmount);
            }
            if (this.isOnline == null) {
                preparedStatement.setNull(14, 4);
            } else {
                preparedStatement.setInt(14, this.isOnline != false ? 1 : 0);
            }
            if (this.factor == null) {
                preparedStatement.setNull(15, 6);
            } else {
                preparedStatement.setFloat(15, this.factor.floatValue());
            }
            if (this.traceInterval == null) {
                preparedStatement.setNull(16, 4);
            } else {
                preparedStatement.setInt(16, this.traceInterval);
            }
            if (this.traceBase == null) {
                preparedStatement.setNull(17, 4);
            } else {
                preparedStatement.setInt(17, this.traceBase);
            }
            preparedStatement.setInt(18, this.traceBaseMultiplier);
            preparedStatement.setFloat(19, this.td0Avg.floatValue());
            preparedStatement.setFloat(20, this.td1Avg.floatValue());
            preparedStatement.setFloat(21, this.td2Avg.floatValue());
            preparedStatement.setFloat(22, this.lwAvg.floatValue());
            preparedStatement.setLong(23, this.lastEval);
            preparedStatement.setLong(24, this.lastWrite);
            preparedStatement.setLong(25, this.creatorUId);
            preparedStatement.setLong(26, this.createTs);
            preparedStatement.setLong(27, this.changerUId);
            preparedStatement.setLong(28, this.changeTs);
            preparedStatement.setLong(29, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "Resource: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : Resource", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "nrId : " + this.nrId, 2);
        SDMSThread.doTrace(null, "scopeId : " + this.scopeId, 2);
        SDMSThread.doTrace(null, "masterId : " + this.masterId, 2);
        SDMSThread.doTrace(null, "ownerId : " + this.ownerId, 2);
        SDMSThread.doTrace(null, "linkId : " + this.linkId, 2);
        SDMSThread.doTrace(null, "managerId : " + this.managerId, 2);
        SDMSThread.doTrace(null, "tag : " + this.tag, 2);
        SDMSThread.doTrace(null, "rsdId : " + this.rsdId, 2);
        SDMSThread.doTrace(null, "rsdTime : " + this.rsdTime, 2);
        SDMSThread.doTrace(null, "definedAmount : " + this.definedAmount, 2);
        SDMSThread.doTrace(null, "requestableAmount : " + this.requestableAmount, 2);
        SDMSThread.doTrace(null, "amount : " + this.amount, 2);
        SDMSThread.doTrace(null, "freeAmount : " + this.freeAmount, 2);
        SDMSThread.doTrace(null, "isOnline : " + this.isOnline, 2);
        SDMSThread.doTrace(null, "factor : " + this.factor, 2);
        SDMSThread.doTrace(null, "traceInterval : " + this.traceInterval, 2);
        SDMSThread.doTrace(null, "traceBase : " + this.traceBase, 2);
        SDMSThread.doTrace(null, "traceBaseMultiplier : " + this.traceBaseMultiplier, 2);
        SDMSThread.doTrace(null, "td0Avg : " + this.td0Avg, 2);
        SDMSThread.doTrace(null, "td1Avg : " + this.td1Avg, 2);
        SDMSThread.doTrace(null, "td2Avg : " + this.td2Avg, 2);
        SDMSThread.doTrace(null, "lwAvg : " + this.lwAvg, 2);
        SDMSThread.doTrace(null, "lastEval : " + this.lastEval, 2);
        SDMSThread.doTrace(null, "lastWrite : " + this.lastWrite, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "nrId                : " + this.nrId + "\n" + string + "scopeId             : " + this.scopeId + "\n" + string + "masterId            : " + this.masterId + "\n" + string + "ownerId             : " + this.ownerId + "\n" + string + "linkId              : " + this.linkId + "\n" + string + "managerId           : " + this.managerId + "\n" + string + "tag                 : " + this.tag + "\n" + string + "rsdId               : " + this.rsdId + "\n" + string + "rsdTime             : " + this.rsdTime + "\n" + string + "definedAmount       : " + this.definedAmount + "\n" + string + "requestableAmount   : " + this.requestableAmount + "\n" + string + "amount              : " + this.amount + "\n" + string + "freeAmount          : " + this.freeAmount + "\n" + string + "isOnline            : " + this.isOnline + "\n" + string + "factor              : " + this.factor + "\n" + string + "traceInterval       : " + this.traceInterval + "\n" + string + "traceBase           : " + this.traceBase + "\n" + string + "traceBaseMultiplier : " + this.traceBaseMultiplier + "\n" + string + "td0Avg              : " + this.td0Avg + "\n" + string + "td1Avg              : " + this.td1Avg + "\n" + string + "td2Avg              : " + this.td2Avg + "\n" + string + "lwAvg               : " + this.lwAvg + "\n" + string + "lastEval            : " + this.lastEval + "\n" + string + "lastWrite           : " + this.lastWrite + "\n" + string + "creatorUId          : " + this.creatorUId + "\n" + string + "createTs            : " + this.createTs + "\n" + string + "changerUId          : " + this.changerUId + "\n" + string + "changeTs            : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

