/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSScheduleGeneric
extends SDMSObject
implements Cloneable {
    public static final boolean ACTIVE = true;
    public static final boolean INACTIVE = false;
    public static final int nr_id = 1;
    public static final int nr_name = 2;
    public static final int nr_ownerId = 3;
    public static final int nr_intId = 4;
    public static final int nr_parentId = 5;
    public static final int nr_timeZone = 6;
    public static final int nr_seId = 7;
    public static final int nr_isActive = 8;
    public static final int nr_creatorUId = 9;
    public static final int nr_createTs = 10;
    public static final int nr_changerUId = 11;
    public static final int nr_changeTs = 12;
    public static final int nr_inheritPrivs = 13;
    public static String tableName = "SCHEDULE";
    protected String name;
    protected Long ownerId;
    protected Long intId;
    protected Long parentId;
    protected String timeZone;
    protected Long seId;
    protected Boolean isActive;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    protected Long inheritPrivs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSScheduleGeneric(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, String string2, Long l4, Boolean bl, Long l5, Long l6, Long l7, Long l8, Long l9) throws SDMSException {
        super(systemEnvironment, SDMSScheduleTableGeneric.table);
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(Schedule) Length of $1 exceeds maximum length $2", (Object)"name", (Object)"64"));
        }
        this.name = string;
        this.ownerId = l;
        this.intId = l2;
        this.parentId = l3;
        if (string2 != null && string2.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(Schedule) Length of $1 exceeds maximum length $2", (Object)"timeZone", (Object)"32"));
        }
        this.timeZone = string2;
        this.seId = l4;
        this.isActive = bl;
        this.creatorUId = l5;
        this.createTs = l6;
        this.changerUId = l7;
        this.changeTs = l8;
        this.inheritPrivs = l9;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.name;
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.name.equals(string)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Schedule) Change of system object not allowed"));
            }
            SDMSScheduleGeneric sDMSScheduleGeneric = (SDMSScheduleGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(Schedule) Length of $1 exceeds maximum length $2", (Object)"name", (Object)"64"));
            }
            sDMSScheduleGeneric.name = string;
            sDMSScheduleGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSScheduleGeneric.changeTs = systemEnvironment.txTime();
            sDMSScheduleGeneric.versions.table.index(systemEnvironment, sDMSScheduleGeneric, 16L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ownerId;
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.ownerId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            SDMSScheduleGeneric sDMSScheduleGeneric = (SDMSScheduleGeneric)this.change(systemEnvironment);
            sDMSScheduleGeneric.ownerId = l;
            sDMSScheduleGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSScheduleGeneric.changeTs = systemEnvironment.txTime();
            sDMSScheduleGeneric.versions.table.index(systemEnvironment, sDMSScheduleGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getIntId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.intId;
    }

    public void setIntId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.intId)) {
            return;
        }
        if (l == null && this.intId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Schedule) Change of system object not allowed"));
            }
            SDMSScheduleGeneric sDMSScheduleGeneric = (SDMSScheduleGeneric)this.change(systemEnvironment);
            sDMSScheduleGeneric.intId = l;
            sDMSScheduleGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSScheduleGeneric.changeTs = systemEnvironment.txTime();
            sDMSScheduleGeneric.versions.table.index(systemEnvironment, sDMSScheduleGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getParentId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.parentId;
    }

    public void setParentId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.parentId)) {
            return;
        }
        if (l == null && this.parentId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Schedule) Change of system object not allowed"));
            }
            SDMSScheduleGeneric sDMSScheduleGeneric = (SDMSScheduleGeneric)this.change(systemEnvironment);
            sDMSScheduleGeneric.parentId = l;
            sDMSScheduleGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSScheduleGeneric.changeTs = systemEnvironment.txTime();
            sDMSScheduleGeneric.versions.table.index(systemEnvironment, sDMSScheduleGeneric, 20L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public String getTimeZone(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.timeZone;
    }

    public void setTimeZone(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.timeZone.equals(string)) {
            return;
        }
        SDMSScheduleGeneric sDMSScheduleGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Schedule) Change of system object not allowed"));
        }
        if (sDMSScheduleGeneric.versions.o_v == null || sDMSScheduleGeneric.versions.o_v.size() == 0 || sDMSScheduleGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduleGeneric = (SDMSScheduleGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(Schedule) Length of $1 exceeds maximum length $2", (Object)"timeZone", (Object)"32"));
        }
        sDMSScheduleGeneric.timeZone = string;
        sDMSScheduleGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduleGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduleGeneric != this) {
            sDMSScheduleGeneric.versions.table.index(systemEnvironment, sDMSScheduleGeneric, 0L);
        }
    }

    public Long getSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seId;
    }

    public void setSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.seId)) {
            return;
        }
        if (l == null && this.seId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Schedule) Change of system object not allowed"));
            }
            SDMSScheduleGeneric sDMSScheduleGeneric = (SDMSScheduleGeneric)this.change(systemEnvironment);
            sDMSScheduleGeneric.seId = l;
            sDMSScheduleGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSScheduleGeneric.changeTs = systemEnvironment.txTime();
            sDMSScheduleGeneric.versions.table.index(systemEnvironment, sDMSScheduleGeneric, 8L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Boolean getIsActive(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isActive;
    }

    public String getIsActiveAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Boolean bl = this.getIsActive(systemEnvironment);
        boolean bl2 = bl;
        if (bl2) {
            return "ACTIVE";
        }
        if (!bl2) {
            return "INACTIVE";
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown Schedule.isActive: $1", (Object)this.getIsActive(systemEnvironment)));
    }

    public void setIsActive(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isActive.equals(bl)) {
            return;
        }
        SDMSScheduleGeneric sDMSScheduleGeneric = this;
        if (sDMSScheduleGeneric.versions.o_v == null || sDMSScheduleGeneric.versions.o_v.size() == 0 || sDMSScheduleGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduleGeneric = (SDMSScheduleGeneric)this.change(systemEnvironment);
        }
        sDMSScheduleGeneric.isActive = bl;
        sDMSScheduleGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduleGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduleGeneric != this) {
            sDMSScheduleGeneric.versions.table.index(systemEnvironment, sDMSScheduleGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSScheduleGeneric sDMSScheduleGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Schedule) Change of system object not allowed"));
        }
        if (sDMSScheduleGeneric.versions.o_v == null || sDMSScheduleGeneric.versions.o_v.size() == 0 || sDMSScheduleGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduleGeneric = (SDMSScheduleGeneric)this.change(systemEnvironment);
        }
        sDMSScheduleGeneric.creatorUId = l;
        sDMSScheduleGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduleGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduleGeneric != this) {
            sDMSScheduleGeneric.versions.table.index(systemEnvironment, sDMSScheduleGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSScheduleGeneric sDMSScheduleGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Schedule) Change of system object not allowed"));
        }
        if (sDMSScheduleGeneric.versions.o_v == null || sDMSScheduleGeneric.versions.o_v.size() == 0 || sDMSScheduleGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduleGeneric = (SDMSScheduleGeneric)this.change(systemEnvironment);
        }
        sDMSScheduleGeneric.createTs = l;
        sDMSScheduleGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduleGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduleGeneric != this) {
            sDMSScheduleGeneric.versions.table.index(systemEnvironment, sDMSScheduleGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSScheduleGeneric sDMSScheduleGeneric = this;
        if (sDMSScheduleGeneric.versions.o_v == null || sDMSScheduleGeneric.versions.o_v.size() == 0 || sDMSScheduleGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduleGeneric = (SDMSScheduleGeneric)this.change(systemEnvironment);
        }
        sDMSScheduleGeneric.changerUId = l;
        sDMSScheduleGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduleGeneric != this) {
            sDMSScheduleGeneric.versions.table.index(systemEnvironment, sDMSScheduleGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSScheduleGeneric sDMSScheduleGeneric = this;
        if (sDMSScheduleGeneric.versions.o_v == null || sDMSScheduleGeneric.versions.o_v.size() == 0 || sDMSScheduleGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduleGeneric = (SDMSScheduleGeneric)this.change(systemEnvironment);
        }
        sDMSScheduleGeneric.changeTs = l;
        sDMSScheduleGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSScheduleGeneric != this) {
            sDMSScheduleGeneric.versions.table.index(systemEnvironment, sDMSScheduleGeneric, 0L);
        }
    }

    public Long getInheritPrivs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.inheritPrivs;
    }

    public void setInheritPrivs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.inheritPrivs.equals(l)) {
            return;
        }
        SDMSScheduleGeneric sDMSScheduleGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Schedule) Change of system object not allowed"));
        }
        if (sDMSScheduleGeneric.versions.o_v == null || sDMSScheduleGeneric.versions.o_v.size() == 0 || sDMSScheduleGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScheduleGeneric = (SDMSScheduleGeneric)this.change(systemEnvironment);
        }
        sDMSScheduleGeneric.inheritPrivs = l;
        sDMSScheduleGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScheduleGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScheduleGeneric != this) {
            sDMSScheduleGeneric.versions.table.index(systemEnvironment, sDMSScheduleGeneric, 0L);
        }
    }

    public SDMSScheduleGeneric set_ParentIdName(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        SDMSScheduleGeneric sDMSScheduleGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(Schedule) Change of system object not allowed"));
            }
            sDMSScheduleGeneric = (SDMSScheduleGeneric)this.change(systemEnvironment);
            sDMSScheduleGeneric.parentId = l;
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290026", "(Schedule) Length of $1 exceeds maximum length $2", (Object)"inheritPrivs", (Object)"64"));
            }
            sDMSScheduleGeneric.name = string;
            sDMSScheduleGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSScheduleGeneric.changeTs = systemEnvironment.txTime();
            sDMSScheduleGeneric.versions.table.index(systemEnvironment, sDMSScheduleGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSScheduleGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return SDMSSchedule.getProxy(systemEnvironment, this);
    }

    protected SDMSScheduleGeneric(Long l, String string, Long l2, Long l3, Long l4, String string2, Long l5, Boolean bl, Long l6, Long l7, Long l8, Long l9, Long l10, long l11, long l12) {
        this.id = l;
        this.name = string;
        this.ownerId = l2;
        this.intId = l3;
        this.parentId = l4;
        this.timeZone = string2;
        this.seId = l5;
        this.isActive = bl;
        this.creatorUId = l6;
        this.createTs = l7;
        this.changerUId = l8;
        this.changeTs = l9;
        this.inheritPrivs = l10;
        this.validFrom = l11;
        this.validTo = l12;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "SCHEDULE" + string3 + " (" + "ID" + ", " + string2 + "NAME" + string3 + ", " + string2 + "OWNER_ID" + string3 + ", " + string2 + "INT_ID" + string3 + ", " + string2 + "PARENT_ID" + string3 + ", " + string2 + "TIME_ZONE" + string3 + ", " + string2 + "SE_ID" + string3 + ", " + string2 + "ACTIVE" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ", " + string2 + "INHERIT_PRIVS" + string3 + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ")";
                SDMSScheduleGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "Schedule: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setString(2, this.name);
            preparedStatement.setLong(3, this.ownerId);
            if (this.intId == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.intId);
            }
            if (this.parentId == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setLong(5, this.parentId);
            }
            preparedStatement.setString(6, this.timeZone);
            if (this.seId == null) {
                preparedStatement.setNull(7, 4);
            } else {
                preparedStatement.setLong(7, this.seId);
            }
            preparedStatement.setInt(8, this.isActive != false ? 1 : 0);
            preparedStatement.setLong(9, this.creatorUId);
            preparedStatement.setLong(10, this.createTs);
            preparedStatement.setLong(11, this.changerUId);
            preparedStatement.setLong(12, this.changeTs);
            preparedStatement.setLong(13, this.inheritPrivs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "Schedule: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "SCHEDULE" + string3 + " WHERE ID = ?";
                SDMSScheduleGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "Schedule: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "Schedule: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "SCHEDULE" + string3 + " SET " + "" + string2 + "NAME" + string3 + " = ? " + ", " + string2 + "OWNER_ID" + string3 + " = ? " + ", " + string2 + "INT_ID" + string3 + " = ? " + ", " + string2 + "PARENT_ID" + string3 + " = ? " + ", " + string2 + "TIME_ZONE" + string3 + " = ? " + ", " + string2 + "SE_ID" + string3 + " = ? " + ", " + string2 + "ACTIVE" + string3 + " = ? " + ", " + string2 + "CREATOR_U_ID" + string3 + " = ? " + ", " + string2 + "CREATE_TS" + string3 + " = ? " + ", " + string2 + "CHANGER_U_ID" + string3 + " = ? " + ", " + string2 + "CHANGE_TS" + string3 + " = ? " + ", " + string2 + "INHERIT_PRIVS" + string3 + " = ? " + "WHERE ID = ?";
                SDMSScheduleGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "Schedule: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setString(1, this.name);
            preparedStatement.setLong(2, this.ownerId);
            if (this.intId == null) {
                preparedStatement.setNull(3, 4);
            } else {
                preparedStatement.setLong(3, this.intId);
            }
            if (this.parentId == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.parentId);
            }
            preparedStatement.setString(5, this.timeZone);
            if (this.seId == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setLong(6, this.seId);
            }
            preparedStatement.setInt(7, this.isActive != false ? 1 : 0);
            preparedStatement.setLong(8, this.creatorUId);
            preparedStatement.setLong(9, this.createTs);
            preparedStatement.setLong(10, this.changerUId);
            preparedStatement.setLong(11, this.changeTs);
            preparedStatement.setLong(12, this.inheritPrivs);
            preparedStatement.setLong(13, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "Schedule: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    public static boolean checkIsActive(Boolean bl) {
        if (bl.booleanValue()) {
            return true;
        }
        return bl == false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : Schedule", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "name : " + this.name, 2);
        SDMSThread.doTrace(null, "ownerId : " + this.ownerId, 2);
        SDMSThread.doTrace(null, "intId : " + this.intId, 2);
        SDMSThread.doTrace(null, "parentId : " + this.parentId, 2);
        SDMSThread.doTrace(null, "timeZone : " + this.timeZone, 2);
        SDMSThread.doTrace(null, "seId : " + this.seId, 2);
        SDMSThread.doTrace(null, "isActive : " + this.isActive, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "inheritPrivs : " + this.inheritPrivs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "name         : " + this.name + "\n" + string + "ownerId      : " + this.ownerId + "\n" + string + "intId        : " + this.intId + "\n" + string + "parentId     : " + this.parentId + "\n" + string + "timeZone     : " + this.timeZone + "\n" + string + "seId         : " + this.seId + "\n" + string + "isActive     : " + this.isActive + "\n" + string + "creatorUId   : " + this.creatorUId + "\n" + string + "createTs     : " + this.createTs + "\n" + string + "changerUId   : " + this.changerUId + "\n" + string + "changeTs     : " + this.changeTs + "\n" + string + "inheritPrivs : " + this.inheritPrivs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

