/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.SubmitJob;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.repository.DependencyDefinitionListElement;
import de.independit.scheduler.server.repository.SDMSAuditTrail;
import de.independit.scheduler.server.repository.SDMSAuditTrailTable;
import de.independit.scheduler.server.repository.SDMSDependencyDefinition;
import de.independit.scheduler.server.repository.SDMSDependencyDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSDependencyDefinitionTable;
import de.independit.scheduler.server.repository.SDMSDependencyInstance;
import de.independit.scheduler.server.repository.SDMSDependencyInstanceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSDependencyInstanceTable;
import de.independit.scheduler.server.repository.SDMSEntityVariable;
import de.independit.scheduler.server.repository.SDMSEntityVariableTable;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfileProxyGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfileTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSHierarchyInstance;
import de.independit.scheduler.server.repository.SDMSHierarchyInstanceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSHierarchyInstanceTable;
import de.independit.scheduler.server.repository.SDMSIgnoredDependencyTable;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSKillJob;
import de.independit.scheduler.server.repository.SDMSKillJobTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectEvent;
import de.independit.scheduler.server.repository.SDMSObjectEventTable;
import de.independit.scheduler.server.repository.SDMSOwnedObject;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceAllocation;
import de.independit.scheduler.server.repository.SDMSResourceAllocationTable;
import de.independit.scheduler.server.repository.SDMSResourceStateMapping;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSRunnableQueueTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityStats;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityStatsTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerQueue;
import de.independit.scheduler.server.repository.SDMSTriggerQueueTable;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import de.independit.scheduler.server.repository.SDMSnpJobFootprint;
import de.independit.scheduler.server.repository.SDMSnpJobFootprintTable;
import de.independit.scheduler.server.repository.SmeVariableResolver;
import de.independit.scheduler.server.repository.UnresolvedExternalDependency;
import de.independit.scheduler.server.repository.VariableResolver;
import de.independit.scheduler.server.util.BoolExpr;
import de.independit.scheduler.server.util.SDMSFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;

public class SDMSSubmittedEntity
extends SDMSSubmittedEntityProxyGeneric
implements SDMSOwnedObject {
    protected static final int NOTYET = 0;
    protected static final int FULFILLED = 1;
    protected static final int UNREACHABLE_CANCELLED = 2;
    protected static final int BROKEN = 3;
    protected static final int UNRESOLVED_SUSPEND = 4;
    public static final int STAT_NONE = 0;
    public static final int STAT_DEPENDENCY_WAIT = 1;
    public static final int STAT_SUSPEND = 2;
    public static final int STAT_SYNCHRONIZE = 3;
    public static final int STAT_RESOURCE = 4;
    public static final int STAT_JOBSERVER = 5;
    public static final int STAT_RESTARTABLE = 6;
    public static final int STAT_CHILD_WAIT = 7;
    public static final String S_JOBID = "JOBID";
    public static final String S_SEID = "SEID";
    public static final String S_MASTERID = "MASTERID";
    public static final String S_KEY = "KEY";
    public static final String S_PID = "PID";
    public static final String S_LOGFILE = "LOGFILE";
    public static final String S_ERRORLOG = "ERRORLOG";
    public static final String S_WORKDIR = "WORKDIR";
    public static final String S_SDMSHOST = "SDMSHOST";
    public static final String S_SDMSPORT = "SDMSPORT";
    public static final String S_JOBNAME = "JOBNAME";
    public static final String S_JOBTAG = "JOBTAG";
    public static final String S_TRNAME = "TRIGGERNAME";
    public static final String S_TRTYPE = "TRIGGERTYPE";
    public static final String S_TRBASE = "TRIGGERBASE";
    public static final String S_TRBASEID = "TRIGGERBASEID";
    public static final String S_TRBASEJOBID = "TRIGGERBASEJOBID";
    public static final String S_TRORIGIN = "TRIGGERORIGIN";
    public static final String S_TRORIGINID = "TRIGGERORIGINID";
    public static final String S_TRORIGINJOBID = "TRIGGERORIGINJOBID";
    public static final String S_TRREASON = "TRIGGERREASON";
    public static final String S_TRREASONID = "TRIGGERREASONID";
    public static final String S_TRREASONJOBID = "TRIGGERREASONJOBID";
    public static final String S_TRSEQ = "TRIGGERSEQNO";
    public static final String S_TROSTATE = "TRIGGEROLDSTATE";
    public static final String S_TRNSTATE = "TRIGGERNEWSTATE";
    public static final String S_TRWARNING = "TRIGGERWARNING";
    public static final String S_SUBMITTS = "SUBMITTIME";
    public static final String S_STARTTS = "STARTTIME";
    public static final String S_EXPRUNTIME = "EXPRUNTIME";
    public static final String S_EXPFINALTIME = "EXPFINALTIME";
    public static final String S_JOBSTATE = "JOBSTATE";
    public static final String S_MERGEDSTATE = "MERGEDSTATE";
    public static final String S_PARENTID = "PARENTID";
    public static final String S_STATE = "STATE";
    public static final String S_ISRESTARTABLE = "ISRESTARTABLE";
    public static final String S_SYNCTS = "SYNCTIME";
    public static final String S_RESOURCETS = "RESOURCETIME";
    public static final String S_RUNNABLETS = "RUNNABLETIME";
    public static final String S_FINISHTS = "FINISHTIME";
    public static final String S_SYSDATE = "SYSDATE";
    public static final String S_WARNING = "LAST_WARNING";
    public static final String S_RERUNSEQ = "RERUNSEQ";
    public static final String S_SCOPENAME = "SCOPENAME";
    public static final String S_IDLE_TIME = "IDLE_TIME";
    public static final String S_DEPENDENCY_WAIT_TIME = "DEPENDENCY_WAIT_TIME";
    public static final String S_SUSPEND_TIME = "SUSPEND_TIME";
    public static final String S_SYNC_TIME = "SYNC_TIME";
    public static final String S_RESOURCE_TIME = "RESOURCE_TIME";
    public static final String S_JOBSERVER_TIME = "JOBSERVER_TIME";
    public static final String S_RESTARTABLE_TIME = "RESTARTABLE_TIME";
    public static final String S_CHILD_WAIT_TIME = "CHILD_WAIT_TIME";
    public static final String S_PROCESS_TIME = "PROCESS_TIME";
    public static final String S_ACTIVE_TIME = "ACTIVE_TIME";
    public static final String S_IDLE_PCT = "IDLE_PCT";
    public static final String S_SUBMITTER = "SUBMITTER";
    public static final String S_SUBMITGROUP = "SUBMITGROUP";
    public static final String S_SEOWNER = "SEOWNER";
    public static final String S_ENVIRONMENT = "ENVIRONMENT";
    protected static final Integer zero = new Integer(0);
    protected static final Long lzero = new Long(0L);
    protected static final VariableResolver SVR = new SmeVariableResolver();
    protected static final HashMap mapper = new HashMap();

    protected SDMSSubmittedEntity(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    public static Integer map(Integer n) {
        return (Integer)mapper.get(n);
    }

    public String getSubmitPathString(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.getSubmitPathString(systemEnvironment, false);
    }

    public String getSubmitPathString(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        Long l;
        String string = "";
        SDMSSubmittedEntity sDMSSubmittedEntity = this;
        do {
            String string2;
            Long l2 = sDMSSubmittedEntity.getSeId(systemEnvironment);
            long l3 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l2, l3);
            if (!string.equals("")) {
                string = ":" + string;
            }
            if (bl && (string2 = sDMSSubmittedEntity.getChildTag(systemEnvironment)) != null && !string2.equals("")) {
                string = "[" + string2 + "]" + string;
            }
            string = sDMSSchedulingEntity.pathString(systemEnvironment, l3) + string;
            l = sDMSSubmittedEntity.getParentId(systemEnvironment);
            if (l == null) continue;
            sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
        } while (l != null);
        return string;
    }

    public void suspend(SystemEnvironment systemEnvironment, boolean bl, boolean bl2) throws SDMSException {
        this.suspend(systemEnvironment, bl, bl2, true);
    }

    public void suspend(SystemEnvironment systemEnvironment, boolean bl, boolean bl2, boolean bl3) throws SDMSException {
        int n = this.getState(systemEnvironment);
        if (n == 12 || n == 10 || this.getIsCancelled(systemEnvironment).booleanValue()) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02201121213", "Cannot suspend an already final (or cancelled) submitted entity"));
        }
        this.suspend(systemEnvironment, true, bl, bl2, bl3);
    }

    public void resume(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        this.resume(systemEnvironment, bl, true);
    }

    public void resume(SystemEnvironment systemEnvironment, boolean bl, boolean bl2) throws SDMSException {
        this.setResumeTs(systemEnvironment, null);
        this.suspend(systemEnvironment, false, false, bl, bl2);
        Long l = this.getJobEsdId(systemEnvironment);
        if (l != null) {
            long l2 = this.getSeVersion(systemEnvironment);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.getSeId(systemEnvironment), l2);
            Long l3 = sDMSSchedulingEntity.getEspId(systemEnvironment);
            SDMSExitState sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(l3, l), l2);
            if (sDMSExitState.getIsFinal(systemEnvironment).booleanValue()) {
                this.setJobIsFinal(systemEnvironment, Boolean.TRUE);
                this.checkDependents(systemEnvironment);
            }
        }
        this.checkFinal(systemEnvironment);
    }

    public void rerun(SystemEnvironment systemEnvironment) throws SDMSException {
        if (!this.getJobIsRestartable(systemEnvironment).booleanValue()) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03205191052", "Submitted entity not rerunable"));
        }
        this.rerunEntity(systemEnvironment);
    }

    public boolean rerunEntity(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.getJobIsRestartable(systemEnvironment).booleanValue()) {
            int n = this.getState(systemEnvironment);
            if (n != 15) {
                Integer n2 = this.getRerunSeq(systemEnvironment);
                SDMSSubmittedEntityStatsTable.table.create(systemEnvironment, this.getId(systemEnvironment), n2, this.getScopeId(systemEnvironment), this.getJobEsdId(systemEnvironment), this.getExitCode(systemEnvironment), this.getCommandline(systemEnvironment), this.getWorkdir(systemEnvironment), this.getLogfile(systemEnvironment), this.getErrlogfile(systemEnvironment), this.getExtPid(systemEnvironment), this.getSyncTs(systemEnvironment), this.getResourceTs(systemEnvironment), this.getRunnableTs(systemEnvironment), this.getStartTs(systemEnvironment), this.getFinishTs(systemEnvironment));
                this.setRerunSeq(systemEnvironment, new Integer(n2 + 1));
            }
            this.setStartTs(systemEnvironment, null);
            this.setFinishTs(systemEnvironment, null);
            this.setErrorMsg(systemEnvironment, null);
            this.setJobEsdId(systemEnvironment, null, false);
            this.setJobEsdPref(systemEnvironment, null);
            this.setState(systemEnvironment, new Integer(1));
            SystemEnvironment.sched.notifyChange(systemEnvironment, this, 17);
            return true;
        }
        return false;
    }

    public void rerunRecursive(SystemEnvironment systemEnvironment, Long l, String string, boolean bl) throws SDMSException {
        Object object;
        Cloneable cloneable;
        boolean bl2 = this.rerunEntity(systemEnvironment);
        if (bl || bl2) {
            cloneable = new Date();
            object = new Long(((Date)cloneable).getTime());
            SDMSAuditTrailTable.table.create(systemEnvironment, systemEnvironment.cEnv.uid(), (Long)object, new Integer(2), new Integer(17), this.getId(systemEnvironment), l, Boolean.FALSE, null, string);
        }
        if (this.getState(systemEnvironment) != 12) {
            cloneable = SDMSHierarchyInstanceTable.idx_parentId.getVector(systemEnvironment, this.getId(systemEnvironment));
            object = ((Vector)cloneable).iterator();
            while (object.hasNext()) {
                SDMSHierarchyInstance sDMSHierarchyInstance = (SDMSHierarchyInstance)object.next();
                SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSHierarchyInstance.getChildId(systemEnvironment));
                sDMSSubmittedEntity.rerunRecursive(systemEnvironment, l, string, false);
            }
        }
    }

    public void kill(SystemEnvironment systemEnvironment) throws SDMSException {
        int n = this.getState(systemEnvironment);
        if (n != 7 && n != 9 && n != 13) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207081340", "Cannot kill a submitted entity which is not in a running State"));
        }
        Date date = new Date();
        Long l = new Long(date.getTime());
        long l2 = this.getSeVersion(systemEnvironment);
        String string = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.getSeId(systemEnvironment), l2).getKillProgram(systemEnvironment);
        if (string == null) {
            return;
        }
        SDMSKillJob sDMSKillJob = SDMSKillJobTable.table.create(systemEnvironment, this.getSeId(systemEnvironment), this.getSeVersion(systemEnvironment), this.getId(systemEnvironment), this.getScopeId(systemEnvironment), new Integer(4), null, string, this.getLogfile(systemEnvironment), this.getErrlogfile(systemEnvironment), null, null, null, l, null, null);
        Long l3 = this.getScopeId(systemEnvironment);
        SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l3);
        SDMSRunnableQueueTable.table.create(systemEnvironment, sDMSKillJob.getId(systemEnvironment), this.getScopeId(systemEnvironment), sDMSKillJob.getState(systemEnvironment));
        this.setKillId(systemEnvironment, sDMSKillJob.getId(systemEnvironment));
        this.setState(systemEnvironment, new Integer(8));
        sDMSScope.notify(systemEnvironment);
    }

    private boolean isActive(SystemEnvironment systemEnvironment) throws SDMSException {
        int n = this.getState(systemEnvironment);
        return n == 5 || n == 6 || n == 7 || n == 8 || n == 9 || n == 13 || this.getCntStarting(systemEnvironment) + this.getCntStarted(systemEnvironment) + this.getCntRunning(systemEnvironment) + this.getCntToKill(systemEnvironment) + this.getCntKilled(systemEnvironment) + this.getCntBrokenActive(systemEnvironment) > 0;
    }

    public void cancel(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSSubmittedEntity sDMSSubmittedEntity;
        int n = this.getState(systemEnvironment);
        if (n == 12 || n == 10) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02204260751", "Cannot cancel an already final (or cancelled) submitted entity"));
        }
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSHierarchyInstanceTable.idx_childId.getVector(systemEnvironment, l);
        for (SDMSHierarchyInstance sDMSHierarchyInstance : vector) {
            sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSHierarchyInstance.getParentId(systemEnvironment));
            sDMSSubmittedEntity.mergeExitStates(systemEnvironment, false, this);
        }
        this.do_cancel(systemEnvironment);
        for (SDMSHierarchyInstance sDMSHierarchyInstance : vector) {
            sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSHierarchyInstance.getParentId(systemEnvironment));
            sDMSSubmittedEntity.checkFinal(systemEnvironment);
        }
    }

    private void do_cancel(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        this.setIsCancelled(systemEnvironment, Boolean.TRUE);
        boolean bl = this.isActive(systemEnvironment);
        HashSet<Long> hashSet = (HashSet<Long>)systemEnvironment.tx.txData.get("CANCEL_HASH_SET");
        if (hashSet == null) {
            hashSet = new HashSet<Long>();
            systemEnvironment.tx.txData.put("CANCEL_HASH_SET", hashSet);
        }
        hashSet.add(this.getId(systemEnvironment));
        if (!bl) {
            this.releaseResources(systemEnvironment, 10);
        }
        if (!bl) {
            this.setState(systemEnvironment, new Integer(10));
        }
        if (!bl) {
            this.fixUpObjectEvents(systemEnvironment);
        }
        Vector vector = SDMSSubmittedEntityTable.idx_parentId.getVector(systemEnvironment, l);
        for (SDMSProxy sDMSProxy : vector) {
            if (((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getState(systemEnvironment) == 12 || ((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getState(systemEnvironment) == 10) continue;
            ((SDMSSubmittedEntity)sDMSProxy).cancel(systemEnvironment);
        }
        this.setResumeTs(systemEnvironment, null);
        this.suspend(systemEnvironment, false, false, true, true, true);
        this.removeAsyncTrigger(systemEnvironment);
        if (!bl) {
            this.deleteLocalResources(systemEnvironment);
            try {
                SDMSProxy sDMSProxy;
                sDMSProxy = SDMSnpJobFootprintTable.idx_smeId_getUnique(systemEnvironment, this.getId(systemEnvironment));
                sDMSProxy.delete(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    public void doDeferredCancel(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSHierarchyInstanceTable.idx_childId.getVector(systemEnvironment, l);
        Iterator iterator = vector.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            SDMSHierarchyInstance sDMSHierarchyInstance = (SDMSHierarchyInstance)iterator.next();
            SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSHierarchyInstance.getParentId(systemEnvironment));
            if (!sDMSSubmittedEntity.getIsCancelled(systemEnvironment).booleanValue()) continue;
            bl = true;
            sDMSSubmittedEntity.doDeferredCancel(systemEnvironment);
        }
        if (!bl && this.getState(systemEnvironment) != 12 && this.getState(systemEnvironment) != 10) {
            this.cancel(systemEnvironment);
        }
    }

    public void disable(SystemEnvironment systemEnvironment) throws SDMSException {
        int n = this.getState(systemEnvironment);
        boolean bl = false;
        if (n == 11) {
            long l = this.getSeVersion(systemEnvironment);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.getSeId(systemEnvironment), l);
            int n2 = sDMSSchedulingEntity.getType(systemEnvironment);
            if (n2 == 1) {
                bl = true;
            }
        }
        if (bl || n == 10 || n == 4 || n == 5 || n == 6 || n == 7 || n == 9 || n == 12 || n == 13 || n == 14 || n == 15 || n == 16 || n == 8 || this.getCntRunnable(systemEnvironment) + this.getCntStarting(systemEnvironment) + this.getCntStarted(systemEnvironment) + this.getCntRunning(systemEnvironment) + this.getCntKilled(systemEnvironment) + this.getCntFinished(systemEnvironment) + this.getCntFinal(systemEnvironment) + this.getCntBrokenActive(systemEnvironment) + this.getCntBrokenFinished(systemEnvironment) + this.getCntError(systemEnvironment) + this.getCntUnreachable(systemEnvironment) + this.getCntRestartable(systemEnvironment) + this.getCntPending(systemEnvironment) + this.getCntToKill(systemEnvironment) > 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02809031333", "Cannot disable a cancelled or already active submitted entity"));
        }
        this.doDisable(systemEnvironment);
    }

    public void doDisable(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSSubmittedEntity sDMSSubmittedEntity = this;
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        if (sDMSSubmittedEntity.getIsDisabled(systemEnvironment).booleanValue()) {
            return;
        }
        sDMSSubmittedEntity.setIsDisabled(systemEnvironment, Boolean.TRUE);
        sDMSSubmittedEntity.setState(systemEnvironment, new Integer(1));
        sDMSSubmittedEntity.checkDependencies(systemEnvironment);
        Vector vector = SDMSHierarchyInstanceTable.idx_parentId.getVector(systemEnvironment, l);
        for (SDMSHierarchyInstance sDMSHierarchyInstance : vector) {
            Long l2 = sDMSHierarchyInstance.getChildId(systemEnvironment);
            SDMSSubmittedEntity sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l2);
            sDMSSubmittedEntity2.doDisable(systemEnvironment);
        }
    }

    private void checkDeferStall(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSSubmittedEntity sDMSSubmittedEntity = this;
        Long l = this.getMasterId(systemEnvironment);
        if (l != this.getId(systemEnvironment)) {
            sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
        }
        if (sDMSSubmittedEntity.getState(systemEnvironment) != 10 && sDMSSubmittedEntity.getIsSuspended(systemEnvironment) == 0 && sDMSSubmittedEntity.getChildSuspended(systemEnvironment) <= 0 && sDMSSubmittedEntity.getJobIsFinal(systemEnvironment).booleanValue() && sDMSSubmittedEntity.getCntSubmitted(systemEnvironment) == 0 && sDMSSubmittedEntity.getCntDependencyWait(systemEnvironment) > 0 && sDMSSubmittedEntity.getCntSynchronizeWait(systemEnvironment) == 0 && sDMSSubmittedEntity.getCntResourceWait(systemEnvironment) == 0 && sDMSSubmittedEntity.getCntRunnable(systemEnvironment) == 0 && sDMSSubmittedEntity.getCntStarting(systemEnvironment) == 0 && sDMSSubmittedEntity.getCntStarted(systemEnvironment) == 0 && sDMSSubmittedEntity.getCntRunning(systemEnvironment) == 0 && sDMSSubmittedEntity.getCntToKill(systemEnvironment) == 0 && sDMSSubmittedEntity.getCntKilled(systemEnvironment) == 0 && sDMSSubmittedEntity.getCntRestartable(systemEnvironment) == 0 && sDMSSubmittedEntity.getCntBrokenActive(systemEnvironment) == 0 && sDMSSubmittedEntity.getCntBrokenFinished(systemEnvironment) == 0 && sDMSSubmittedEntity.getCntError(systemEnvironment) == 0 && sDMSSubmittedEntity.getCntUnreachable(systemEnvironment) == 0) {
            SDMSSubmittedEntity sDMSSubmittedEntity2;
            int n;
            Vector vector = SDMSSubmittedEntityTable.idx_masterId.getVector(systemEnvironment, (Object)l, new SDMSFilter(){

                @Override
                public boolean isValid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
                    return ((SDMSSubmittedEntity)sDMSProxy).getState(systemEnvironment) == 1;
                }
            });
            Vector<SDMSSubmittedEntity> vector2 = new Vector<SDMSSubmittedEntity>();
            for (n = 0; n < vector.size(); ++n) {
                SDMSDependencyInstance sDMSDependencyInstance;
                int n2;
                sDMSSubmittedEntity2 = (SDMSSubmittedEntity)vector.get(n);
                boolean bl = false;
                boolean bl2 = false;
                Vector vector3 = SDMSDependencyInstanceTable.idx_dependentId.getVector(systemEnvironment, sDMSSubmittedEntity2.getId(systemEnvironment));
                for (n2 = 0; n2 < vector3.size(); ++n2) {
                    sDMSDependencyInstance = (SDMSDependencyInstance)vector3.get(n2);
                    if (sDMSDependencyInstance.getState(systemEnvironment) != 0) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                for (n2 = 0; n2 < vector3.size(); ++n2) {
                    sDMSDependencyInstance = (SDMSDependencyInstance)vector3.get(n2);
                    if (sDMSDependencyInstance.getState(systemEnvironment) != 4 || sDMSDependencyInstance.getRequiredSeId(systemEnvironment) != null) continue;
                    SDMSDependencyDefinition sDMSDependencyDefinition = SDMSDependencyDefinitionTable.getObject(systemEnvironment, sDMSDependencyInstance.getDdId(systemEnvironment), sDMSSubmittedEntity2.getSeVersion(systemEnvironment));
                    if (sDMSDependencyDefinition.getUnresolvedHandling(systemEnvironment) != 5) {
                        sDMSDependencyInstance.setState(systemEnvironment, 2);
                    }
                    bl2 = true;
                }
                if (!bl2) continue;
                vector2.add(sDMSSubmittedEntity2);
            }
            for (n = 0; n < vector2.size(); ++n) {
                sDMSSubmittedEntity2 = (SDMSSubmittedEntity)vector2.get(n);
                sDMSSubmittedEntity2.testDependencies(systemEnvironment);
            }
        }
    }

    private boolean canFinalize(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.getState(systemEnvironment) != 10 && this.getIsSuspended(systemEnvironment) == 0 && this.getParentSuspended(systemEnvironment) == 0 && this.getChildSuspended(systemEnvironment) <= 0 && this.getJobIsFinal(systemEnvironment) == true && this.getCntSubmitted(systemEnvironment) == 0 && this.getCntDependencyWait(systemEnvironment) == 0 && this.getCntSynchronizeWait(systemEnvironment) == 0 && this.getCntResourceWait(systemEnvironment) == 0 && this.getCntRunnable(systemEnvironment) == 0 && this.getCntStarting(systemEnvironment) == 0 && this.getCntStarted(systemEnvironment) == 0 && this.getCntRunning(systemEnvironment) == 0 && this.getCntToKill(systemEnvironment) == 0 && this.getCntKilled(systemEnvironment) == 0 && this.getCntFinished(systemEnvironment) == 0 && this.getCntBrokenActive(systemEnvironment) == 0 && this.getCntBrokenFinished(systemEnvironment) == 0 && this.getCntError(systemEnvironment) == 0 && this.getCntUnreachable(systemEnvironment) == 0;
    }

    public void checkFinal(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.getState(systemEnvironment) == 10 || this.getState(systemEnvironment) == 12) {
            return;
        }
        boolean bl = this.canFinalize(systemEnvironment);
        if (bl) {
            if (this.getFinalEsdId(systemEnvironment) == null) {
                int n = 0;
                int n2 = 0;
                Long l = null;
                Long l2 = null;
                long l3 = this.getSeVersion(systemEnvironment);
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.getSeId(systemEnvironment), l3);
                Vector vector = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, (Object)sDMSSchedulingEntity.getEspId(systemEnvironment), l3);
                for (SDMSExitState sDMSExitState : vector) {
                    if (sDMSExitState.getIsBatchDefault(systemEnvironment).booleanValue()) {
                        l2 = sDMSExitState.getEsdId(systemEnvironment);
                        break;
                    }
                    if (n2 < sDMSExitState.getPreference(systemEnvironment) && sDMSExitState.getIsFinal(systemEnvironment).booleanValue() && !sDMSExitState.getIsUnreachable(systemEnvironment).booleanValue()) {
                        n2 = sDMSExitState.getPreference(systemEnvironment);
                        l2 = sDMSExitState.getEsdId(systemEnvironment);
                    }
                    if (n >= sDMSExitState.getPreference(systemEnvironment) || !sDMSExitState.getIsFinal(systemEnvironment).booleanValue()) continue;
                    n = sDMSExitState.getPreference(systemEnvironment);
                    l = sDMSExitState.getEsdId(systemEnvironment);
                }
                if (l2 != null) {
                    l = l2;
                }
                this.setFinalEsdId(systemEnvironment, l);
            }
            this.trigger(systemEnvironment, 2);
            bl = this.canFinalize(systemEnvironment);
        }
        if (bl) {
            this.trigger(systemEnvironment, 3);
            this.releaseResources(systemEnvironment, 12);
            this.setState(systemEnvironment, new Integer(12));
            this.fixUpObjectEvents(systemEnvironment);
            this.removeAsyncTrigger(systemEnvironment);
            this.deleteLocalResources(systemEnvironment);
            try {
                SDMSnpJobFootprint sDMSnpJobFootprint = SDMSnpJobFootprintTable.idx_smeId_getUniqueForUpdate(systemEnvironment, this.getId(systemEnvironment));
                sDMSnpJobFootprint.delete(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    private void fixUpObjectEvents(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSObjectEvent sDMSObjectEvent;
        int n;
        Vector vector = SDMSObjectEventTable.idx_smeId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (n = 0; n < vector.size(); ++n) {
            sDMSObjectEvent = (SDMSObjectEvent)vector.elementAt(n);
            sDMSObjectEvent.setFinalEsdId(systemEnvironment, this.getFinalEsdId(systemEnvironment));
            sDMSObjectEvent.setFinalTs(systemEnvironment, this.getFinalTs(systemEnvironment));
        }
        vector = SDMSObjectEventTable.idx_mainSmeId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (n = 0; n < vector.size(); ++n) {
            sDMSObjectEvent = (SDMSObjectEvent)vector.elementAt(n);
            sDMSObjectEvent.setMainFinalEsdId(systemEnvironment, this.getFinalEsdId(systemEnvironment));
            sDMSObjectEvent.setMainFinalTs(systemEnvironment, this.getFinalTs(systemEnvironment));
        }
    }

    private void deleteLocalResources(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getMasterId(systemEnvironment);
        Long l2 = this.getId(systemEnvironment);
        if (l2.equals(l)) {
            Vector vector = SDMSResourceTable.idx_masterId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector.size(); ++i) {
                SDMSResource sDMSResource = (SDMSResource)vector.get(i);
                sDMSResource.delete(systemEnvironment);
            }
        }
    }

    private void suspend(SystemEnvironment systemEnvironment, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SDMSException {
        this.suspend(systemEnvironment, bl, bl2, bl3, bl4, false);
    }

    private void suspend(SystemEnvironment systemEnvironment, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws SDMSException {
        int n = this.getIsSuspended(systemEnvironment);
        Boolean bl6 = this.getIsSuspendedLocal(systemEnvironment);
        if (n == 0 && !bl) {
            return;
        }
        if (n == 1 && bl & !bl3) {
            return;
        }
        if (n == 2 && bl && bl3) {
            return;
        }
        if (bl && bl2 && n != 0 && (bl6 == null || !bl6.booleanValue())) {
            return;
        }
        if (!(bl5 || !bl3 || systemEnvironment.cEnv.isUser() && systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId))) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03503051428", "Insufficient privileges for admin suspend/resume"));
        }
        if (!(n != 2 || bl3 || systemEnvironment.cEnv.isUser() && systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId))) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03408111621", "Insufficient privileges for admin suspend/resume"));
        }
        if (!bl) {
            bl2 = bl6 != null ? bl6 : false;
        } else {
            this.setIsSuspendedLocal(systemEnvironment, new Boolean(bl2));
            this.setResumeTs(systemEnvironment, null);
        }
        int n2 = bl && bl3 ? 2 : (bl ? 1 : 0);
        this.setIsSuspended(systemEnvironment, new Integer(n2));
        if (!bl) {
            this.setIsSuspendedLocal(systemEnvironment, Boolean.FALSE);
        }
        if (!(n == 1 && n2 == 2 || n == 2 && n2 == 1)) {
            if (!bl2) {
                this.addParentSuspendedToChildren(systemEnvironment, bl ? 1 : -1);
            }
            this.fixCntInParents(systemEnvironment, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, bl ? 1 : -1, 0);
            this.updateStatistics(systemEnvironment);
        }
        long l = new Date().getTime();
        int n3 = this.getState(systemEnvironment);
        if (bl) {
            if (n3 == 3 || n3 == 4) {
                this.releaseResources(systemEnvironment, 2);
                this.setState(systemEnvironment, new Integer(1));
            }
            if (bl4) {
                this.setOpSusresTs(systemEnvironment, new Long(-l));
            }
        } else {
            if (bl4) {
                this.setOpSusresTs(systemEnvironment, new Long(l));
            }
            this.checkDeferStall(systemEnvironment);
            if ((n3 == 2 || n3 == 1) && this.getScopeId(systemEnvironment) != null) {
                this.setScopeId(systemEnvironment, null);
            }
        }
        SystemEnvironment.sched.notifyChange(systemEnvironment, this, bl ? 6 : 7);
    }

    private void addParentSuspendedToChildren(SystemEnvironment systemEnvironment, int n) throws SDMSException {
        Vector vector = SDMSHierarchyInstanceTable.idx_parentId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (SDMSHierarchyInstance sDMSHierarchyInstance : vector) {
            int n2;
            SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSHierarchyInstance.getChildId(systemEnvironment));
            Integer n3 = (int)sDMSSubmittedEntity.getParentSuspended(systemEnvironment);
            int n4 = n + n3;
            sDMSSubmittedEntity.setParentSuspended(systemEnvironment, new Integer(n4));
            if (n3 == 0 && n > 0 && ((n2 = sDMSSubmittedEntity.getState(systemEnvironment).intValue()) == 3 || n2 == 4)) {
                sDMSSubmittedEntity.releaseResources(systemEnvironment, 2);
            }
            sDMSSubmittedEntity.addParentSuspendedToChildren(systemEnvironment, n);
            if (n >= 0) continue;
            Long l = sDMSSubmittedEntity.getJobEsdId(systemEnvironment);
            if (l != null) {
                long l2 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l2);
                Long l3 = sDMSSchedulingEntity.getEspId(systemEnvironment);
                SDMSExitState sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(l3, l), l2);
                if (sDMSExitState.getIsFinal(systemEnvironment).booleanValue() && sDMSSubmittedEntity.getIsSuspended(systemEnvironment) == 0 && n4 == 0) {
                    sDMSSubmittedEntity.setJobIsFinal(systemEnvironment, Boolean.TRUE);
                    sDMSSubmittedEntity.checkDependents(systemEnvironment);
                }
            }
            sDMSSubmittedEntity.checkFinal(systemEnvironment);
        }
    }

    protected void checkParameters(SystemEnvironment systemEnvironment) throws SDMSException {
        long l = this.getSeVersion(systemEnvironment);
        Vector vector = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, (Object)this.getSeId(systemEnvironment), l);
        for (SDMSParameterDefinition sDMSParameterDefinition : vector) {
            int n = sDMSParameterDefinition.getType(systemEnvironment);
            if (n != 50) continue;
            try {
                SVR.getVariableValue(systemEnvironment, this, sDMSParameterDefinition.getName(systemEnvironment), false, "DEFAULT", false, null);
            }
            catch (NotFoundException notFoundException) {
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.getSeId(systemEnvironment), l);
                throw new NotFoundException(new SDMSMessage(systemEnvironment, "03606211020", "Couldn't resolve parameter $1 of $2", (Object)sDMSParameterDefinition.getName(systemEnvironment), (Object)sDMSSchedulingEntity.pathString(systemEnvironment)));
            }
        }
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, String string, boolean bl, String string2, boolean bl2, SDMSScope sDMSScope) throws SDMSException {
        return SVR.getVariableValue(systemEnvironment, this, string, bl, string2, bl2, sDMSScope);
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, String string, boolean bl, String string2, boolean bl2) throws SDMSException {
        return SVR.getVariableValue(systemEnvironment, this, string, bl, string2, bl2, null);
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, String string, boolean bl, String string2) throws SDMSException {
        return SVR.getVariableValue(systemEnvironment, this, string, bl, string2, false, null);
    }

    public void setVariableValue(SystemEnvironment systemEnvironment, String string, String string2) throws SDMSException {
        block9: {
            long l = this.getSeVersion(systemEnvironment);
            String string3 = "=" + string2;
            Long l2 = this.getId(systemEnvironment);
            try {
                SDMSParameterDefinition sDMSParameterDefinition = SDMSParameterDefinitionTable.idx_seId_Name_getUnique(systemEnvironment, new SDMSKey(this.getSeId(systemEnvironment), (Comparable)((Object)string)), l);
                int n = sDMSParameterDefinition.getType(systemEnvironment);
                if (n != 50 && n != 40 && n != 91) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03208090253", "Attempt to write the readonly variable $1 ($2)", (Object)string, (Object)sDMSParameterDefinition.getTypeAsString(systemEnvironment)));
                }
                if (n == 91) {
                    systemEnvironment.checkFeatureAvailability("WRITABLE_RESOURCE_PARAMS");
                    SDMSParameterDefinition sDMSParameterDefinition2 = SDMSParameterDefinitionTable.getObject(systemEnvironment, sDMSParameterDefinition.getLinkPdId(systemEnvironment));
                    Long l3 = sDMSParameterDefinition2.getSeId(systemEnvironment);
                    Vector vector = SDMSResourceAllocationTable.idx_smeId_nrId.getVector(systemEnvironment, new SDMSKey(l2, l3));
                    for (int i = 0; i < vector.size(); ++i) {
                        SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)vector.get(i);
                        if (sDMSResourceAllocation.getAllocationType(systemEnvironment) != 4) continue;
                        SDMSResource sDMSResource = SDMSResourceTable.getObject(systemEnvironment, sDMSResourceAllocation.getRId(systemEnvironment));
                        sDMSResource.setVariableValue(systemEnvironment, sDMSParameterDefinition2.getName(systemEnvironment), l2, string2);
                    }
                    break block9;
                }
                try {
                    SDMSEntityVariable sDMSEntityVariable = SDMSEntityVariableTable.idx_smeId_Name_getUnique(systemEnvironment, new SDMSKey(this.getId(systemEnvironment), (Comparable)((Object)string)));
                    sDMSEntityVariable.setEvLink(systemEnvironment, null);
                    sDMSEntityVariable.setValue(systemEnvironment, string3);
                }
                catch (NotFoundException notFoundException) {
                    SDMSEntityVariableTable.table.create(systemEnvironment, this.getId(systemEnvironment), string, string3, sDMSParameterDefinition.getIsLocal(systemEnvironment), null);
                }
            }
            catch (NotFoundException notFoundException) {
                try {
                    SDMSEntityVariable sDMSEntityVariable = SDMSEntityVariableTable.idx_smeId_Name_getUnique(systemEnvironment, new SDMSKey(this.getId(systemEnvironment), (Comparable)((Object)string)));
                    sDMSEntityVariable.setValue(systemEnvironment, string3);
                }
                catch (NotFoundException notFoundException2) {
                    SDMSEntityVariableTable.table.create(systemEnvironment, this.getId(systemEnvironment), string, string3, Boolean.TRUE, null);
                }
            }
        }
    }

    protected void resolveDependencies(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        this.resolveRequired(systemEnvironment);
        this.resolveDependent(systemEnvironment);
        this.checkParameters(systemEnvironment);
        Vector vector = SDMSSubmittedEntityTable.idx_parentId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (SDMSSubmittedEntity sDMSSubmittedEntity : vector) {
            sDMSSubmittedEntity.resolveDependencies(systemEnvironment, bl);
        }
    }

    private void resolveRequired(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        long l2 = this.getSeVersion(systemEnvironment);
        Integer n = null;
        Long l3 = this.getSeId(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3, l2);
        Integer n2 = sDMSSchedulingEntity.getDependencyOperation(systemEnvironment);
        Vector vector = SDMSDependencyDefinitionTable.idx_seDependentId.getVector(systemEnvironment, (Object)l3, l2);
        block8: for (SDMSDependencyDefinition sDMSDependencyDefinition : vector) {
            SDMSProxy sDMSProxy;
            Comparable<Integer> comparable;
            int n3 = sDMSDependencyDefinition.getResolveMode(systemEnvironment);
            String string = sDMSDependencyDefinition.getName(systemEnvironment);
            Long l4 = sDMSDependencyDefinition.getId(systemEnvironment);
            Long l5 = sDMSDependencyDefinition.getSeRequiredId(systemEnvironment);
            SDMSProxy sDMSProxy2 = null;
            Long l6 = l5;
            if (n3 != 1 && (sDMSProxy2 = this.getNearestSubmittedEntity(systemEnvironment, l5, false, false, true)) != null) {
                l6 = null;
            }
            if (sDMSProxy2 == null && n3 != 0) {
                sDMSProxy2 = this.getExternalSubmittedEntity(systemEnvironment, sDMSDependencyDefinition);
            }
            if (sDMSProxy2 == null) {
                int n4 = sDMSDependencyDefinition.getUnresolvedHandling(systemEnvironment);
                if (n3 != 0) {
                    n4 = 4;
                }
                if (n4 == 2 && (comparable = ((SDMSSubmittedEntityProxyGeneric)(sDMSProxy = SDMSSubmittedEntityTable.getObject(systemEnvironment, this.getMasterId(systemEnvironment)))).getUnresolvedHandling(systemEnvironment)) != null) {
                    n4 = (Integer)comparable;
                }
                switch (n4) {
                    case 1: {
                        continue block8;
                    }
                    case 2: {
                        sDMSProxy = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3, l2);
                        comparable = SDMSSchedulingEntityTable.getObject(systemEnvironment, l5, l2);
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02201110833", "Cannot resolve dependency of $1 from $2 for Version $3", ((SDMSSchedulingEntity)sDMSProxy).pathString(systemEnvironment, l2), ((SDMSSchedulingEntity)comparable).pathString(systemEnvironment, l2), new Long(l2)));
                    }
                    case 3: {
                        this.suspend(systemEnvironment, false, false);
                        Date date = new Date();
                        Long l7 = new Long(date.getTime());
                        SDMSAuditTrailTable.table.create(systemEnvironment, SDMSObject.internalUId, l7, new Integer(4), new Integer(17), this.getId(systemEnvironment), this.getId(systemEnvironment), Boolean.FALSE, null, "Suspended because of unresolved dependencies");
                        continue block8;
                    }
                    case 4: 
                    case 5: {
                        n = new Integer(4);
                    }
                }
            } else {
                Long l8;
                l5 = l8 = sDMSProxy2.getId(systemEnvironment);
                n = new Integer(0);
            }
            Integer n5 = new Integer(0);
            try {
                sDMSProxy = SDMSDependencyInstanceTable.table.create(systemEnvironment, l4, l, l, n2, l5, l6, n, n5, new Long(0L), new Long(l2));
                comparable = sDMSProxy.getId(systemEnvironment);
                ((SDMSDependencyInstanceProxyGeneric)sDMSProxy).setDiIdOrig(systemEnvironment, (Long)comparable);
                ((SDMSDependencyInstance)sDMSProxy).check(systemEnvironment, null, false);
                this.createChildDependencyInstances(systemEnvironment, l4, string, l, n2, l5, l6, ((SDMSDependencyInstanceProxyGeneric)sDMSProxy).getState(systemEnvironment), n5, (Long)comparable, new Long(l2));
            }
            catch (DuplicateKeyException duplicateKeyException) {}
        }
    }

    private void resolveDependent(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object;
        Comparable<Long> comparable;
        Object object222;
        Long l = this.getId(systemEnvironment);
        long l2 = this.getSeVersion(systemEnvironment);
        Integer n = null;
        Long l3 = this.getSeId(systemEnvironment);
        Vector<DependencyDefinitionListElement> vector = new Vector<DependencyDefinitionListElement>();
        Vector vector2 = SDMSDependencyDefinitionTable.idx_seRequiredId.getVector(systemEnvironment, (Object)l3, l2);
        for (Object object222 : vector2) {
            vector.add(new DependencyDefinitionListElement(l2, (SDMSDependencyDefinition)object222));
        }
        object222 = SDMSDependencyInstanceTable.idx_requiredSeId.getVector(systemEnvironment, l3);
        Iterator iterator = ((Vector)object222).iterator();
        while (iterator.hasNext()) {
            int n2;
            SDMSDependencyInstance sDMSDependencyInstance = (SDMSDependencyInstance)iterator.next();
            Long object3 = sDMSDependencyInstance.getDependentId(systemEnvironment);
            if (!sDMSDependencyInstance.getDependentIdOrig(systemEnvironment).equals(object3) || (n2 = ((SDMSSubmittedEntityProxyGeneric)(comparable = SDMSSubmittedEntityTable.getObject(systemEnvironment, object3))).getState(systemEnvironment).intValue()) == 12 || n2 == 10) continue;
            Long l4 = ((SDMSSubmittedEntityProxyGeneric)comparable).getSeVersion(systemEnvironment);
            object = SDMSDependencyDefinitionTable.getObject(systemEnvironment, sDMSDependencyInstance.getDdId(systemEnvironment), l4);
            int n3 = ((SDMSDependencyDefinitionProxyGeneric)object).getResolveMode(systemEnvironment);
            if (n3 == 0) continue;
            vector.add(new DependencyDefinitionListElement(l4, (SDMSDependencyDefinition)object));
        }
        for (DependencyDefinitionListElement dependencyDefinitionListElement : vector) {
            comparable = dependencyDefinitionListElement.seVersion;
            SDMSDependencyDefinition sDMSDependencyDefinition = dependencyDefinitionListElement.dd;
            int n4 = sDMSDependencyDefinition.getResolveMode(systemEnvironment);
            object = sDMSDependencyDefinition.getName(systemEnvironment);
            Long l5 = sDMSDependencyDefinition.getId(systemEnvironment);
            Long l6 = sDMSDependencyDefinition.getSeDependentId(systemEnvironment);
            Long l7 = this.getMasterId(systemEnvironment);
            Vector<SDMSSubmittedEntity> vector3 = new Vector<SDMSSubmittedEntity>();
            if (n4 != 1) {
                vector3.addAll(SDMSSubmittedEntityTable.idx_masterId_seId.getVector(systemEnvironment, new SDMSKey(l7, l6)));
            }
            if (n4 != 0) {
                Vector vector4 = SDMSSubmittedEntityTable.idx_seId.getVector(systemEnvironment, l6);
                Iterator iterator2 = vector4.iterator();
                while (iterator2.hasNext()) {
                    SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)iterator2.next();
                    if (sDMSSubmittedEntity.getMasterId(systemEnvironment).equals(l7) || !sDMSSubmittedEntity.getSeVersion(systemEnvironment).equals(comparable)) continue;
                    vector3.add(sDMSSubmittedEntity);
                }
            }
            for (SDMSSubmittedEntity sDMSSubmittedEntity : vector3) {
                Comparable<Long> comparable2;
                int n5 = sDMSSubmittedEntity.getState(systemEnvironment);
                if (n5 != 1 && n5 != 0 && n5 != 16 || sDMSSubmittedEntity.getIsReplaced(systemEnvironment).booleanValue()) continue;
                Long l8 = sDMSSubmittedEntity.getId(systemEnvironment);
                SDMSProxy sDMSProxy = null;
                Long l9 = sDMSSubmittedEntity.getMasterId(systemEnvironment);
                if (n4 != 1) {
                    sDMSProxy = sDMSSubmittedEntity.getNearestSubmittedEntity(systemEnvironment, l3, false, false, true);
                }
                if (sDMSProxy == null && n4 != 0) {
                    sDMSProxy = sDMSSubmittedEntity.getExternalSubmittedEntity(systemEnvironment, sDMSDependencyDefinition);
                }
                if (sDMSProxy == null) {
                    if (!l9.equals(l7)) continue;
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02201111122", "Cannot resolve $1 from $2", (Object)l3, (Object)l8));
                }
                Long l10 = sDMSProxy.getId(systemEnvironment);
                if (!l10.equals(l)) continue;
                try {
                    comparable2 = SDMSDependencyInstanceTable.idx_ddId_dependentId_RequiredId_getUnique(systemEnvironment, new SDMSKey(l5, l8, l3));
                    int n6 = ((SDMSDependencyInstanceProxyGeneric)comparable2).getState(systemEnvironment);
                    if (n6 == 4 && ((SDMSDependencyInstanceProxyGeneric)comparable2).getRequiredSeId(systemEnvironment) == null) {
                        ((SDMSDependencyInstanceProxyGeneric)comparable2).delete(systemEnvironment);
                    }
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
                comparable2 = sDMSSubmittedEntity.getSeId(systemEnvironment);
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, (Long)comparable2, sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                Integer n7 = sDMSSchedulingEntity.getDependencyOperation(systemEnvironment);
                n = new Integer(0);
                try {
                    Serializable serializable;
                    Comparable<Long> comparable3;
                    Comparable comparable42;
                    boolean bl = false;
                    Vector vector5 = SDMSDependencyInstanceTable.idx_dependentId.getVector(systemEnvironment, l8);
                    if (n4 != 0) {
                        object222 = SDMSDependencyInstanceTable.idx_requiredSeId.getVector(systemEnvironment, l3);
                        vector5.addAll(object222);
                    }
                    for (Comparable comparable42 : vector5) {
                        if (!((SDMSDependencyInstanceProxyGeneric)comparable42).getDdId(systemEnvironment).equals(l5)) continue;
                        bl = true;
                        comparable3 = ((SDMSDependencyInstanceProxyGeneric)comparable42).getRequiredId(systemEnvironment);
                        if (((Long)comparable3).equals(l)) continue;
                        serializable = SDMSDependencyInstanceTable.idx_diIdOrig.getVector(systemEnvironment, ((SDMSProxy)comparable42).getId(systemEnvironment));
                        for (SDMSDependencyInstance sDMSDependencyInstance : serializable) {
                            if (sDMSDependencyInstance.getState(systemEnvironment) != 0 && sDMSDependencyInstance.getRequiredSeId(systemEnvironment) == null) continue;
                            sDMSDependencyInstance.setRequiredId(systemEnvironment, l);
                            sDMSDependencyInstance.setState(systemEnvironment, 0);
                        }
                    }
                    if (bl) continue;
                    comparable42 = new Integer(0);
                    comparable3 = SDMSDependencyInstanceTable.table.create(systemEnvironment, l5, l8, l8, n7, l, null, n, (Integer)comparable42, new Long(0L), (Long)comparable);
                    serializable = ((SDMSProxy)comparable3).getId(systemEnvironment);
                    ((SDMSDependencyInstanceProxyGeneric)comparable3).setDiIdOrig(systemEnvironment, (Long)serializable);
                    sDMSSubmittedEntity.createChildDependencyInstances(systemEnvironment, l5, (String)object, l8, n7, l, null, n, (Integer)comparable42, (Long)serializable, (Long)comparable);
                }
                catch (DuplicateKeyException duplicateKeyException) {}
            }
        }
    }

    private void createChildDependencyInstances(SystemEnvironment systemEnvironment, Long l, String string, Long l2, Integer n, Long l3, Long l4, Integer n2, Integer n3, Long l5, Long l6) throws SDMSException {
        Vector vector = SDMSHierarchyInstanceTable.idx_parentId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (SDMSHierarchyInstance sDMSHierarchyInstance : vector) {
            Long l7;
            SDMSSubmittedEntity sDMSSubmittedEntity;
            int n4;
            if (string != null && SDMSIgnoredDependencyTable.idx_shId_ddName.containsKey(systemEnvironment, new SDMSKey(sDMSHierarchyInstance.getShId(systemEnvironment), (Comparable)((Object)string))) || (n4 = (sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l7 = sDMSHierarchyInstance.getChildId(systemEnvironment))).getState(systemEnvironment).intValue()) != 0 && n4 != 1) continue;
            Long l8 = sDMSSubmittedEntity.getId(systemEnvironment);
            try {
                SDMSDependencyInstanceTable.table.create(systemEnvironment, l, l8, l2, n, l3, l4, n2, n3, l5, l6);
                sDMSSubmittedEntity.createChildDependencyInstances(systemEnvironment, l, string, l2, n, l3, l4, n2, n3, l5, l6);
            }
            catch (DuplicateKeyException duplicateKeyException) {}
        }
    }

    SDMSSubmittedEntity getNearestSubmittedEntity(SystemEnvironment systemEnvironment, Long l, boolean bl, boolean bl2) throws SDMSException {
        return this.getNearestSubmittedEntity(systemEnvironment, l, bl, bl2, false);
    }

    SDMSSubmittedEntity getExternalSubmittedEntity(SystemEnvironment systemEnvironment, SDMSDependencyDefinition sDMSDependencyDefinition) throws SDMSException {
        Integer n = sDMSDependencyDefinition.getExpiredBase(systemEnvironment);
        Integer n2 = sDMSDependencyDefinition.getExpiredAmount(systemEnvironment);
        int n3 = 0;
        long l = 0L;
        if (n2 != null && n != null) {
            l = n2.longValue();
            n3 = n;
            switch (n3) {
                case 0: {
                    l *= 60000L;
                    break;
                }
                case 1: {
                    l *= 3600000L;
                    break;
                }
                case 2: {
                    l *= 86400000L;
                    break;
                }
                case 3: {
                    l *= 604800000L;
                    break;
                }
                case 4: {
                    l *= 2592000000L;
                    break;
                }
                case 5: {
                    l *= 31536000000L;
                }
            }
        }
        long l2 = this.getSubmitTs(systemEnvironment);
        String string = sDMSDependencyDefinition.getSelectCondition(systemEnvironment);
        int n4 = sDMSDependencyDefinition.getResolveMode(systemEnvironment);
        long l3 = this.getMasterId(systemEnvironment);
        Vector<Long> vector = new Vector<Long>();
        vector.add(this.getOwnerId(systemEnvironment));
        SDMSSubmittedEntity sDMSSubmittedEntity = null;
        long l4 = 0L;
        Vector vector2 = SDMSSubmittedEntityTable.idx_seId.getVector(systemEnvironment, sDMSDependencyDefinition.getSeRequiredId(systemEnvironment));
        for (SDMSSubmittedEntity sDMSSubmittedEntity2 : vector2) {
            long l5;
            block14: {
                SDMSPrivilege sDMSPrivilege;
                if (n4 == 1 && l3 == sDMSSubmittedEntity2.getMasterId(systemEnvironment)) continue;
                l5 = sDMSSubmittedEntity2.getSubmitTs(systemEnvironment);
                if (sDMSSubmittedEntity2.getState(systemEnvironment) == 10 || l5 <= l4 || !(sDMSPrivilege = sDMSSubmittedEntity2.getPrivilegesForGroups(systemEnvironment, vector)).can(4096L) || n2 != null && n != null && l5 + l < l2) continue;
                if (string != null) {
                    BoolExpr boolExpr = new BoolExpr(string);
                    try {
                        if (!boolExpr.checkCondition(systemEnvironment, null, this, sDMSSubmittedEntity2, null, null, null)) {
                        }
                        break block14;
                    }
                    catch (CommonErrorException commonErrorException) {
                        this.setWarn(systemEnvironment, new Integer(25), "error evaluating select condition", new Long(new Date().getTime()));
                    }
                    continue;
                }
            }
            sDMSSubmittedEntity = sDMSSubmittedEntity2;
            l4 = l5;
        }
        return sDMSSubmittedEntity;
    }

    SDMSSubmittedEntity getNearestSubmittedEntity(SystemEnvironment systemEnvironment, Long l, boolean bl, boolean bl2, boolean bl3) throws SDMSException {
        SDMSSubmittedEntity sDMSSubmittedEntity = null;
        Long l2 = this.getParentId(systemEnvironment);
        Long l3 = this.getId(systemEnvironment);
        while (l2 != null) {
            SDMSSubmittedEntity sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l2);
            if (bl3 && sDMSSubmittedEntity2.getSeId(systemEnvironment).equals(l)) {
                return sDMSSubmittedEntity2;
            }
            sDMSSubmittedEntity = sDMSSubmittedEntity2.getChildSubmittedEntity(systemEnvironment, l, l3, this, bl2);
            if (sDMSSubmittedEntity != null || bl && !sDMSSubmittedEntity2.getIsStatic(systemEnvironment).booleanValue()) break;
            l3 = l2;
            l2 = sDMSSubmittedEntity2.getParentId(systemEnvironment);
        }
        return sDMSSubmittedEntity;
    }

    public SDMSSubmittedEntity getChildSubmittedEntity(SystemEnvironment systemEnvironment, Long l, Long l2, SDMSSubmittedEntity sDMSSubmittedEntity, boolean bl) throws SDMSException {
        long l3 = this.getSeVersion(systemEnvironment);
        SDMSSubmittedEntity sDMSSubmittedEntity2 = null;
        SDMSSubmittedEntity sDMSSubmittedEntity3 = null;
        Long l4 = sDMSSubmittedEntity.getId(systemEnvironment);
        Vector vector = SDMSSubmittedEntityTable.idx_parentId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (SDMSSubmittedEntity sDMSSubmittedEntity4 : vector) {
            Long l5 = sDMSSubmittedEntity4.getId(systemEnvironment);
            if (l2 != null && l5.equals(l2)) continue;
            if (sDMSSubmittedEntity4.getSeId(systemEnvironment).equals(l)) {
                if (sDMSSubmittedEntity4.getIsReplaced(systemEnvironment).booleanValue() || bl && sDMSSubmittedEntity4.getMergeMode(systemEnvironment) == 3) continue;
                sDMSSubmittedEntity3 = sDMSSubmittedEntity4;
            } else {
                sDMSSubmittedEntity3 = sDMSSubmittedEntity4.getChildSubmittedEntity(systemEnvironment, l, null, sDMSSubmittedEntity, bl);
            }
            if (sDMSSubmittedEntity3 == null) continue;
            if (sDMSSubmittedEntity2 == null) {
                sDMSSubmittedEntity2 = sDMSSubmittedEntity3;
                continue;
            }
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l, l3);
            SDMSSchedulingEntity sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.getSeId(systemEnvironment), l3);
            SDMSSchedulingEntity sDMSSchedulingEntity3 = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l3);
            Object[] objectArray = new Object[]{sDMSSchedulingEntity.pathString(systemEnvironment, l3), sDMSSubmittedEntity2.getId(systemEnvironment), sDMSSubmittedEntity3.getId(systemEnvironment), sDMSSchedulingEntity2.pathString(systemEnvironment, l3), this.getId(systemEnvironment), sDMSSchedulingEntity3.pathString(systemEnvironment, l3), l4};
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02201111026", "Ambigous resolution for $1[$2,$3] at $4[$5] from $6[$7]", objectArray));
        }
        return sDMSSubmittedEntity2;
    }

    public void checkDependencies(SystemEnvironment systemEnvironment) throws SDMSException {
        this.testDependencies(systemEnvironment);
        Vector vector = SDMSSubmittedEntityTable.idx_parentId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (SDMSSubmittedEntity sDMSSubmittedEntity : vector) {
            sDMSSubmittedEntity.checkDependencies(systemEnvironment);
        }
    }

    protected void testDependencies(SystemEnvironment systemEnvironment) throws SDMSException {
        boolean bl;
        Collection<Object> collection;
        Object object;
        Object object2;
        SDMSProxy sDMSProxy;
        int n = this.getState(systemEnvironment);
        boolean bl2 = false;
        if (n != 0 && n != 1 && n != 16) {
            return;
        }
        if (n == 1 && this.getOldState(systemEnvironment) != null && !this.getIsDisabled(systemEnvironment).booleanValue()) {
            return;
        }
        long l = this.getSeVersion(systemEnvironment);
        Long l2 = this.getId(systemEnvironment);
        Vector vector = SDMSDependencyInstanceTable.idx_dependentId.getVector(systemEnvironment, l2);
        HashMap<Long, Collection<Object>> hashMap = new HashMap<Long, Collection<Object>>();
        HashMap<Long, Object> hashMap2 = new HashMap<Long, Object>();
        Iterator iterator = vector.iterator();
        HashMap hashMap3 = new HashMap();
        while (iterator.hasNext()) {
            Long l3;
            sDMSProxy = (SDMSDependencyInstance)iterator.next();
            if (((SDMSDependencyInstanceProxyGeneric)sDMSProxy).getIgnore(systemEnvironment) == 1 || ((SDMSDependencyInstanceProxyGeneric)sDMSProxy).getIgnore(systemEnvironment) == 2) continue;
            if (((SDMSDependencyInstanceProxyGeneric)sDMSProxy).getRequiredSeId(systemEnvironment) != null) {
                long l4 = ((SDMSDependencyInstanceProxyGeneric)sDMSProxy).getSeVersion(systemEnvironment);
                object2 = ((SDMSDependencyInstanceProxyGeneric)sDMSProxy).getDdId(systemEnvironment);
                object = SDMSDependencyDefinitionTable.getObject(systemEnvironment, (Long)object2, l4);
                if (((SDMSDependencyDefinitionProxyGeneric)object).getResolveMode(systemEnvironment) != 0) {
                    SDMSSubmittedEntity sDMSSubmittedEntity = this.getExternalSubmittedEntity(systemEnvironment, (SDMSDependencyDefinition)object);
                    if (sDMSSubmittedEntity == null) {
                        ((SDMSDependencyInstanceProxyGeneric)sDMSProxy).setState(systemEnvironment, 4);
                        ((SDMSDependencyInstanceProxyGeneric)sDMSProxy).setRequiredId(systemEnvironment, ((SDMSDependencyInstanceProxyGeneric)sDMSProxy).getRequiredSeId(systemEnvironment));
                    } else if (!sDMSSubmittedEntity.getId(systemEnvironment).equals(l2)) {
                        ((SDMSDependencyInstanceProxyGeneric)sDMSProxy).setState(systemEnvironment, 0);
                        ((SDMSDependencyInstanceProxyGeneric)sDMSProxy).setRequiredId(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
                        ((SDMSDependencyInstance)sDMSProxy).check(systemEnvironment, hashMap3);
                    }
                }
            }
            if (!hashMap2.containsKey(l3 = ((SDMSDependencyInstanceProxyGeneric)sDMSProxy).getDependentIdOrig(systemEnvironment))) {
                object2 = ((SDMSDependencyInstanceProxyGeneric)sDMSProxy).getDependencyOperation(systemEnvironment);
                hashMap2.put(l3, object2);
                collection = new Vector();
                hashMap.put(l3, collection);
            } else {
                collection = (Vector)hashMap.get(l3);
            }
            ((Vector)collection).add(sDMSProxy);
        }
        sDMSProxy = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.getSeId(systemEnvironment), l);
        int n2 = 1;
        collection = hashMap2.keySet();
        object2 = collection.iterator();
        object = null;
        boolean bl3 = false;
        Vector<UnresolvedExternalDependency> vector2 = new Vector<UnresolvedExternalDependency>();
        while (object2.hasNext() && (n2 == 1 || n2 == 2 || n2 == 0)) {
            boolean bl4;
            boolean bl5;
            Long l5 = (Long)object2.next();
            bl = false;
            boolean bl6 = false;
            boolean bl7 = false;
            int n3 = (Integer)hashMap2.get(l5);
            if (n3 == 1) {
                bl5 = true;
                bl4 = false;
            } else {
                bl5 = false;
                bl4 = true;
            }
            Vector vector3 = (Vector)hashMap.get(l5);
            for (SDMSDependencyInstance sDMSDependencyInstance : vector3) {
                int n4 = sDMSDependencyInstance.getState(systemEnvironment);
                SDMSDependencyDefinition sDMSDependencyDefinition = SDMSDependencyDefinitionTable.getObject(systemEnvironment, sDMSDependencyInstance.getDdId(systemEnvironment), l);
                int n5 = sDMSDependencyDefinition.getUnresolvedHandling(systemEnvironment);
                if (n4 == 8) {
                    bl = true;
                }
                if (n4 == 3) {
                    object = "Broken Dependency";
                    bl6 = true;
                }
                if (n3 == 1 && n4 != 1) {
                    if (n4 != 4) {
                        bl5 = false;
                    } else if (n5 != 5) {
                        if (sDMSDependencyInstance.getRequiredSeId(systemEnvironment) != null && n5 != 4) {
                            vector2.add(new UnresolvedExternalDependency(n5, sDMSDependencyInstance));
                        }
                        bl5 = false;
                    }
                    if (n4 == 0) {
                        bl3 = true;
                    }
                    if (n4 == 2 || n4 == 3 || n4 == 8) {
                        if (sDMSDependencyInstance.getRequiredSeId(systemEnvironment) == null) {
                            bl4 = true;
                            break;
                        }
                        bl7 = true;
                    }
                    if (n4 == 4 && n5 == 4) {
                        bl3 = true;
                    }
                }
                if (n3 == 2 && n4 == 1) {
                    bl5 = true;
                    bl4 = false;
                    break;
                }
                if (n3 != 2 || n4 != 0 && n4 != 4) continue;
                bl4 = false;
            }
            if (bl5) continue;
            if (bl4) {
                if (bl6) {
                    n2 = 3;
                    continue;
                }
                if (bl) {
                    n2 = 2;
                    continue;
                }
                n2 = 16;
                continue;
            }
            if (n2 == 2) continue;
            if (bl7 && !bl3) {
                n2 = 16;
                continue;
            }
            n2 = 0;
        }
        if (vector2.size() > 0 && !bl3) {
            for (UnresolvedExternalDependency unresolvedExternalDependency : vector2) {
                if (unresolvedExternalDependency.unresolvedHandling == 2) {
                    object = "Unresolved External Dependency";
                    n2 = 3;
                    continue;
                }
                if (unresolvedExternalDependency.unresolvedHandling == 3) {
                    n2 = 4;
                }
                if (unresolvedExternalDependency.unresolvedHandling != 3 && unresolvedExternalDependency.unresolvedHandling != 1) continue;
                unresolvedExternalDependency.di.delete(systemEnvironment);
                bl2 = true;
            }
        }
        int n6 = ((SDMSSchedulingEntityProxyGeneric)sDMSProxy).getType(systemEnvironment);
        switch (n2) {
            case 0: {
                this.setState(systemEnvironment, new Integer(1));
                break;
            }
            case 4: {
                this.suspend(systemEnvironment, false, false);
                Date date = new Date();
                Long l6 = new Long(date.getTime());
                SDMSAuditTrailTable.table.create(systemEnvironment, SDMSObject.internalUId, l6, new Integer(4), new Integer(17), this.getId(systemEnvironment), this.getId(systemEnvironment), Boolean.FALSE, null, "Suspended because of unresolved external dependencies");
                if (bl3) {
                    this.setState(systemEnvironment, new Integer(1));
                    break;
                }
            }
            case 1: {
                if (this.getState(systemEnvironment) == 0) {
                    this.setState(systemEnvironment, new Integer(1));
                }
                if (this.getState(systemEnvironment) == 15) break;
                switch (n6) {
                    case 1: {
                        boolean bl8 = bl = this.getOldState(systemEnvironment) == null;
                        if (!this.getIsDisabled(systemEnvironment).booleanValue()) {
                            if (!bl) break;
                            this.setState(systemEnvironment, new Integer(2));
                            break;
                        }
                    }
                    case 2: 
                    case 3: {
                        this.setJobIsFinal(systemEnvironment, Boolean.TRUE);
                        this.setState(systemEnvironment, new Integer(11));
                        this.trigger(systemEnvironment, 5);
                        this.trigger(systemEnvironment, 6);
                        this.mergeExitStates(systemEnvironment);
                        this.checkFinal(systemEnvironment);
                    }
                }
                break;
            }
            case 16: {
                Long l7 = ((SDMSSchedulingEntityProxyGeneric)sDMSProxy).getEspId(systemEnvironment);
                SDMSExitStateProfile sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, l7, l);
                Long l8 = sDMSExitStateProfile.getUnreachableState(systemEnvironment, l);
                if (l8 == null) {
                    this.setState(systemEnvironment, new Integer(16));
                    break;
                }
                SDMSExitState sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(l7, l8), l);
                this.changeState(systemEnvironment, l8, sDMSExitState, null, null, null);
                break;
            }
            case 2: {
                this.setState(systemEnvironment, new Integer(16));
                break;
            }
            case 3: {
                this.setToError(systemEnvironment, (String)object);
            }
        }
        if (bl2) {
            this.testDependencies(systemEnvironment);
        }
    }

    protected void submitChilds(SystemEnvironment systemEnvironment, int n, Long l, Long l2, int n2, boolean bl) throws SDMSException {
        long l3 = this.getSeVersion(systemEnvironment);
        Vector vector = SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, (Object)this.getSeId(systemEnvironment), l3);
        for (SDMSSchedulingHierarchy sDMSSchedulingHierarchy : vector) {
            if (!sDMSSchedulingHierarchy.getIsStatic(systemEnvironment).booleanValue()) continue;
            Long l4 = sDMSSchedulingHierarchy.getSeChildId(systemEnvironment);
            Long l5 = null;
            if (l2 != null) {
                Vector vector2 = SDMSSubmittedEntityTable.idx_parentId_seId.getVector(systemEnvironment, new SDMSKey(l2, l4));
                boolean bl2 = false;
                for (SDMSSubmittedEntity sDMSSubmittedEntity : vector2) {
                    if (sDMSSubmittedEntity.getIsReplaced(systemEnvironment).booleanValue()) continue;
                    bl2 = true;
                    l5 = sDMSSubmittedEntity.getId(systemEnvironment);
                    break;
                }
                if (!bl2) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02305141559", "Cannot find child to replace for smeId $1, seId $2", (Object)l2, (Object)l4));
                }
            }
            this.doSubmitChild(systemEnvironment, l4, n, null, l, sDMSSchedulingHierarchy, l3, l5, null, null, null, true, bl, new Integer(n2));
        }
    }

    public TimeZone getEffectiveTimeZone(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = null;
        Long l = this.getMasterId(systemEnvironment);
        if (this.getId(systemEnvironment).equals(l)) {
            string = this.getTimeZone(systemEnvironment);
        } else {
            SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
            string = sDMSSubmittedEntity.getTimeZone(systemEnvironment);
        }
        if (string == null) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(string);
    }

    public String getEffectiveTimeZoneName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.getEffectiveTimeZone(systemEnvironment).getID();
    }

    private boolean evaluateDisable(SystemEnvironment systemEnvironment, SDMSSchedulingHierarchy sDMSSchedulingHierarchy) throws SDMSException {
        boolean bl = sDMSSchedulingHierarchy.getIsDisabled(systemEnvironment);
        long l = this.getSeVersion(systemEnvironment);
        Long l2 = sDMSSchedulingHierarchy.getIntId(systemEnvironment);
        if (!bl && l2 != null) {
            SDMSInterval sDMSInterval = SDMSIntervalTable.getObject(systemEnvironment, l2, l);
            TimeZone timeZone = this.getEffectiveTimeZone(systemEnvironment);
            Long l3 = this.getSubmitTs(systemEnvironment);
            Long l4 = sDMSInterval.filter(systemEnvironment, l3, sDMSInterval.getHorizon(systemEnvironment, timeZone), timeZone, 0);
            if (l4 > this.getSubmitTs(systemEnvironment)) {
                bl = true;
            }
        }
        return bl;
    }

    private void checkMergeFailure(SystemEnvironment systemEnvironment, Long l, Long l2, SDMSSchedulingEntity sDMSSchedulingEntity, SDMSSchedulingHierarchy sDMSSchedulingHierarchy) throws SDMSException {
        SDMSKey sDMSKey = new SDMSKey(l, l2, new Integer(4));
        Vector vector = SDMSSubmittedEntityTable.idx_masterId_seId_mergeMode.getVector(systemEnvironment, sDMSKey);
        if (vector.size() != 0) {
            Long l3 = ((SDMSSubmittedEntity)vector.elementAt(0)).getId(systemEnvironment);
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02201201334", "$1 alread submitted with id $2 and merge mode FAILURE in same Master run", (Object)sDMSSchedulingEntity.pathString(systemEnvironment, this.getSeVersion(systemEnvironment)), (Object)l3));
        }
        int n = sDMSSchedulingHierarchy.getMergeMode(systemEnvironment);
        if (n == 4 && SDMSSubmittedEntityTable.idx_masterId_seId.containsKey(systemEnvironment, sDMSKey = new SDMSKey(l, l2))) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02201101318", "$1 has merge mode FAILURE and cannot be submitted twice in same Master run", (Object)sDMSSchedulingEntity.pathString(systemEnvironment, this.getSeVersion(systemEnvironment))));
        }
    }

    private Boolean determineSuspend(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, SDMSSchedulingHierarchy sDMSSchedulingHierarchy) throws SDMSException {
        int n = sDMSSchedulingHierarchy.getSuspend(systemEnvironment);
        Boolean bl = Boolean.FALSE;
        switch (n) {
            case 1: {
                bl = sDMSSchedulingEntity.getSubmitSuspended(systemEnvironment);
                break;
            }
            case 2: {
                bl = Boolean.FALSE;
                break;
            }
            case 3: {
                bl = Boolean.TRUE;
            }
        }
        return bl;
    }

    private Long determineResumeTs(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, SDMSSchedulingHierarchy sDMSSchedulingHierarchy, Long l, Long l2) throws SDMSException {
        Long l3 = l;
        int n = sDMSSchedulingHierarchy.getSuspend(systemEnvironment);
        Boolean bl = Boolean.FALSE;
        switch (n) {
            case 1: {
                l3 = SubmitJob.evalResumeObj(systemEnvironment, sDMSSchedulingEntity.getResumeAt(systemEnvironment), sDMSSchedulingEntity.getResumeIn(systemEnvironment), sDMSSchedulingEntity.getResumeBase(systemEnvironment), l2, true, this.getEffectiveTimeZone(systemEnvironment));
                break;
            }
            case 2: {
                l3 = null;
                break;
            }
            case 3: {
                l3 = SubmitJob.evalResumeObj(systemEnvironment, sDMSSchedulingHierarchy.getResumeAt(systemEnvironment), sDMSSchedulingHierarchy.getResumeIn(systemEnvironment), sDMSSchedulingHierarchy.getResumeBase(systemEnvironment), l2, true, this.getEffectiveTimeZone(systemEnvironment));
            }
        }
        return l3;
    }

    private void fixMergedCounters(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        int n = sDMSSubmittedEntity.getCntSubmitted(systemEnvironment);
        int n2 = sDMSSubmittedEntity.getCntDependencyWait(systemEnvironment);
        int n3 = sDMSSubmittedEntity.getCntSynchronizeWait(systemEnvironment);
        int n4 = sDMSSubmittedEntity.getCntResourceWait(systemEnvironment);
        int n5 = sDMSSubmittedEntity.getCntRunnable(systemEnvironment);
        int n6 = sDMSSubmittedEntity.getCntStarting(systemEnvironment);
        int n7 = sDMSSubmittedEntity.getCntStarted(systemEnvironment);
        int n8 = sDMSSubmittedEntity.getCntRunning(systemEnvironment);
        int n9 = sDMSSubmittedEntity.getCntToKill(systemEnvironment);
        int n10 = sDMSSubmittedEntity.getCntKilled(systemEnvironment);
        int n11 = sDMSSubmittedEntity.getCntCancelled(systemEnvironment);
        int n12 = sDMSSubmittedEntity.getCntFinished(systemEnvironment);
        int n13 = sDMSSubmittedEntity.getCntFinal(systemEnvironment);
        int n14 = sDMSSubmittedEntity.getCntBrokenActive(systemEnvironment);
        int n15 = sDMSSubmittedEntity.getCntBrokenFinished(systemEnvironment);
        int n16 = sDMSSubmittedEntity.getCntError(systemEnvironment);
        int n17 = sDMSSubmittedEntity.getCntUnreachable(systemEnvironment);
        int n18 = sDMSSubmittedEntity.getCntRestartable(systemEnvironment);
        int n19 = sDMSSubmittedEntity.getCntWarn(systemEnvironment);
        int n20 = sDMSSubmittedEntity.getChildSuspended(systemEnvironment);
        int n21 = sDMSSubmittedEntity.getCntPending(systemEnvironment);
        switch (sDMSSubmittedEntity.getState(systemEnvironment)) {
            case 0: {
                ++n;
                break;
            }
            case 1: {
                ++n2;
                break;
            }
            case 2: {
                ++n3;
                break;
            }
            case 3: {
                ++n4;
                break;
            }
            case 4: {
                ++n5;
                break;
            }
            case 5: {
                ++n6;
                break;
            }
            case 6: {
                ++n7;
                break;
            }
            case 7: {
                ++n8;
                break;
            }
            case 8: {
                ++n9;
                break;
            }
            case 9: {
                ++n10;
                break;
            }
            case 10: {
                ++n11;
                break;
            }
            case 11: {
                ++n12;
                break;
            }
            case 12: {
                ++n13;
                break;
            }
            case 13: {
                ++n14;
                break;
            }
            case 14: {
                ++n15;
                break;
            }
            case 15: {
                ++n16;
                break;
            }
            case 16: {
                ++n17;
            }
        }
        if (sDMSSubmittedEntity.getJobIsRestartable(systemEnvironment).booleanValue()) {
            ++n18;
        }
        if (sDMSSubmittedEntity.getIsSuspended(systemEnvironment) != 0) {
            ++n20;
        }
        if (sDMSSubmittedEntity.isPending(systemEnvironment)) {
            ++n21;
        }
        if (n != 0) {
            this.setCntSubmitted(systemEnvironment, new Integer(this.getCntSubmitted(systemEnvironment) + n));
        }
        if (n2 != 0) {
            this.setCntDependencyWait(systemEnvironment, new Integer(this.getCntDependencyWait(systemEnvironment) + n2));
        }
        if (n3 != 0) {
            this.setCntSynchronizeWait(systemEnvironment, new Integer(this.getCntSynchronizeWait(systemEnvironment) + n3));
        }
        if (n4 != 0) {
            this.setCntResourceWait(systemEnvironment, new Integer(this.getCntResourceWait(systemEnvironment) + n4));
        }
        if (n5 != 0) {
            this.setCntRunnable(systemEnvironment, new Integer(this.getCntRunnable(systemEnvironment) + n5));
        }
        if (n6 != 0) {
            this.setCntStarting(systemEnvironment, new Integer(this.getCntStarting(systemEnvironment) + n6));
        }
        if (n7 != 0) {
            this.setCntStarted(systemEnvironment, new Integer(this.getCntStarted(systemEnvironment) + n7));
        }
        if (n8 != 0) {
            this.setCntRunning(systemEnvironment, new Integer(this.getCntRunning(systemEnvironment) + n8));
        }
        if (n9 != 0) {
            this.setCntToKill(systemEnvironment, new Integer(this.getCntToKill(systemEnvironment) + n9));
        }
        if (n10 != 0) {
            this.setCntKilled(systemEnvironment, new Integer(this.getCntKilled(systemEnvironment) + n10));
        }
        if (n11 != 0) {
            this.setCntCancelled(systemEnvironment, new Integer(this.getCntCancelled(systemEnvironment) + n11));
        }
        if (n12 != 0) {
            this.setCntFinished(systemEnvironment, new Integer(this.getCntFinished(systemEnvironment) + n12));
        }
        if (n13 != 0) {
            this.setCntFinal(systemEnvironment, new Integer(this.getCntFinal(systemEnvironment) + n13));
        }
        if (n14 != 0) {
            this.setCntBrokenActive(systemEnvironment, new Integer(this.getCntBrokenActive(systemEnvironment) + n14));
        }
        if (n15 != 0) {
            this.setCntBrokenFinished(systemEnvironment, new Integer(this.getCntBrokenFinished(systemEnvironment) + n15));
        }
        if (n16 != 0) {
            this.setCntError(systemEnvironment, new Integer(this.getCntError(systemEnvironment) + n16));
        }
        if (n17 != 0) {
            this.setCntUnreachable(systemEnvironment, new Integer(this.getCntUnreachable(systemEnvironment) + n17));
        }
        if (n18 != 0) {
            this.setCntRestartable(systemEnvironment, new Integer(this.getCntRestartable(systemEnvironment) + n18));
        }
        if (n20 != 0) {
            this.setChildSuspended(systemEnvironment, new Integer(this.getChildSuspended(systemEnvironment) + n20));
        }
        if (n21 != 0) {
            this.setCntPending(systemEnvironment, new Integer(this.getCntPending(systemEnvironment) + n21));
        }
        this.fixCntInParents(systemEnvironment, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18, n19, n20, n21);
    }

    private void checkValidESP(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, long l) throws SDMSException {
        Long l2 = sDMSSchedulingEntity.getEspId(systemEnvironment);
        SDMSExitStateProfile sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, l2, l);
        if (!sDMSExitStateProfile.getIsValid(systemEnvironment).booleanValue()) {
            sDMSExitStateProfile.checkProfile(systemEnvironment);
        }
    }

    private SDMSSubmittedEntity doSubmitChild(SystemEnvironment systemEnvironment, Long l, int n, Long l2, Long l3, SDMSSchedulingHierarchy sDMSSchedulingHierarchy, long l4, Long l5, Integer n2, String string, String string2, boolean bl, boolean bl2, Integer n3) throws SDMSException {
        int n4;
        boolean bl3;
        if (!bl2) {
            bl2 = this.evaluateDisable(systemEnvironment, sDMSSchedulingHierarchy);
        }
        Long l6 = this.getId(systemEnvironment);
        Long l7 = this.getMasterId(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l, l4);
        Long l8 = sDMSSchedulingEntity.getId(systemEnvironment);
        SDMSSubmittedEntity sDMSSubmittedEntity = null;
        Long l9 = l2;
        Date date = new Date();
        Long l10 = new Long(date.getTime());
        int n5 = this.getState(systemEnvironment);
        if (n5 == 10 || n5 == 12) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03703141457", "Submitting children of a cancelled or final parent isn't allowed"));
        }
        this.checkMergeFailure(systemEnvironment, l7, l, sDMSSchedulingEntity, sDMSSchedulingHierarchy);
        Boolean bl4 = n2 != null ? Boolean.valueOf(n2 != 0) : this.determineSuspend(systemEnvironment, sDMSSchedulingEntity, sDMSSchedulingHierarchy);
        if (bl4.booleanValue()) {
            l9 = this.determineResumeTs(systemEnvironment, sDMSSchedulingEntity, sDMSSchedulingHierarchy, l2, l10);
        }
        boolean bl5 = false;
        int n6 = sDMSSchedulingHierarchy.getMergeMode(systemEnvironment);
        if (n6 == 2 || n6 == 1) {
            bl3 = false;
            if (n6 == 1) {
                bl3 = true;
            }
            if ((sDMSSubmittedEntity = this.getNearestSubmittedEntity(systemEnvironment, l, bl3, true)) != null) {
                int n7 = sDMSSubmittedEntity.getState(systemEnvironment);
                if (bl4.booleanValue() && sDMSSubmittedEntity.getIsSuspended(systemEnvironment) != 0 && n7 != 12 && n7 != 10) {
                    sDMSSubmittedEntity.suspend(systemEnvironment, false, false);
                }
                bl5 = true;
                if (n > 0) {
                    n4 = sDMSSubmittedEntity.getParentSuspended(systemEnvironment) + n;
                    sDMSSubmittedEntity.setParentSuspended(systemEnvironment, new Integer(n4));
                    sDMSSubmittedEntity.addParentSuspendedToChildren(systemEnvironment, n);
                }
            }
        }
        boolean bl6 = bl3 = !bl5;
        if (bl3) {
            this.checkValidESP(systemEnvironment, sDMSSchedulingEntity, l4);
            sDMSSubmittedEntity = this.createSme(systemEnvironment, sDMSSchedulingEntity, sDMSSchedulingHierarchy, string, l3, bl, bl2, bl4.booleanValue() ? (n2 == null ? new Integer(1) : n2) : new Integer(0), n, l9, l5, string2, l10, null);
        }
        SDMSHierarchyInstance sDMSHierarchyInstance = SDMSHierarchyInstanceTable.table.create(systemEnvironment, l6, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSchedulingHierarchy.getId(systemEnvironment), sDMSSchedulingHierarchy.getPriority(systemEnvironment), null, null, new Long(l4));
        if (bl3) {
            Long l11;
            n4 = 0;
            SDMSSubmittedEntity sDMSSubmittedEntity2 = sDMSSubmittedEntity;
            while (sDMSSubmittedEntity2 != null && sDMSSubmittedEntity2.getIsStatic(systemEnvironment).booleanValue()) {
                l11 = sDMSSubmittedEntity2.getParentId(systemEnvironment);
                if (l11 != null) {
                    sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l11);
                    continue;
                }
                sDMSSubmittedEntity2 = null;
            }
            if (sDMSSubmittedEntity2 != null) {
                l11 = sDMSSubmittedEntity2.getParentId(systemEnvironment);
                sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l11);
                Vector vector = SDMSSchedulingHierarchyTable.idx_seChildId.getVector(systemEnvironment, (Object)l8, l4);
                for (SDMSSchedulingHierarchy sDMSSchedulingHierarchy2 : vector) {
                    Long l12;
                    int n8;
                    SDMSSubmittedEntity sDMSSubmittedEntity3;
                    Long l13;
                    SDMSSchedulingEntity sDMSSchedulingEntity2;
                    if (sDMSSchedulingHierarchy2.getIsStatic(systemEnvironment).booleanValue() || (sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, l13 = sDMSSchedulingHierarchy2.getSeParentId(systemEnvironment), l4)).getType(systemEnvironment) != 3 || (sDMSSubmittedEntity3 = sDMSSubmittedEntity2.getNearestSubmittedEntity(systemEnvironment, l13, false, false)) == null || (n8 = sDMSSubmittedEntity3.getState(systemEnvironment).intValue()) == 12 || n8 == 10 || (l12 = sDMSSubmittedEntity3.getId(systemEnvironment)).equals(l6)) continue;
                    SDMSHierarchyInstanceTable.table.create(systemEnvironment, l12, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSchedulingHierarchy2.getId(systemEnvironment), sDMSSchedulingHierarchy2.getPriority(systemEnvironment), null, null, new Long(l4));
                    int n9 = sDMSSubmittedEntity3.getParentSuspended(systemEnvironment) + (sDMSSubmittedEntity3.getIsSuspended(systemEnvironment) != 0 ? 1 : 0);
                    n4 += n9;
                    n3 = sDMSSubmittedEntity.getParentNiceX100(systemEnvironment);
                }
            }
            sDMSSubmittedEntity.setRawPriority(systemEnvironment, new Integer(n3 + sDMSSubmittedEntity.getRawPriority(systemEnvironment)));
            sDMSSubmittedEntity.submitChilds(systemEnvironment, n + (bl4 != false ? 1 : 0) + n4, l3, l5, n3 + sDMSSubmittedEntity.getNice(systemEnvironment) * 100, bl2);
            sDMSSubmittedEntity.fixCntInParents(systemEnvironment, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, bl4 != false ? 1 : 0, 0);
        } else {
            this.fixMergedCounters(systemEnvironment, sDMSSubmittedEntity);
            n3 = sDMSSubmittedEntity.getParentNiceX100(systemEnvironment);
            n4 = n3 + sDMSSubmittedEntity.getNice(systemEnvironment) * 100 + sDMSSubmittedEntity.getRawPriority(systemEnvironment);
            int n10 = n4 - sDMSSubmittedEntity.getRawPriority(systemEnvironment);
            if (n10 != 0) {
                sDMSSubmittedEntity.setRawPriority(systemEnvironment, new Integer(n4));
                sDMSSubmittedEntity.fixChildPrioritiesAndNpNice(systemEnvironment, n10, null);
            }
        }
        return sDMSSubmittedEntity;
    }

    protected void inheritDependencies(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, long l, SDMSHierarchyInstance sDMSHierarchyInstance) throws SDMSException {
        int n = sDMSSubmittedEntity.getState(systemEnvironment);
        if (n != 0 && n != 1) {
            return;
        }
        Long l2 = sDMSHierarchyInstance.getParentId(systemEnvironment);
        Vector vector = SDMSDependencyInstanceTable.idx_dependentId.getVector(systemEnvironment, l2);
        for (SDMSDependencyInstance sDMSDependencyInstance : vector) {
            Long l3 = sDMSDependencyInstance.getDdId(systemEnvironment);
            SDMSDependencyDefinition sDMSDependencyDefinition = SDMSDependencyDefinitionTable.getObject(systemEnvironment, l3, l);
            String string = sDMSDependencyDefinition.getName(systemEnvironment);
            if (string != null && SDMSIgnoredDependencyTable.idx_shId_ddName.containsKey(systemEnvironment, new SDMSKey(sDMSHierarchyInstance.getShId(systemEnvironment), (Comparable)((Object)string)))) continue;
            try {
                Integer n2 = sDMSDependencyInstance.getIgnore(systemEnvironment) == 2 ? new Integer(2) : new Integer(0);
                Long l4 = sDMSDependencyInstance.getDependentIdOrig(systemEnvironment);
                Integer n3 = sDMSDependencyInstance.getDependencyOperation(systemEnvironment);
                Long l5 = sDMSDependencyInstance.getRequiredId(systemEnvironment);
                Long l6 = sDMSDependencyInstance.getRequiredSeId(systemEnvironment);
                Integer n4 = sDMSDependencyInstance.getState(systemEnvironment);
                Long l7 = sDMSDependencyInstance.getDiIdOrig(systemEnvironment);
                SDMSDependencyInstanceTable.table.create(systemEnvironment, l3, sDMSSubmittedEntity.getId(systemEnvironment), l4, n3, l5, l6, n4, n2, l7, new Long(l));
                sDMSSubmittedEntity.createChildDependencyInstances(systemEnvironment, l3, string, l4, n3, l5, l6, n4, n2, l7, new Long(l));
            }
            catch (DuplicateKeyException duplicateKeyException) {}
        }
    }

    public void finishJob(SystemEnvironment systemEnvironment, Integer n, String string, Long l) throws SDMSException {
        SDMSExitState sDMSExitState;
        SDMSProxy sDMSProxy;
        long l2 = this.getSeVersion(systemEnvironment);
        Long l3 = this.getSeId(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3, l2);
        Long l4 = sDMSSchedulingEntity.getEspId(systemEnvironment);
        Long l5 = sDMSSchedulingEntity.getEsmpId(systemEnvironment);
        if (l5 == null) {
            sDMSProxy = SDMSExitStateProfileTable.getObject(systemEnvironment, l4, l2);
            l5 = ((SDMSExitStateProfileProxyGeneric)sDMSProxy).getDefaultEsmpId(systemEnvironment);
        }
        sDMSProxy = SDMSExitStateMappingProfileTable.getObject(systemEnvironment, l5, l2);
        Long l6 = ((SDMSExitStateMappingProfile)sDMSProxy).map(systemEnvironment, n, l2);
        try {
            sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(l4, l6), l2);
        }
        catch (NotFoundException notFoundException) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "02201111630", "Invalid Exit State Mapping Profile $1 maps to exit state definition $2 not in exit state profile $3", l5, l6, l4));
        }
        this.changeState(systemEnvironment, l6, sDMSExitState, n, string, l);
    }

    private void finishChildTriggers(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        HashSet hashSet = new HashSet();
        Stack stack = new Stack();
        this.do_finishChildTriggers(systemEnvironment, hashSet, l, stack, true);
    }

    private void do_finishChildTriggers(SystemEnvironment systemEnvironment, HashSet hashSet, Long l, Stack stack, boolean bl) throws SDMSException {
        Vector vector2;
        Long l2 = this.getId(systemEnvironment);
        long l3 = this.getSeVersion(systemEnvironment);
        SDMSKey sDMSKey = new SDMSKey(l2, l);
        if (bl) {
            if (!hashSet.add(sDMSKey)) {
                return;
            }
            stack.push(sDMSKey);
        }
        for (Vector vector2 : stack) {
            this.trigger(systemEnvironment, 4, (Long)vector2.get(1), (Long)vector2.get(0), false);
        }
        vector2 = SDMSHierarchyInstanceTable.idx_childId.getVector(systemEnvironment, l2);
        for (SDMSHierarchyInstance sDMSHierarchyInstance : vector2) {
            SDMSProxy sDMSProxy;
            SDMSSchedulingHierarchy sDMSSchedulingHierarchy = SDMSSchedulingHierarchyTable.getObject(systemEnvironment, sDMSHierarchyInstance.getShId(systemEnvironment), l3);
            Long l4 = l;
            boolean bl2 = false;
            if (sDMSSchedulingHierarchy.getEstpId(systemEnvironment) != null) {
                sDMSProxy = SDMSExitStateTranslationProfileTable.getObject(systemEnvironment, sDMSSchedulingHierarchy.getEstpId(systemEnvironment), l3);
                l4 = ((SDMSExitStateTranslationProfile)sDMSProxy).translate(systemEnvironment, l, l3, false);
                if (l4 != null) {
                    bl2 = true;
                } else {
                    l4 = l;
                }
            }
            sDMSProxy = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSHierarchyInstance.getParentId(systemEnvironment));
            super.do_finishChildTriggers(systemEnvironment, hashSet, l4, stack, bl2);
        }
        if (bl) {
            stack.pop();
        }
    }

    public void changeState(SystemEnvironment systemEnvironment, Long l, SDMSExitState sDMSExitState, Integer n, String string, Long l2) throws SDMSException {
        this.changeState(systemEnvironment, l, sDMSExitState, n, string, l2, true);
    }

    public void changeState(SystemEnvironment systemEnvironment, Long l, SDMSExitState sDMSExitState, Integer n, String string, Long l2, boolean bl) throws SDMSException {
        Long l3 = (Long)systemEnvironment.tx.txData.get("BASE_SME_ID");
        if (l3 == null) {
            l3 = this.getId(systemEnvironment);
            systemEnvironment.tx.txData.put("BASE_SME_ID", l3);
        }
        this.setJobEsdId(systemEnvironment, l);
        Integer n2 = sDMSExitState.getPreference(systemEnvironment);
        this.setJobEsdPref(systemEnvironment, n2);
        if (sDMSExitState.getIsFinal(systemEnvironment).booleanValue() && this.getIsSuspended(systemEnvironment) == 0 && this.getParentSuspended(systemEnvironment) == 0) {
            this.setJobIsFinal(systemEnvironment, Boolean.TRUE);
        }
        if (sDMSExitState.getIsRestartable(systemEnvironment).booleanValue()) {
            this.setJobIsRestartable(systemEnvironment, Boolean.TRUE);
            Date date = new Date();
            Long l4 = new Long(date.getTime());
            SDMSAuditTrailTable.table.create(systemEnvironment, SDMSObject.internalUId, l4, new Integer(18), new Integer(17), this.getId(systemEnvironment), this.getId(systemEnvironment), Boolean.FALSE, string, "Job reached restartable state");
        } else {
            this.setJobIsRestartable(systemEnvironment, Boolean.FALSE);
        }
        this.setState(systemEnvironment, new Integer(11));
        if (l2 != null) {
            this.setFinishTs(systemEnvironment, l2);
        }
        this.setExitCode(systemEnvironment, n);
        this.setErrorMsg(systemEnvironment, string);
        if (l3.equals(this.getId(systemEnvironment))) {
            this.finishChildTriggers(systemEnvironment, l);
        }
        this.trigger(systemEnvironment, 0, false);
        this.trigger(systemEnvironment, 5);
        this.trigger(systemEnvironment, 6);
        this.mergeExitStates(systemEnvironment);
        this.checkFinal(systemEnvironment);
        if (this.getState(systemEnvironment) != 12) {
            this.releaseResources(systemEnvironment, this.getState(systemEnvironment));
        }
        if (this.getJobIsRestartable(systemEnvironment).booleanValue() && this.getState(systemEnvironment) != 15 && this.getState(systemEnvironment) != 14 && bl && this.getIsSuspended(systemEnvironment) == 0) {
            this.trigger(systemEnvironment, 0, true);
        }
        SystemEnvironment.sched.notifyChange(systemEnvironment, this, 10);
    }

    private void mergeExitStates(SystemEnvironment systemEnvironment) throws SDMSException {
        this.mergeExitStates(systemEnvironment, true, null);
    }

    private void mergeExitStates(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        this.mergeExitStates(systemEnvironment, bl, null);
    }

    private void mergeExitStates(SystemEnvironment systemEnvironment, boolean bl, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        Long l;
        if (this.getState(systemEnvironment) == 10) {
            return;
        }
        Long l2 = this.getId(systemEnvironment);
        Vector vector = SDMSHierarchyInstanceTable.idx_parentId.getVectorForUpdate(systemEnvironment, l2);
        Long l3 = l = this.getJobEsdId(systemEnvironment);
        Long l4 = this.getFinalEsdId(systemEnvironment);
        Integer n = this.getJobEsdPref(systemEnvironment);
        int n2 = n == null ? -1 : n;
        for (SDMSHierarchyInstance sDMSHierarchyInstance : vector) {
            int n3;
            SDMSSubmittedEntity sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObjectForUpdate(systemEnvironment, sDMSHierarchyInstance.getChildId(systemEnvironment));
            if (sDMSSubmittedEntity != null && sDMSSubmittedEntity.getId(systemEnvironment).equals(sDMSSubmittedEntity2.getId(systemEnvironment)) || sDMSSubmittedEntity2.getState(systemEnvironment) == 10 || sDMSHierarchyInstance.getChildEsdId(systemEnvironment) == null || (n3 = sDMSHierarchyInstance.getChildEsPreference(systemEnvironment).intValue()) >= n2 && n2 != -1) continue;
            n2 = n3;
            l3 = sDMSHierarchyInstance.getChildEsdId(systemEnvironment);
        }
        if (l3 == null && l4 == null) {
            return;
        }
        if (l3 != null && l4 == null || l3 == null && l4 != null || !l3.equals(l4)) {
            this.setFinalEsdId(systemEnvironment, l3, bl);
        }
    }

    private void translateToParent(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        long l = this.getSeVersion(systemEnvironment);
        Long l2 = this.getId(systemEnvironment);
        Long l3 = this.getFinalEsdId(systemEnvironment);
        Vector vector = SDMSHierarchyInstanceTable.idx_childId.getVectorForUpdate(systemEnvironment, l2);
        for (SDMSHierarchyInstance sDMSHierarchyInstance : vector) {
            Comparable<Long> comparable;
            Long l4 = sDMSHierarchyInstance.getShId(systemEnvironment);
            SDMSSchedulingHierarchy sDMSSchedulingHierarchy = SDMSSchedulingHierarchyTable.getObject(systemEnvironment, l4, l);
            Long l5 = sDMSSchedulingHierarchy.getEstpId(systemEnvironment);
            Long l6 = l3;
            boolean bl2 = false;
            if (l5 != null && l3 != null) {
                comparable = SDMSExitStateTranslationProfileTable.getObject(systemEnvironment, l5, l);
                l6 = ((SDMSExitStateTranslationProfile)comparable).translate(systemEnvironment, l3, l, false);
                if (l6 == null) {
                    l6 = l3;
                } else {
                    bl2 = true;
                }
            } else {
                l6 = l3;
            }
            comparable = sDMSHierarchyInstance.getChildEsdId(systemEnvironment);
            if (comparable == null && l6 == null || comparable != null && ((Long)comparable).equals(l6)) {
                return;
            }
            SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObjectForUpdate(systemEnvironment, sDMSHierarchyInstance.getParentId(systemEnvironment));
            if (l6 != null) {
                Integer n;
                Long l7 = sDMSSubmittedEntity.getSeId(systemEnvironment);
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l7, l);
                Long l8 = sDMSSchedulingEntity.getEspId(systemEnvironment);
                try {
                    SDMSExitState sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(l8, l6), l);
                    n = sDMSExitState.getPreference(systemEnvironment);
                }
                catch (NotFoundException notFoundException) {
                    if (bl2) {
                        throw new FatalException(new SDMSMessage(systemEnvironment, "02201112130", "Invalid Exit State Translation Profile $1 translates to exit state definition $2 not in exit state profile $3", l5, l6, l8));
                    }
                    l6 = null;
                    n = null;
                }
                sDMSHierarchyInstance.setChildEsdId(systemEnvironment, l6);
                sDMSHierarchyInstance.setChildEsPreference(systemEnvironment, n);
            } else {
                sDMSHierarchyInstance.setChildEsPreference(systemEnvironment, null);
                sDMSHierarchyInstance.setChildEsdId(systemEnvironment, null);
            }
            sDMSSubmittedEntity.mergeExitStates(systemEnvironment, bl);
        }
    }

    private boolean checkParentCancelled(SystemEnvironment systemEnvironment, Long l, HashSet hashSet) throws SDMSException {
        if (hashSet == null) {
            return false;
        }
        Vector vector = SDMSHierarchyInstanceTable.idx_childId.getVector(systemEnvironment, l);
        for (SDMSHierarchyInstance sDMSHierarchyInstance : vector) {
            Long l2 = sDMSHierarchyInstance.getParentId(systemEnvironment);
            if (hashSet.contains(l2)) {
                return true;
            }
            if (!this.checkParentCancelled(systemEnvironment, l2, hashSet)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        HashSet hashSet;
        Long l;
        Comparable comparable;
        HashMap<Long, Long> hashMap;
        long l2 = this.getSeVersion(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.getSeId(systemEnvironment), l2);
        Long l3 = this.getId(systemEnvironment);
        int n2 = this.getState(systemEnvironment);
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        Date date = new Date();
        Long l4 = new Long(date.getTime());
        if (n3 == 5 && n2 != 5) {
            hashMap = SystemEnvironment.jidsStarting;
            synchronized (hashMap) {
                SystemEnvironment.jidsStarting.put(this.getId(systemEnvironment), l4);
            }
        }
        if (n2 == 5 && n3 != 5) {
            hashMap = SystemEnvironment.jidsStarting;
            synchronized (hashMap) {
                SystemEnvironment.jidsStarting.remove(this.getId(systemEnvironment));
            }
        }
        if (n2 == n3) {
            return;
        }
        switch (n2) {
            case 0: {
                --n4;
                break;
            }
            case 1: {
                --n5;
                break;
            }
            case 2: {
                --n6;
                break;
            }
            case 3: {
                --n7;
                break;
            }
            case 4: {
                --n8;
                break;
            }
            case 5: {
                --n9;
                break;
            }
            case 6: {
                --n10;
                break;
            }
            case 7: {
                --n11;
                break;
            }
            case 8: {
                --n12;
                break;
            }
            case 9: {
                --n13;
                break;
            }
            case 10: {
                --n14;
                break;
            }
            case 11: {
                --n15;
                break;
            }
            case 12: {
                --n16;
                break;
            }
            case 13: {
                --n17;
                break;
            }
            case 14: {
                --n18;
                break;
            }
            case 15: {
                --n19;
                break;
            }
            case 16: {
                --n20;
            }
        }
        switch (n3) {
            case 0: {
                ++n4;
                break;
            }
            case 1: {
                ++n5;
                break;
            }
            case 2: {
                ++n6;
                break;
            }
            case 3: {
                ++n7;
                break;
            }
            case 4: {
                ++n8;
                break;
            }
            case 5: {
                ++n9;
                break;
            }
            case 6: {
                ++n10;
                break;
            }
            case 7: {
                ++n11;
                break;
            }
            case 8: {
                ++n12;
                break;
            }
            case 9: {
                ++n13;
                break;
            }
            case 10: {
                ++n14;
                break;
            }
            case 11: {
                ++n15;
                break;
            }
            case 12: {
                ++n16;
                break;
            }
            case 13: {
                ++n17;
                break;
            }
            case 14: {
                ++n18;
                break;
            }
            case 15: {
                ++n19;
                break;
            }
            case 16: {
                ++n20;
            }
        }
        super.setState(systemEnvironment, n);
        this.fixCntInParents(systemEnvironment, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18, n19, n20, 0, 0, 0, 0);
        if (this.getIsCancelled(systemEnvironment).booleanValue() && n3 != 10) {
            this.doDeferredCancel(systemEnvironment);
            return;
        }
        if (n3 == 3) {
            this.setResourceTs(systemEnvironment, l4);
        }
        if (n3 == 4) {
            this.setRunnableTs(systemEnvironment, l4);
        }
        if (n3 == 5 || n3 == 6) {
            this.setStartTs(systemEnvironment, l4);
        }
        if (n3 == 10) {
            this.setFinalTs(systemEnvironment, l4);
            int n21 = sDMSSchedulingEntity.getType(systemEnvironment);
            if (n21 != 2 && this.getFinishTs(systemEnvironment) == null) {
                this.setFinishTs(systemEnvironment, l4);
            }
            this.setJobIsRestartable(systemEnvironment, Boolean.FALSE);
        }
        if (n3 == 15 || n3 == 14 || n3 == 11) {
            this.setFinishTs(systemEnvironment, l4);
        }
        if (n3 != 11 && n3 != 10) {
            if (n3 != 12) {
                this.setJobEsdId(systemEnvironment, null);
                this.setJobEsdPref(systemEnvironment, null);
            }
            if (this.getJobIsRestartable(systemEnvironment).booleanValue()) {
                this.setJobIsRestartable(systemEnvironment, Boolean.FALSE);
            }
        }
        if (n3 == 15 || n3 == 14) {
            Long l5 = sDMSSchedulingEntity.getEspId(systemEnvironment);
            comparable = SDMSExitStateProfileTable.getObject(systemEnvironment, l5);
            l = comparable.getBrokenState(systemEnvironment, l2);
            if (l != null) {
                SDMSExitState sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(l5, l));
                this.changeState(systemEnvironment, l, sDMSExitState, null, null, null, true);
                int n22 = this.getState(systemEnvironment);
                if (n22 == 11) {
                    super.setState(systemEnvironment, n);
                    this.fixCntInParents(systemEnvironment, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, n3 == 14 ? 1 : 0, n3 == 15 ? 1 : 0, 0, 0, 0, 0, 0);
                }
            } else {
                this.setJobIsRestartable(systemEnvironment, Boolean.TRUE);
            }
        }
        if (n3 == 12) {
            this.setFinalTs(systemEnvironment, l4);
            this.setJobIsRestartable(systemEnvironment, Boolean.FALSE);
        }
        if (n3 == 16 && !this.checkParentCancelled(systemEnvironment, l3, hashSet = (HashSet)systemEnvironment.tx.txData.get("CANCEL_HASH_SET"))) {
            comparable = new Date();
            l = new Long(date.getTime());
            SDMSAuditTrailTable.table.create(systemEnvironment, SDMSObject.internalUId, l, new Integer(28), new Integer(17), l3, l3, Boolean.FALSE, null, null);
        }
        if (n3 == 1) {
            if (sDMSSchedulingEntity.getType(systemEnvironment) == 1 && !this.getIsDisabled(systemEnvironment).booleanValue()) {
                this.setOldState(systemEnvironment, new Integer(n2));
                SystemEnvironment.sched.addToRequestList(systemEnvironment, l3);
            } else {
                this.checkDependencies(systemEnvironment);
            }
            SystemEnvironment.sched.notifyChange(systemEnvironment, this, 10);
        }
        if (n3 == 2) {
            this.setOldState(systemEnvironment, new Integer(n2));
            SystemEnvironment.sched.addToRequestList(systemEnvironment, l3);
            this.setSyncTs(systemEnvironment, l4);
            SystemEnvironment.sched.notifyChange(systemEnvironment, this, 10);
        }
        if (n3 == 12 || n3 == 10 || n3 == 11 && this.getJobIsFinal(systemEnvironment).booleanValue() || n3 == 16 || (n3 == 1 || n3 == 2 || n3 == 11 || n3 == 12) && (n2 == 16 || n2 == 15)) {
            this.checkDependents(systemEnvironment);
        }
        if (this.getFinalTs(systemEnvironment) != null && this.getFinishTs(systemEnvironment) == null) {
            this.setFinishTs(systemEnvironment, l4);
        }
        if (this.getFinishTs(systemEnvironment) != null && this.getStartTs(systemEnvironment) == null) {
            this.setStartTs(systemEnvironment, l4);
        }
        if (this.getStartTs(systemEnvironment) != null && this.getRunnableTs(systemEnvironment) == null) {
            this.setRunnableTs(systemEnvironment, l4);
        }
        if (this.getRunnableTs(systemEnvironment) != null && this.getResourceTs(systemEnvironment) == null) {
            this.setResourceTs(systemEnvironment, l4);
        }
        if (this.getResourceTs(systemEnvironment) != null && this.getSyncTs(systemEnvironment) == null) {
            this.setSyncTs(systemEnvironment, l4);
        }
        if (n3 == 12 || n3 == 10 || n3 == 11 || n3 == 15 || n3 == 14) {
            SystemEnvironment.sched.notifyChange(systemEnvironment, this, 10);
            this.checkDeferStall(systemEnvironment);
        }
        this.updateStatistics(systemEnvironment);
    }

    private void checkDependents(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSDependencyInstanceTable.idx_requiredId.getVectorForUpdate(systemEnvironment, l);
        HashMap hashMap = new HashMap();
        for (SDMSDependencyInstance sDMSDependencyInstance : vector) {
            int n = sDMSDependencyInstance.getState(systemEnvironment);
            int n2 = sDMSDependencyInstance.check(systemEnvironment, hashMap);
            if (n2 == 0 && (n != 2 || n2 == 2)) continue;
            Long l2 = sDMSDependencyInstance.getDependentId(systemEnvironment);
            SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l2);
            sDMSSubmittedEntity.testDependencies(systemEnvironment);
        }
    }

    private void fixCntInParents(SystemEnvironment systemEnvironment, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19, int n20, int n21) throws SDMSException {
        Comparable comparable2;
        Vector vector = SDMSHierarchyInstanceTable.idx_childId.getVectorForUpdate(systemEnvironment, this.getId(systemEnvironment));
        for (Comparable comparable2 : vector) {
            Long l = ((SDMSHierarchyInstanceProxyGeneric)comparable2).getParentId(systemEnvironment);
            SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObjectForUpdate(systemEnvironment, l);
            if (n != 0) {
                sDMSSubmittedEntity.setCntSubmitted(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntSubmitted(systemEnvironment) + n));
            }
            if (n2 != 0) {
                sDMSSubmittedEntity.setCntDependencyWait(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntDependencyWait(systemEnvironment) + n2));
            }
            if (n3 != 0) {
                sDMSSubmittedEntity.setCntSynchronizeWait(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntSynchronizeWait(systemEnvironment) + n3));
            }
            if (n4 != 0) {
                sDMSSubmittedEntity.setCntResourceWait(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntResourceWait(systemEnvironment) + n4));
            }
            if (n5 != 0) {
                sDMSSubmittedEntity.setCntRunnable(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntRunnable(systemEnvironment) + n5));
            }
            if (n6 != 0) {
                sDMSSubmittedEntity.setCntStarting(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntStarting(systemEnvironment) + n6));
            }
            if (n7 != 0) {
                sDMSSubmittedEntity.setCntStarted(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntStarted(systemEnvironment) + n7));
            }
            if (n8 != 0) {
                sDMSSubmittedEntity.setCntRunning(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntRunning(systemEnvironment) + n8));
            }
            if (n9 != 0) {
                sDMSSubmittedEntity.setCntToKill(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntToKill(systemEnvironment) + n9));
            }
            if (n10 != 0) {
                sDMSSubmittedEntity.setCntKilled(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntKilled(systemEnvironment) + n10));
            }
            if (n11 != 0) {
                sDMSSubmittedEntity.setCntCancelled(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntCancelled(systemEnvironment) + n11));
            }
            if (n12 != 0) {
                sDMSSubmittedEntity.setCntFinished(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntFinished(systemEnvironment) + n12));
            }
            if (n13 != 0) {
                sDMSSubmittedEntity.setCntFinal(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntFinal(systemEnvironment) + n13));
            }
            if (n14 != 0) {
                sDMSSubmittedEntity.setCntBrokenActive(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntBrokenActive(systemEnvironment) + n14));
            }
            if (n15 != 0) {
                sDMSSubmittedEntity.setCntBrokenFinished(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntBrokenFinished(systemEnvironment) + n15));
            }
            if (n16 != 0) {
                sDMSSubmittedEntity.setCntError(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntError(systemEnvironment) + n16));
            }
            if (n17 != 0) {
                sDMSSubmittedEntity.setCntUnreachable(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntUnreachable(systemEnvironment) + n17));
            }
            if (n18 != 0) {
                sDMSSubmittedEntity.setCntRestartable(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntRestartable(systemEnvironment) + n18));
            }
            if (n19 != 0) {
                sDMSSubmittedEntity.setCntWarn(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntWarn(systemEnvironment) + n19));
            }
            if (n20 != 0) {
                sDMSSubmittedEntity.setChildSuspended(systemEnvironment, new Integer(sDMSSubmittedEntity.getChildSuspended(systemEnvironment) + n20));
            }
            if (n21 != 0) {
                sDMSSubmittedEntity.setCntPending(systemEnvironment, new Integer(sDMSSubmittedEntity.getCntPending(systemEnvironment) + n21));
            }
            sDMSSubmittedEntity.fixCntInParents(systemEnvironment, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18, n19, n20, n21);
            sDMSSubmittedEntity.checkFinal(systemEnvironment);
        }
        comparable2 = this.getIdleTs(systemEnvironment);
        boolean bl = false;
        int n22 = this.getState(systemEnvironment);
        if (n22 != 0 && n22 != 1 && n22 != 6 && n22 != 7 && n22 != 8 && n22 != 9 && n22 != 13 && n22 != 12 && n22 != 10 && this.getCntRunning(systemEnvironment) == 0 && this.getCntStarted(systemEnvironment) == 0 && this.getCntToKill(systemEnvironment) == 0 && this.getCntKilled(systemEnvironment) == 0 && this.getCntBrokenActive(systemEnvironment) == 0) {
            bl = true;
        }
        if (bl && comparable2 == null) {
            this.setIdleTs(systemEnvironment, new Integer((int)((systemEnvironment.cEnv.last() - this.getSubmitTs(systemEnvironment)) / 1000L)));
        }
        if (!bl && comparable2 != null) {
            Integer n23 = this.getIdleTime(systemEnvironment);
            int n24 = 0;
            if (n23 != null) {
                n24 = n23;
            }
            this.setIdleTime(systemEnvironment, new Integer(n24 + (int)((systemEnvironment.cEnv.last() - this.getSubmitTs(systemEnvironment)) / 1000L) - (Integer)comparable2));
            this.setIdleTs(systemEnvironment, null);
        }
    }

    @Override
    public void setFinalEsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.setFinalEsdId(systemEnvironment, l, true);
    }

    public void setFinalEsdId(SystemEnvironment systemEnvironment, Long l, boolean bl) throws SDMSException {
        Long l2 = this.getFinalEsdId(systemEnvironment);
        if (l == null && l2 == null) {
            return;
        }
        if (l != null && l2 == null || l == null && l2 != null || !l.equals(l2)) {
            super.setFinalEsdId(systemEnvironment, l);
            if (bl) {
                this.trigger(systemEnvironment, 1);
            }
            this.translateToParent(systemEnvironment, bl);
            return;
        }
    }

    @Override
    public void setResumeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        super.setResumeTs(systemEnvironment, l);
        if (l == null) {
            SystemEnvironment.tt.removeFromJobsToResume(systemEnvironment, this.getId(systemEnvironment));
        } else {
            SystemEnvironment.tt.addToJobsToResume(systemEnvironment, this.getId(systemEnvironment));
        }
    }

    @Override
    public void setJobIsRestartable(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl.booleanValue() != this.getJobIsRestartable(systemEnvironment).booleanValue()) {
            super.setJobIsRestartable(systemEnvironment, bl);
            this.fixCntInParents(systemEnvironment, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, bl != false ? 1 : -1, 0, 0, 0);
        }
    }

    @Override
    public void setJobEsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.setJobEsdId(systemEnvironment, l, true);
    }

    boolean isPending(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isPendingState(systemEnvironment, this.getJobEsdId(systemEnvironment));
    }

    boolean isPendingState(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l == null) {
            return false;
        }
        long l2 = this.getSeVersion(systemEnvironment);
        Long l3 = this.getSeId(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3, l2);
        Long l4 = sDMSSchedulingEntity.getEspId(systemEnvironment);
        SDMSExitStateProfile sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, l4, l2);
        return sDMSExitStateProfile.isPendingState(systemEnvironment, l, l2);
    }

    public void setJobEsdId(SystemEnvironment systemEnvironment, Long l, boolean bl) throws SDMSException {
        boolean bl2;
        Long l2 = this.getJobEsdId(systemEnvironment);
        boolean bl3 = this.isPendingState(systemEnvironment, l2);
        if (bl3 != (bl2 = this.isPendingState(systemEnvironment, l))) {
            this.fixCntInParents(systemEnvironment, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, bl2 ? 1 : -1);
        }
        if (l == null && l2 == null) {
            return;
        }
        if (l != null && l2 == null || l == null && l2 != null || !l.equals(l2)) {
            super.setJobEsdId(systemEnvironment, l);
            this.mergeExitStates(systemEnvironment, bl);
        }
    }

    public SDMSSubmittedEntity submitChild(SystemEnvironment systemEnvironment, Vector vector, Integer n, Long l, Long l2, String string, Long l3, String string2) throws SDMSException {
        return this.submitChild(systemEnvironment, vector, n, l, l2, string, l3, string2, true);
    }

    public SDMSSubmittedEntity submitChild(SystemEnvironment systemEnvironment, Vector vector, Integer n, Long l, Long l2, String string, Long l3, String string2, boolean bl) throws SDMSException {
        Object object2;
        SDMSSchedulingHierarchy sDMSSchedulingHierarchy;
        long l4 = this.getSeVersion(systemEnvironment);
        Long l5 = this.getSeId(systemEnvironment);
        try {
            sDMSSchedulingHierarchy = SDMSSchedulingHierarchyTable.idx_parentId_childId_getUnique(systemEnvironment, new SDMSKey(l5, l2), l4);
        }
        catch (NotFoundException notFoundException) {
            if (bl) {
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l2, l4);
                SDMSSchedulingEntity sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, l5, l4);
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02210120844", "$1 not a child of $2", (Object)sDMSSchedulingEntity.pathString(systemEnvironment, l4), (Object)sDMSSchedulingEntity2.pathString(systemEnvironment, l4)));
            }
            sDMSSchedulingHierarchy = SDMSSchedulingHierarchyTable.getObject(systemEnvironment, SDMSObject.dummyShId, l4);
        }
        if (l3 == null && sDMSSchedulingHierarchy.getIsStatic(systemEnvironment).booleanValue()) {
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l2, l4);
            SDMSSchedulingEntity sDMSSchedulingEntity3 = SDMSSchedulingEntityTable.getObject(systemEnvironment, l5, l4);
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02210120849", "$1 must not be a static child of $2", (Object)sDMSSchedulingEntity.pathString(systemEnvironment, l4), (Object)sDMSSchedulingEntity3.pathString(systemEnvironment, l4)));
        }
        int n2 = this.getParentSuspended(systemEnvironment);
        int n3 = this.getIsSuspended(systemEnvironment) != 0 ? 1 : 0;
        Long l6 = this.getOwnerId(systemEnvironment);
        int n4 = this.getParentNiceX100(systemEnvironment) + this.getNice(systemEnvironment);
        SDMSSubmittedEntity sDMSSubmittedEntity = this.doSubmitChild(systemEnvironment, l2, n2 += n3, l, l6, sDMSSchedulingHierarchy, l4, l3, n, string, string2, this.evaluateDisable(systemEnvironment, sDMSSchedulingHierarchy), false, n4);
        if (vector != null) {
            for (Object object2 : vector) {
                sDMSSubmittedEntity.setVariableValue(systemEnvironment, (String)((Object)((WithItem)object2).key), ((WithItem)object2).value.toString());
            }
        }
        sDMSSubmittedEntity.resolveDependencies(systemEnvironment, false);
        Vector vector2 = SDMSHierarchyInstanceTable.idx_childId.getVector(systemEnvironment, (Object)sDMSSubmittedEntity.getId(systemEnvironment), l4);
        object2 = vector2.iterator();
        while (object2.hasNext()) {
            SDMSHierarchyInstance sDMSHierarchyInstance = (SDMSHierarchyInstance)object2.next();
            this.inheritDependencies(systemEnvironment, sDMSSubmittedEntity, l4, sDMSHierarchyInstance);
        }
        sDMSSubmittedEntity.checkDependencies(systemEnvironment);
        return sDMSSubmittedEntity;
    }

    private void copySmeParameters(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        Vector vector = SDMSEntityVariableTable.idx_smeId.getVector(systemEnvironment, l);
        for (SDMSEntityVariable sDMSEntityVariable : vector) {
            if (sDMSEntityVariable.getIsLocal(systemEnvironment).booleanValue()) continue;
            SDMSEntityVariableTable.table.create(systemEnvironment, l2, sDMSEntityVariable.getName(systemEnvironment), sDMSEntityVariable.getValue(systemEnvironment), Boolean.FALSE, null);
        }
    }

    public void releaseResources(SystemEnvironment systemEnvironment, int n) throws SDMSException {
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(SDMSObject.adminGId);
        systemEnvironment.cEnv.pushGid(systemEnvironment, hashSet);
        try {
            Vector vector = SDMSResourceAllocationTable.idx_smeId.getVectorForUpdate(systemEnvironment, this.getId(systemEnvironment));
            for (int i = 0; i < vector.size(); ++i) {
                SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)vector.get(i);
                int n2 = n;
                if (sDMSResourceAllocation.getAllocationType(systemEnvironment) != 5) {
                    int n3 = sDMSResourceAllocation.getKeepMode(systemEnvironment);
                    if (n3 != 0 && (n2 == 11 && !this.getJobIsFinal(systemEnvironment).booleanValue() || n3 == 2 && n2 != 12 && n2 != 10)) continue;
                    boolean bl = false;
                    SDMSResource sDMSResource = SDMSResourceTable.getObjectForUpdate(systemEnvironment, sDMSResourceAllocation.getRId(systemEnvironment));
                    if (sDMSResourceAllocation.getIsSticky(systemEnvironment).booleanValue()) {
                        this.releaseStickyResource(systemEnvironment, sDMSResourceAllocation, sDMSResource, n);
                        if (!this.getJobIsFinal(systemEnvironment).booleanValue() && n2 != 10) {
                            sDMSResourceAllocation.setAllocationType(systemEnvironment, 1);
                            bl = true;
                        }
                    }
                    if ((n2 == 11 || n2 == 12) && sDMSResourceAllocation.getRsmpId(systemEnvironment) != null && sDMSResourceAllocation.getLockmode(systemEnvironment) == 0) {
                        this.setResourceState(systemEnvironment, sDMSResource, sDMSResourceAllocation.getRsmpId(systemEnvironment));
                    }
                    if (bl) continue;
                }
                sDMSResourceAllocation.delete(systemEnvironment, false, true);
            }
        }
        finally {
            systemEnvironment.cEnv.popGid(systemEnvironment);
        }
    }

    public void releaseStickyResource(SystemEnvironment systemEnvironment, SDMSResourceAllocation sDMSResourceAllocation, SDMSResource sDMSResource, int n) throws SDMSException {
        int n2;
        SDMSResourceAllocation sDMSResourceAllocation2;
        int n3 = 255;
        Long l = sDMSResource.getId(systemEnvironment);
        Long l2 = sDMSResourceAllocation.getId(systemEnvironment);
        String string = sDMSResourceAllocation.getStickyName(systemEnvironment);
        Long l3 = sDMSResourceAllocation.getStickyParent(systemEnvironment);
        int n4 = 0;
        try {
            sDMSResourceAllocation2 = SDMSResourceAllocationTable.idx_smeId_rId_stickyName_getUnique(systemEnvironment, new SDMSKey(new Long(-l3.longValue()), l, (Comparable)((Object)string)));
        }
        catch (NotFoundException notFoundException) {
            return;
        }
        Long l4 = sDMSResourceAllocation2.getId(systemEnvironment);
        Vector vector = SDMSResourceAllocationTable.idx_stickyParent_rId_stickyName.getVector(systemEnvironment, new SDMSKey(l3, l, (Comparable)((Object)string)));
        for (n2 = 0; n2 < vector.size(); ++n2) {
            SDMSResourceAllocation sDMSResourceAllocation3 = (SDMSResourceAllocation)vector.get(n2);
            Long l5 = sDMSResourceAllocation3.getId(systemEnvironment);
            if (l5.equals(l4) || l5.equals(l2) && (n == 12 || n == 10 || this.getJobIsFinal(systemEnvironment).booleanValue() && sDMSResourceAllocation3.getKeepMode(systemEnvironment) != 2) || sDMSResourceAllocation3.getAllocationType(systemEnvironment) == 5) continue;
            int n5 = sDMSResourceAllocation3.getAmount(systemEnvironment);
            if (n5 > n4) {
                n4 = n5;
            }
            n3 &= sDMSResourceAllocation3.getLockmode(systemEnvironment).intValue();
        }
        sDMSResourceAllocation2.setLockmode(systemEnvironment, new Integer(n3));
        n2 = sDMSResourceAllocation2.getOrigAmount(systemEnvironment);
        if (n2 > n4) {
            int n6 = sDMSResourceAllocation2.getAmount(systemEnvironment) - (n2 - n4);
            sDMSResourceAllocation2.setOrigAmount(systemEnvironment, new Integer(n4));
            sDMSResourceAllocation2.setAmount(systemEnvironment, new Integer(n6));
        }
    }

    public void setResourceState(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, Long l) throws SDMSException {
        Long l2;
        SDMSResourceStateMapping sDMSResourceStateMapping;
        int n;
        Long l3 = new Long(new Date().getTime());
        Vector vector = SDMSResourceStateMappingTable.idx_rsmpId.getVector(systemEnvironment, l);
        for (n = 0; n < vector.size(); ++n) {
            sDMSResourceStateMapping = (SDMSResourceStateMapping)vector.get(n);
            if (!this.getJobEsdId(systemEnvironment).equals(sDMSResourceStateMapping.getEsdId(systemEnvironment)) || (l2 = sDMSResourceStateMapping.getFromRsdId(systemEnvironment)) == null || !l2.equals(sDMSResource.getRsdId(systemEnvironment))) continue;
            try {
                sDMSResource.setRsdId(systemEnvironment, sDMSResourceStateMapping.getToRsdId(systemEnvironment), this);
                sDMSResource.setRsdTime(systemEnvironment, l3);
            }
            catch (CommonErrorException commonErrorException) {
                this.setWarn(systemEnvironment, new Integer(24), "Set resource state for resource " + sDMSResource.getName(systemEnvironment) + " failed : " + commonErrorException.toString(), l3);
            }
            return;
        }
        for (n = 0; n < vector.size(); ++n) {
            sDMSResourceStateMapping = (SDMSResourceStateMapping)vector.get(n);
            if (!this.getJobEsdId(systemEnvironment).equals(sDMSResourceStateMapping.getEsdId(systemEnvironment)) || (l2 = sDMSResourceStateMapping.getFromRsdId(systemEnvironment)) != null) continue;
            try {
                sDMSResource.setRsdId(systemEnvironment, sDMSResourceStateMapping.getToRsdId(systemEnvironment), this);
                sDMSResource.setRsdTime(systemEnvironment, l3);
            }
            catch (CommonErrorException commonErrorException) {
                this.setWarn(systemEnvironment, new Integer(24), "Set resource state for resource " + sDMSResource.getName(systemEnvironment) + " failed : " + commonErrorException.toString(), l3);
            }
            return;
        }
    }

    public Vector pathStrings(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector<Vector> vector = new Vector<Vector>();
        String string = this.getChildTag(systemEnvironment);
        Long l = this.getId(systemEnvironment);
        Vector vector2 = SDMSHierarchyInstanceTable.idx_childId.getVector(systemEnvironment, this.getId(systemEnvironment));
        if (vector2.size() == 0) {
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(l);
            vector3.add(string);
            vector.add(vector3);
        } else {
            int n;
            SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, this.getParentId(systemEnvironment));
            Long l2 = sDMSSubmittedEntity.getId(systemEnvironment);
            Vector vector4 = sDMSSubmittedEntity.pathStrings(systemEnvironment);
            for (n = 0; n < vector4.size(); ++n) {
                Vector vector5 = (Vector)vector4.get(n);
                vector5.add(l);
                vector5.add(string);
                vector.add(vector5);
            }
            for (n = 0; n < vector2.size(); ++n) {
                SDMSHierarchyInstance sDMSHierarchyInstance = (SDMSHierarchyInstance)vector2.get(n);
                SDMSSubmittedEntity sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSHierarchyInstance.getParentId(systemEnvironment));
                if (l2.equals(sDMSSubmittedEntity2.getId(systemEnvironment))) continue;
                vector4 = sDMSSubmittedEntity2.pathStrings(systemEnvironment);
                for (int i = 0; i < vector4.size(); ++i) {
                    Vector vector6 = (Vector)vector4.get(i);
                    vector6.add(l);
                    vector6.add(string);
                    vector.add(vector6);
                }
            }
        }
        return vector;
    }

    private void removeAsyncTrigger(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSTriggerQueueTable.idx_smeId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSTriggerQueue sDMSTriggerQueue = (SDMSTriggerQueue)vector.get(i);
            sDMSTriggerQueue.delete(systemEnvironment);
        }
    }

    protected boolean trigger(SystemEnvironment systemEnvironment, int n) throws SDMSException {
        return this.trigger(systemEnvironment, n, false);
    }

    protected boolean trigger(SystemEnvironment systemEnvironment, int n, boolean bl) throws SDMSException {
        Long l = n == 0 ? this.getJobEsdId(systemEnvironment) : this.getFinalEsdId(systemEnvironment);
        return this.trigger(systemEnvironment, n, l, this.getId(systemEnvironment), bl);
    }

    private boolean trigger(SystemEnvironment systemEnvironment, int n, Long l, Long l2, boolean bl) throws SDMSException {
        if (this.getIsCancelled(systemEnvironment).booleanValue()) {
            return false;
        }
        long l3 = this.getSeVersion(systemEnvironment);
        boolean bl2 = false;
        Long l4 = this.getSeId(systemEnvironment);
        HashSet hashSet = (HashSet)systemEnvironment.tx.txData.get("TRIGGER_HASH_SET");
        if (hashSet == null) {
            hashSet = new HashSet();
            systemEnvironment.tx.txData.put("TRIGGER_HASH_SET", hashSet);
        }
        Vector vector = SDMSTriggerTable.idx_fireId_type.getVector(systemEnvironment, (Object)new SDMSKey(l4, new Integer(n)), l3);
        for (SDMSTrigger sDMSTrigger : vector) {
            int n2 = sDMSTrigger.getAction(systemEnvironment);
            if (bl && n2 == 1 && sDMSTrigger.trigger(systemEnvironment, l, l2, null, this)) {
                bl2 = true;
            }
            if (bl || n2 != 0 || !sDMSTrigger.trigger(systemEnvironment, l, l2, null, this)) continue;
            bl2 = true;
        }
        return bl2;
    }

    public void setWarn(SystemEnvironment systemEnvironment, Integer n, String string, Long l) throws SDMSException {
        this.setWarn(systemEnvironment, n, string, l, SDMSObject.internalUId, true);
    }

    public void setWarn(SystemEnvironment systemEnvironment, Integer n, String string, Long l, boolean bl) throws SDMSException {
        this.setWarn(systemEnvironment, n, string, l, SDMSObject.internalUId, bl);
    }

    public void setWarn(SystemEnvironment systemEnvironment, Integer n, String string, Long l, Long l2, boolean bl) throws SDMSException {
        if (!systemEnvironment.checkFeature("WARNINGS")) {
            return;
        }
        int n2 = this.getWarnCount(systemEnvironment);
        this.fixCntInParents(systemEnvironment, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0);
        this.setWarnCount(systemEnvironment, new Integer(n2 + 1));
        SDMSAuditTrail sDMSAuditTrail = SDMSAuditTrailTable.table.create(systemEnvironment, l2, l, n, new Integer(17), this.getId(systemEnvironment), this.getId(systemEnvironment), Boolean.TRUE, null, string);
        if (bl) {
            this.trigger(systemEnvironment, 7, sDMSAuditTrail.getId(systemEnvironment), null, false);
        }
    }

    public void clearWarn(SystemEnvironment systemEnvironment, Integer n, String string, Long l) throws SDMSException {
        this.clearWarn(systemEnvironment, n, string, l, SDMSObject.internalUId);
    }

    public void clearWarn(SystemEnvironment systemEnvironment, Integer n, String string, Long l, Long l2) throws SDMSException {
        int n2 = this.getWarnCount(systemEnvironment);
        this.fixCntInParents(systemEnvironment, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -n2, 0, 0);
        this.setWarnCount(systemEnvironment, new Integer(0));
        SDMSAuditTrailTable.table.create(systemEnvironment, l2, l, n, new Integer(17), this.getId(systemEnvironment), this.getId(systemEnvironment), Boolean.FALSE, null, string);
    }

    private SDMSSubmittedEntity createSme(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, SDMSSchedulingHierarchy sDMSSchedulingHierarchy, String string, Long l, boolean bl, boolean bl2, Integer n, int n2, Long l2, Long l3, String string2, Long l4, String string3) throws SDMSException {
        Object object;
        Integer n3;
        Long l5 = sDMSSchedulingEntity.getId(systemEnvironment);
        Integer n4 = null;
        Integer n5 = null;
        if (sDMSSchedulingEntity.getType(systemEnvironment) == 2 || sDMSSchedulingEntity.getType(systemEnvironment) == 3) {
            n3 = sDMSSchedulingEntity.getPriority(systemEnvironment);
            n4 = zero;
            n5 = zero;
        } else {
            n4 = sDMSSchedulingEntity.getPriority(systemEnvironment);
            n5 = new Integer(sDMSSchedulingEntity.getPriority(systemEnvironment) * 100);
            n3 = zero;
        }
        Integer n6 = sDMSSchedulingEntity.getMinPriority(systemEnvironment);
        if (n6 == null) {
            n6 = new Integer(SystemEnvironment.priorityLowerBound);
        }
        Integer n7 = sDMSSchedulingEntity.getAgingAmount(systemEnvironment);
        Integer n8 = sDMSSchedulingEntity.getAgingBase(systemEnvironment);
        if (n7 == null || n8 == null) {
            n7 = new Integer(SystemEnvironment.priorityDelay);
            n8 = new Integer(0);
        }
        switch (n8) {
            case 0: {
                break;
            }
            case 1: {
                n7 = new Integer((int)((long)n7.intValue() * 60L));
                break;
            }
            case 2: {
                n7 = new Integer((int)((long)n7.intValue() * 1440L));
                break;
            }
            case 3: {
                n7 = new Integer((int)((long)n7.intValue() * 10080L));
                break;
            }
            case 4: {
                n7 = new Integer((int)((long)n7.intValue() * 43200L));
                break;
            }
            case 5: {
                n7 = new Integer((int)((long)n7.intValue() * 525600L));
            }
        }
        n8 = new Integer(0);
        Long l6 = null;
        if (n != 0) {
            l6 = new Long(-l4.longValue());
        }
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.table.create(systemEnvironment, systemEnvironment.randomLong(), this.getMasterId(systemEnvironment), string2, null, l5, string, this.getSeVersion(systemEnvironment), l, this.getId(systemEnvironment), null, new Boolean(bl), new Boolean(bl2), null, sDMSSchedulingHierarchy.getMergeMode(systemEnvironment), new Integer(0), null, null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, zero, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null, null, zero, null, null, null, null, null, null, null, null, n, n4, n5, n3, zero, n6, n7, new Integer(n2), zero, zero, null, l4, l2, null, null, null, null, null, null, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, null, zero, zero, zero, zero, zero, zero, zero, zero, zero, l6, null, string3);
        if (l3 != null) {
            this.copySmeParameters(systemEnvironment, l3, sDMSSubmittedEntity.getId(systemEnvironment));
            object = SDMSSubmittedEntityTable.getObject(systemEnvironment, l3);
            ((SDMSSubmittedEntityProxyGeneric)object).setIsReplaced(systemEnvironment, Boolean.TRUE);
        }
        object = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, l5);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            SDMSTrigger sDMSTrigger = (SDMSTrigger)((Vector)object).get(i);
            int n9 = sDMSTrigger.getType(systemEnvironment);
            if (n9 != 5 && n9 != 6) continue;
            SDMSTriggerQueueTable.table.create(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment), sDMSTrigger.getId(systemEnvironment), lzero, zero, zero);
        }
        return sDMSSubmittedEntity;
    }

    private void fixChildPrioritiesAndNpNice(SystemEnvironment systemEnvironment, int n, Integer n2) throws SDMSException {
        Vector vector = SDMSHierarchyInstanceTable.idx_parentId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSHierarchyInstance sDMSHierarchyInstance = (SDMSHierarchyInstance)vector.get(i);
            SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSHierarchyInstance.getChildId(systemEnvironment));
            int n3 = SDMSHierarchyInstanceTable.idx_childId.getVector(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment)).size();
            if ((n /= n3) != 0) {
                sDMSSubmittedEntity.setRawPriority(systemEnvironment, new Integer(sDMSSubmittedEntity.getRawPriority(systemEnvironment) + n));
            }
            sDMSSubmittedEntity.fixChildPrioritiesAndNpNice(systemEnvironment, n, n2);
            if (n2 == null) continue;
            sDMSSubmittedEntity.setNpNice(systemEnvironment, n2);
        }
    }

    public int getParentNiceX100(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSHierarchyInstanceTable.idx_childId.getVector(systemEnvironment, this.getId(systemEnvironment));
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            SDMSHierarchyInstance sDMSHierarchyInstance = (SDMSHierarchyInstance)vector.get(i);
            Long l = sDMSHierarchyInstance.getParentId(systemEnvironment);
            SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
            n += (sDMSHierarchyInstance.getNice(systemEnvironment) + sDMSSubmittedEntity.getNice(systemEnvironment)) * 100 + sDMSSubmittedEntity.getParentNiceX100(systemEnvironment);
        }
        if (vector.size() == 0) {
            return 0;
        }
        return n / vector.size();
    }

    public void renice(SystemEnvironment systemEnvironment, Integer n, Integer n2, String string) throws SDMSException {
        int n3 = 0;
        int n4 = this.getState(systemEnvironment);
        if (n4 == 10 || n4 == 12) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03303061417", "Cannot renice a cancelled or final job"));
        }
        int n5 = 0;
        if (n != null) {
            n3 = n;
            if (n3 < -100) {
                n3 = -100;
            }
            if (n3 > 100) {
                n3 = 100;
            }
            n5 = n3 - this.getNice(systemEnvironment);
            this.setNice(systemEnvironment, new Integer(n3));
        }
        int n6 = 0;
        if (n2 != null) {
            n6 = n2 - this.getNpNice(systemEnvironment);
            this.setNpNice(systemEnvironment, n2);
        }
        Integer n7 = this.getRawPriority(systemEnvironment);
        int n8 = (n5 + n6) * 100;
        if (n7 != null && n8 != 0) {
            int n9 = n7 + n8;
            this.setRawPriority(systemEnvironment, new Integer(n9));
        }
        this.fixChildPrioritiesAndNpNice(systemEnvironment, n8, n2);
        if (n5 != 0) {
            Date date = new Date();
            Long l = new Long(date.getTime());
            String string2 = "old=" + new Integer(n3 - n5) + ", new=" + new Integer(n3);
            SDMSAuditTrailTable.table.create(systemEnvironment, systemEnvironment.cEnv.uid(), l, new Integer(20), new Integer(17), this.getId(systemEnvironment), this.getId(systemEnvironment), Boolean.FALSE, string2, string);
        }
    }

    @Override
    public void setPriority(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.setRawPriority(systemEnvironment, new Integer(n * 100), true);
    }

    @Override
    public void setRawPriority(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.setRawPriority(systemEnvironment, n, false);
    }

    public void setRawPriority(SystemEnvironment systemEnvironment, Integer n, boolean bl) throws SDMSException {
        int n2 = n;
        int n3 = this.getPriority(systemEnvironment);
        int n4 = this.getRawPriority(systemEnvironment);
        if (n2 == n4) {
            return;
        }
        int n5 = n2 / 100;
        if (n5 > 100) {
            n5 = 100;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n5 < SystemEnvironment.priorityLowerBound && !bl) {
            n5 = SystemEnvironment.priorityLowerBound;
        }
        if (n3 < SystemEnvironment.priorityLowerBound && !bl) {
            n5 = n3;
        }
        super.setRawPriority(systemEnvironment, n);
        if (n5 != n3) {
            super.setPriority(systemEnvironment, new Integer(n5));
            SystemEnvironment.sched.notifyChange(systemEnvironment, this, 14);
        }
    }

    public synchronized void releaseMaster(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        int n = this.getState(systemEnvironment);
        if (!l.equals(this.getMasterId(systemEnvironment))) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03311061650", "Tried to release a nonmaster submitted entity ($1)", (Object)l));
        }
        if (n != 10 && n != 12) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03311061638", "Tried to release a nonfinal submitted entity ($1)", (Object)l));
        }
        systemEnvironment.seVersionList.remove(this.getSeVersion(systemEnvironment));
        this.release(systemEnvironment);
    }

    @Override
    synchronized void release(SystemEnvironment systemEnvironment) throws SDMSException {
        int n;
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSSubmittedEntityTable.idx_parentId.getVector(systemEnvironment, l);
        for (n = 0; n < vector.size(); ++n) {
            ((SDMSSubmittedEntity)vector.get(n)).release(systemEnvironment);
        }
        vector = SDMSHierarchyInstanceTable.idx_childId.getVector(systemEnvironment, l);
        for (n = 0; n < vector.size(); ++n) {
            ((SDMSHierarchyInstance)vector.get(n)).release(systemEnvironment);
        }
        vector = SDMSDependencyInstanceTable.idx_dependentId.getVector(systemEnvironment, l);
        for (n = 0; n < vector.size(); ++n) {
            ((SDMSDependencyInstance)vector.get(n)).release(systemEnvironment);
        }
        vector = SDMSDependencyInstanceTable.idx_requiredId.getVector(systemEnvironment, l);
        for (n = 0; n < vector.size(); ++n) {
            ((SDMSDependencyInstance)vector.get(n)).release(systemEnvironment);
        }
        vector = SDMSEntityVariableTable.idx_smeId.getVector(systemEnvironment, l);
        for (n = 0; n < vector.size(); ++n) {
            ((SDMSEntityVariable)vector.get(n)).release(systemEnvironment);
        }
        vector = SDMSAuditTrailTable.idx_objectId.getVector(systemEnvironment, l);
        for (n = 0; n < vector.size(); ++n) {
            ((SDMSAuditTrail)vector.get(n)).release(systemEnvironment);
        }
        vector = SDMSKillJobTable.idx_smeId.getVector(systemEnvironment, l);
        for (n = 0; n < vector.size(); ++n) {
            ((SDMSKillJob)vector.get(n)).release(systemEnvironment);
        }
        vector = SDMSSubmittedEntityStatsTable.idx_smeId.getVector(systemEnvironment, l);
        for (n = 0; n < vector.size(); ++n) {
            ((SDMSSubmittedEntityStats)vector.get(n)).release(systemEnvironment);
        }
        super.release(systemEnvironment);
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        long l2 = super.getPrivileges(systemEnvironment, l, bl, vector);
        if (systemEnvironment.cEnv.isUser()) {
            Long l3 = this.getMasterId(systemEnvironment);
            if (!l3.equals(this.getId(systemEnvironment)) && l3 != 0L) {
                SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObjectForUpdate(systemEnvironment, l3);
                return sDMSSubmittedEntity.getPrivileges(systemEnvironment, l, bl, vector);
            }
            if ((l2 & 0x10000L) != 65536L) {
                long l4 = this.getSeVersion(systemEnvironment);
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.getSeId(systemEnvironment), l4);
                long l5 = sDMSSchedulingEntity.getPrivileges(systemEnvironment, 69632L, false, vector, l4);
                if (l5 != 0L) {
                    SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, this.getOwnerId(systemEnvironment));
                    l5 &= sDMSGroup.getPrivileges(systemEnvironment, 69632L, false, vector);
                }
                l2 |= l5;
            }
        }
        l2 = this.addImplicitPrivs(l2);
        return l2 & l;
    }

    @Override
    public long addImplicitPrivs(long l) {
        if (((l = super.addImplicitPrivs(l)) & 0x10000L) == 65536L) {
            l |= 0x100L;
        }
        return l;
    }

    public void setToError(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.setState(systemEnvironment, new Integer(15));
        if (string != null) {
            this.setErrorMsg(systemEnvironment, string);
        }
        Date date = new Date();
        Long l = new Long(date.getTime());
        if (string == null) {
            string = "No Message";
        }
        SDMSAuditTrailTable.table.create(systemEnvironment, systemEnvironment.cEnv.uid(), l, new Integer(25), new Integer(17), this.getId(systemEnvironment), this.getId(systemEnvironment), Boolean.FALSE, null, string);
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.getId(systemEnvironment).toString();
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        return "job " + this.getURLName(systemEnvironment);
    }

    public void updateStatistics(SystemEnvironment systemEnvironment) throws SDMSException {
        int n = 0;
        Integer n2 = this.getStatisticTs(systemEnvironment);
        if (n2 != null) {
            n = n2;
        }
        int n3 = n % 10;
        n /= 10;
        int n4 = 0;
        boolean bl = this.getIsSuspended(systemEnvironment) != 0 || this.getParentSuspended(systemEnvironment) > 0;
        int n5 = this.getState(systemEnvironment);
        switch (n5) {
            case 0: {
                if (!bl) break;
                n4 = 2;
                break;
            }
            case 1: 
            case 16: {
                if (bl) {
                    n4 = 2;
                    break;
                }
                n4 = 1;
                break;
            }
            case 2: {
                if (bl) {
                    n4 = 2;
                    break;
                }
                n4 = 3;
                break;
            }
            case 3: {
                if (bl) {
                    n4 = 2;
                    break;
                }
                n4 = 4;
                break;
            }
            case 4: 
            case 5: {
                n4 = 5;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n4 = 0;
                break;
            }
            case 11: {
                if (this.getJobIsRestartable(systemEnvironment).booleanValue()) {
                    n4 = 6;
                    break;
                }
                if (bl) {
                    n4 = 2;
                    break;
                }
                n4 = 7;
                break;
            }
            case 14: 
            case 15: {
                n4 = 6;
            }
        }
        if (n4 != n3) {
            int n6;
            Integer n7 = null;
            switch (n3) {
                case 1: {
                    n7 = this.getDependencyWaitTime(systemEnvironment);
                    break;
                }
                case 2: {
                    n7 = this.getSuspendTime(systemEnvironment);
                    break;
                }
                case 3: {
                    n7 = this.getSyncTime(systemEnvironment);
                    break;
                }
                case 4: {
                    n7 = this.getResourceTime(systemEnvironment);
                    break;
                }
                case 5: {
                    n7 = this.getJobserverTime(systemEnvironment);
                    break;
                }
                case 6: {
                    n7 = this.getRestartableTime(systemEnvironment);
                    break;
                }
                case 7: {
                    n7 = this.getChildWaitTime(systemEnvironment);
                }
            }
            if (n7 == null) {
                n7 = new Integer(0);
            }
            if ((n6 = (int)((systemEnvironment.cEnv.last() - this.getSubmitTs(systemEnvironment)) / 1000L)) < 0) {
                n6 = 0;
            }
            int n8 = n6 - n;
            n7 = new Integer(n7 + n8);
            switch (n3) {
                case 1: {
                    this.setDependencyWaitTime(systemEnvironment, n7);
                    break;
                }
                case 2: {
                    this.setSuspendTime(systemEnvironment, n7);
                    break;
                }
                case 3: {
                    this.setSyncTime(systemEnvironment, n7);
                    break;
                }
                case 4: {
                    this.setResourceTime(systemEnvironment, n7);
                    break;
                }
                case 5: {
                    this.setJobserverTime(systemEnvironment, n7);
                    break;
                }
                case 6: {
                    this.setRestartableTime(systemEnvironment, n7);
                    break;
                }
                case 7: {
                    this.setChildWaitTime(systemEnvironment, n7);
                }
            }
            this.setStatisticTs(systemEnvironment, new Integer(n6 * 10 + n4));
        }
    }

    public Integer evaluateTime(SystemEnvironment systemEnvironment, Integer n, Integer n2, int n3) throws SDMSException {
        int n4 = 0;
        if (n != null) {
            n4 = n;
        }
        if (n2 != null) {
            int n5 = n2;
            int n6 = n5 % 10;
            if (n3 >= 0) {
                n5 /= 10;
            }
            if (n3 == -1 || n6 == n3) {
                int n7 = (int)((systemEnvironment.cEnv.last() - this.getSubmitTs(systemEnvironment)) / 1000L);
                n4 += n7 - n5;
            }
        }
        return new Integer(n4);
    }

    static {
        mapper.put(new Integer(582), new Integer(0));
        mapper.put(new Integer(330), new Integer(1));
        mapper.put(new Integer(588), new Integer(2));
        mapper.put(new Integer(536), new Integer(3));
        mapper.put(new Integer(545), new Integer(4));
        mapper.put(new Integer(569), new Integer(5));
        mapper.put(new Integer(568), new Integer(6));
        mapper.put(new Integer(546), new Integer(7));
        mapper.put(new Integer(376), new Integer(11));
        mapper.put(new Integer(373), new Integer(12));
        mapper.put(new Integer(288), new Integer(13));
        mapper.put(new Integer(289), new Integer(14));
        mapper.put(new Integer(350), new Integer(15));
        mapper.put(new Integer(599), new Integer(8));
        mapper.put(new Integer(426), new Integer(9));
        mapper.put(new Integer(293), new Integer(10));
        mapper.put(new Integer(608), new Integer(16));
    }
}

