/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.repository.SDMSTriggerQueue;
import de.independit.scheduler.server.repository.SDMSTriggerQueueGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerQueueTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSTriggerQueueTableGeneric
extends SDMSTable {
    public static final String tableName = "TRIGGER_QUEUE";
    public static SDMSTriggerQueueTable table = null;
    public static final String[] columnNames = new String[]{"ID", "SME_ID", "TR_ID", "NEXT_TRIGGER_TIME", "TIMES_CHECKED", "TIMES_TRIGGERED", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_smeId;
    public static SDMSIndex idx_trId;
    public static SDMSIndex idx_smeId_trId;

    public SDMSTriggerQueueTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "TriggerQueue"));
        }
        table = (SDMSTriggerQueueTable)this;
        table = (SDMSTriggerQueueTable)this;
        this.isVersioned = false;
        idx_smeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "smeId");
        idx_trId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "trId");
        idx_smeId_trId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "smeId_trId");
    }

    public SDMSTriggerQueue create(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Integer n, Integer n2) throws SDMSException {
        SDMSTriggerQueue sDMSTriggerQueue;
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        Long l6 = systemEnvironment.cEnv.uid();
        Long l7 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "TriggerQueue"));
        }
        this.validate(systemEnvironment, l, l2, l3, n, n2, l4, l5, l6, l7);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSTriggerQueueGeneric sDMSTriggerQueueGeneric = new SDMSTriggerQueueGeneric(systemEnvironment, l, l2, l3, n, n2, l4, l5, l6, l7);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSTriggerQueueGeneric.versions, true);
            table.put(systemEnvironment, sDMSTriggerQueueGeneric.id, sDMSTriggerQueueGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSTriggerQueue = (SDMSTriggerQueue)sDMSTriggerQueueGeneric.toProxy(systemEnvironment);
            sDMSTriggerQueue.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSTriggerQueue sDMSTriggerQueue2 = (SDMSTriggerQueue)sDMSTriggerQueueGeneric.toProxy(systemEnvironment);
            sDMSTriggerQueue2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSTriggerQueue)) {
            throw new AccessViolationException(sDMSTriggerQueue.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSTriggerQueue;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSTriggerQueue sDMSTriggerQueue) throws SDMSException {
        return true;
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Integer n, Integer n2, Long l4, Long l5, Long l6, Long l7) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Integer n;
        Integer n2;
        Long l7;
        Long l8;
        Long l9;
        Long l10;
        try {
            l10 = new Long(resultSet.getLong(1));
            l9 = new Long(resultSet.getLong(2));
            l8 = new Long(resultSet.getLong(3));
            l7 = new Long(resultSet.getLong(4));
            n2 = new Integer(resultSet.getInt(5));
            n = new Integer(resultSet.getInt(6));
            l6 = new Long(resultSet.getLong(7));
            l5 = new Long(resultSet.getLong(8));
            l4 = new Long(resultSet.getLong(9));
            l3 = new Long(resultSet.getLong(10));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "TriggerQueue: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSTriggerQueueGeneric(l10, l9, l8, l7, n2, n, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "SME_ID" + string2 + ", " + string + "TR_ID" + string2 + ", " + string + "NEXT_TRIGGER_TIME" + string2 + ", " + string + "TIMES_CHECKED" + string2 + ", " + string + "TIMES_TRIGGERED" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_smeId.check(((SDMSTriggerQueueGeneric)sDMSObject).smeId, sDMSObject);
        string = string + "idx_smeId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_trId.check(((SDMSTriggerQueueGeneric)sDMSObject).trId, sDMSObject);
        string = string + "idx_trId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTriggerQueueGeneric)sDMSObject).smeId);
        sDMSKey.add(((SDMSTriggerQueueGeneric)sDMSObject).trId);
        bl = idx_smeId_trId.check(sDMSKey, sDMSObject);
        string = string + "idx_smeId_trId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_smeId.put(systemEnvironment, ((SDMSTriggerQueueGeneric)sDMSObject).smeId, sDMSObject, (1L & l) != 0L);
        idx_trId.put(systemEnvironment, ((SDMSTriggerQueueGeneric)sDMSObject).trId, sDMSObject, (2L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTriggerQueueGeneric)sDMSObject).smeId);
        sDMSKey.add(((SDMSTriggerQueueGeneric)sDMSObject).trId);
        idx_smeId_trId.put(systemEnvironment, sDMSKey, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_smeId.remove(systemEnvironment, ((SDMSTriggerQueueGeneric)sDMSObject).smeId, sDMSObject);
        idx_trId.remove(systemEnvironment, ((SDMSTriggerQueueGeneric)sDMSObject).trId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTriggerQueueGeneric)sDMSObject).smeId);
        sDMSKey.add(((SDMSTriggerQueueGeneric)sDMSObject).trId);
        idx_smeId_trId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSTriggerQueue getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSTriggerQueue)table.get(systemEnvironment, l);
    }

    public static SDMSTriggerQueue getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSTriggerQueue)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSTriggerQueue getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSTriggerQueue)table.get(systemEnvironment, l, l2);
    }

    public static SDMSTriggerQueue idx_smeId_trId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSTriggerQueue)idx_smeId_trId.getUnique(systemEnvironment, object);
    }

    public static SDMSTriggerQueue idx_smeId_trId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSTriggerQueue)idx_smeId_trId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSTriggerQueue idx_smeId_trId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSTriggerQueue)idx_smeId_trId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

