/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSTriggerTableGeneric
extends SDMSTable {
    public static final String tableName = "TRIGGER_DEFINITION";
    public static SDMSTriggerTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "FIRE_ID", "OBJECT_TYPE", "SE_ID", "MAIN_SE_ID", "PARENT_SE_ID", "IS_ACTIVE", "IS_INVERSE", "ACTION", "TYPE", "IS_MASTER", "IS_SUSPEND", "IS_CREATE", "IS_CHANGE", "IS_DELETE", "IS_GROUP", "RESUME_AT", "RESUME_IN", "RESUME_BASE", "IS_WARN_ON_LIMIT", "LIMIT_STATE", "MAX_RETRY", "SUBMIT_OWNER_ID", "CONDITION", "CHECK_AMOUNT", "CHECK_BASE", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_fireId;
    public static SDMSIndex idx_seId;
    public static SDMSIndex idx_mainSeId;
    public static SDMSIndex idx_parentSeId;
    public static SDMSIndex idx_submitOwnerId;
    public static SDMSIndex idx_fireId_type;
    public static SDMSIndex idx_fireId_name;
    public static SDMSIndex idx_seId_name;
    public static SDMSIndex idx_fireId_seId_name_isInverse;

    public SDMSTriggerTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "Trigger"));
        }
        table = (SDMSTriggerTable)this;
        table = (SDMSTriggerTable)this;
        this.isVersioned = true;
        idx_fireId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "fireId");
        idx_seId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "seId");
        idx_mainSeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "mainSeId");
        idx_parentSeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "parentSeId");
        idx_submitOwnerId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "submitOwnerId");
        idx_fireId_type = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "fireId_type");
        idx_fireId_name = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "fireId_name");
        idx_seId_name = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "seId_name");
        idx_fireId_seId_name_isInverse = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "fireId_seId_name_isInverse");
    }

    public SDMSTrigger create(SystemEnvironment systemEnvironment, String string, Long l, Integer n, Long l2, Long l3, Long l4, Boolean bl, Boolean bl2, Integer n2, Integer n3, Boolean bl3, Boolean bl4, Boolean bl5, Boolean bl6, Boolean bl7, Boolean bl8, String string2, Integer n4, Integer n5, Boolean bl9, Long l5, Integer n6, Long l6, String string3, Integer n7, Integer n8) throws SDMSException {
        SDMSTrigger sDMSTrigger;
        Long l7 = systemEnvironment.cEnv.uid();
        Long l8 = systemEnvironment.txTime();
        Long l9 = systemEnvironment.cEnv.uid();
        Long l10 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "Trigger"));
        }
        this.validate(systemEnvironment, string, l, n, l2, l3, l4, bl, bl2, n2, n3, bl3, bl4, bl5, bl6, bl7, bl8, string2, n4, n5, bl9, l5, n6, l6, string3, n7, n8, l7, l8, l9, l10);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSTriggerGeneric sDMSTriggerGeneric = new SDMSTriggerGeneric(systemEnvironment, string, l, n, l2, l3, l4, bl, bl2, n2, n3, bl3, bl4, bl5, bl6, bl7, bl8, string2, n4, n5, bl9, l5, n6, l6, string3, n7, n8, l7, l8, l9, l10);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSTriggerGeneric.versions, true);
            table.put(systemEnvironment, sDMSTriggerGeneric.id, sDMSTriggerGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSTrigger = (SDMSTrigger)sDMSTriggerGeneric.toProxy(systemEnvironment);
            sDMSTrigger.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSTrigger sDMSTrigger2 = (SDMSTrigger)sDMSTriggerGeneric.toProxy(systemEnvironment);
            sDMSTrigger2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSTrigger)) {
            throw new AccessViolationException(sDMSTrigger.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSTrigger.touchMaster(systemEnvironment);
        return sDMSTrigger;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger) throws SDMSException {
        return sDMSTrigger.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Long l, Integer n, Long l2, Long l3, Long l4, Boolean bl, Boolean bl2, Integer n2, Integer n3, Boolean bl3, Boolean bl4, Boolean bl5, Boolean bl6, Boolean bl7, Boolean bl8, String string2, Integer n4, Integer n5, Boolean bl9, Long l5, Integer n6, Long l6, String string3, Integer n7, Integer n8, Long l7, Long l8, Long l9, Long l10) throws SDMSException {
        if (!SDMSTriggerGeneric.checkObjectType(n)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "Trigger: $1 $2", (Object)"objectType", (Object)n));
        }
        if (!SDMSTriggerGeneric.checkAction(n2)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "Trigger: $1 $2", (Object)"action", (Object)n2));
        }
        if (!SDMSTriggerGeneric.checkType(n3)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "Trigger: $1 $2", (Object)"type", (Object)n3));
        }
        if (!SDMSTriggerGeneric.checkIsMaster(bl3)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "Trigger: $1 $2", (Object)"isMaster", (Object)bl3));
        }
        if (!SDMSTriggerGeneric.checkIsSuspend(bl4)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "Trigger: $1 $2", (Object)"isSuspend", (Object)bl4));
        }
        if (!SDMSTriggerGeneric.checkResumeBase(n5)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "Trigger: $1 $2", (Object)"resumeBase", (Object)n5));
        }
        if (!SDMSTriggerGeneric.checkCheckBase(n8)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "Trigger: $1 $2", (Object)"checkBase", (Object)n8));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Integer n;
        Integer n2;
        String string;
        Long l7;
        Integer n3;
        Long l8;
        Boolean bl;
        Integer n4;
        Integer n5;
        String string2;
        Boolean bl2;
        Boolean bl3;
        Boolean bl4;
        Boolean bl5;
        Boolean bl6;
        Boolean bl7;
        Integer n6;
        Integer n7;
        Boolean bl8;
        Boolean bl9;
        Long l9;
        Long l10;
        Long l11;
        Integer n8;
        Long l12;
        String string3;
        Long l13;
        try {
            l13 = new Long(resultSet.getLong(1));
            string3 = resultSet.getString(2);
            l12 = new Long(resultSet.getLong(3));
            n8 = new Integer(resultSet.getInt(4));
            l11 = new Long(resultSet.getLong(5));
            l10 = new Long(resultSet.getLong(6));
            if (resultSet.wasNull()) {
                l10 = null;
            }
            l9 = new Long(resultSet.getLong(7));
            if (resultSet.wasNull()) {
                l9 = null;
            }
            bl9 = new Boolean(resultSet.getInt(8) != 0);
            bl8 = new Boolean(resultSet.getInt(9) != 0);
            n7 = new Integer(resultSet.getInt(10));
            n6 = new Integer(resultSet.getInt(11));
            bl7 = new Boolean(resultSet.getInt(12) != 0);
            bl6 = new Boolean(resultSet.getInt(13) != 0);
            bl5 = new Boolean(resultSet.getInt(14) != 0);
            if (resultSet.wasNull()) {
                bl5 = null;
            }
            bl4 = new Boolean(resultSet.getInt(15) != 0);
            if (resultSet.wasNull()) {
                bl4 = null;
            }
            bl3 = new Boolean(resultSet.getInt(16) != 0);
            if (resultSet.wasNull()) {
                bl3 = null;
            }
            bl2 = new Boolean(resultSet.getInt(17) != 0);
            if (resultSet.wasNull()) {
                bl2 = null;
            }
            string2 = resultSet.getString(18);
            if (resultSet.wasNull()) {
                string2 = null;
            }
            n5 = new Integer(resultSet.getInt(19));
            if (resultSet.wasNull()) {
                n5 = null;
            }
            n4 = new Integer(resultSet.getInt(20));
            if (resultSet.wasNull()) {
                n4 = null;
            }
            bl = new Boolean(resultSet.getInt(21) != 0);
            l8 = new Long(resultSet.getLong(22));
            if (resultSet.wasNull()) {
                l8 = null;
            }
            n3 = new Integer(resultSet.getInt(23));
            l7 = new Long(resultSet.getLong(24));
            if (resultSet.wasNull()) {
                l7 = null;
            }
            string = resultSet.getString(25);
            if (resultSet.wasNull()) {
                string = null;
            }
            n2 = new Integer(resultSet.getInt(26));
            if (resultSet.wasNull()) {
                n2 = null;
            }
            n = new Integer(resultSet.getInt(27));
            if (resultSet.wasNull()) {
                n = null;
            }
            l6 = new Long(resultSet.getLong(28));
            l5 = new Long(resultSet.getLong(29));
            l4 = new Long(resultSet.getLong(30));
            l3 = new Long(resultSet.getLong(31));
            l2 = resultSet.getLong(32);
            l = resultSet.getLong(33);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "Trigger: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSTriggerGeneric(l13, string3, l12, n8, l11, l10, l9, bl9, bl8, n7, n6, bl7, bl6, bl5, bl4, bl3, bl2, string2, n5, n4, bl, l8, n3, l7, string, n2, n, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "NAME" + string2 + ", " + string + "FIRE_ID" + string2 + ", " + string + "OBJECT_TYPE" + string2 + ", " + string + "SE_ID" + string2 + ", " + string + "MAIN_SE_ID" + string2 + ", " + string + "PARENT_SE_ID" + string2 + ", " + string + "IS_ACTIVE" + string2 + ", " + string + "IS_INVERSE" + string2 + ", " + string + "ACTION" + string2 + ", " + string + "TYPE" + string2 + ", " + string + "IS_MASTER" + string2 + ", " + string + "IS_SUSPEND" + string2 + ", " + string + "IS_CREATE" + string2 + ", " + string + "IS_CHANGE" + string2 + ", " + string + "IS_DELETE" + string2 + ", " + string + "IS_GROUP" + string2 + ", " + string + "RESUME_AT" + string2 + ", " + string + "RESUME_IN" + string2 + ", " + string + "RESUME_BASE" + string2 + ", " + string + "IS_WARN_ON_LIMIT" + string2 + ", " + string + "LIMIT_STATE" + string2 + ", " + string + "MAX_RETRY" + string2 + ", " + string + "SUBMIT_OWNER_ID" + string2 + ", " + string + "CONDITION" + string2 + ", " + string + "CHECK_AMOUNT" + string2 + ", " + string + "CHECK_BASE" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO " + " FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion) + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_fireId.check(((SDMSTriggerGeneric)sDMSObject).fireId, sDMSObject);
        string = string + "idx_fireId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_seId.check(((SDMSTriggerGeneric)sDMSObject).seId, sDMSObject);
        string = string + "idx_seId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_mainSeId.check(((SDMSTriggerGeneric)sDMSObject).mainSeId, sDMSObject);
        string = string + "idx_mainSeId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_parentSeId.check(((SDMSTriggerGeneric)sDMSObject).parentSeId, sDMSObject);
        string = string + "idx_parentSeId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_submitOwnerId.check(((SDMSTriggerGeneric)sDMSObject).submitOwnerId, sDMSObject);
        string = string + "idx_submitOwnerId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).fireId);
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).type);
        bl = idx_fireId_type.check(sDMSKey, sDMSObject);
        string = string + "idx_fireId_type: " + (bl ? "ok" : "missing") + "\n";
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).fireId);
        sDMSKey.add((Comparable)((Object)((SDMSTriggerGeneric)sDMSObject).name));
        bl = idx_fireId_name.check(sDMSKey, sDMSObject);
        string = string + "idx_fireId_name: " + (bl ? "ok" : "missing") + "\n";
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).seId);
        sDMSKey.add((Comparable)((Object)((SDMSTriggerGeneric)sDMSObject).name));
        bl = idx_seId_name.check(sDMSKey, sDMSObject);
        string = string + "idx_seId_name: " + (bl ? "ok" : "missing") + "\n";
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).fireId);
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).seId);
        sDMSKey.add((Comparable)((Object)((SDMSTriggerGeneric)sDMSObject).name));
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).isInverse);
        bl = idx_fireId_seId_name_isInverse.check(sDMSKey, sDMSObject);
        string = string + "idx_fireId_seId_name_isInverse: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_fireId.put(systemEnvironment, ((SDMSTriggerGeneric)sDMSObject).fireId, sDMSObject, (1L & l) != 0L);
        idx_seId.put(systemEnvironment, ((SDMSTriggerGeneric)sDMSObject).seId, sDMSObject, (2L & l) != 0L);
        idx_mainSeId.put(systemEnvironment, ((SDMSTriggerGeneric)sDMSObject).mainSeId, sDMSObject, (4L & l) != 0L);
        idx_parentSeId.put(systemEnvironment, ((SDMSTriggerGeneric)sDMSObject).parentSeId, sDMSObject, (8L & l) != 0L);
        idx_submitOwnerId.put(systemEnvironment, ((SDMSTriggerGeneric)sDMSObject).submitOwnerId, sDMSObject, (0x10L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).fireId);
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).type);
        idx_fireId_type.put(systemEnvironment, sDMSKey, sDMSObject, (0x20L & l) != 0L);
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).fireId);
        sDMSKey.add((Comparable)((Object)((SDMSTriggerGeneric)sDMSObject).name));
        idx_fireId_name.put(systemEnvironment, sDMSKey, sDMSObject, (0x40L & l) != 0L);
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).seId);
        sDMSKey.add((Comparable)((Object)((SDMSTriggerGeneric)sDMSObject).name));
        idx_seId_name.put(systemEnvironment, sDMSKey, sDMSObject, (0x80L & l) != 0L);
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).fireId);
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).seId);
        sDMSKey.add((Comparable)((Object)((SDMSTriggerGeneric)sDMSObject).name));
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).isInverse);
        idx_fireId_seId_name_isInverse.put(systemEnvironment, sDMSKey, sDMSObject, (0x100L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_fireId.remove(systemEnvironment, ((SDMSTriggerGeneric)sDMSObject).fireId, sDMSObject);
        idx_seId.remove(systemEnvironment, ((SDMSTriggerGeneric)sDMSObject).seId, sDMSObject);
        idx_mainSeId.remove(systemEnvironment, ((SDMSTriggerGeneric)sDMSObject).mainSeId, sDMSObject);
        idx_parentSeId.remove(systemEnvironment, ((SDMSTriggerGeneric)sDMSObject).parentSeId, sDMSObject);
        idx_submitOwnerId.remove(systemEnvironment, ((SDMSTriggerGeneric)sDMSObject).submitOwnerId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).fireId);
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).type);
        idx_fireId_type.remove(systemEnvironment, sDMSKey, sDMSObject);
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).fireId);
        sDMSKey.add((Comparable)((Object)((SDMSTriggerGeneric)sDMSObject).name));
        idx_fireId_name.remove(systemEnvironment, sDMSKey, sDMSObject);
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).seId);
        sDMSKey.add((Comparable)((Object)((SDMSTriggerGeneric)sDMSObject).name));
        idx_seId_name.remove(systemEnvironment, sDMSKey, sDMSObject);
        sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).fireId);
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).seId);
        sDMSKey.add((Comparable)((Object)((SDMSTriggerGeneric)sDMSObject).name));
        sDMSKey.add(((SDMSTriggerGeneric)sDMSObject).isInverse);
        idx_fireId_seId_name_isInverse.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSTrigger getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSTrigger)table.get(systemEnvironment, l);
    }

    public static SDMSTrigger getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSTrigger)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSTrigger getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSTrigger)table.get(systemEnvironment, l, l2);
    }

    public static SDMSTrigger idx_fireId_seId_name_isInverse_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSTrigger)idx_fireId_seId_name_isInverse.getUnique(systemEnvironment, object);
    }

    public static SDMSTrigger idx_fireId_seId_name_isInverse_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSTrigger)idx_fireId_seId_name_isInverse.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSTrigger idx_fireId_seId_name_isInverse_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSTrigger)idx_fireId_seId_name_isInverse.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

