/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSUserEquiv;
import de.independit.scheduler.server.repository.SDMSUserEquivTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSUserEquivGeneric
extends SDMSObject
implements Cloneable {
    public static final int USER = 0;
    public static final int SERVER = 1;
    public static final int nr_id = 1;
    public static final int nr_uId = 2;
    public static final int nr_altType = 3;
    public static final int nr_altUId = 4;
    public static final int nr_creatorUId = 5;
    public static final int nr_createTs = 6;
    public static final int nr_changerUId = 7;
    public static final int nr_changeTs = 8;
    public static String tableName = "USER_EQUIV";
    protected Long uId;
    protected Integer altType;
    protected Long altUId;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSUserEquivGeneric(SystemEnvironment systemEnvironment, Long l, Integer n, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        super(systemEnvironment, SDMSUserEquivTableGeneric.table);
        this.uId = l;
        this.altType = n;
        this.altUId = l2;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
    }

    public Long getUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.uId;
    }

    public void setUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.uId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(UserEquiv) Change of system object not allowed"));
            }
            SDMSUserEquivGeneric sDMSUserEquivGeneric = (SDMSUserEquivGeneric)this.change(systemEnvironment);
            sDMSUserEquivGeneric.uId = l;
            sDMSUserEquivGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSUserEquivGeneric.changeTs = systemEnvironment.txTime();
            sDMSUserEquivGeneric.versions.table.index(systemEnvironment, sDMSUserEquivGeneric, 5L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getAltType(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.altType;
    }

    public String getAltTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getAltType(systemEnvironment);
        switch (n) {
            case 0: {
                return "USER";
            }
            case 1: {
                return "SERVER";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown UserEquiv.altType: $1", (Object)this.getAltType(systemEnvironment)));
    }

    public void setAltType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.altType.equals(n)) {
            return;
        }
        SDMSUserEquivGeneric sDMSUserEquivGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(UserEquiv) Change of system object not allowed"));
        }
        if (sDMSUserEquivGeneric.versions.o_v == null || sDMSUserEquivGeneric.versions.o_v.size() == 0 || sDMSUserEquivGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSUserEquivGeneric = (SDMSUserEquivGeneric)this.change(systemEnvironment);
        }
        sDMSUserEquivGeneric.altType = n;
        sDMSUserEquivGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSUserEquivGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSUserEquivGeneric != this) {
            sDMSUserEquivGeneric.versions.table.index(systemEnvironment, sDMSUserEquivGeneric, 0L);
        }
    }

    public Long getAltUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.altUId;
    }

    public void setAltUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.altUId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(UserEquiv) Change of system object not allowed"));
            }
            SDMSUserEquivGeneric sDMSUserEquivGeneric = (SDMSUserEquivGeneric)this.change(systemEnvironment);
            sDMSUserEquivGeneric.altUId = l;
            sDMSUserEquivGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSUserEquivGeneric.changeTs = systemEnvironment.txTime();
            sDMSUserEquivGeneric.versions.table.index(systemEnvironment, sDMSUserEquivGeneric, 6L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSUserEquivGeneric sDMSUserEquivGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(UserEquiv) Change of system object not allowed"));
        }
        if (sDMSUserEquivGeneric.versions.o_v == null || sDMSUserEquivGeneric.versions.o_v.size() == 0 || sDMSUserEquivGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSUserEquivGeneric = (SDMSUserEquivGeneric)this.change(systemEnvironment);
        }
        sDMSUserEquivGeneric.creatorUId = l;
        sDMSUserEquivGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSUserEquivGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSUserEquivGeneric != this) {
            sDMSUserEquivGeneric.versions.table.index(systemEnvironment, sDMSUserEquivGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSUserEquivGeneric sDMSUserEquivGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(UserEquiv) Change of system object not allowed"));
        }
        if (sDMSUserEquivGeneric.versions.o_v == null || sDMSUserEquivGeneric.versions.o_v.size() == 0 || sDMSUserEquivGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSUserEquivGeneric = (SDMSUserEquivGeneric)this.change(systemEnvironment);
        }
        sDMSUserEquivGeneric.createTs = l;
        sDMSUserEquivGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSUserEquivGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSUserEquivGeneric != this) {
            sDMSUserEquivGeneric.versions.table.index(systemEnvironment, sDMSUserEquivGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSUserEquivGeneric sDMSUserEquivGeneric = this;
        if (sDMSUserEquivGeneric.versions.o_v == null || sDMSUserEquivGeneric.versions.o_v.size() == 0 || sDMSUserEquivGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSUserEquivGeneric = (SDMSUserEquivGeneric)this.change(systemEnvironment);
        }
        sDMSUserEquivGeneric.changerUId = l;
        sDMSUserEquivGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSUserEquivGeneric != this) {
            sDMSUserEquivGeneric.versions.table.index(systemEnvironment, sDMSUserEquivGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSUserEquivGeneric sDMSUserEquivGeneric = this;
        if (sDMSUserEquivGeneric.versions.o_v == null || sDMSUserEquivGeneric.versions.o_v.size() == 0 || sDMSUserEquivGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSUserEquivGeneric = (SDMSUserEquivGeneric)this.change(systemEnvironment);
        }
        sDMSUserEquivGeneric.changeTs = l;
        sDMSUserEquivGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSUserEquivGeneric != this) {
            sDMSUserEquivGeneric.versions.table.index(systemEnvironment, sDMSUserEquivGeneric, 0L);
        }
    }

    public SDMSUserEquivGeneric set_UIdAltUId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSUserEquivGeneric sDMSUserEquivGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(UserEquiv) Change of system object not allowed"));
            }
            sDMSUserEquivGeneric = (SDMSUserEquivGeneric)this.change(systemEnvironment);
            sDMSUserEquivGeneric.uId = l;
            sDMSUserEquivGeneric.altUId = l2;
            sDMSUserEquivGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSUserEquivGeneric.changeTs = systemEnvironment.txTime();
            sDMSUserEquivGeneric.versions.table.index(systemEnvironment, sDMSUserEquivGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSUserEquivGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return SDMSUserEquiv.getProxy(systemEnvironment, this);
    }

    protected SDMSUserEquivGeneric(Long l, Long l2, Integer n, Long l3, Long l4, Long l5, Long l6, Long l7, long l8, long l9) {
        this.id = l;
        this.uId = l2;
        this.altType = n;
        this.altUId = l3;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.validFrom = l8;
        this.validTo = l9;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "USER_EQUIV" + string3 + " (" + "ID" + ", " + string2 + "U_ID" + string3 + ", " + string2 + "ALT_U_TYPE" + string3 + ", " + string2 + "ALT_U_ID" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ")";
                SDMSUserEquivGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "UserEquiv: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.uId);
            preparedStatement.setInt(3, this.altType);
            preparedStatement.setLong(4, this.altUId);
            preparedStatement.setLong(5, this.creatorUId);
            preparedStatement.setLong(6, this.createTs);
            preparedStatement.setLong(7, this.changerUId);
            preparedStatement.setLong(8, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "UserEquiv: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "USER_EQUIV" + string3 + " WHERE ID = ?";
                SDMSUserEquivGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "UserEquiv: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "UserEquiv: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "USER_EQUIV" + string3 + " SET " + "" + string2 + "U_ID" + string3 + " = ? " + ", " + string2 + "ALT_U_TYPE" + string3 + " = ? " + ", " + string2 + "ALT_U_ID" + string3 + " = ? " + ", " + string2 + "CREATOR_U_ID" + string3 + " = ? " + ", " + string2 + "CREATE_TS" + string3 + " = ? " + ", " + string2 + "CHANGER_U_ID" + string3 + " = ? " + ", " + string2 + "CHANGE_TS" + string3 + " = ? " + "WHERE ID = ?";
                SDMSUserEquivGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "UserEquiv: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.uId);
            preparedStatement.setInt(2, this.altType);
            preparedStatement.setLong(3, this.altUId);
            preparedStatement.setLong(4, this.creatorUId);
            preparedStatement.setLong(5, this.createTs);
            preparedStatement.setLong(6, this.changerUId);
            preparedStatement.setLong(7, this.changeTs);
            preparedStatement.setLong(8, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "UserEquiv: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    public static boolean checkAltType(Integer n) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : UserEquiv", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "uId : " + this.uId, 2);
        SDMSThread.doTrace(null, "altType : " + this.altType, 2);
        SDMSThread.doTrace(null, "altUId : " + this.altUId, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "uId        : " + this.uId + "\n" + string + "altType    : " + this.altType + "\n" + string + "altUId     : " + this.altUId + "\n" + string + "creatorUId : " + this.creatorUId + "\n" + string + "createTs   : " + this.createTs + "\n" + string + "changerUId : " + this.changerUId + "\n" + string + "changeTs   : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

