/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserGeneric;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSUserTableGeneric
extends SDMSTable {
    public static final String tableName = "USERS";
    public static SDMSUserTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "PASSWD", "SALT", "METHOD", "IS_ENABLED", "DEFAULT_G_ID", "CONNECTION_TYPE", "DELETE_VERSION", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_name;
    public static SDMSIndex idx_name_deleteVersion;

    public SDMSUserTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "User"));
        }
        table = (SDMSUserTable)this;
        table = (SDMSUserTable)this;
        this.isVersioned = false;
        idx_name = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "name");
        idx_name_deleteVersion = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "name_deleteVersion");
    }

    public SDMSUser create(SystemEnvironment systemEnvironment, String string, String string2, String string3, Integer n, Boolean bl, Long l, Integer n2, Long l2) throws SDMSException {
        SDMSUser sDMSUser;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "User"));
        }
        this.validate(systemEnvironment, string, string2, string3, n, bl, l, n2, l2, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSUserGeneric sDMSUserGeneric = new SDMSUserGeneric(systemEnvironment, string, string2, string3, n, bl, l, n2, l2, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSUserGeneric.versions, true);
            table.put(systemEnvironment, sDMSUserGeneric.id, sDMSUserGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSUser = (SDMSUser)sDMSUserGeneric.toProxy(systemEnvironment);
            sDMSUser.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSUser sDMSUser2 = (SDMSUser)sDMSUserGeneric.toProxy(systemEnvironment);
            sDMSUser2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSUser)) {
            throw new AccessViolationException(sDMSUser.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSUser;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSUser sDMSUser) throws SDMSException {
        return sDMSUser.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, String string2, String string3, Integer n, Boolean bl, Long l, Integer n2, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        if (!SDMSUserGeneric.checkMethod(n)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "User: $1 $2", (Object)"method", (Object)n));
        }
        if (!SDMSUserGeneric.checkConnectionType(n2)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "User: $1 $2", (Object)"connectionType", (Object)n2));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Integer n;
        Long l8;
        Boolean bl;
        Integer n2;
        String string;
        String string2;
        String string3;
        Long l9;
        try {
            l9 = new Long(resultSet.getLong(1));
            string3 = resultSet.getString(2);
            string2 = resultSet.getString(3);
            string = resultSet.getString(4);
            if (resultSet.wasNull()) {
                string = null;
            }
            n2 = new Integer(resultSet.getInt(5));
            bl = new Boolean(resultSet.getInt(6) != 0);
            l8 = new Long(resultSet.getLong(7));
            n = new Integer(resultSet.getInt(8));
            l7 = new Long(resultSet.getLong(9));
            l6 = new Long(resultSet.getLong(10));
            l5 = new Long(resultSet.getLong(11));
            l4 = new Long(resultSet.getLong(12));
            l3 = new Long(resultSet.getLong(13));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "User: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSUserGeneric(l9, string3, string2, string, n2, bl, l8, n, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "NAME" + string2 + ", " + string + "PASSWD" + string2 + ", " + string + "SALT" + string2 + ", " + string + "METHOD" + string2 + ", " + string + "IS_ENABLED" + string2 + ", " + string + "DEFAULT_G_ID" + string2 + ", " + string + "CONNECTION_TYPE" + string2 + ", " + string + "DELETE_VERSION" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_name.check(((SDMSUserGeneric)sDMSObject).name, sDMSObject);
        string = string + "idx_name: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)((SDMSUserGeneric)sDMSObject).name));
        sDMSKey.add(((SDMSUserGeneric)sDMSObject).deleteVersion);
        bl = idx_name_deleteVersion.check(sDMSKey, sDMSObject);
        string = string + "idx_name_deleteVersion: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_name.put(systemEnvironment, ((SDMSUserGeneric)sDMSObject).name, sDMSObject, (1L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)((SDMSUserGeneric)sDMSObject).name));
        sDMSKey.add(((SDMSUserGeneric)sDMSObject).deleteVersion);
        idx_name_deleteVersion.put(systemEnvironment, sDMSKey, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_name.remove(systemEnvironment, ((SDMSUserGeneric)sDMSObject).name, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)((SDMSUserGeneric)sDMSObject).name));
        sDMSKey.add(((SDMSUserGeneric)sDMSObject).deleteVersion);
        idx_name_deleteVersion.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSUser getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSUser)table.get(systemEnvironment, l);
    }

    public static SDMSUser getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSUser)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSUser getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSUser)table.get(systemEnvironment, l, l2);
    }

    public static SDMSUser idx_name_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSUser)idx_name.getUnique(systemEnvironment, object);
    }

    public static SDMSUser idx_name_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSUser)idx_name.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSUser idx_name_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSUser)idx_name.getUnique(systemEnvironment, object, l);
    }

    public static SDMSUser idx_name_deleteVersion_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSUser)idx_name_deleteVersion.getUnique(systemEnvironment, object);
    }

    public static SDMSUser idx_name_deleteVersion_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSUser)idx_name_deleteVersion.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSUser idx_name_deleteVersion_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSUser)idx_name_deleteVersion.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

