/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.util;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SerializationException;
import de.independit.scheduler.server.repository.SDMSUserProxyGeneric;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AuditWriter {
    public static final String __version = "@(#) $Id: AuditWriter.java,v 2.1.8.1 2013/03/14 10:25:28 ronald Exp $";
    private static final SimpleDateFormat sysDateFmt = (SimpleDateFormat)SystemEnvironment.staticSystemDateFormat.clone();
    private static PrintStream audit = null;

    private static void openAuditFile(SystemEnvironment systemEnvironment) throws IOException {
        int n = 0;
        File file = new File(SystemEnvironment.auditFile);
        String string = file.getParent();
        String string2 = file.getName() + ".";
        String[] stringArray = new File(string).list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string2)) continue;
            String string3 = stringArray[i].substring(string2.length());
            try {
                int n2 = Integer.parseInt(string3);
                if (n2 <= n) continue;
                n = n2;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        string2 = string2 + ++n;
        File file2 = new File(string, string2);
        audit = new PrintStream(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getHeader(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Object object;
        Object object2;
        String string = null;
        if (systemEnvironment.cEnv != null) {
            object2 = systemEnvironment.cEnv.uid();
            if (object2 != null) {
                try {
                    object = SDMSUserTable.getObject(systemEnvironment, (Long)object2);
                    string = ((SDMSUserProxyGeneric)object).getName(systemEnvironment);
                }
                catch (NotFoundException notFoundException) {
                    string = systemEnvironment.cEnv.name() + "(" + object2 + ")";
                }
            } else {
                string = systemEnvironment.cEnv.name();
            }
        } else {
            string = "Unknown";
        }
        object2 = "" + l + "\t" + string;
        object = sysDateFmt;
        synchronized (object) {
            return (String)object2 + "\t[" + sysDateFmt.format(new Date(System.currentTimeMillis())) + "]\t";
        }
    }

    public static void write(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        try {
            if (audit == null) {
                AuditWriter.openAuditFile(systemEnvironment);
            }
            audit.println(AuditWriter.getHeader(systemEnvironment, l) + string);
        }
        catch (IOException iOException) {
            if (audit != null) {
                audit.close();
                audit = null;
            }
        }
        catch (SerializationException serializationException) {
            throw serializationException;
        }
        catch (SDMSException sDMSException) {
            // empty catch block
        }
    }
}

