/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.util;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSMessage;

public class Lockmode {
    public static final String __version = "@(#) $Id: Lockmode.java,v 2.2.18.1 2013/03/14 10:25:29 ronald Exp $";
    private int mode;
    public static final String Nolock = "N";
    public static final String Shared = "S";
    public static final String SharedExcl = "SX";
    public static final String SharedComp = "SC";
    public static final String Exclusive = "X";
    public static final int X = 0;
    public static final int SX = 2;
    public static final int S = 4;
    public static final int SC = 6;
    public static final int N = 255;

    public Lockmode() {
        this.mode = 255;
    }

    public Lockmode(SystemEnvironment systemEnvironment, int n) throws CommonErrorException {
        if (n != 0 && n != 2 && n != 4 && n != 6 && n != 255) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03110181507", "Invalid Lockmode $1", (Object)new Integer(n)));
        }
        this.mode = n;
    }

    public Lockmode(int n) {
        this.mode = 255;
        if (n == 0 || n == 2 || n == 4 || n == 6 || n == 255) {
            this.mode = n;
        }
    }

    public int getLockmode() {
        return this.mode;
    }

    public int setLockmode(int n) {
        int n2 = this.mode;
        if (n == 0 || n == 2 || n == 4 || n == 6 || n == 255) {
            this.mode = n;
        }
        return n2;
    }

    public int setLockmode(Lockmode lockmode) {
        int n = this.mode;
        this.mode = lockmode.mode;
        return n;
    }

    public int setLockmode(SystemEnvironment systemEnvironment, int n) throws CommonErrorException {
        int n2 = this.mode;
        if (n != 0 && n != 2 && n != 4 && n != 6 && n != 255) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03308061033", "Invalid Lockmode $1", (Object)new Integer(n)));
        }
        this.mode = n;
        return n2;
    }

    public String str(SystemEnvironment systemEnvironment) throws FatalException {
        switch (this.mode) {
            case 0: {
                return Exclusive;
            }
            case 2: {
                return SharedExcl;
            }
            case 4: {
                return Shared;
            }
            case 6: {
                return SharedComp;
            }
            case 255: {
                return Nolock;
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "03110181508", "Invalid internal State $1", (Object)new Integer(this.mode)));
    }

    public static boolean isCompatible(Lockmode lockmode, Lockmode lockmode2) {
        return ((lockmode.mode | 0x80) & (lockmode2.mode | 0x40)) > 0;
    }

    public static boolean isCompatible(Integer n, Lockmode lockmode) {
        return ((n | 0x80) & (lockmode.mode | 0x40)) > 0;
    }

    public static boolean isCompatible(Lockmode lockmode, Integer n) {
        return ((lockmode.mode | 0x80) & (n | 0x40)) > 0;
    }

    public static boolean isCompatible(Integer n, Integer n2) {
        return ((n | 0x80) & (n2 | 0x40)) > 0;
    }
}

