-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE OBJECT_INSTANCE (
    ID                             bigint NOT NULL
    , UNIQUE_NAME                    lvarchar(256)   NOT NULL
    , OM_ID                          bigint          NOT NULL
    , MODIFY_TS                      bigint              NULL
    , REMOVE_TS                      bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_OBJECT_INSTANCE
ON OBJECT_INSTANCE(ID);
CREATE VIEW SCI_OBJECT_INSTANCE (ID,UNIQUE_NAME,OM_ID,MODIFY_TS,REMOVE_TS,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , UNIQUE_NAME                    AS UNIQUE_NAME
    , OM_ID                          AS OM_ID
    , dbinfo ('utc_to_datetime', round(mod(MODIFY_TS, 1125899906842624)/1000)) AS MODIFY_TS
    , dbinfo ('utc_to_datetime', round(mod(REMOVE_TS, 1125899906842624)/1000)) AS REMOVE_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM OBJECT_INSTANCE;
