-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE OBJECT_MONITOR (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , WT_ID                          bigint          NOT NULL
    , RECREATE_HANDLING              int8            NOT NULL
    , WATCH_SE_ID                    bigint              NULL
    , DELETE_AMOUNT                  int8                NULL
    , DELETE_BASE                    int8                NULL
    , EVENT_DELETE_AMOUNT            int8                NULL
    , EVENT_DELETE_BASE              int8                NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_OBJECT_MONITOR
ON OBJECT_MONITOR(ID);
CREATE VIEW SCI_OBJECT_MONITOR (ID,NAME,OWNER_ID,WT_ID,RECREATE_HANDLING,WATCH_SE_ID,DELETE_AMOUNT,DELETE_BASE,EVENT_DELETE_AMOUNT,EVENT_DELETE_BASE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , WT_ID                          AS WT_ID
    , DECODE (RECREATE_HANDLING, 0, 'NONE', 1, 'CREATE', 2, 'CHANGE') AS RECREATE_HANDLING
    , WATCH_SE_ID                    AS WATCH_SE_ID
    , DELETE_AMOUNT                  AS DELETE_AMOUNT
    , DECODE (DELETE_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS DELETE_BASE
    , EVENT_DELETE_AMOUNT            AS EVENT_DELETE_AMOUNT
    , DECODE (EVENT_DELETE_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EVENT_DELETE_BASE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM OBJECT_MONITOR;
