-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE USERS (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , PASSWD                         lvarchar(64)    NOT NULL
    , SALT                           lvarchar(64)        NULL
    , METHOD                         int8            NOT NULL
    , IS_ENABLED                     integer         NOT NULL
    , DEFAULT_G_ID                   bigint          NOT NULL
    , CONNECTION_TYPE                int8            NOT NULL
    , DELETE_VERSION                 bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_USERS
ON USERS(ID);
CREATE VIEW SCI_USERS (ID,NAME,IS_ENABLED,DEFAULT_G_ID,CONNECTION_TYPE,DELETE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DEFAULT_G_ID                   AS DEFAULT_G_ID
    , DECODE (CONNECTION_TYPE, 0, 'PLAIN', 1, 'SSL', 2, 'SSL_AUTH') AS CONNECTION_TYPE
    , DELETE_VERSION                 AS DELETE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM USERS;
