ALTER TABLE OBJECT_COMMENT ADD (
    TAG lvarchar(64)
);
DROP VIEW SCI_C_OBJECT_COMMENT;
DROP VIEW SCI_V_OBJECT_COMMENT;
CREATE VIEW SCI_C_OBJECT_COMMENT (ID,OBJECT_ID,OBJECT_TYPE,INFO_TYPE,SEQUENCE_NUMBER,TAG,DESCRIPTION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , OBJECT_ID                      AS OBJECT_ID
    , DECODE (OBJECT_TYPE, 9, 'JOB_DEFINITION', 2, 'EXIT_STATE_DEFINITION', 3, 'EXIT_STATE_PROFILE', 4, 'EXIT_STATE_MAPPING', 5, 'EXIT_STATE_TRANSLATION', 6, 'FOLDER', 15, 'SCOPE', 10, 'NAMED_RESOURCE', 31, 'NICE_PROFILE', 11, 'RESOURCE', 1, 'ENVIRONMENT', 7, 'FOOTPRINT', 13, 'RESOURCE_STATE_DEFINITION', 14, 'RESOURCE_STATE_PROFILE', 12, 'RESOURCE_STATE_MAPPING', 8, 'USER', 16, 'TRIGGER', 17, 'JOB', 18, 'EVENT', 19, 'INTERVAL', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 21, 'GROUP', 23, 'PARAMETER', 24, 'POOL', 25, 'DISTRIBUTION', 29, 'WATCH_TYPE', 30, 'OBJECT_MONITOR') AS OBJECT_TYPE
    , DECODE (INFO_TYPE, 0, 'TEXT', 1, 'URL') AS INFO_TYPE
    , SEQUENCE_NUMBER                AS SEQUENCE_NUMBER
    , TAG                            AS TAG
    , DESCRIPTION                    AS DESCRIPTION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM OBJECT_COMMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_OBJECT_COMMENT (ID,OBJECT_ID,OBJECT_TYPE,INFO_TYPE,SEQUENCE_NUMBER,TAG,DESCRIPTION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , OBJECT_ID                      AS OBJECT_ID
    , DECODE (OBJECT_TYPE, 9, 'JOB_DEFINITION', 2, 'EXIT_STATE_DEFINITION', 3, 'EXIT_STATE_PROFILE', 4, 'EXIT_STATE_MAPPING', 5, 'EXIT_STATE_TRANSLATION', 6, 'FOLDER', 15, 'SCOPE', 10, 'NAMED_RESOURCE', 31, 'NICE_PROFILE', 11, 'RESOURCE', 1, 'ENVIRONMENT', 7, 'FOOTPRINT', 13, 'RESOURCE_STATE_DEFINITION', 14, 'RESOURCE_STATE_PROFILE', 12, 'RESOURCE_STATE_MAPPING', 8, 'USER', 16, 'TRIGGER', 17, 'JOB', 18, 'EVENT', 19, 'INTERVAL', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 21, 'GROUP', 23, 'PARAMETER', 24, 'POOL', 25, 'DISTRIBUTION', 29, 'WATCH_TYPE', 30, 'OBJECT_MONITOR') AS OBJECT_TYPE
    , DECODE (INFO_TYPE, 0, 'TEXT', 1, 'URL') AS INFO_TYPE
    , SEQUENCE_NUMBER                AS SEQUENCE_NUMBER
    , TAG                            AS TAG
    , DESCRIPTION                    AS DESCRIPTION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM OBJECT_COMMENT;
ALTER TABLE PARAMETER_DEFINITION ADD (
    EXPORT_NAME lvarchar(64)
);
DROP VIEW SCI_C_PARAMETER_DEFINITION;
DROP VIEW SCI_V_PARAMETER_DEFINITION;
CREATE VIEW SCI_C_PARAMETER_DEFINITION (ID,SE_ID,NAME,TYPE,AGG_FUNCTION,DEFAULTVALUE,IS_LOCAL,LINK_PD_ID,EXPORT_NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , NAME                           AS NAME
    , DECODE (TYPE, 10, 'REFERENCE', 20, 'CHILDREFERENCE', 30, 'CONSTANT', 40, 'RESULT', 50, 'PARAMETER', 60, 'EXPRESSION', 70, 'IMPORT', 80, 'DYNAMIC', 81, 'DYNAMICVALUE', 90, 'LOCAL_CONSTANT', 91, 'RESOURCEREFERENCE') AS TYPE
    , DECODE (AGG_FUNCTION, 0, 'NONE', 61, 'AVG', 62, 'COUNT', 63, 'MIN', 64, 'MAX', 65, 'SUM') AS AGG_FUNCTION
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , LINK_PD_ID                     AS LINK_PD_ID
    , EXPORT_NAME                    AS EXPORT_NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM PARAMETER_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_PARAMETER_DEFINITION (ID,SE_ID,NAME,TYPE,AGG_FUNCTION,DEFAULTVALUE,IS_LOCAL,LINK_PD_ID,EXPORT_NAME,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , NAME                           AS NAME
    , DECODE (TYPE, 10, 'REFERENCE', 20, 'CHILDREFERENCE', 30, 'CONSTANT', 40, 'RESULT', 50, 'PARAMETER', 60, 'EXPRESSION', 70, 'IMPORT', 80, 'DYNAMIC', 81, 'DYNAMICVALUE', 90, 'LOCAL_CONSTANT', 91, 'RESOURCEREFERENCE') AS TYPE
    , DECODE (AGG_FUNCTION, 0, 'NONE', 61, 'AVG', 62, 'COUNT', 63, 'MIN', 64, 'MAX', 65, 'SUM') AS AGG_FUNCTION
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , LINK_PD_ID                     AS LINK_PD_ID
    , EXPORT_NAME                    AS EXPORT_NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM PARAMETER_DEFINITION;
ALTER TABLE SCHEDULING_HIERARCHY ADD (
    IS_DISABLED integer DEFAULT 0 NOT NULL
);
DROP VIEW SCI_C_SCHEDULING_HIERARCHY;
DROP VIEW SCI_V_SCHEDULING_HIERARCHY;
CREATE VIEW SCI_C_SCHEDULING_HIERARCHY (ID,SE_PARENT_ID,SE_CHILD_ID,ALIAS_NAME,IS_STATIC,IS_DISABLED,PRIORITY,SUSPEND,RESUME_AT,RESUME_IN,RESUME_BASE,MERGE_MODE,ESTP_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SE_PARENT_ID                   AS SE_PARENT_ID
    , SE_CHILD_ID                    AS SE_CHILD_ID
    , ALIAS_NAME                     AS ALIAS_NAME
    , DECODE (IS_STATIC, 1, 'STATIC', 0, 'DYNAMIC') AS IS_STATIC
    , DECODE (IS_DISABLED, 0, 'ENABLED', 1, 'DISABLED') AS IS_DISABLED
    , PRIORITY                       AS PRIORITY
    , DECODE (SUSPEND, 1, 'CHILDSUSPEND', 2, 'NOSUSPEND', 3, 'SUSPEND') AS SUSPEND
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , ESTP_ID                        AS ESTP_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SCHEDULING_HIERARCHY
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_SCHEDULING_HIERARCHY (ID,SE_PARENT_ID,SE_CHILD_ID,ALIAS_NAME,IS_STATIC,IS_DISABLED,PRIORITY,SUSPEND,RESUME_AT,RESUME_IN,RESUME_BASE,MERGE_MODE,ESTP_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , SE_PARENT_ID                   AS SE_PARENT_ID
    , SE_CHILD_ID                    AS SE_CHILD_ID
    , ALIAS_NAME                     AS ALIAS_NAME
    , DECODE (IS_STATIC, 1, 'STATIC', 0, 'DYNAMIC') AS IS_STATIC
    , DECODE (IS_DISABLED, 0, 'ENABLED', 1, 'DISABLED') AS IS_DISABLED
    , PRIORITY                       AS PRIORITY
    , DECODE (SUSPEND, 1, 'CHILDSUSPEND', 2, 'NOSUSPEND', 3, 'SUSPEND') AS SUSPEND
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , ESTP_ID                        AS ESTP_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM SCHEDULING_HIERARCHY;
ALTER TABLE SUBMITTED_ENTITY ADD (
    IS_DISABLED integer DEFAULT 0 NOT NULL,
    OLD_STATE int8
);
ALTER TABLE ARC_SUBMITTED_ENTITY ADD (
    IS_DISABLED integer,
    OLD_STATE int8
);
DROP VIEW SCI_SUBMITTED_ENTITY;
CREATE VIEW SCI_SUBMITTED_ENTITY (ID,MASTER_ID,SUBMIT_TAG,UNRESOLVED_HANDLING,SE_ID,CHILD_TAG,SE_VERSION,OWNER_ID,PARENT_ID,SCOPE_ID,IS_STATIC,IS_DISABLED,OLD_STATE,MERGE_MODE,STATE,JOB_ESD_ID,JOB_ESD_PREF,JOB_IS_FINAL,JOB_IS_RESTARTABLE,FINAL_ESD_ID,EXIT_CODE,COMMANDLINE,RR_COMMANDLINE,RERUN_SEQ,IS_REPLACED,IS_CANCELLED,BASE_SME_ID,REASON_SME_ID,FIRE_SME_ID,FIRE_SE_ID,TR_ID,TR_SD_ID_OLD,TR_SD_ID_NEW,TR_SEQ,WORKDIR,LOGFILE,ERRLOGFILE,PID,EXTPID,ERROR_MSG,KILL_ID,KILL_EXIT_CODE,IS_SUSPENDED,IS_SUSPENDED_LOCAL,PRIORITY,RAW_PRIORITY,NICE,NP_NICE,MIN_PRIORITY,AGING_AMOUNT,PARENT_SUSPENDED,CHILD_SUSPENDED,WARN_COUNT,WARN_LINK,SUBMIT_TS,RESUME_TS,SYNC_TS,RESOURCE_TS,RUNNABLE_TS,START_TS,FINSH_TS,FINAL_TS,IDLE_TIME,DEPENDENCY_WAIT_TIME,SUSPEND_TIME,SYNC_TIME,RESOURCE_TIME,JOBSERVER_TIME,RESTARTABLE_TIME,CHILD_WAIT_TIME,OP_SUSRES_TS,NPE_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS,PROCESS_TIME) AS
SELECT 
    ID 
    , MASTER_ID                      AS MASTER_ID
    , SUBMIT_TAG                     AS SUBMIT_TAG
    , DECODE (UNRESOLVED_HANDLING, 1, 'UH_IGNORE', 3, 'UH_SUSPEND', 2, 'UH_ERROR') AS UNRESOLVED_HANDLING
    , SE_ID                          AS SE_ID
    , CHILD_TAG                      AS CHILD_TAG
    , SE_VERSION                     AS SE_VERSION
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , SCOPE_ID                       AS SCOPE_ID
    , DECODE (IS_STATIC, 1, 'TRUE', 0, 'FALSE') AS IS_STATIC
    , DECODE (IS_DISABLED, 1, 'TRUE', 0, 'FALSE') AS IS_DISABLED
    , OLD_STATE                      AS OLD_STATE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , DECODE (STATE, 0, 'SUBMITTED', 1, 'DEPENDENCY_WAIT', 2, 'SYNCHRONIZE_WAIT', 3, 'RESOURCE_WAIT', 4, 'RUNNABLE', 5, 'STARTING', 6, 'STARTED', 7, 'RUNNING', 8, 'TO_KILL', 9, 'KILLED', 10, 'CANCELLED', 11, 'FINISHED', 12, 'FINAL', 13, 'BROKEN_ACTIVE', 14, 'BROKEN_FINISHED', 15, 'ERROR', 16, 'UNREACHABLE') AS STATE
    , JOB_ESD_ID                     AS JOB_ESD_ID
    , JOB_ESD_PREF                   AS JOB_ESD_PREF
    , DECODE (JOB_IS_FINAL, 1, 'TRUE', 0, 'FALSE') AS JOB_IS_FINAL
    , DECODE (JOB_IS_RESTARTABLE, 1, 'TRUE', 0, 'FALSE') AS JOB_IS_RESTARTABLE
    , FINAL_ESD_ID                   AS FINAL_ESD_ID
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , RR_COMMANDLINE                 AS RR_COMMANDLINE
    , RERUN_SEQ                      AS RERUN_SEQ
    , DECODE (IS_REPLACED, 1, 'TRUE', 0, 'FALSE') AS IS_REPLACED
    , DECODE (IS_CANCELLED, 1, 'TRUE', 0, 'FALSE') AS IS_CANCELLED
    , BASE_SME_ID                    AS BASE_SME_ID
    , REASON_SME_ID                  AS REASON_SME_ID
    , FIRE_SME_ID                    AS FIRE_SME_ID
    , FIRE_SE_ID                     AS FIRE_SE_ID
    , TR_ID                          AS TR_ID
    , TR_SD_ID_OLD                   AS TR_SD_ID_OLD
    , TR_SD_ID_NEW                   AS TR_SD_ID_NEW
    , TR_SEQ                         AS TR_SEQ
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , PID                            AS PID
    , EXTPID                         AS EXTPID
    , ERROR_MSG                      AS ERROR_MSG
    , KILL_ID                        AS KILL_ID
    , KILL_EXIT_CODE                 AS KILL_EXIT_CODE
    , DECODE (IS_SUSPENDED, 2, 'ADMINSUSPEND', 1, 'SUSPEND', 0, 'NOSUSPEND') AS IS_SUSPENDED
    , DECODE (IS_SUSPENDED_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_SUSPENDED_LOCAL
    , PRIORITY                       AS PRIORITY
    , RAW_PRIORITY                   AS RAW_PRIORITY
    , NICE                           AS NICE
    , NP_NICE                        AS NP_NICE
    , MIN_PRIORITY                   AS MIN_PRIORITY
    , AGING_AMOUNT                   AS AGING_AMOUNT
    , PARENT_SUSPENDED               AS PARENT_SUSPENDED
    , CHILD_SUSPENDED                AS CHILD_SUSPENDED
    , WARN_COUNT                     AS WARN_COUNT
    , WARN_LINK                      AS WARN_LINK
    , dbinfo ('utc_to_datetime', round(mod(SUBMIT_TS, 1125899906842624)/1000)) AS SUBMIT_TS
    , dbinfo ('utc_to_datetime', round(mod(RESUME_TS, 1125899906842624)/1000)) AS RESUME_TS
    , dbinfo ('utc_to_datetime', round(mod(SYNC_TS, 1125899906842624)/1000)) AS SYNC_TS
    , dbinfo ('utc_to_datetime', round(mod(RESOURCE_TS, 1125899906842624)/1000)) AS RESOURCE_TS
    , dbinfo ('utc_to_datetime', round(mod(RUNNABLE_TS, 1125899906842624)/1000)) AS RUNNABLE_TS
    , dbinfo ('utc_to_datetime', round(mod(START_TS, 1125899906842624)/1000)) AS START_TS
    , dbinfo ('utc_to_datetime', round(mod(FINSH_TS, 1125899906842624)/1000)) AS FINSH_TS
    , dbinfo ('utc_to_datetime', round(mod(FINAL_TS, 1125899906842624)/1000)) AS FINAL_TS
    , IDLE_TIME                      AS IDLE_TIME
    , DEPENDENCY_WAIT_TIME           AS DEPENDENCY_WAIT_TIME
    , SUSPEND_TIME                   AS SUSPEND_TIME
    , SYNC_TIME                      AS SYNC_TIME
    , RESOURCE_TIME                  AS RESOURCE_TIME
    , JOBSERVER_TIME                 AS JOBSERVER_TIME
    , RESTARTABLE_TIME               AS RESTARTABLE_TIME
    , CHILD_WAIT_TIME                AS CHILD_WAIT_TIME
    , OP_SUSRES_TS                   AS OP_SUSRES_TS
    , NPE_ID                         AS NPE_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , ((NVL(FINAL_TS, dbinfo ('utc_current') * 1000) - SUBMIT_TS) / 1000) - DEPENDENCY_WAIT_TIME AS PROCESS_TIME
  FROM SUBMITTED_ENTITY;
ALTER TABLE TRIGGER_DEFINITION ADD (
    IS_INVERSE integer DEFAULT 0 NOT NULL,
    LIMIT_STATE bigint
);
DROP VIEW SCI_C_TRIGGER_DEFINITION;
DROP VIEW SCI_V_TRIGGER_DEFINITION;
CREATE VIEW SCI_C_TRIGGER_DEFINITION (ID,NAME,FIRE_ID,OBJECT_TYPE,SE_ID,MAIN_SE_ID,PARENT_SE_ID,IS_ACTIVE,IS_INVERSE,ACTION,TYPE,IS_MASTER,IS_SUSPEND,IS_CREATE,IS_CHANGE,IS_DELETE,IS_GROUP,RESUME_AT,RESUME_IN,RESUME_BASE,IS_WARN_ON_LIMIT,LIMIT_STATE,MAX_RETRY,SUBMIT_OWNER_ID,CONDITION,CHECK_AMOUNT,CHECK_BASE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , FIRE_ID                        AS FIRE_ID
    , DECODE (OBJECT_TYPE, 0, 'JOB_DEFINITION', 1, 'RESOURCE', 2, 'NAMED_RESOURCE', 3, 'OBJECT_MONITOR') AS OBJECT_TYPE
    , SE_ID                          AS SE_ID
    , MAIN_SE_ID                     AS MAIN_SE_ID
    , PARENT_SE_ID                   AS PARENT_SE_ID
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , DECODE (IS_INVERSE, 1, 'TRUE', 0, 'FALSE') AS IS_INVERSE
    , DECODE (ACTION, 0, 'SUBMIT', 1, 'RERUN') AS ACTION
    , DECODE (TYPE, 0, 'IMMEDIATE_LOCAL', 2, 'BEFORE_FINAL', 3, 'AFTER_FINAL', 1, 'IMMEDIATE_MERGE', 4, 'FINISH_CHILD', 5, 'UNTIL_FINISHED', 6, 'UNTIL_FINAL', 7, 'WARNING') AS TYPE
    , DECODE (IS_MASTER, 1, 'MASTER', 0, 'NOMASTER') AS IS_MASTER
    , DECODE (IS_SUSPEND, 1, 'SUSPEND', 0, 'NOSUSPEND') AS IS_SUSPEND
    , DECODE (IS_CREATE, 1, 'TRUE', 0, 'FALSE') AS IS_CREATE
    , DECODE (IS_CHANGE, 1, 'TRUE', 0, 'FALSE') AS IS_CHANGE
    , DECODE (IS_DELETE, 1, 'TRUE', 0, 'FALSE') AS IS_DELETE
    , DECODE (IS_GROUP, 1, 'TRUE', 0, 'FALSE') AS IS_GROUP
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (IS_WARN_ON_LIMIT, 1, 'TRUE', 0, 'FALSE') AS IS_WARN_ON_LIMIT
    , LIMIT_STATE                    AS LIMIT_STATE
    , MAX_RETRY                      AS MAX_RETRY
    , SUBMIT_OWNER_ID                AS SUBMIT_OWNER_ID
    , CONDITION                      AS CONDITION
    , CHECK_AMOUNT                   AS CHECK_AMOUNT
    , DECODE (CHECK_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS CHECK_BASE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM TRIGGER_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_TRIGGER_DEFINITION (ID,NAME,FIRE_ID,OBJECT_TYPE,SE_ID,MAIN_SE_ID,PARENT_SE_ID,IS_ACTIVE,IS_INVERSE,ACTION,TYPE,IS_MASTER,IS_SUSPEND,IS_CREATE,IS_CHANGE,IS_DELETE,IS_GROUP,RESUME_AT,RESUME_IN,RESUME_BASE,IS_WARN_ON_LIMIT,LIMIT_STATE,MAX_RETRY,SUBMIT_OWNER_ID,CONDITION,CHECK_AMOUNT,CHECK_BASE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , FIRE_ID                        AS FIRE_ID
    , DECODE (OBJECT_TYPE, 0, 'JOB_DEFINITION', 1, 'RESOURCE', 2, 'NAMED_RESOURCE', 3, 'OBJECT_MONITOR') AS OBJECT_TYPE
    , SE_ID                          AS SE_ID
    , MAIN_SE_ID                     AS MAIN_SE_ID
    , PARENT_SE_ID                   AS PARENT_SE_ID
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , DECODE (IS_INVERSE, 1, 'TRUE', 0, 'FALSE') AS IS_INVERSE
    , DECODE (ACTION, 0, 'SUBMIT', 1, 'RERUN') AS ACTION
    , DECODE (TYPE, 0, 'IMMEDIATE_LOCAL', 2, 'BEFORE_FINAL', 3, 'AFTER_FINAL', 1, 'IMMEDIATE_MERGE', 4, 'FINISH_CHILD', 5, 'UNTIL_FINISHED', 6, 'UNTIL_FINAL', 7, 'WARNING') AS TYPE
    , DECODE (IS_MASTER, 1, 'MASTER', 0, 'NOMASTER') AS IS_MASTER
    , DECODE (IS_SUSPEND, 1, 'SUSPEND', 0, 'NOSUSPEND') AS IS_SUSPEND
    , DECODE (IS_CREATE, 1, 'TRUE', 0, 'FALSE') AS IS_CREATE
    , DECODE (IS_CHANGE, 1, 'TRUE', 0, 'FALSE') AS IS_CHANGE
    , DECODE (IS_DELETE, 1, 'TRUE', 0, 'FALSE') AS IS_DELETE
    , DECODE (IS_GROUP, 1, 'TRUE', 0, 'FALSE') AS IS_GROUP
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (IS_WARN_ON_LIMIT, 1, 'TRUE', 0, 'FALSE') AS IS_WARN_ON_LIMIT
    , LIMIT_STATE                    AS LIMIT_STATE
    , MAX_RETRY                      AS MAX_RETRY
    , SUBMIT_OWNER_ID                AS SUBMIT_OWNER_ID
    , CONDITION                      AS CONDITION
    , CHECK_AMOUNT                   AS CHECK_AMOUNT
    , DECODE (CHECK_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS CHECK_BASE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM TRIGGER_DEFINITION;
ALTER TABLE EXIT_STATE_MAPPING MODIFY (ECR_START BIGINT);
ALTER TABLE EXIT_STATE_MAPPING MODIFY (ECR_END BIGINT);
