-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE NAMED_RESOURCE (
    ID                             decimal(20) NOT NULL
    , NAME                           varchar(64)     NOT NULL
    , OWNER_ID                       decimal(20)     NOT NULL
    , PARENT_ID                      decimal(20)     WITH NULL
    , USAGE                          integer         NOT NULL
    , RSP_ID                         decimal(20)     WITH NULL
    , FACTOR                         float           WITH NULL
    , CREATOR_U_ID                   decimal(20)     NOT NULL
    , CREATE_TS                      decimal(20)     NOT NULL
    , CHANGER_U_ID                   decimal(20)     NOT NULL
    , CHANGE_TS                      decimal(20)     NOT NULL
    , INHERIT_PRIVS                  decimal(20)     NOT NULL
);\g
CREATE UNIQUE INDEX PK_NAMED_RESOURCE
ON NAMED_RESOURCE(ID) WITH STRUCTURE = BTREE;\g
CREATE VIEW SCI_NAMED_RESOURCE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , CASE USAGE WHEN 1 THEN 'STATIC' WHEN 2 THEN 'SYSTEM' WHEN 4 THEN 'SYNCHRONIZING' WHEN 8 THEN 'CATEGORY' WHEN 3 THEN 'POOL' END AS USAGE
    , RSP_ID                         AS RSP_ID
    , FACTOR                         AS FACTOR
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , '01-JAN-1970 00:00:00 GMT' + date(char(decimal((CREATE_TS- decimal(CREATE_TS/1125899906842624, 18, 0)*1125899906842624)/1000, 18, 0)) + ' secs') AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , '01-JAN-1970 00:00:00 GMT' + date(char(decimal((CHANGE_TS- decimal(CHANGE_TS/1125899906842624, 18, 0)*1125899906842624)/1000, 18, 0)) + ' secs') AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM NAMED_RESOURCE;\g
