-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [INTERVAL_DISPATCHER] (
    [ID]                           decimal (38) NOT NULL
    , [INT_ID]                       decimal (38)    NOT NULL
    , [SEQ_NO]                       integer         NOT NULL
    , [NAME]                         varchar(64)     NOT NULL
    , [SELECT_INT_ID]                decimal (38)        NULL
    , [FILTER_INT_ID]                decimal (38)        NULL
    , [IS_ENABLED]                   integer         NOT NULL
    , [IS_ACTIVE]                    integer         NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_INTERVAL_DISPATCHER
ON [INTERVAL_DISPATCHER]([ID]);
go
CREATE VIEW SCI_INTERVAL_DISPATCHER AS
SELECT 
    ID 
    , [INT_ID]                       AS [INT_ID]
    , [SEQ_NO]                       AS [SEQ_NO]
    , [NAME]                         AS [NAME]
    , [SELECT_INT_ID]                AS [SELECT_INT_ID]
    , [FILTER_INT_ID]                AS [FILTER_INT_ID]
    , CASE [IS_ENABLED] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IS_ENABLED]
    , CASE [IS_ACTIVE] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IS_ACTIVE]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [INTERVAL_DISPATCHER];
go
