ALTER TABLE [ENTITY_VARIABLE] ADD
    [IS_LONG] integer NOT NULL DEFAULT 0;
go
ALTER TABLE [ARC_ENTITY_VARIABLE] ADD
    [IS_LONG] integer;
go
DROP VIEW SCI_ENTITY_VARIABLE;
go
CREATE VIEW SCI_ENTITY_VARIABLE AS
SELECT 
    ID 
    , [SME_ID]                       AS [SME_ID]
    , [NAME]                         AS [NAME]
    , [VALUE]                        AS [VALUE]
    , CASE [IS_LOCAL] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IS_LOCAL]
    , CASE [IS_LONG] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IS_LONG]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [ENTITY_VARIABLE];
go
CREATE TABLE ARC_EXTENTS (
    ID                             decimal (38) NOT NULL
    , [O_ID]                         decimal (38)     NULL
    , [SME_ID]                       decimal (38)     NULL
    , [SEQUENCE]                     integer          NULL
    , [EXTENT]                       varchar(256)     NULL
    , [CREATOR_U_ID]                 decimal (38)     NULL
    , [CREATE_TS]                    decimal (38)     NULL
    , [CHANGER_U_ID]                 decimal (38)     NULL
    , [CHANGE_TS]                    decimal (38)     NULL
);
go
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [EXTENTS] (
    [ID]                           decimal (38) NOT NULL
    , [O_ID]                         decimal (38)    NOT NULL
    , [SME_ID]                       decimal (38)    NOT NULL
    , [SEQUENCE]                     integer         NOT NULL
    , [EXTENT]                       varchar(256)    NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_EXTENTS
ON [EXTENTS]([ID]);
go
DROP VIEW SCI_EXTENTS;
go
CREATE VIEW SCI_EXTENTS AS
SELECT 
    ID 
    , [O_ID]                         AS [O_ID]
    , [SME_ID]                       AS [SME_ID]
    , [SEQUENCE]                     AS [SEQUENCE]
    , [EXTENT]                       AS [EXTENT]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [EXTENTS];
go
ALTER TABLE [PARAMETER_DEFINITION] ADD
    [IS_LONG] integer NOT NULL DEFAULT 0;
go
DROP VIEW SCI_C_PARAMETER_DEFINITION;
go
DROP VIEW SCI_V_PARAMETER_DEFINITION;
go
CREATE VIEW SCI_C_PARAMETER_DEFINITION AS
SELECT 
    ID 
    , [SE_ID]                        AS [SE_ID]
    , [NAME]                         AS [NAME]
    , CASE [TYPE] WHEN 10 THEN 'REFERENCE' WHEN 20 THEN 'CHILDREFERENCE' WHEN 30 THEN 'CONSTANT' WHEN 40 THEN 'RESULT' WHEN 50 THEN 'PARAMETER' WHEN 60 THEN 'EXPRESSION' WHEN 70 THEN 'IMPORT' WHEN 80 THEN 'DYNAMIC' WHEN 81 THEN 'DYNAMICVALUE' WHEN 90 THEN 'LOCAL_CONSTANT' WHEN 91 THEN 'RESOURCEREFERENCE' END AS [TYPE]
    , CASE [AGG_FUNCTION] WHEN 0 THEN 'NONE' WHEN 61 THEN 'AVG' WHEN 62 THEN 'COUNT' WHEN 63 THEN 'MIN' WHEN 64 THEN 'MAX' WHEN 65 THEN 'SUM' END AS [AGG_FUNCTION]
    , [DEFAULTVALUE]                 AS [DEFAULTVALUE]
    , CASE [IS_LOCAL] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IS_LOCAL]
    , [LINK_PD_ID]                   AS [LINK_PD_ID]
    , [EXPORT_NAME]                  AS [EXPORT_NAME]
    , CASE [IS_LONG] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IS_LONG]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [PARAMETER_DEFINITION]
 WHERE VALID_TO = 9223372036854775807;
go
CREATE VIEW SCI_V_PARAMETER_DEFINITION AS
SELECT 
    ID 
    , [SE_ID]                        AS [SE_ID]
    , [NAME]                         AS [NAME]
    , CASE [TYPE] WHEN 10 THEN 'REFERENCE' WHEN 20 THEN 'CHILDREFERENCE' WHEN 30 THEN 'CONSTANT' WHEN 40 THEN 'RESULT' WHEN 50 THEN 'PARAMETER' WHEN 60 THEN 'EXPRESSION' WHEN 70 THEN 'IMPORT' WHEN 80 THEN 'DYNAMIC' WHEN 81 THEN 'DYNAMICVALUE' WHEN 90 THEN 'LOCAL_CONSTANT' WHEN 91 THEN 'RESOURCEREFERENCE' END AS [TYPE]
    , CASE [AGG_FUNCTION] WHEN 0 THEN 'NONE' WHEN 61 THEN 'AVG' WHEN 62 THEN 'COUNT' WHEN 63 THEN 'MIN' WHEN 64 THEN 'MAX' WHEN 65 THEN 'SUM' END AS [AGG_FUNCTION]
    , [DEFAULTVALUE]                 AS [DEFAULTVALUE]
    , CASE [IS_LOCAL] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IS_LOCAL]
    , [LINK_PD_ID]                   AS [LINK_PD_ID]
    , [EXPORT_NAME]                  AS [EXPORT_NAME]
    , CASE [IS_LONG] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IS_LONG]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
    , VALID_FROM
    , VALID_TO
  FROM [PARAMETER_DEFINITION];
go
ALTER TABLE [RESOURCE_REQUIREMENT] ADD
    [IGNORE_ON_RERUN] integer NOT NULL DEFAULT 0;
go
DROP VIEW SCI_C_RESOURCE_REQUIREMENT;
go
DROP VIEW SCI_V_RESOURCE_REQUIREMENT;
go
CREATE VIEW SCI_C_RESOURCE_REQUIREMENT AS
SELECT 
    ID 
    , [NR_ID]                        AS [NR_ID]
    , [SE_ID]                        AS [SE_ID]
    , [AMOUNT]                       AS [AMOUNT]
    , CASE [KEEP_MODE] WHEN 0 THEN 'NOKEEP' WHEN 1 THEN 'KEEP' WHEN 2 THEN 'KEEP_FINAL' END AS [KEEP_MODE]
    , CASE [IS_STICKY] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IS_STICKY]
    , [STICKY_NAME]                  AS [STICKY_NAME]
    , [STICKY_PARENT]                AS [STICKY_PARENT]
    , [RSMP_ID]                      AS [RSMP_ID]
    , [EXPIRED_AMOUNT]               AS [EXPIRED_AMOUNT]
    , CASE [EXPIRED_BASE] WHEN 0 THEN 'MINUTE' WHEN 1 THEN 'HOUR' WHEN 2 THEN 'DAY' WHEN 3 THEN 'WEEK' WHEN 4 THEN 'MONTH' WHEN 5 THEN 'YEAR' END AS [EXPIRED_BASE]
    , CASE [IGNORE_ON_RERUN] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IGNORE_ON_RERUN]
    , CASE [LOCKMODE] WHEN 255 THEN 'N' WHEN 0 THEN 'X' WHEN 2 THEN 'SX' WHEN 4 THEN 'S' WHEN 6 THEN 'SC' END AS [LOCKMODE]
    , [CONDITION]                    AS [CONDITION]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [RESOURCE_REQUIREMENT]
 WHERE VALID_TO = 9223372036854775807;
go
CREATE VIEW SCI_V_RESOURCE_REQUIREMENT AS
SELECT 
    ID 
    , [NR_ID]                        AS [NR_ID]
    , [SE_ID]                        AS [SE_ID]
    , [AMOUNT]                       AS [AMOUNT]
    , CASE [KEEP_MODE] WHEN 0 THEN 'NOKEEP' WHEN 1 THEN 'KEEP' WHEN 2 THEN 'KEEP_FINAL' END AS [KEEP_MODE]
    , CASE [IS_STICKY] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IS_STICKY]
    , [STICKY_NAME]                  AS [STICKY_NAME]
    , [STICKY_PARENT]                AS [STICKY_PARENT]
    , [RSMP_ID]                      AS [RSMP_ID]
    , [EXPIRED_AMOUNT]               AS [EXPIRED_AMOUNT]
    , CASE [EXPIRED_BASE] WHEN 0 THEN 'MINUTE' WHEN 1 THEN 'HOUR' WHEN 2 THEN 'DAY' WHEN 3 THEN 'WEEK' WHEN 4 THEN 'MONTH' WHEN 5 THEN 'YEAR' END AS [EXPIRED_BASE]
    , CASE [IGNORE_ON_RERUN] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IGNORE_ON_RERUN]
    , CASE [LOCKMODE] WHEN 255 THEN 'N' WHEN 0 THEN 'X' WHEN 2 THEN 'SX' WHEN 4 THEN 'S' WHEN 6 THEN 'SC' END AS [LOCKMODE]
    , [CONDITION]                    AS [CONDITION]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
    , VALID_FROM
    , VALID_TO
  FROM [RESOURCE_REQUIREMENT];
go
CREATE TABLE ARC_SUBMITTED_ENTITY_STATS (
    ID                             decimal (38) NOT NULL
    , [SME_ID]                       decimal (38)     NULL
    , [RERUN_SEQ]                    integer          NULL
    , [SCOPE_ID]                     decimal (38)     NULL
    , [JOB_ESD_ID]                   decimal (38)     NULL
    , [EXIT_CODE]                    integer          NULL
    , [COMMANDLINE]                  varchar(512)     NULL
    , [WORKDIR]                      varchar(512)     NULL
    , [LOGFILE]                      varchar(512)     NULL
    , [ERRLOGFILE]                   varchar(512)     NULL
    , [EXTPID]                       varchar(32)      NULL
    , [SYNC_TS]                      decimal (38)     NULL
    , [RESOURCE_TS]                  decimal (38)     NULL
    , [RUNNABLE_TS]                  decimal (38)     NULL
    , [START_TS]                     decimal (38)     NULL
    , [FINISH_TS]                    decimal (38)     NULL
    , [CREATOR_U_ID]                 decimal (38)     NULL
    , [CREATE_TS]                    decimal (38)     NULL
    , [CHANGER_U_ID]                 decimal (38)     NULL
    , [CHANGE_TS]                    decimal (38)     NULL
);
go
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [SUBMITTED_ENTITY_STATS] (
    [ID]                           decimal (38) NOT NULL
    , [SME_ID]                       decimal (38)    NOT NULL
    , [RERUN_SEQ]                    integer         NOT NULL
    , [SCOPE_ID]                     decimal (38)        NULL
    , [JOB_ESD_ID]                   decimal (38)        NULL
    , [EXIT_CODE]                    integer             NULL
    , [COMMANDLINE]                  varchar(512)        NULL
    , [WORKDIR]                      varchar(512)        NULL
    , [LOGFILE]                      varchar(512)        NULL
    , [ERRLOGFILE]                   varchar(512)        NULL
    , [EXTPID]                       varchar(32)         NULL
    , [SYNC_TS]                      decimal (38)        NULL
    , [RESOURCE_TS]                  decimal (38)        NULL
    , [RUNNABLE_TS]                  decimal (38)        NULL
    , [START_TS]                     decimal (38)        NULL
    , [FINISH_TS]                    decimal (38)        NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_SUBMITTED_ENTITY_STATS
ON [SUBMITTED_ENTITY_STATS]([ID]);
go
DROP VIEW SCI_SUBMITTED_ENTITY_STATS;
go
CREATE VIEW SCI_SUBMITTED_ENTITY_STATS AS
SELECT 
    ID 
    , [SME_ID]                       AS [SME_ID]
    , [RERUN_SEQ]                    AS [RERUN_SEQ]
    , [SCOPE_ID]                     AS [SCOPE_ID]
    , [JOB_ESD_ID]                   AS [JOB_ESD_ID]
    , [EXIT_CODE]                    AS [EXIT_CODE]
    , [COMMANDLINE]                  AS [COMMANDLINE]
    , [WORKDIR]                      AS [WORKDIR]
    , [LOGFILE]                      AS [LOGFILE]
    , [ERRLOGFILE]                   AS [ERRLOGFILE]
    , [EXTPID]                       AS [EXTPID]
    , dateadd(ss, round(([SYNC_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [SYNC_TS]
    , dateadd(ss, round(([RESOURCE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [RESOURCE_TS]
    , dateadd(ss, round(([RUNNABLE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [RUNNABLE_TS]
    , dateadd(ss, round(([START_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [START_TS]
    , dateadd(ss, round(([FINISH_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [FINISH_TS]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [SUBMITTED_ENTITY_STATS];
go
ALTER TABLE [USERS] ADD
    [CONNECTION_TYPE] integer NOT NULL DEFAULT 0;
go
DROP VIEW SCI_USERS;
go
CREATE VIEW SCI_USERS AS
SELECT 
    ID 
    , [NAME]                         AS [NAME]
    , CASE [IS_ENABLED] WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS [IS_ENABLED]
    , [DEFAULT_G_ID]                 AS [DEFAULT_G_ID]
    , CASE [CONNECTION_TYPE] WHEN 0 THEN 'PLAIN' WHEN 1 THEN 'SSL' WHEN 2 THEN 'SSL_AUTH' END AS [CONNECTION_TYPE]
    , [DELETE_VERSION]               AS [DELETE_VERSION]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [USERS];
go
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [USER_EQUIV] (
    [ID]                           decimal (38) NOT NULL
    , [U_ID]                         decimal (38)    NOT NULL
    , [ALT_U_TYPE]                   integer         NOT NULL
    , [ALT_U_ID]                     decimal (38)    NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_USER_EQUIV
ON [USER_EQUIV]([ID]);
go
DROP VIEW SCI_USER_EQUIV;
go
CREATE VIEW SCI_USER_EQUIV AS
SELECT 
    ID 
    , [U_ID]                         AS [U_ID]
    , CASE [ALT_U_TYPE] WHEN 0 THEN 'USER' WHEN 1 THEN 'SERVER' END AS [ALT_U_TYPE]
    , [ALT_U_ID]                     AS [ALT_U_ID]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [USER_EQUIV];
go
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [VERSIONED_EXTENTS] (
    [ID]                           decimal (38) NOT NULL
    , [O_ID]                         decimal (38)    NOT NULL
    , [SEQUENCE]                     integer         NOT NULL
    , [EXTENT]                       varchar(256)    NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
    , [VALID_FROM]                 decimal (38) NOT NULL
    , [VALID_TO]                   decimal (38) NOT NULL
);
go
CREATE INDEX PK_VERSIONED_EXTENTS
ON [VERSIONED_EXTENTS]([ID]);
go
DROP VIEW SCI_C_VERSIONED_EXTENTS;
go
DROP VIEW SCI_V_VERSIONED_EXTENTS;
go
CREATE VIEW SCI_C_VERSIONED_EXTENTS AS
SELECT 
    ID 
    , [O_ID]                         AS [O_ID]
    , [SEQUENCE]                     AS [SEQUENCE]
    , [EXTENT]                       AS [EXTENT]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [VERSIONED_EXTENTS]
 WHERE VALID_TO = 9223372036854775807;
go
CREATE VIEW SCI_V_VERSIONED_EXTENTS AS
SELECT 
    ID 
    , [O_ID]                         AS [O_ID]
    , [SEQUENCE]                     AS [SEQUENCE]
    , [EXTENT]                       AS [EXTENT]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
    , VALID_FROM
    , VALID_TO
  FROM [VERSIONED_EXTENTS];
go
