-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE `IGNORED_DEPENDENCY` (
    `ID`                           decimal(20) NOT NULL
    , `SH_ID`                        decimal(20)     NOT NULL
    , `DD_NAME`                      varchar(64)     NOT NULL
    , `CREATOR_U_ID`                 decimal(20)     NOT NULL
    , `CREATE_TS`                    decimal(20)     NOT NULL
    , `CHANGER_U_ID`                 decimal(20)     NOT NULL
    , `CHANGE_TS`                    decimal(20)     NOT NULL
    , `VALID_FROM`                 decimal(20) NOT NULL
    , `VALID_TO`                   decimal(20) NOT NULL
) ENGINE = INNODB;
CREATE INDEX PK_IGNORED_DEPENDENCY
ON `IGNORED_DEPENDENCY`(`ID`);
CREATE VIEW SCI_C_IGNORED_DEPENDENCY AS
SELECT 
    ID 
    , `SH_ID`                        AS `SH_ID`
    , `DD_NAME`                      AS `DD_NAME`
    , `CREATOR_U_ID`                 AS `CREATOR_U_ID`
    , from_unixtime((`CREATE_TS` & ~1125899906842624)/1000) AS `CREATE_TS`
    , `CHANGER_U_ID`                 AS `CHANGER_U_ID`
    , from_unixtime((`CHANGE_TS` & ~1125899906842624)/1000) AS `CHANGE_TS`
  FROM `IGNORED_DEPENDENCY`
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_IGNORED_DEPENDENCY AS
SELECT 
    ID 
    , `SH_ID`                        AS `SH_ID`
    , `DD_NAME`                      AS `DD_NAME`
    , `CREATOR_U_ID`                 AS `CREATOR_U_ID`
    , from_unixtime((`CREATE_TS` & ~1125899906842624)/1000) AS `CREATE_TS`
    , `CHANGER_U_ID`                 AS `CHANGER_U_ID`
    , from_unixtime((`CHANGE_TS` & ~1125899906842624)/1000) AS `CHANGE_TS`
    , VALID_FROM
    , VALID_TO
  FROM `IGNORED_DEPENDENCY`;
