-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXIT_STATE_MAPPING (
    ID                             NUMBER (38) NOT NULL
    , ESMP_ID                        NUMBER (38)          NOT NULL
    , ESD_ID                         NUMBER (38)          NOT NULL
    , ECR_START                      NUMBER (38)              NULL
    , ECR_END                        NUMBER (38)              NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
    , VALID_FROM                   NUMBER (38) NOT NULL
    , VALID_TO                     NUMBER (38) NOT NULL
    , PRIMARY KEY (ID, VALID_TO)
);
CREATE OR REPLACE VIEW SCI_C_EXIT_STATE_MAPPING AS
SELECT 
    ID 
    , ESMP_ID                        AS ESMP_ID
    , ESD_ID                         AS ESD_ID
    , ECR_START                      AS ECR_START
    , ECR_END                        AS ECR_END
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM EXIT_STATE_MAPPING
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_EXIT_STATE_MAPPING AS
SELECT 
    ID 
    , ESMP_ID                        AS ESMP_ID
    , ESD_ID                         AS ESD_ID
    , ECR_START                      AS ECR_START
    , ECR_END                        AS ECR_END
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_MAPPING;
