ALTER TABLE DEPENDENCY_DEFINITION ADD (
    RESOLVE_MODE NUMBER (38) DEFAULT 0 NOT NULL,
    EXPIRED_AMOUNT NUMBER (38),
    EXPIRED_BASE NUMBER (38),
    SELECT_CONDITION VARCHAR2 (1024 CHAR)
);
CREATE OR REPLACE VIEW SCI_C_DEPENDENCY_DEFINITION AS
SELECT 
    ID 
    , SE_DEPENDENT_ID                AS SE_DEPENDENT_ID
    , SE_REQUIRED_ID                 AS SE_REQUIRED_ID
    , NAME                           AS NAME
    , DECODE (UNRESOLVED_HANDLING, 1, 'IGNORE', 2, 'ERROR', 3, 'SUSPEND', 4, 'DEFER', 5, 'DEFER_IGNORE') AS UNRESOLVED_HANDLING
    , DECODE (DMODE, 1, 'ALL_FINAL', 2, 'JOB_FINAL') AS DMODE
    , DECODE (STATE_SELECTION, 0, 'FINAL', 1, 'ALL_REACHABLE', 2, 'UNREACHABLE', 3, 'DEFAULT') AS STATE_SELECTION
    , CONDITION                      AS CONDITION
    , DECODE (RESOLVE_MODE, 0, 'INTERNAL', 1, 'EXTERNAL', 2, 'BOTH') AS RESOLVE_MODE
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , SELECT_CONDITION               AS SELECT_CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM DEPENDENCY_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_DEPENDENCY_DEFINITION AS
SELECT 
    ID 
    , SE_DEPENDENT_ID                AS SE_DEPENDENT_ID
    , SE_REQUIRED_ID                 AS SE_REQUIRED_ID
    , NAME                           AS NAME
    , DECODE (UNRESOLVED_HANDLING, 1, 'IGNORE', 2, 'ERROR', 3, 'SUSPEND', 4, 'DEFER', 5, 'DEFER_IGNORE') AS UNRESOLVED_HANDLING
    , DECODE (DMODE, 1, 'ALL_FINAL', 2, 'JOB_FINAL') AS DMODE
    , DECODE (STATE_SELECTION, 0, 'FINAL', 1, 'ALL_REACHABLE', 2, 'UNREACHABLE', 3, 'DEFAULT') AS STATE_SELECTION
    , CONDITION                      AS CONDITION
    , DECODE (RESOLVE_MODE, 0, 'INTERNAL', 1, 'EXTERNAL', 2, 'BOTH') AS RESOLVE_MODE
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , SELECT_CONDITION               AS SELECT_CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM DEPENDENCY_DEFINITION;
ALTER TABLE DEPENDENCY_INSTANCE ADD (
    REQUIRED_SE_ID NUMBER (38)
);
ALTER TABLE ARC_DEPENDENCY_INSTANCE ADD (
    REQUIRED_SE_ID NUMBER (38)
);
CREATE OR REPLACE VIEW SCI_DEPENDENCY_INSTANCE AS
SELECT 
    ID 
    , DD_ID                          AS DD_ID
    , DEPENDENT_ID                   AS DEPENDENT_ID
    , DEPENDENT_ID_ORIG              AS DEPENDENT_ID_ORIG
    , DECODE (DEPENDENCY_OPERATION, 1, 'AND', 2, 'OR') AS DEPENDENCY_OPERATION
    , REQUIRED_ID                    AS REQUIRED_ID
    , REQUIRED_SE_ID                 AS REQUIRED_SE_ID
    , DECODE (STATE, 0, 'OPEN', 1, 'FULFILLED', 2, 'FAILED', 3, 'BROKEN', 4, 'DEFERRED', 8, 'CANCELLED') AS STATE
    , DECODE (IGNORE, 0, 'NO', 1, 'YES', 2, 'RECURSIVE') AS IGNORE
    , DI_ID_ORIG                     AS DI_ID_ORIG
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM DEPENDENCY_INSTANCE;
ALTER TABLE INTERVALL ADD (
    OBJ_ID NUMBER (38),
    OBJ_TYPE NUMBER (38)
);
CREATE OR REPLACE VIEW SCI_INTERVALL AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , pkg_time.gmt2local(START_TIME) AS START_TIME
    , pkg_time.gmt2local(END_TIME) AS END_TIME
    , DELAY                          AS DELAY
    , DECODE (BASE_INTERVAL, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS BASE_INTERVAL
    , BASE_INTERVAL_MULTIPLIER       AS BASE_INTERVAL_MULTIPLIER
    , DECODE (DURATION, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS DURATION
    , DURATION_MULTIPLIER            AS DURATION_MULTIPLIER
    , pkg_time.gmt2local(SYNC_TIME) AS SYNC_TIME
    , DECODE (IS_INVERSE, 1, 'TRUE', 0, 'FALSE') AS IS_INVERSE
    , DECODE (IS_MERGE, 1, 'TRUE', 0, 'FALSE') AS IS_MERGE
    , EMBEDDED_INT_ID                AS EMBEDDED_INT_ID
    , SE_ID                          AS SE_ID
    , OBJ_ID                         AS OBJ_ID
    , DECODE (OBJ_TYPE, 25, 'DISTRIBUTION', 8, 'USER', 9, 'JOB_DEFINITION', 11, 'RESOURCE', 15, 'SCOPE', 16, 'TRIGGER', 18, 'EVENT', 19, 'INTERVAL', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 28, 'RESOURCE_TEMPLATE', 88, 'INTERVAL_DISPATCHER') AS OBJ_TYPE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM INTERVALL;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE INTERVAL_DISPATCHER (
    ID                             NUMBER (38) PRIMARY KEY
    , INT_ID                         NUMBER (38)          NOT NULL
    , SEQ_NO                         NUMBER (38)          NOT NULL
    , NAME                           VARCHAR2 (64 CHAR)   NOT NULL
    , SELECT_INT_ID                  NUMBER (38)              NULL
    , FILTER_INT_ID                  NUMBER (38)              NULL
    , IS_ENABLED                     NUMBER (1)           NOT NULL
    , IS_ACTIVE                      NUMBER (1)           NOT NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_INTERVAL_DISPATCHER AS
SELECT 
    ID 
    , INT_ID                         AS INT_ID
    , SEQ_NO                         AS SEQ_NO
    , NAME                           AS NAME
    , SELECT_INT_ID                  AS SELECT_INT_ID
    , FILTER_INT_ID                  AS FILTER_INT_ID
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM INTERVAL_DISPATCHER;
ALTER TABLE SCHEDULING_HIERARCHY ADD (
    INT_ID NUMBER (38)
);
CREATE OR REPLACE VIEW SCI_C_SCHEDULING_HIERARCHY AS
SELECT 
    ID 
    , SE_PARENT_ID                   AS SE_PARENT_ID
    , SE_CHILD_ID                    AS SE_CHILD_ID
    , ALIAS_NAME                     AS ALIAS_NAME
    , DECODE (IS_STATIC, 1, 'STATIC', 0, 'DYNAMIC') AS IS_STATIC
    , DECODE (IS_DISABLED, 0, 'ENABLED', 1, 'DISABLED') AS IS_DISABLED
    , PRIORITY                       AS PRIORITY
    , DECODE (SUSPEND, 1, 'CHILDSUSPEND', 2, 'NOSUSPEND', 3, 'SUSPEND') AS SUSPEND
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , ESTP_ID                        AS ESTP_ID
    , INT_ID                         AS INT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM SCHEDULING_HIERARCHY
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_SCHEDULING_HIERARCHY AS
SELECT 
    ID 
    , SE_PARENT_ID                   AS SE_PARENT_ID
    , SE_CHILD_ID                    AS SE_CHILD_ID
    , ALIAS_NAME                     AS ALIAS_NAME
    , DECODE (IS_STATIC, 1, 'STATIC', 0, 'DYNAMIC') AS IS_STATIC
    , DECODE (IS_DISABLED, 0, 'ENABLED', 1, 'DISABLED') AS IS_DISABLED
    , PRIORITY                       AS PRIORITY
    , DECODE (SUSPEND, 1, 'CHILDSUSPEND', 2, 'NOSUSPEND', 3, 'SUSPEND') AS SUSPEND
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , ESTP_ID                        AS ESTP_ID
    , INT_ID                         AS INT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM SCHEDULING_HIERARCHY;
ALTER TABLE SUBMITTED_ENTITY ADD (
    TIME_ZONE VARCHAR2 (32 CHAR)
);
ALTER TABLE ARC_SUBMITTED_ENTITY ADD (
    TIME_ZONE VARCHAR2 (32 CHAR)
);
CREATE OR REPLACE VIEW SCI_SUBMITTED_ENTITY AS
SELECT 
    ID 
    , MASTER_ID                      AS MASTER_ID
    , SUBMIT_TAG                     AS SUBMIT_TAG
    , DECODE (UNRESOLVED_HANDLING, 1, 'UH_IGNORE', 3, 'UH_SUSPEND', 2, 'UH_ERROR') AS UNRESOLVED_HANDLING
    , SE_ID                          AS SE_ID
    , CHILD_TAG                      AS CHILD_TAG
    , SE_VERSION                     AS SE_VERSION
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , SCOPE_ID                       AS SCOPE_ID
    , DECODE (IS_STATIC, 1, 'TRUE', 0, 'FALSE') AS IS_STATIC
    , DECODE (IS_DISABLED, 1, 'TRUE', 0, 'FALSE') AS IS_DISABLED
    , OLD_STATE                      AS OLD_STATE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , DECODE (STATE, 0, 'SUBMITTED', 1, 'DEPENDENCY_WAIT', 2, 'SYNCHRONIZE_WAIT', 3, 'RESOURCE_WAIT', 4, 'RUNNABLE', 5, 'STARTING', 6, 'STARTED', 7, 'RUNNING', 8, 'TO_KILL', 9, 'KILLED', 10, 'CANCELLED', 11, 'FINISHED', 12, 'FINAL', 13, 'BROKEN_ACTIVE', 14, 'BROKEN_FINISHED', 15, 'ERROR', 16, 'UNREACHABLE') AS STATE
    , JOB_ESD_ID                     AS JOB_ESD_ID
    , JOB_ESD_PREF                   AS JOB_ESD_PREF
    , DECODE (JOB_IS_FINAL, 1, 'TRUE', 0, 'FALSE') AS JOB_IS_FINAL
    , DECODE (JOB_IS_RESTARTABLE, 1, 'TRUE', 0, 'FALSE') AS JOB_IS_RESTARTABLE
    , FINAL_ESD_ID                   AS FINAL_ESD_ID
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , RR_COMMANDLINE                 AS RR_COMMANDLINE
    , RERUN_SEQ                      AS RERUN_SEQ
    , DECODE (IS_REPLACED, 1, 'TRUE', 0, 'FALSE') AS IS_REPLACED
    , DECODE (IS_CANCELLED, 1, 'TRUE', 0, 'FALSE') AS IS_CANCELLED
    , BASE_SME_ID                    AS BASE_SME_ID
    , REASON_SME_ID                  AS REASON_SME_ID
    , FIRE_SME_ID                    AS FIRE_SME_ID
    , FIRE_SE_ID                     AS FIRE_SE_ID
    , TR_ID                          AS TR_ID
    , TR_SD_ID_OLD                   AS TR_SD_ID_OLD
    , TR_SD_ID_NEW                   AS TR_SD_ID_NEW
    , TR_SEQ                         AS TR_SEQ
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , PID                            AS PID
    , EXTPID                         AS EXTPID
    , ERROR_MSG                      AS ERROR_MSG
    , KILL_ID                        AS KILL_ID
    , KILL_EXIT_CODE                 AS KILL_EXIT_CODE
    , DECODE (IS_SUSPENDED, 2, 'ADMINSUSPEND', 1, 'SUSPEND', 0, 'NOSUSPEND') AS IS_SUSPENDED
    , DECODE (IS_SUSPENDED_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_SUSPENDED_LOCAL
    , PRIORITY                       AS PRIORITY
    , RAW_PRIORITY                   AS RAW_PRIORITY
    , NICE                           AS NICE
    , NP_NICE                        AS NP_NICE
    , MIN_PRIORITY                   AS MIN_PRIORITY
    , AGING_AMOUNT                   AS AGING_AMOUNT
    , PARENT_SUSPENDED               AS PARENT_SUSPENDED
    , CHILD_SUSPENDED                AS CHILD_SUSPENDED
    , WARN_COUNT                     AS WARN_COUNT
    , WARN_LINK                      AS WARN_LINK
    , pkg_time.gmt2local(SUBMIT_TS) AS SUBMIT_TS
    , pkg_time.gmt2local(RESUME_TS) AS RESUME_TS
    , pkg_time.gmt2local(SYNC_TS) AS SYNC_TS
    , pkg_time.gmt2local(RESOURCE_TS) AS RESOURCE_TS
    , pkg_time.gmt2local(RUNNABLE_TS) AS RUNNABLE_TS
    , pkg_time.gmt2local(START_TS) AS START_TS
    , pkg_time.gmt2local(FINSH_TS) AS FINSH_TS
    , pkg_time.gmt2local(FINAL_TS) AS FINAL_TS
    , IDLE_TIME                      AS IDLE_TIME
    , DEPENDENCY_WAIT_TIME           AS DEPENDENCY_WAIT_TIME
    , SUSPEND_TIME                   AS SUSPEND_TIME
    , SYNC_TIME                      AS SYNC_TIME
    , RESOURCE_TIME                  AS RESOURCE_TIME
    , JOBSERVER_TIME                 AS JOBSERVER_TIME
    , RESTARTABLE_TIME               AS RESTARTABLE_TIME
    , CHILD_WAIT_TIME                AS CHILD_WAIT_TIME
    , OP_SUSRES_TS                   AS OP_SUSRES_TS
    , NPE_ID                         AS NPE_ID
    , TIME_ZONE                      AS TIME_ZONE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
    , ((NVL(FINAL_TS, (CAST(SYS_EXTRACT_UTC(SYSTIMESTAMP) AS DATE) - TO_DATE('19700101', 'YYYYDDSS')) * 24 * 60 * 60 * 1000) - SUBMIT_TS) / 1000) - DEPENDENCY_WAIT_TIME AS PROCESS_TIME
  FROM SUBMITTED_ENTITY;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE TRIGGER_PARAMETER (
    ID                             NUMBER (38) NOT NULL
    , NAME                           VARCHAR2 (64 CHAR)   NOT NULL
    , EXPRESSION                     VARCHAR2 (1024 CHAR) NOT NULL
    , TRIGGER_ID                     NUMBER (38)          NOT NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
    , VALID_FROM                   NUMBER (38) NOT NULL
    , VALID_TO                     NUMBER (38) NOT NULL
    , PRIMARY KEY (ID, VALID_TO)
);
CREATE OR REPLACE VIEW SCI_C_TRIGGER_PARAMETER AS
SELECT 
    ID 
    , NAME                           AS NAME
    , EXPRESSION                     AS EXPRESSION
    , TRIGGER_ID                     AS TRIGGER_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM TRIGGER_PARAMETER
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_TRIGGER_PARAMETER AS
SELECT 
    ID 
    , NAME                           AS NAME
    , EXPRESSION                     AS EXPRESSION
    , TRIGGER_ID                     AS TRIGGER_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM TRIGGER_PARAMETER;
ALTER TABLE SCOPE MODIFY (NODE VARCHAR2(64 CHAR));
