/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    static final int MIN_ARROW_WIDTH = 6;
    int lastEventTime = 0;
    long gdkEventKey = 0L;
    int fixStart = -1;
    int fixEnd = -1;
    double climbRate = 1.0;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Spinner(Composite composite, int n) {
        super(composite, Spinner.checkStyle(n));
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Object object;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_widget_realize(this.handle);
        long l = OS.gtk_entry_get_layout(this.handle);
        long l2 = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l2);
        int n3 = OS.gtk_spin_button_get_digits(this.handle);
        int n4 = 0;
        while (n4 < n3) {
            gtkAdjustment.upper *= 10.0;
            ++n4;
        }
        String string = String.valueOf((int)gtkAdjustment.upper);
        if (n3 > 0) {
            object = new StringBuffer();
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append(this.getDecimalSeparator());
            int n5 = n3 - string.length();
            while (n5 >= 0) {
                ((StringBuffer)object).append("0");
                --n5;
            }
            string = ((StringBuffer)object).toString();
        }
        object = Converter.wcsToMbcs(null, string, false);
        long l3 = OS.pango_layout_get_text(l);
        int n6 = OS.strlen(l3);
        byte[] byArray = new byte[n6];
        OS.memmove(byArray, l3, (long)n6);
        OS.pango_layout_set_text(l, (byte[])object, ((Object)object).length);
        OS.pango_layout_get_size(l, nArray, nArray2);
        OS.pango_layout_set_text(l, byArray, byArray.length);
        int n7 = OS.PANGO_PIXELS(nArray[0]);
        int n8 = OS.PANGO_PIXELS(nArray2[0]);
        n7 = n == -1 ? n7 : n;
        n8 = n2 == -1 ? n8 : n2;
        Rectangle rectangle = this.computeTrim(0, 0, n7, n8);
        return new Point(rectangle.width, rectangle.height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int n5 = 0;
        int n6 = 0;
        long l = OS.gtk_widget_get_style(this.handle);
        if ((this.style & 0x800) != 0) {
            n5 += OS.gtk_style_get_xthickness(l);
            n6 += OS.gtk_style_get_ythickness(l);
        }
        int[] nArray = new int[1];
        OS.gtk_widget_style_get(this.handle, OS.interior_focus, nArray, 0L);
        if (nArray[0] == 0) {
            OS.gtk_widget_style_get(this.handle, OS.focus_line_width, nArray, 0L);
            n5 += nArray[0];
            n6 += nArray[0];
        }
        long l2 = OS.gtk_style_get_font_desc(l);
        int n7 = OS.pango_font_description_get_size(l2);
        int n8 = Math.max(OS.PANGO_PIXELS(n7), 6);
        n8 -= n8 % 2;
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        rectangle.x -= n5;
        rectangle.y -= n6;
        rectangle.width += 2 * n5;
        rectangle.height += 2 * n6;
        rectangle.width += n8 + 2 * OS.gtk_style_get_xthickness(l);
        GtkBorder gtkBorder = Display.getEntryInnerBorder(this.handle);
        rectangle.x -= gtkBorder.left;
        rectangle.y -= gtkBorder.top;
        rectangle.width += gtkBorder.left + gtkBorder.right;
        rectangle.height += gtkBorder.top + gtkBorder.bottom;
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void copy() {
        this.checkWidget();
        OS.gtk_editable_copy_clipboard(this.handle);
    }

    void createHandle(int n) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        long l = OS.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 0.0);
        if (l == 0L) {
            this.error(2);
        }
        this.handle = OS.gtk_spin_button_new(l, this.climbRate, 0);
        if (this.handle == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        OS.gtk_editable_set_editable(this.handle, (this.style & 8) == 0);
        OS.gtk_entry_set_has_frame(this.handle, (this.style & 0x800) != 0);
        OS.gtk_spin_button_set_wrap(this.handle, (this.style & 0x40) != 0);
    }

    public void cut() {
        this.checkWidget();
        OS.gtk_editable_cut_clipboard(this.handle);
    }

    void deregister() {
        super.deregister();
        long l = this.imContext();
        if (l != 0L) {
            this.display.removeWidget(l);
        }
    }

    long eventWindow() {
        return this.paintWindow();
    }

    long enterExitHandle() {
        return this.fixedHandle;
    }

    boolean filterKey(int n, long l) {
        int n2 = OS.gdk_event_get_time(l);
        if (n2 != this.lastEventTime) {
            this.lastEventTime = n2;
            long l2 = this.imContext();
            if (l2 != 0L) {
                return OS.gtk_im_context_filter_keypress(l2, l);
            }
        }
        this.gdkEventKey = l;
        return false;
    }

    void fixIM() {
        long l;
        if (this.gdkEventKey != 0L && this.gdkEventKey != -1L && (l = this.imContext()) != 0L) {
            OS.gtk_im_context_filter_keypress(l, this.gdkEventKey);
            this.gdkEventKey = -1L;
            return;
        }
        this.gdkEventKey = 0L;
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public int getBorderWidth() {
        this.checkWidget();
        long l = OS.gtk_widget_get_style(this.handle);
        if ((this.style & 0x800) != 0) {
            return OS.gtk_style_get_xthickness(l);
        }
        return 0;
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getIncrement() {
        this.checkWidget();
        long l = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        int n = OS.gtk_spin_button_get_digits(this.handle);
        double d = gtkAdjustment.step_increment;
        int n2 = 0;
        while (n2 < n) {
            d *= 10.0;
            ++n2;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public int getMaximum() {
        this.checkWidget();
        long l = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        int n = OS.gtk_spin_button_get_digits(this.handle);
        double d = gtkAdjustment.upper;
        int n2 = 0;
        while (n2 < n) {
            d *= 10.0;
            ++n2;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public int getMinimum() {
        this.checkWidget();
        long l = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        int n = OS.gtk_spin_button_get_digits(this.handle);
        double d = gtkAdjustment.lower;
        int n2 = 0;
        while (n2 < n) {
            d *= 10.0;
            ++n2;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public int getPageIncrement() {
        this.checkWidget();
        long l = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        int n = OS.gtk_spin_button_get_digits(this.handle);
        double d = gtkAdjustment.page_increment;
        int n2 = 0;
        while (n2 < n) {
            d *= 10.0;
            ++n2;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public int getSelection() {
        this.checkWidget();
        long l = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        int n = OS.gtk_spin_button_get_digits(this.handle);
        double d = gtkAdjustment.value;
        int n2 = 0;
        while (n2 < n) {
            d *= 10.0;
            ++n2;
        }
        return (int)(d > 0.0 ? d + 0.5 : d - 0.5);
    }

    public String getText() {
        this.checkWidget();
        long l = OS.gtk_entry_get_text(this.handle);
        if (l == 0L) {
            return "";
        }
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        return new String(Converter.mbcsToWcs(null, byArray));
    }

    public int getTextLimit() {
        this.checkWidget();
        int n = OS.gtk_entry_get_max_length(this.handle);
        return n == 0 ? 65535 : n;
    }

    public int getDigits() {
        this.checkWidget();
        return OS.gtk_spin_button_get_digits(this.handle);
    }

    String getDecimalSeparator() {
        long l = OS.localeconv_decimal_point();
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        return new String(Converter.mbcsToWcs(null, byArray));
    }

    long gtk_activate(long l) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    long gtk_changed(long l) {
        long l2 = OS.gtk_entry_get_text(this.handle);
        int n = OS.strlen(l2);
        if (n > 0) {
            long[] lArray = new long[1];
            double d = OS.g_strtod(l2, lArray);
            if (lArray[0] == l2 + (long)n) {
                long l3 = OS.gtk_spin_button_get_adjustment(this.handle);
                GtkAdjustment gtkAdjustment = new GtkAdjustment();
                OS.memmove(gtkAdjustment, l3);
                if (d != gtkAdjustment.value && gtkAdjustment.lower <= d && d <= gtkAdjustment.upper) {
                    OS.gtk_spin_button_update(this.handle);
                }
            }
        }
        boolean bl = false;
        long l4 = OS.gtk_get_current_event();
        if (l4 != 0L) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l4, (long)GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    bl = true;
                }
            }
            OS.gdk_event_free(l4);
        }
        if (bl) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0L;
    }

    long gtk_commit(long l, long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        if (!OS.gtk_editable_get_editable(this.handle)) {
            return 0L;
        }
        int n = OS.strlen(l2);
        if (n == 0) {
            return 0L;
        }
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l2, (long)n);
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        char[] cArray2 = this.sendIMKeyEvent(1, null, cArray);
        if (cArray2 == null) {
            return 0L;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 9L);
        int n2 = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
        int n3 = 17;
        OS.g_signal_handlers_unblock_matched(l, n3, n2, 0, 0L, 0L, this.handle);
        if (cArray2 == cArray) {
            OS.g_signal_emit_by_name(l, OS.commit, l2);
        } else {
            byArray = Converter.wcsToMbcs(null, cArray2, true);
            OS.g_signal_emit_by_name(l, OS.commit, byArray);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 9L);
        OS.g_signal_handlers_block_matched(l, n3, n2, 0, 0L, 0L, this.handle);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            OS.gtk_editable_set_position(this.handle, this.fixStart);
            OS.gtk_editable_select_region(this.handle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0L;
    }

    long gtk_delete_text(long l, long l2, long l3) {
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        if (l3 == -1L) {
            l3 = OS.g_utf8_strlen(OS.gtk_entry_get_text(this.handle), -1L);
        }
        if ((string = this.verifyText("", (int)l2, (int)l3)) == null) {
            OS.g_signal_stop_emission_by_name(this.handle, OS.delete_text);
        } else if (string.length() > 0) {
            int[] nArray = new int[]{(int)l3};
            byte[] byArray = Converter.wcsToMbcs(null, string, false);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            OS.gtk_editable_insert_text(this.handle, byArray, byArray.length, nArray);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.gtk_editable_set_position(this.handle, nArray[0]);
        }
        return 0L;
    }

    long gtk_event_after(long l, long l2) {
        if (this.cursor != null) {
            this.setCursor(this.cursor.handle);
        }
        return super.gtk_event_after(l, l2);
    }

    long gtk_focus_out_event(long l, long l2) {
        this.fixIM();
        return super.gtk_focus_out_event(l, l2);
    }

    long gtk_insert_text(long l, long l2, long l3, long l4) {
        String string;
        if (l2 == 0L || l3 == 0L) {
            return 0L;
        }
        byte[] byArray = new byte[(int)l3];
        OS.memmove(byArray, l2, (long)byArray.length);
        String string2 = new String(Converter.mbcsToWcs(null, byArray));
        int[] nArray = new int[1];
        OS.memmove(nArray, l4, 4L);
        if (nArray[0] == -1) {
            long l5 = OS.gtk_entry_get_text(this.handle);
            nArray[0] = (int)OS.g_utf8_strlen(l5, -1L);
        }
        if ((string = this.verifyText(string2, nArray[0], nArray[0])) != string2) {
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, nArray2, nArray3);
            if (string != null) {
                if (nArray2[0] != nArray3[0]) {
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                    OS.gtk_editable_delete_selection(this.handle);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                }
                byte[] byArray2 = Converter.wcsToMbcs(null, string, false);
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
                OS.gtk_editable_insert_text(this.handle, byArray2, byArray2.length, nArray);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
                nArray2[0] = nArray3[0] = nArray[0];
            }
            nArray[0] = nArray3[0];
            if (nArray2[0] != nArray3[0]) {
                this.fixStart = nArray2[0];
                this.fixEnd = nArray3[0];
            }
            OS.memmove(l4, nArray, 4L);
            OS.g_signal_stop_emission_by_name(this.handle, OS.insert_text);
        }
        return 0L;
    }

    long gtk_key_press_event(long l, long l2) {
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            this.fixIM();
        }
        if (this.gdkEventKey == -1L) {
            l3 = 1L;
        }
        this.gdkEventKey = 0L;
        return l3;
    }

    long gtk_populate_popup(long l, long l2) {
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction(l2, 2);
            OS.gtk_container_forall(l2, this.display.setDirectionProc, 2L);
        }
        return 0L;
    }

    long gtk_value_changed(long l) {
        this.sendSelectionEvent(13);
        return 0L;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.changed, this.display.closures[6], true);
        OS.g_signal_connect_closure(this.handle, OS.insert_text, this.display.closures[26], false);
        OS.g_signal_connect_closure(this.handle, OS.delete_text, this.display.closures[13], false);
        OS.g_signal_connect_closure(this.handle, OS.value_changed, this.display.closures[57], false);
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.closures[1], false);
        OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.closures[37], false);
        long l = this.imContext();
        if (l != 0L) {
            OS.g_signal_connect_closure(l, OS.commit, this.display.closures[9], false);
            int n = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
            int n2 = 17;
            OS.g_signal_handlers_block_matched(l, n2, n, 0, 0L, 0L, this.handle);
        }
    }

    long imContext() {
        return OS.GTK_ENTRY_IM_CONTEXT(this.handle);
    }

    long paintWindow() {
        long l = super.paintWindow();
        long l2 = OS.gdk_window_get_children(l);
        if (l2 != 0L) {
            l = OS.g_list_data(l2);
        }
        OS.g_list_free(l2);
        return l;
    }

    public void paste() {
        this.checkWidget();
        OS.gtk_editable_paste_clipboard(this.handle);
    }

    void register() {
        super.register();
        long l = this.imContext();
        if (l != 0L) {
            this.display.addWidget(l, this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.fixIM();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        OS.gtk_widget_modify_base(this.handle, 0, gdkColor);
    }

    void setCursor(long l) {
        long l2 = 0L;
        if (l == 0L) {
            l2 = OS.gdk_cursor_new(152L);
        }
        super.setCursor(l != 0L ? l : l2);
        if (l == 0L) {
            OS.gdk_cursor_destroy(l2);
        }
    }

    void setFontDescription(long l) {
        super.setFontDescription(l);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        long l = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        double d = n;
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        int n3 = 0;
        while (n3 < n2) {
            d /= 10.0;
            ++n3;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_spin_button_set_increments(this.handle, d, gtkAdjustment.page_increment);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        long l = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        double d = n;
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        int n3 = 0;
        while (n3 < n2) {
            d /= 10.0;
            ++n3;
        }
        if (d < gtkAdjustment.lower) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_spin_button_set_range(this.handle, gtkAdjustment.lower, d);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        long l = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        double d = n;
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        int n3 = 0;
        while (n3 < n2) {
            d /= 10.0;
            ++n3;
        }
        if (d > gtkAdjustment.upper) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_spin_button_set_range(this.handle, d, gtkAdjustment.upper);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        long l = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        double d = n;
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        int n3 = 0;
        while (n3 < n2) {
            d /= 10.0;
            ++n3;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_spin_button_set_increments(this.handle, gtkAdjustment.step_increment, d);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setSelection(int n) {
        this.checkWidget();
        double d = n;
        int n2 = OS.gtk_spin_button_get_digits(this.handle);
        int n3 = 0;
        while (n3 < n2) {
            d /= 10.0;
            ++n3;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_spin_button_set_value(this.handle, d);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        OS.gtk_entry_set_max_length(this.handle, n);
    }

    public void setDigits(int n) {
        int n2;
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        if (n == (n2 = OS.gtk_spin_button_get_digits(this.handle))) {
            return;
        }
        long l = OS.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment gtkAdjustment = new GtkAdjustment();
        OS.memmove(gtkAdjustment, l);
        int n3 = Math.abs(n - n2);
        int n4 = 1;
        int n5 = 0;
        while (n5 < n3) {
            n4 *= 10;
            ++n5;
        }
        if (n2 > n) {
            gtkAdjustment.value *= (double)n4;
            gtkAdjustment.upper *= (double)n4;
            gtkAdjustment.lower *= (double)n4;
            gtkAdjustment.step_increment *= (double)n4;
            gtkAdjustment.page_increment *= (double)n4;
            this.climbRate *= (double)n4;
        } else {
            gtkAdjustment.value /= (double)n4;
            gtkAdjustment.upper /= (double)n4;
            gtkAdjustment.lower /= (double)n4;
            gtkAdjustment.step_increment /= (double)n4;
            gtkAdjustment.page_increment /= (double)n4;
            this.climbRate /= (double)n4;
        }
        OS.memmove(l, gtkAdjustment);
        OS.gtk_spin_button_configure(this.handle, l, this.climbRate, n);
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n3 < n2) {
            return;
        }
        if (n4 < 0) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n = Math.min(Math.max(n2, n), n3);
        double d = 1.0;
        int n7 = 0;
        while (n7 < n4) {
            d *= 10.0;
            ++n7;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        OS.gtk_spin_button_set_range(this.handle, (double)n2 / d, (double)n3 / d);
        OS.gtk_spin_button_set_increments(this.handle, (double)n5 / d, (double)n6 / d);
        OS.gtk_spin_button_set_value(this.handle, (double)n / d);
        this.climbRate = 1.0 / d;
        long l = OS.gtk_spin_button_get_adjustment(this.handle);
        OS.gtk_spin_button_configure(this.handle, l, this.climbRate, n4);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    boolean checkSubwindow() {
        return false;
    }

    boolean translateTraversal(GdkEventKey gdkEventKey) {
        int n = gdkEventKey.keyval;
        switch (n) {
            case 65293: 
            case 65421: {
                long l = this.imContext();
                if (l == 0L) break;
                long[] lArray = new long[1];
                OS.gtk_im_context_get_preedit_string(l, lArray, null, null);
                if (lArray[0] == 0L) break;
                int n2 = OS.strlen(lArray[0]);
                OS.g_free(lArray[0]);
                if (n2 == 0) break;
                return false;
            }
        }
        return super.translateTraversal(gdkEventKey);
    }

    String verifyText(String string, int n, int n2) {
        if (string.length() == 0 && n == n2) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = n;
        event.end = n2;
        long l = OS.gtk_get_current_event();
        if (l != 0L) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, l, (long)GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    this.setKeyState(event, gdkEventKey);
                }
            }
            OS.gdk_event_free(l);
        }
        int n3 = 0;
        if (OS.gtk_spin_button_get_digits(this.handle) > 0) {
            String string2 = this.getDecimalSeparator();
            n3 = string.indexOf(string2);
            if (n3 != -1) {
                string = String.valueOf(string.substring(0, n3)) + string.substring(n3 + 1);
            }
            n3 = 0;
        }
        if (string.length() > 0) {
            long l2 = OS.gtk_spin_button_get_adjustment(this.handle);
            GtkAdjustment gtkAdjustment = new GtkAdjustment();
            OS.memmove(gtkAdjustment, l2);
            if (gtkAdjustment.lower < 0.0 && string.charAt(0) == '-') {
                ++n3;
            }
        }
        while (n3 < string.length()) {
            if (!Character.isDigit(string.charAt(n3))) break;
            ++n3;
        }
        event.doit = n3 == string.length();
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

