/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.gtk.OS;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String URI_LIST = "text/uri-list";
    private static final int URI_LIST_ID = FileTransfer.registerType("text/uri-list");
    private static final String GNOME_LIST = "x-special/gnome-copied-files";
    private static final int GNOME_LIST_ID = FileTransfer.registerType("x-special/gnome-copied-files");

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        byte[] byArray;
        byte[] byArray2;
        boolean bl;
        transferData.result = 0;
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        boolean bl2 = bl = transferData.type == GNOME_LIST_ID;
        if (bl) {
            byArray2 = new byte[]{99, 111, 112, 121};
            byArray = new byte[]{10};
        } else {
            byArray2 = new byte[]{};
            byArray = new byte[]{13, 10};
        }
        String[] stringArray = (String[])object;
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            String string = stringArray[n];
            if (string != null && (n2 = string.length()) != 0) {
                char[] cArray = new char[n2];
                string.getChars(0, n2, cArray, 0);
                int[] nArray = new int[1];
                int n3 = OS.g_utf16_to_utf8(cArray, cArray.length, null, null, nArray);
                if (nArray[0] == 0 && n3 != 0) {
                    int n4 = OS.g_filename_from_utf8(n3, -1, null, null, nArray);
                    OS.g_free(n3);
                    if (nArray[0] == 0 && n4 != 0) {
                        int n5 = OS.g_filename_to_uri(n4, 0, nArray);
                        OS.g_free(n4);
                        if (nArray[0] == 0 && n5 != 0) {
                            n2 = OS.strlen(n5);
                            byte[] byArray3 = new byte[n2];
                            OS.memmove(byArray3, n5, n2);
                            OS.g_free(n5);
                            int n6 = byArray2.length > 0 ? byArray2.length + byArray.length + byArray3.length : byArray3.length;
                            byte[] byArray4 = new byte[n6];
                            int n7 = 0;
                            if (byArray2.length > 0) {
                                System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
                                System.arraycopy(byArray, 0, byArray4, n7 += byArray2.length, byArray.length);
                                n7 += byArray.length;
                            }
                            System.arraycopy(byArray3, 0, byArray4, n7, byArray3.length);
                            byArray2 = byArray4;
                        }
                    }
                }
            }
            ++n;
        }
        if (byArray2.length == 0) {
            return;
        }
        n = OS.g_malloc(byArray2.length + 1);
        OS.memset(n, 0, byArray2.length + 1);
        OS.memmove(n, byArray2, byArray2.length);
        transferData.pValue = n;
        transferData.length = byArray2.length;
        transferData.format = 8;
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        int[] nArray;
        int n;
        int n2;
        if (!this.isSupportedType(transferData) || transferData.pValue == 0 || transferData.length <= 0) {
            return null;
        }
        int n3 = transferData.length;
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, transferData.pValue, n3);
        boolean bl = transferData.type == GNOME_LIST_ID;
        int n4 = bl ? 1 : 2;
        int[] nArray2 = new int[]{};
        int n5 = 0;
        int n6 = 0;
        while (n6 < byArray.length - 1) {
            int n7 = bl ? (byArray[n6] == 10 ? 1 : 0) : (n2 = byArray[n6] == 13 && byArray[n6 + 1] == 10 ? 1 : 0);
            if (n2 != 0) {
                if (!bl || n5 != 0) {
                    int n8 = n6 - n5;
                    n = OS.g_malloc(n8 + 1);
                    byte[] byArray2 = new byte[n8 + 1];
                    System.arraycopy(byArray, n5, byArray2, 0, n8);
                    OS.memmove(n, byArray2, n8 + 1);
                    nArray = new int[nArray2.length + 1];
                    System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                    nArray[nArray2.length] = n;
                    nArray2 = nArray;
                }
                n5 = n6 + n4;
            }
            ++n6;
        }
        if (n5 < byArray.length - n4) {
            n6 = byArray.length - n5;
            n2 = OS.g_malloc(n6 + 1);
            byte[] byArray3 = new byte[n6 + 1];
            System.arraycopy(byArray, n5, byArray3, 0, n6);
            OS.memmove(n2, byArray3, n6 + 1);
            int[] nArray3 = new int[nArray2.length + 1];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
            nArray3[nArray2.length] = n2;
            nArray2 = nArray3;
        }
        String[] stringArray = new String[]{};
        n2 = 0;
        while (n2 < nArray2.length) {
            int[] nArray4 = new int[1];
            n = OS.g_filename_from_uri(nArray2[n2], null, nArray4);
            OS.g_free(nArray2[n2]);
            if (nArray4[0] == 0 && n != 0) {
                int n9 = OS.g_filename_to_utf8(n, -1, null, null, nArray4);
                OS.g_free(n);
                if (nArray4[0] == 0 && n9 != 0) {
                    nArray = new int[1];
                    int n10 = OS.g_utf8_to_utf16(n9, -1, null, nArray, null);
                    OS.g_free(n9);
                    n3 = nArray[0];
                    char[] cArray = new char[n3];
                    OS.memmove(cArray, n10, n3 * 2);
                    OS.g_free(n10);
                    String string = new String(cArray);
                    String[] stringArray2 = new String[stringArray.length + 1];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    stringArray2[stringArray.length] = string;
                    stringArray = stringArray2;
                }
            }
            ++n2;
        }
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    protected int[] getTypeIds() {
        return new int[]{URI_LIST_ID, GNOME_LIST_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{URI_LIST, GNOME_LIST};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] stringArray = (String[])object;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null || stringArray[n].length() == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

