/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.output;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.output.SDMSOutputRenderer;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class SDMSSerialRenderer
extends SDMSOutputRenderer {
    public static final String __version = "@(#) $Id: SDMSSerialRenderer.java,v 2.1.20.1 2013/03/14 10:24:19 ronald Exp $";
    String errorCode;
    String errorMessage;

    @Override
    public void render(SystemEnvironment systemEnvironment, SDMSOutput sDMSOutput) throws FatalException {
        try {
            this.render(systemEnvironment.cEnv.ostream(), sDMSOutput);
        }
        catch (FatalException fatalException) {
            throw new FatalException(new SDMSMessage(systemEnvironment, this.errorCode, this.errorMessage));
        }
    }

    @Override
    public void render(PrintStream printStream, SDMSOutput sDMSOutput) throws FatalException {
        try {
            if (sDMSOutput.container != null) {
                this.cleanContainer(sDMSOutput.container);
            }
            if (sDMSOutput.feedback != null) {
                sDMSOutput.feedback = sDMSOutput.feedback.toString();
            }
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(printStream);
            objectOutputStream.writeObject(sDMSOutput);
            objectOutputStream.flush();
        }
        catch (Exception exception) {
            this.errorCode = "02111032117";
            this.errorMessage = "Error writing object to ObjectOutputStream, " + exception.toString();
            throw new FatalException("Error writing object to ObjectOutputStream");
        }
    }

    private void cleanContainer(SDMSOutputContainer sDMSOutputContainer) {
        if (sDMSOutputContainer.title != null) {
            sDMSOutputContainer.title = sDMSOutputContainer.title.toString();
        }
        if (sDMSOutputContainer.columns == 0) {
            Vector vector = (Vector)sDMSOutputContainer.dataset.elementAt(0);
            for (Object e : vector) {
                if (e == null || !(e instanceof SDMSOutputContainer)) continue;
                this.cleanContainer((SDMSOutputContainer)e);
            }
        }
    }
}

