/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ChownChecker;
import de.independit.scheduler.server.parser.EventParameter;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.SubmitJob;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;

public class AlterEvent
extends Node {
    public static final String __version = "@(#) $Id: AlterEvent.java,v 2.5.4.1 2013/03/14 10:24:20 ronald Exp $";
    private final ObjectURL obj;
    private final WithHash with;
    private final boolean noerr;

    public AlterEvent(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.obj = objectURL;
        this.with = withHash;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object;
        SDMSEvent sDMSEvent = (SDMSEvent)this.obj.resolve(systemEnvironment);
        Long l = this.obj.objId;
        if (this.with.containsKey("ACTION")) {
            Object object22;
            object = (SubmitJob)this.with.get("ACTION");
            for (Object object22 : ((SubmitJob)object).with.keySet()) {
                if (((String)object22).equals("PARAMETERS")) continue;
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04207101802", (String)object22 + " not allowed here"));
            }
            object22 = SDMSSchedulingEntityTable.get(systemEnvironment, ((SubmitJob)object).path, ((SubmitJob)object).name);
            if (!((SDMSSchedulingEntityProxyGeneric)object22).checkPrivileges(systemEnvironment, 0x100000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402131254", "Execute privilege on $1 missing", ((SDMSSchedulingEntity)object22).pathString(systemEnvironment)));
            }
            Long l2 = ((SDMSProxy)object22).getId(systemEnvironment);
            sDMSEvent.setSeId(systemEnvironment, l2);
            EventParameter.kill(systemEnvironment, l);
            EventParameter.create(systemEnvironment, l, (SubmitJob)object);
            SystemEnvironment.timer.notifyChange(systemEnvironment, sDMSEvent, 2);
        }
        if (this.with.containsKey("GROUP")) {
            object = (String)this.with.get("GROUP");
            Long l3 = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)object, SDMSConstants.lZERO)).getId(systemEnvironment);
            ChownChecker.check(systemEnvironment, l3, sDMSEvent.getOwnerId(systemEnvironment));
            sDMSEvent.setOwnerId(systemEnvironment, l3);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201212234", "Event altered"));
    }
}

