/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ChownChecker;
import de.independit.scheduler.server.parser.CreateInterval;
import de.independit.scheduler.server.parser.IntervalUtil;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcher;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcherProxyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalDispatcherTable;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchy;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyProxyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyTable;
import de.independit.scheduler.server.repository.SDMSIntervalProxyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalSelectionTable;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.timer.TimerDate;
import de.independit.scheduler.server.util.DateTime;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class AlterInterval
extends Node {
    private final ObjectURL obj;
    private final WithHash with;
    private final boolean noerr;
    private Long ivalId;

    public AlterInterval(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.obj = objectURL;
        this.with = withHash;
        this.noerr = bl;
    }

    private void checkIntegrity(SystemEnvironment systemEnvironment, SDMSInterval sDMSInterval) throws SDMSException {
        String string = null;
        Long l = sDMSInterval.getId(systemEnvironment);
        if (SDMSIntervalDispatcherTable.idx_intId.containsKey(systemEnvironment, l)) {
            if (sDMSInterval.getBaseIntervalMultiplier(systemEnvironment) != null) {
                string = "Dispatcher can't have a base";
            } else if (sDMSInterval.getDurationMultiplier(systemEnvironment) != null) {
                string = "Dispatcher can't have a duration";
            } else if (sDMSInterval.getEmbeddedIntervalId(systemEnvironment) != null) {
                string = "Dispatcher can't have an embedded interval";
            } else if (SDMSIntervalSelectionTable.idx_intId.containsKey(systemEnvironment, l)) {
                string = "Dispatcher can't have a selection";
            } else if (SDMSIntervalHierarchyTable.idx_parentId.containsKey(systemEnvironment, l)) {
                string = "Dispatcher can't have a filter";
            }
        }
        if (string != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03812101356", "Inconsistency in definition: " + string));
        }
    }

    private void checkStructure(SystemEnvironment systemEnvironment, SDMSInterval sDMSInterval, HashSet hashSet) throws SDMSException {
        SDMSProxy sDMSProxy;
        Object object;
        Object object2;
        Object object3;
        Long l = sDMSInterval.getId(systemEnvironment);
        if (hashSet.contains(l)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04209121544", "cyclic references not allowed"));
        }
        hashSet.add(l);
        Long l2 = sDMSInterval.getEmbeddedIntervalId(systemEnvironment);
        if (l2 != null) {
            object3 = SDMSIntervalTable.getObject(systemEnvironment, l2);
            this.checkStructure(systemEnvironment, (SDMSInterval)object3, hashSet);
        }
        object3 = SDMSIntervalHierarchyTable.idx_parentId.getVector(systemEnvironment, l);
        Iterator iterator = ((Vector)object3).iterator();
        while (iterator.hasNext()) {
            object2 = (SDMSIntervalHierarchy)iterator.next();
            object = ((SDMSIntervalHierarchyProxyGeneric)object2).getChildId(systemEnvironment);
            sDMSProxy = SDMSIntervalTable.getObject(systemEnvironment, (Long)object);
            this.checkStructure(systemEnvironment, (SDMSInterval)sDMSProxy, hashSet);
        }
        object2 = SDMSIntervalDispatcherTable.idx_intId.getVector(systemEnvironment, l);
        object = ((Vector)object2).iterator();
        while (object.hasNext()) {
            Comparable comparable;
            sDMSProxy = (SDMSIntervalDispatcher)object.next();
            if (!((SDMSIntervalDispatcherProxyGeneric)sDMSProxy).getIsActive(systemEnvironment).booleanValue()) continue;
            Long l3 = ((SDMSIntervalDispatcherProxyGeneric)sDMSProxy).getSelectIntId(systemEnvironment);
            if (l3 != null) {
                comparable = SDMSIntervalTable.getObject(systemEnvironment, l3);
                this.checkStructure(systemEnvironment, (SDMSInterval)comparable, hashSet);
            }
            if ((comparable = ((SDMSIntervalDispatcherProxyGeneric)sDMSProxy).getFilterIntId(systemEnvironment)) == null) continue;
            SDMSInterval sDMSInterval2 = SDMSIntervalTable.getObject(systemEnvironment, (Long)comparable);
            this.checkStructure(systemEnvironment, sDMSInterval2, hashSet);
        }
        hashSet.remove(l);
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Comparable comparable;
        Object object;
        Number number;
        Serializable serializable;
        DateTime dateTime = new DateTime(new Date());
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        SDMSInterval sDMSInterval = (SDMSInterval)this.obj.resolve(systemEnvironment);
        this.ivalId = this.obj.objId;
        if (this.with.containsKey("BASE")) {
            serializable = (WithHash)this.with.get("BASE");
            if (serializable == null) {
                sDMSInterval.setBaseInterval(systemEnvironment, null);
                sDMSInterval.setBaseIntervalMultiplier(systemEnvironment, null);
            } else {
                number = (Integer)serializable.get("INTERVAL");
                object = IntervalUtil.getMultiplier(systemEnvironment, serializable);
                sDMSInterval.setBaseInterval(systemEnvironment, (Integer)number);
                sDMSInterval.setBaseIntervalMultiplier(systemEnvironment, (Integer)object);
            }
        }
        if (this.with.containsKey("DURATION")) {
            serializable = (WithHash)this.with.get("DURATION");
            if (serializable == null) {
                sDMSInterval.setDuration(systemEnvironment, null);
                sDMSInterval.setDurationMultiplier(systemEnvironment, null);
            } else {
                number = (Integer)serializable.get("INTERVAL");
                object = IntervalUtil.getMultiplier(systemEnvironment, serializable);
                sDMSInterval.setDuration(systemEnvironment, (Integer)number);
                sDMSInterval.setDurationMultiplier(systemEnvironment, (Integer)object);
            }
        }
        if (this.with.containsKey("SYNCTIME")) {
            if (IntervalUtil.getDateTime(systemEnvironment, dateTime, this.with, "SYNCTIME")) {
                bl = true;
            }
            dateTime.fixToMinDate();
            dateTime.suppressSeconds();
            sDMSInterval.setSyncTime(systemEnvironment, dateTime.toLong());
        }
        if (this.with.containsKey("STARTTIME")) {
            if (this.with.get("STARTTIME") == null) {
                sDMSInterval.setStartTime(systemEnvironment, null);
            } else {
                if (IntervalUtil.getDateTime(systemEnvironment, dateTime, this.with, "STARTTIME")) {
                    bl = true;
                }
                dateTime.fixToMinDate();
                dateTime.suppressSeconds();
                sDMSInterval.setStartTime(systemEnvironment, dateTime.toLong());
            }
        }
        if (this.with.containsKey("ENDTIME")) {
            if (this.with.get("ENDTIME") == null) {
                sDMSInterval.setEndTime(systemEnvironment, null);
            } else {
                if (IntervalUtil.getDateTime(systemEnvironment, dateTime, this.with, "ENDTIME")) {
                    bl = true;
                }
                dateTime.fixToMaxDate();
                dateTime.suppressSeconds();
                sDMSInterval.setEndTime(systemEnvironment, dateTime.toLong());
            }
        }
        serializable = sDMSInterval.getStartTime(systemEnvironment);
        number = sDMSInterval.getEndTime(systemEnvironment);
        if (serializable != null && number != null) {
            object = new TimerDate(new DateTime((Long)serializable, false).toDate());
            comparable = new TimerDate(new DateTime((Long)number, false).toDate());
            if (((TimerDate)comparable).eq((TimerDate)object)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04210011321", "STARTTIME and ENDTIME must be different"));
            }
        }
        if (this.with.containsKey("EMBEDDED")) {
            Object object2;
            object = sDMSInterval.getEmbeddedIntervalId(systemEnvironment);
            if (object != null) {
                comparable = SDMSIntervalTable.getObject(systemEnvironment, (Long)object);
                object2 = ((SDMSIntervalProxyGeneric)comparable).getObjId(systemEnvironment);
                if (this.ivalId.equals(object2)) {
                    ((SDMSInterval)comparable).delete(systemEnvironment);
                }
                sDMSInterval.setEmbeddedIntervalId(systemEnvironment, null);
            }
            if ((comparable = this.with.get("EMBEDDED")) != null) {
                if (comparable instanceof String) {
                    object2 = SDMSIntervalTable.idx_name_objId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)IntervalUtil.mapIdName((String)((Object)comparable), this.obj.seId)), null));
                    if ((((SDMSIntervalProxyGeneric)object2).getPrivileges(systemEnvironment).toLong() & 0x10000000L) != 0x10000000L) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03308181546", "Insufficient privileges to use Interval " + (String)((Object)comparable)));
                    }
                    Long l = ((SDMSProxy)object2).getId(systemEnvironment);
                    sDMSInterval.setEmbeddedIntervalId(systemEnvironment, l);
                } else {
                    object2 = (CreateInterval)((Object)comparable);
                    ((Node)object2).setEnv(systemEnvironment.cEnv);
                    ((CreateInterval)object2).go(systemEnvironment, 1);
                    SDMSInterval sDMSInterval2 = ((CreateInterval)object2).getIval();
                    sDMSInterval2.setObjId(systemEnvironment, this.ivalId);
                    sDMSInterval2.setObjType(systemEnvironment, SDMSConstants.IV_INTERVAL);
                }
            }
        }
        if (sDMSInterval.getEmbeddedIntervalId(systemEnvironment) != null && sDMSInterval.getDuration(systemEnvironment) != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04311251855", "intervals with EMBEDDED cannot have DURATION"));
        }
        if (this.with.containsKey("DELAY")) {
            string = "DELAY not longer supported; option ignored";
        }
        if (this.with.containsKey("INVERSE")) {
            object = (Boolean)this.with.get("INVERSE");
            sDMSInterval.setIsInverse(systemEnvironment, (Boolean)object);
        }
        if (this.with.containsKey("MERGE")) {
            string = "MERGE not longer supported; option ignored";
        }
        if (this.with.containsKey("SELECTION")) {
            IntervalUtil.killSelections(systemEnvironment, this.ivalId);
            if (this.with.get("SELECTION") != null) {
                IntervalUtil.killDispatcher(systemEnvironment, this.ivalId);
            }
            switch (IntervalUtil.createSelections(systemEnvironment, this.ivalId, this.with)) {
                case 2: {
                    bl = true;
                    break;
                }
                case 1: {
                    bl3 = true;
                }
            }
        }
        if (this.with.containsKey("FILTER")) {
            IntervalUtil.killFilter(systemEnvironment, this.ivalId);
            if (this.with.get("FILTER") != null) {
                IntervalUtil.killDispatcher(systemEnvironment, this.ivalId);
            }
            bl2 = IntervalUtil.createFilter(systemEnvironment, this.ivalId, this.with, this.obj.seId, 0);
        }
        if (this.with.containsKey("DISPATCH")) {
            IntervalUtil.killDispatcher(systemEnvironment, this.ivalId);
            if ((this.with.get("FILTER") != null || this.with.get("SELECTION") != null) && this.with.get("DISPATCH") != null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03812111214", "An interval can't be both a filter/selection and a dispatcher"));
            }
            if (this.with.get("DISPATCH") != null) {
                IntervalUtil.killSelections(systemEnvironment, this.ivalId);
                IntervalUtil.killFilter(systemEnvironment, this.ivalId);
                IntervalUtil.createDispatcher(systemEnvironment, this.ivalId, this.with, 0);
            }
        }
        sDMSInterval.setSeId(systemEnvironment, this.obj.seId);
        this.checkIntegrity(systemEnvironment, sDMSInterval);
        this.checkStructure(systemEnvironment, sDMSInterval, new HashSet());
        SystemEnvironment.timer.notifyChange(systemEnvironment, sDMSInterval, 2);
        if (this.with.containsKey("GROUP")) {
            object = (String)this.with.get("GROUP");
            comparable = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)object, SDMSConstants.lZERO)).getId(systemEnvironment);
            ChownChecker.check(systemEnvironment, (Long)comparable, sDMSInterval.getOwnerId(systemEnvironment));
            sDMSInterval.setOwnerId(systemEnvironment, (Long)comparable);
        }
        if (bl2) {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "04209270127", "Interval created (WARNING: duplicate FILTER will be ignored)"));
        } else if (bl) {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "04209201344", "Interval altered (WARNING: seconds will be ignored)"));
        } else if (bl3) {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "04209270144", "Interval created (WARNING: upper range(s) will be ignored)"));
        } else {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207241731", "Interval altered" + (string == null ? "" : ". " + string)));
        }
    }
}

