/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ChownChecker;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceAllocationTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import java.io.Serializable;
import java.util.Vector;

public class AlterNamedResource
extends Node {
    public static final String __version = "@(#) $Id: AlterNamedResource.java,v 2.18.2.3 2013/03/19 10:03:51 ronald Exp $";
    private ObjectURL url;
    private Integer usage;
    private String rspName;
    private String gName;
    private Long gId;
    private Float factor = null;
    private WithHash with;
    private boolean noerr;
    private WithHash parms = null;
    private boolean allTypes = false;

    public AlterNamedResource(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.url = objectURL;
        this.with = withHash;
        this.noerr = bl;
    }

    private void evaluateWith(SystemEnvironment systemEnvironment) throws SDMSException {
        this.usage = (Integer)this.with.get("USAGE");
        this.rspName = (String)this.with.get("STATUS_PROFILE");
        if (this.with.containsKey("GROUP") && this.with.containsKey("GROUP_CASCADE")) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03402041406", "It is not allowed to specify the group clause twice"));
        }
        this.gName = (String)this.with.get("GROUP");
        if (this.gName == null) {
            this.gName = (String)this.with.get("GROUP_CASCADE");
        }
        this.gId = this.gName != null ? SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.gName), SDMSConstants.lZERO)).getId(systemEnvironment) : null;
        this.factor = (Float)this.with.get("FACTOR");
        this.parms = (WithHash)this.with.get("PARAMETERS");
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object;
        Serializable serializable;
        Long l;
        SDMSNamedResource sDMSNamedResource;
        this.evaluateWith(systemEnvironment);
        try {
            sDMSNamedResource = (SDMSNamedResource)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311122309", "No Named Resource altered"));
                return;
            }
            throw notFoundException;
        }
        if (this.usage != null) {
            if (!this.usage.equals(sDMSNamedResource.getUsage(systemEnvironment))) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03402041237", "You cannot change the resource usage"));
            }
        } else {
            this.usage = sDMSNamedResource.getUsage(systemEnvironment);
        }
        if (sDMSNamedResource.getUsage(systemEnvironment) == 4) {
            this.allTypes = true;
        }
        SDMSResourceStateProfile sDMSResourceStateProfile = null;
        if (this.rspName != null) {
            sDMSResourceStateProfile = SDMSResourceStateProfileTable.idx_name_getUnique(systemEnvironment, this.rspName);
            l = sDMSResourceStateProfile.getId(systemEnvironment);
        } else {
            l = null;
        }
        Long l2 = sDMSNamedResource.getRspId(systemEnvironment);
        if (l != null) {
            sDMSNamedResource.setRspId(systemEnvironment, l);
            if (l2 == null) {
                serializable = sDMSResourceStateProfile.getInitialRsdId(systemEnvironment);
                Vector vector = SDMSResourceTable.idx_nrId.getVector(systemEnvironment, sDMSNamedResource.getId(systemEnvironment));
                for (int i = 0; i < vector.size(); ++i) {
                    object = (SDMSResource)vector.get(i);
                    ((SDMSResource)object).setRsdId(systemEnvironment, (Long)serializable);
                }
            } else if (!l2.equals(l)) {
                serializable = SDMSResourceTable.idx_nrId.getVector(systemEnvironment, sDMSNamedResource.getId(systemEnvironment));
                for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                    String string;
                    SDMSResource sDMSResource = (SDMSResource)((Vector)serializable).get(i);
                    Long l3 = sDMSResource.getRsdId(systemEnvironment);
                    if (l3.equals(sDMSResourceStateProfile.getInitialRsdId(systemEnvironment)) || SDMSResourceStateTable.idx_rsdId_rspId.containsKey(systemEnvironment, new SDMSKey(l3, l))) continue;
                    try {
                        SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, sDMSResource.getScopeId(systemEnvironment));
                        string = sDMSScope.pathString(systemEnvironment);
                    }
                    catch (NotFoundException notFoundException) {
                        SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, sDMSResource.getScopeId(systemEnvironment));
                        string = sDMSFolder.pathString(systemEnvironment);
                    }
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03709071000", "Profile does not contain state $1 of resource $2->$3", SDMSResourceStateDefinitionTable.getObject(systemEnvironment, sDMSResource.getRsdId(systemEnvironment)).getName(systemEnvironment), string, SDMSNamedResourceTable.getObject(systemEnvironment, ((SDMSResource)((Vector)serializable).get(i)).getNrId(systemEnvironment)).pathString(systemEnvironment)));
                }
            }
        } else if (l2 != null && this.with.containsKey("STATUS_PROFILE")) {
            sDMSNamedResource.setRspId(systemEnvironment, l);
            serializable = SDMSResourceTable.idx_nrId.getVector(systemEnvironment, sDMSNamedResource.getId(systemEnvironment));
            for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                SDMSResource sDMSResource = (SDMSResource)((Vector)serializable).get(i);
                object = SDMSResourceAllocationTable.idx_rId.getVector(systemEnvironment, sDMSResource.getId(systemEnvironment));
                if (((Vector)object).size() > 0) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03709071020", "Resource $1->$2 currently allocated, cannot set resource state to null", SDMSScopeTable.getObject(systemEnvironment, sDMSResource.getScopeId(systemEnvironment)), sDMSNamedResource.pathVector(systemEnvironment)));
                }
                sDMSResource.setRsdId(systemEnvironment, null);
            }
        }
        serializable = SDMSResourceRequirementTable.idx_nrId.getVector(systemEnvironment, sDMSNamedResource.getId(systemEnvironment));
        for (int i = 0; i < ((Vector)serializable).size(); ++i) {
            ((SDMSResourceRequirement)((Vector)serializable).get(i)).check(systemEnvironment);
        }
        if (this.gId != null) {
            ChownChecker.check(systemEnvironment, this.gId, sDMSNamedResource.getOwnerId(systemEnvironment));
            sDMSNamedResource.setOwnerId(systemEnvironment, this.gId);
            if (this.with.containsKey("GROUP_CASCADE")) {
                this.changeChildGroup(systemEnvironment, sDMSNamedResource.getId(systemEnvironment), this.gId);
            }
        }
        if (this.with.containsKey("INHERIT")) {
            Long l4 = (Long)this.with.get("INHERIT");
            if (l4 == null) {
                l4 = SDMSConstants.lZERO;
            }
            long l5 = l4;
            if ((sDMSNamedResource.getPrivilegeMask() & l5) != l5) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202061135", "Incompatible grant"));
            }
            sDMSNamedResource.setInheritPrivs(systemEnvironment, l4);
        }
        int n = this.usage;
        if (this.factor != null && !this.factor.equals(SDMSConstants.fONE)) {
            systemEnvironment.checkFeatureAvailability("RESOURCE_TRACING");
        }
        if (n != 1 && n != 8 && n != 1 && this.factor != null) {
            sDMSNamedResource.setFactor(systemEnvironment, this.factor);
        }
        if (this.with.containsKey("PARAMETERS")) {
            sDMSNamedResource.alterParameters(systemEnvironment, this.parms, this.allTypes);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201212235", "Named Resource altered"));
    }

    private void changeChildGroup(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        Vector vector = SDMSNamedResourceTable.idx_parentId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSNamedResource sDMSNamedResource = (SDMSNamedResource)vector.get(i);
            try {
                sDMSNamedResource.setOwnerId(systemEnvironment, l2);
            }
            catch (AccessViolationException accessViolationException) {
                // empty catch block
            }
            this.changeChildGroup(systemEnvironment, sDMSNamedResource.getId(systemEnvironment), l2);
        }
    }
}

