/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.HashMap;
import java.util.Vector;

public class CopyFolder
extends Node {
    public static final String __version = "@(#) $Id: CopyFolder.java,v 2.7.2.1 2013/03/14 10:24:24 ronald Exp $";
    private ObjectURL url;
    private Vector urlVector;
    private Vector name2;
    private String newName;

    public CopyFolder(Vector vector, Vector vector2) {
        this.urlVector = vector;
        this.name2 = vector2;
        this.newName = null;
    }

    public CopyFolder(Vector vector, String string) {
        this.urlVector = vector;
        this.name2 = null;
        this.newName = string;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSSchedulingEntity sDMSSchedulingEntity;
        Comparable comparable;
        int n;
        Long l;
        SDMSFolder sDMSFolder;
        String string;
        SDMSFolder sDMSFolder2;
        boolean bl = false;
        if (this.newName == null) {
            try {
                sDMSFolder2 = SDMSFolderTable.getFolder(systemEnvironment, this.name2);
                string = null;
                bl = true;
            }
            catch (NotFoundException notFoundException) {
                if (this.urlVector.size() > 1) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03203131151", "It isn't possible to copy multiple sources to one target"));
                }
                string = (String)this.name2.remove(this.name2.size() - 1);
                sDMSFolder2 = SDMSFolderTable.getFolder(systemEnvironment, this.name2);
            }
        } else {
            if (this.urlVector.size() > 1) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03203131143", "A partially specified target allows only one folder to be copied"));
            }
            this.url = (ObjectURL)this.urlVector.get(0);
            sDMSFolder = (SDMSFolder)this.url.resolve(systemEnvironment);
            l = sDMSFolder.getParentId(systemEnvironment);
            sDMSFolder2 = SDMSFolderTable.getObject(systemEnvironment, l);
            string = this.newName;
        }
        Long l2 = sDMSFolder2.getId(systemEnvironment);
        SDMSFolder sDMSFolder3 = sDMSFolder2;
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        Vector<SDMSProxy> vector = new Vector<SDMSProxy>();
        for (n = 0; n < this.urlVector.size(); ++n) {
            this.url = (ObjectURL)this.urlVector.get(n);
            if (this.url.objType.equals(6)) {
                try {
                    sDMSFolder = (SDMSFolder)this.url.resolve(systemEnvironment);
                }
                catch (ClassCastException classCastException) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03209161248", "The object " + this.url.toString() + " is not a Folder"));
                }
                if (!sDMSFolder.checkPrivileges(systemEnvironment, 0x10000000L)) {
                    throw new AccessViolationException(sDMSFolder.accessViolationMessage(systemEnvironment, "03203131453"));
                }
                l = sDMSFolder.getParentId(systemEnvironment);
                if (bl) {
                    string = sDMSFolder.getName(systemEnvironment);
                }
                if (l == null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03704102216", "The Folder SYSTEM cannot be copied"));
                }
                Long l3 = sDMSFolder.getId(systemEnvironment);
                if (SDMSSchedulingEntityTable.idx_folderId_name.containsKey(systemEnvironment, new SDMSKey(l2, (Comparable)((Object)string)))) {
                    throw new DuplicateKeyException(new SDMSMessage(systemEnvironment, "02204160938", "Object with name $1 already exists within $2", string, sDMSFolder3.pathString(systemEnvironment)));
                }
                if (SDMSFolderTable.idx_parentId_name.containsKey(systemEnvironment, new SDMSKey(l2, (Comparable)((Object)string)))) {
                    throw new DuplicateKeyException(new SDMSMessage(systemEnvironment, "03112191224", "Object with name $1 already exists within $2", string, sDMSFolder3.pathString(systemEnvironment)));
                }
                if (l2.equals(l3)) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02204160936", "A Folder cannot be copied below itself"));
                }
                sDMSFolder2 = sDMSFolder3;
                while ((comparable = sDMSFolder2.getParentId(systemEnvironment)) != null) {
                    if (((Long)comparable).equals(l3)) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02204160937", "A Folder cannot be copied below itself"));
                    }
                    sDMSFolder2 = SDMSFolderTable.getObject(systemEnvironment, (Long)comparable);
                }
                SDMSFolder sDMSFolder4 = sDMSFolder.copy(systemEnvironment, l2, string, hashMap);
                vector.addElement(sDMSFolder4);
                continue;
            }
            try {
                sDMSSchedulingEntity = (SDMSSchedulingEntity)this.url.resolve(systemEnvironment);
            }
            catch (ClassCastException classCastException) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03209161249", "The object " + this.url.toString() + " is not a Job Definition"));
            }
            if (!sDMSSchedulingEntity.checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(sDMSSchedulingEntity.accessViolationMessage(systemEnvironment, "03203131454"));
            }
            if (bl) {
                string = sDMSSchedulingEntity.getName(systemEnvironment);
            }
            if (SDMSFolderTable.idx_parentId_name.containsKey(systemEnvironment, new SDMSKey(l2, (Comparable)((Object)string)))) {
                throw new DuplicateKeyException(new SDMSMessage(systemEnvironment, "02204160925", "Object with name $1 already exists within $2", string, sDMSFolder3.pathString(systemEnvironment)));
            }
            comparable = sDMSSchedulingEntity.copy(systemEnvironment, l2, string, hashMap);
            hashMap.put(sDMSSchedulingEntity.getId(systemEnvironment), ((SDMSProxy)comparable).getId(systemEnvironment));
            vector.addElement((SDMSProxy)comparable);
        }
        for (n = 0; n < vector.size(); ++n) {
            comparable = (SDMSProxy)vector.get(n);
            if (comparable instanceof SDMSFolder) {
                sDMSFolder = (SDMSFolder)comparable;
                sDMSFolder.relocateEntityDetails(systemEnvironment, hashMap);
                continue;
            }
            sDMSSchedulingEntity = (SDMSSchedulingEntity)comparable;
            sDMSSchedulingEntity.relocateDetails(systemEnvironment, hashMap);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03202200945", "Folder(s) copied"));
    }
}

