/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterEvent;
import de.independit.scheduler.server.parser.EventParameter;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.SubmitJob;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;

public class CreateEvent
extends Node {
    public static final String __version = "@(#) $Id: CreateEvent.java,v 2.6.4.1 2013/03/14 10:24:25 ronald Exp $";
    private final ObjectURL obj;
    private final WithHash with;
    private final boolean replace;
    private SubmitJob submit;

    public CreateEvent(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.obj = objectURL;
        this.with = withHash;
        this.replace = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object;
        Long l;
        try {
            this.obj.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (!this.with.containsKey("ACTION")) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03312161111", "No action specified"));
        }
        this.submit = (SubmitJob)this.with.get("ACTION");
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.get(systemEnvironment, this.submit.path, this.submit.name);
        if (!sDMSSchedulingEntity.checkPrivileges(systemEnvironment, 0x100000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402131255", "Submit privilege on $1 missing", sDMSSchedulingEntity.pathString(systemEnvironment)));
        }
        Long l2 = sDMSSchedulingEntity.getId(systemEnvironment);
        Long l3 = this.env.uid();
        SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, l3);
        if (!this.with.containsKey("GROUP")) {
            l = sDMSUser.getDefaultGId(systemEnvironment);
        } else {
            object = (String)this.with.get("GROUP");
            l = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)object, SDMSConstants.lZERO)).getId(systemEnvironment);
        }
        sDMSSchedulingEntity.checkSubmitForGroup(systemEnvironment, l);
        try {
            object = SDMSEventTable.table.create(systemEnvironment, this.obj.mappedName, l, l2);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            if (this.replace) {
                AlterEvent alterEvent = new AlterEvent(this.obj, this.with, Boolean.FALSE);
                alterEvent.setEnv(this.env);
                alterEvent.go(systemEnvironment);
                this.result = alterEvent.result;
                return;
            }
            throw duplicateKeyException;
        }
        Long l4 = ((SDMSProxy)object).getId(systemEnvironment);
        EventParameter.create(systemEnvironment, l4, this.submit);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04203071739", "Event created"));
    }
}

