/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterExitStateMapping;
import de.independit.scheduler.server.parser.EsmMap;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateMappingTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import java.util.Vector;

public class CreateExitStatusMapping
extends Node {
    public static final String __version = "@(#) $Id: CreateExitStatusMapping.java,v 2.1.14.1 2013/03/14 10:24:25 ronald Exp $";
    private String name;
    private Vector maps;
    private boolean replace;

    public CreateExitStatusMapping(String string, Vector vector, Boolean bl) {
        this.name = string;
        this.maps = vector;
        this.replace = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSExitStateMappingProfile sDMSExitStateMappingProfile;
        try {
            sDMSExitStateMappingProfile = SDMSExitStateMappingProfileTable.table.create(systemEnvironment, this.name);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            if (this.replace) {
                AlterExitStateMapping alterExitStateMapping = new AlterExitStateMapping(new ObjectURL(SDMSConstants.PS_EXIT_STATUS_MAPPING, this.name), this.maps, Boolean.FALSE);
                alterExitStateMapping.setEnv(this.env);
                alterExitStateMapping.go(systemEnvironment);
                this.result = alterExitStateMapping.result;
                return;
            }
            throw duplicateKeyException;
        }
        SDMSProxy sDMSProxy = null;
        Long l = sDMSExitStateMappingProfile.getId(systemEnvironment);
        int n = 0;
        int n2 = 0;
        for (EsmMap esmMap : this.maps) {
            if (n2 != 0) {
                if (n >= esmMap.from()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02110222023", "Exit Code $1 out of sequence", esmMap.from()));
                }
                SDMSExitStateMappingTable.table.create(systemEnvironment, l, sDMSProxy.getId(systemEnvironment), n, esmMap.from() - 1);
            }
            ++n2;
            n = esmMap.from();
            sDMSProxy = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, esmMap.name());
        }
        SDMSExitStateMappingTable.table.create(systemEnvironment, l, sDMSProxy.getId(systemEnvironment), n, SDMSConstants.iMAX_VALUE);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201161956", "Exit State Mapping created"));
    }
}

