/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ScopeConfig;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import java.util.Vector;

public class RegisterServer
extends Node {
    public static final String __version = "@(#) $Id: RegisterServer.java,v 2.3.14.1 2013/03/14 10:24:43 ronald Exp $";
    private Vector path;
    private String name;
    private String pid;
    private Boolean suspended;

    public RegisterServer(Vector vector, String string, String string2, Boolean bl) {
        this.cmdtype = 3;
        this.path = vector;
        this.name = string;
        this.pid = string2;
        this.suspended = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.name == null) {
            SDMSScope sDMSScope = this.registerByServer(systemEnvironment);
        } else if (this.pid != null) {
            SDMSScope sDMSScope = this.registerByOperator(systemEnvironment);
        } else {
            SDMSScope sDMSScope = this.deregisterByOperator(systemEnvironment);
        }
    }

    private SDMSScope registerByOperator(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = SDMSScopeTable.pathToId(systemEnvironment, this.path);
        SDMSScope sDMSScope = SDMSScopeTable.idx_parentId_name_getUnique(systemEnvironment, new SDMSKey(l, (Comparable)((Object)this.name)));
        if (sDMSScope.getType(systemEnvironment) != 2) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201291821", "A Scope cannot be registered"));
        }
        sDMSScope.setIsRegistered(systemEnvironment, Boolean.TRUE);
        sDMSScope.setState(systemEnvironment, SDMSConstants.S_NOMINAL);
        sDMSScope.setErrmsg(systemEnvironment, null);
        sDMSScope.setPid(systemEnvironment, this.pid);
        if (this.suspended != null) {
            sDMSScope.setIsSuspended(systemEnvironment, this.suspended);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201292822", "Server registered"));
        return sDMSScope;
    }

    private SDMSScope deregisterByOperator(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = SDMSScopeTable.pathToId(systemEnvironment, this.path);
        SDMSScope sDMSScope = SDMSScopeTable.idx_parentId_name_getUnique(systemEnvironment, new SDMSKey(l, (Comparable)((Object)this.name)));
        if (sDMSScope.getType(systemEnvironment) != 2) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201291822", "A Scope cannot be deregistered"));
        }
        sDMSScope.setIsRegistered(systemEnvironment, Boolean.FALSE);
        if (this.suspended != null) {
            sDMSScope.setIsSuspended(systemEnvironment, this.suspended);
        }
        Vector vector = SDMSSubmittedEntityTable.idx_scopeId.getVector(systemEnvironment, sDMSScope.getId(systemEnvironment));
        block5: for (int i = 0; i < vector.size(); ++i) {
            SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)vector.get(i);
            int n = sDMSSubmittedEntity.getState(systemEnvironment);
            int n2 = 14;
            switch (n) {
                case 6: 
                case 7: 
                case 13: {
                    sDMSSubmittedEntity.releaseResources(systemEnvironment, n2);
                    sDMSSubmittedEntity.setErrorMsg(systemEnvironment, "Jobserver deregistered");
                    sDMSSubmittedEntity.setState(systemEnvironment, n2);
                    continue block5;
                }
                case 8: 
                case 9: {
                    if (sDMSSubmittedEntity.getJobEsdId(systemEnvironment) == null) {
                        sDMSSubmittedEntity.releaseResources(systemEnvironment, n2);
                        sDMSSubmittedEntity.setErrorMsg(systemEnvironment, "Jobserver deregistered");
                        sDMSSubmittedEntity.setState(systemEnvironment, n2);
                        continue block5;
                    }
                    sDMSSubmittedEntity.setState(systemEnvironment, 11);
                    continue block5;
                }
                case 5: {
                    sDMSSubmittedEntity.setState(systemEnvironment, SDMSConstants.SME_RUNNABLE);
                }
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201292823", "Server deregistered"));
        return sDMSScope;
    }

    private SDMSScope registerByServer(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSScope sDMSScope = SDMSScopeTable.getObjectForUpdate(systemEnvironment, systemEnvironment.cEnv.uid());
        sDMSScope.setIsRegistered(systemEnvironment, Boolean.TRUE);
        sDMSScope.setState(systemEnvironment, SDMSConstants.S_NOMINAL);
        sDMSScope.setErrmsg(systemEnvironment, null);
        sDMSScope.setPid(systemEnvironment, this.pid);
        sDMSScope.setHasAlteredConfig(systemEnvironment, Boolean.FALSE);
        this.result.setOutputContainer(ScopeConfig.get(systemEnvironment, sDMSScope, false));
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201292824", "Server registered"));
        return sDMSScope;
    }
}

