/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;

public class SetState
extends Node {
    public static final String __version = "@(#) $Id: SetState.java,v 2.1.4.1 2013/03/14 10:24:48 ronald Exp $";
    private String name;

    public SetState(String string) {
        this.cmdtype = 4;
        this.name = string;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSExitState sDMSExitState;
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid());
        if (sDMSSubmittedEntity.getJobIsFinal(systemEnvironment).booleanValue()) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207251516", "Job must be in a pending state"));
        }
        if (sDMSSubmittedEntity.getJobIsRestartable(systemEnvironment).booleanValue()) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207251517", "Job must be in a pending state"));
        }
        long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        Long l2 = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, this.name, l).getId(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l);
        try {
            sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(sDMSSchedulingEntity.getEspId(systemEnvironment), l2), l);
        }
        catch (NotFoundException notFoundException) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207251523", "State is not part of profile"));
        }
        sDMSSubmittedEntity.changeState(systemEnvironment, l2, sDMSExitState, sDMSSubmittedEntity.getExitCode(systemEnvironment), sDMSSubmittedEntity.getErrorMsg(systemEnvironment), null);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03207251503", "Status set"));
    }
}

